/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.scaladsl;

import akka.event.Logging$;
import akka.pattern.BackoffSupervisor$;
import akka.stream.Attributes;
import akka.stream.Attributes$LogLevels$;
import akka.stream.Inlet;
import akka.stream.Outlet;
import akka.stream.Shape;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.stream.stage.TimerGraphStageLogicWithLogging;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005}d!B\u000f\u001f\u0003\u0013)\u0003\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u0011m\u0002!\u0011!Q\u0001\nqB\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\"Aa\u000b\u0001B\u0001B\u0003%a\n\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003Y\u0011!Y\u0006A!A!\u0002\u0013a\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u000b\r\u0004A\u0011\u00013\t\u000f=\u0004\u0001\u0019!C\u0001a\"9\u0011\u000f\u0001a\u0001\n\u0003\u0011\bB\u0002=\u0001A\u0003&\u0001\rC\u0004z\u0001\u0001\u0007I\u0011\u0001>\t\u000fy\u0004\u0001\u0019!C\u0001\u007f\"9\u00111\u0001\u0001!B\u0013Y\b\"CA\u0003\u0001\u0001\u0007I\u0011AA\u0004\u0011%\tI\u0001\u0001a\u0001\n\u0003\tY\u0001C\u0004\u0002\u0010\u0001\u0001\u000b\u0015\u0002/\t\u000f\u0005E\u0001\u0001\"\u0015\u0002\u0014!9\u00111\u0006\u0001\u0007\u0012\u00055\u0002bBA\u0018\u0001\u0019E\u0011Q\u0006\u0005\b\u0003c\u0001A\u0011BA\u0004\u0011\u001d\t\u0019\u0004\u0001C\u000b\u0003kAq!!\u0016\u0001\t+\t9\u0006C\u0004\u0002p\u0001!)\"!\u001d\t\u000f\u0005M\u0004\u0001\"\u0006\u0002.!9\u0011Q\u000f\u0001\u0005R\u0005]\u0004bBA?\u0001\u0011\u0005\u0013Q\u0006\u0002\u0018%\u0016\u001cH/\u0019:u/&$\bNQ1dW>4g\rT8hS\u000eT!a\b\u0011\u0002\u0011M\u001c\u0017\r\\1eg2T!!\t\u0012\u0002\rM$(/Z1n\u0015\u0005\u0019\u0013\u0001B1lW\u0006\u001c\u0001!\u0006\u0002'}M\u0011\u0001a\n\t\u0003Q-j\u0011!\u000b\u0006\u0003U\u0001\nQa\u001d;bO\u0016L!\u0001L\u0015\u0003?QKW.\u001a:He\u0006\u0004\bn\u0015;bO\u0016dunZ5d/&$\b\u000eT8hO&tw-\u0001\u0003oC6,\u0007CA\u00189\u001d\t\u0001d\u0007\u0005\u00022i5\t!G\u0003\u00024I\u00051AH]8pizR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\na\u0001\u0015:fI\u00164\u0017BA\u001d;\u0005\u0019\u0019FO]5oO*\u0011q\u0007N\u0001\u0006g\"\f\u0007/\u001a\t\u0003{yb\u0001\u0001B\u0003@\u0001\t\u0007\u0001IA\u0001T#\t\tU\t\u0005\u0002C\u00076\tA'\u0003\u0002Ei\t9aj\u001c;iS:<\u0007C\u0001$H\u001b\u0005\u0001\u0013B\u0001%!\u0005\u0015\u0019\u0006.\u00199f\u0003MIg\u000e[3sSR,G-\u0011;ue&\u0014W\u000f^3t!\t15*\u0003\u0002MA\tQ\u0011\t\u001e;sS\n,H/Z:\u0002\u00155LgNQ1dW>4g\r\u0005\u0002P)6\t\u0001K\u0003\u0002R%\u0006AA-\u001e:bi&|gN\u0003\u0002Ti\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005U\u0003&A\u0004$j]&$X\rR;sCRLwN\\\u0001\u000b[\u0006D()Y2l_\u001a4\u0017\u0001\u0004:b]\u0012|WNR1di>\u0014\bC\u0001\"Z\u0013\tQFG\u0001\u0004E_V\u0014G.Z\u0001\u000f_:d\u0017p\u00148GC&dWO]3t!\t\u0011U,\u0003\u0002_i\t9!i\\8mK\u0006t\u0017aC7bqJ+7\u000f^1siN\u0004\"AQ1\n\u0005\t$$aA%oi\u00061A(\u001b8jiz\"\u0012\"Z4iS*\\G.\u001c8\u0011\u0007\u0019\u0004A(D\u0001\u001f\u0011\u0015i\u0013\u00021\u0001/\u0011\u0015Y\u0014\u00021\u0001=\u0011\u0015I\u0015\u00021\u0001K\u0011\u0015i\u0015\u00021\u0001O\u0011\u00151\u0016\u00021\u0001O\u0011\u00159\u0016\u00021\u0001Y\u0011\u0015Y\u0016\u00021\u0001]\u0011\u0015y\u0016\u00021\u0001a\u00031\u0011Xm\u001d;beR\u001cu.\u001e8u+\u0005\u0001\u0017\u0001\u0005:fgR\f'\u000f^\"pk:$x\fJ3r)\t\u0019h\u000f\u0005\u0002Ci&\u0011Q\u000f\u000e\u0002\u0005+:LG\u000fC\u0004x\u0017\u0005\u0005\t\u0019\u00011\u0002\u0007a$\u0013'A\u0007sKN$\u0018M\u001d;D_VtG\u000fI\u0001\u000ee\u0016\u001cX\r\u001e#fC\u0012d\u0017N\\3\u0016\u0003m\u0004\"a\u0014?\n\u0005u\u0004&\u0001\u0003#fC\u0012d\u0017N\\3\u0002#I,7/\u001a;EK\u0006$G.\u001b8f?\u0012*\u0017\u000fF\u0002t\u0003\u0003Aqa\u001e\b\u0002\u0002\u0003\u000710\u0001\bsKN,G\u000fR3bI2Lg.\u001a\u0011\u0002\u0013\u0019Lg.[:iS:<W#\u0001/\u0002\u001b\u0019Lg.[:iS:<w\fJ3r)\r\u0019\u0018Q\u0002\u0005\boF\t\t\u00111\u0001]\u0003)1\u0017N\\5tQ&tw\rI\u0001\nY><7k\\;sG\u0016,\"!!\u00061\t\u0005]\u0011q\u0004\t\u0006_\u0005e\u0011QD\u0005\u0004\u00037Q$!B\"mCN\u001c\bcA\u001f\u0002 \u0011Y\u0011\u0011E\n\u0002\u0002\u0003\u0005)\u0011AA\u0012\u0005\ryF%N\t\u0004\u0003\u0006\u0015\u0002c\u0001\"\u0002(%\u0019\u0011\u0011\u0006\u001b\u0003\u0007\u0005s\u00170\u0001\u0006ti\u0006\u0014Ho\u0012:ba\"$\u0012a]\u0001\bE\u0006\u001c7n\u001c4g\u00039awnZ4j]\u001e,e.\u00192mK\u0012\fab\u0019:fCR,7+\u001e2J]2,G/\u0006\u0003\u00028\u0005\u001dC\u0003BA\u001d\u0003\u0017\u0002b!a\u000f\u0002>\u0005\u0015S\"\u0001\u0001\n\t\u0005}\u0012\u0011\t\u0002\r'V\u00147+\u001b8l\u0013:dW\r^\u0005\u0004\u0003\u0007J#aD$sCBD7\u000b^1hK2{w-[2\u0011\u0007u\n9\u0005B\u0004\u0002J]\u0011\r!a\t\u0003\u0003QCq!!\u0014\u0018\u0001\u0004\ty%A\u0002pkR\u0004RARA)\u0003\u000bJ1!a\u0015!\u0005\u0019yU\u000f\u001e7fi\u0006y1M]3bi\u0016\u001cVOY(vi2,G/\u0006\u0003\u0002Z\u0005\rD\u0003BA.\u0003K\u0002b!a\u000f\u0002^\u0005\u0005\u0014\u0002BA0\u0003\u0003\u0012qbU;c'>,(oY3PkRdW\r\u001e\t\u0004{\u0005\rDaBA%1\t\u0007\u00111\u0005\u0005\b\u0003OB\u0002\u0019AA5\u0003\tIg\u000eE\u0003G\u0003W\n\t'C\u0002\u0002n\u0001\u0012Q!\u00138mKR\f!#\\1y%\u0016\u001cH/\u0019:ugJ+\u0017m\u00195fIR\tA,\u0001\u000btG\",G-\u001e7f%\u0016\u001cH/\u0019:u)&lWM]\u0001\b_:$\u0016.\\3s)\r\u0019\u0018\u0011\u0010\u0005\b\u0003wZ\u0002\u0019AA\u0013\u0003!!\u0018.\\3s\u0017\u0016L\u0018\u0001\u00039sKN#\u0018M\u001d;")
public abstract class RestartWithBackoffLogic<S extends Shape>
extends TimerGraphStageLogicWithLogging {
    private final String name;
    private final Attributes inheritedAttributes;
    private final FiniteDuration minBackoff;
    private final FiniteDuration maxBackoff;
    private final double randomFactor;
    public final boolean akka$stream$scaladsl$RestartWithBackoffLogic$$onlyOnFailures;
    private final int maxRestarts;
    private int restartCount;
    private Deadline resetDeadline;
    private boolean finishing;

    public int restartCount() {
        return this.restartCount;
    }

    public void restartCount_$eq(int x$1) {
        this.restartCount = x$1;
    }

    public Deadline resetDeadline() {
        return this.resetDeadline;
    }

    public void resetDeadline_$eq(Deadline x$1) {
        this.resetDeadline = x$1;
    }

    public boolean finishing() {
        return this.finishing;
    }

    public void finishing_$eq(boolean x$1) {
        this.finishing = x$1;
    }

    @Override
    public Class<?> logSource() {
        return RestartWithBackoffLogic.class;
    }

    public abstract void startGraph();

    public abstract void backoff();

    public boolean akka$stream$scaladsl$RestartWithBackoffLogic$$loggingEnabled() {
        boolean bl;
        Option option = this.inheritedAttributes.get(ClassTag$.MODULE$.apply(Attributes.LogLevels.class));
        if (option instanceof Some) {
            Some some = (Some)option;
            Attributes.LogLevels levels = (Attributes.LogLevels)some.value();
            bl = levels.onFailure() != Attributes$LogLevels$.MODULE$.Off();
        } else if (None$.MODULE$.equals(option)) {
            bl = true;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> GraphStageLogic.SubSinkInlet<T> createSubInlet(Outlet<T> out) {
        void var2_2;
        GraphStageLogic.SubSinkInlet sinkIn = new GraphStageLogic.SubSinkInlet(this, new StringBuilder(24).append("RestartWithBackoff").append(this.name).append(".subIn").toString());
        sinkIn.setHandler(new InHandler(this, out, sinkIn){
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            private final Outlet out$1;
            private final GraphStageLogic.SubSinkInlet sinkIn$1;

            public void onPush() {
                this.$outer.push(this.out$1, this.sinkIn$1.grab());
            }

            public void onUpstreamFinish() {
                if (this.$outer.finishing() || this.$outer.maxRestartsReached() || this.$outer.akka$stream$scaladsl$RestartWithBackoffLogic$$onlyOnFailures) {
                    this.$outer.complete(this.out$1);
                } else {
                    this.$outer.scheduleRestartTimer();
                }
            }

            public void onUpstreamFailure(Throwable ex) {
                if (this.$outer.finishing() || this.$outer.maxRestartsReached()) {
                    this.$outer.fail(this.out$1, ex);
                } else {
                    if (this.$outer.akka$stream$scaladsl$RestartWithBackoffLogic$$loggingEnabled()) {
                        this.$outer.log().warning("Restarting graph due to failure. stack_trace: {}", (Object)Logging$.MODULE$.stackTraceFor(ex));
                    }
                    this.$outer.scheduleRestartTimer();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.out$1 = out$1;
                this.sinkIn$1 = sinkIn$1;
                InHandler.$init$(this);
            }
        });
        this.setHandler(out, new OutHandler(this, sinkIn){
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            private final GraphStageLogic.SubSinkInlet sinkIn$1;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$(this);
            }

            public void onPull() {
                this.sinkIn$1.pull();
            }

            public void onDownstreamFinish(Throwable cause) {
                this.$outer.finishing_$eq(true);
                this.sinkIn$1.cancel(cause);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sinkIn$1 = sinkIn$1;
                OutHandler.$init$(this);
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final <T> GraphStageLogic.SubSourceOutlet<T> createSubOutlet(Inlet<T> in) {
        void var2_2;
        GraphStageLogic.SubSourceOutlet sourceOut = new GraphStageLogic.SubSourceOutlet(this, new StringBuilder(25).append("RestartWithBackoff").append(this.name).append(".subOut").toString());
        sourceOut.setHandler(new OutHandler(this, in, sourceOut){
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            private final Inlet in$1;
            private final GraphStageLogic.SubSourceOutlet sourceOut$1;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$(this);
            }

            public void onPull() {
                block1: {
                    block0: {
                        if (!this.$outer.isAvailable(this.in$1)) break block0;
                        this.sourceOut$1.push(this.$outer.grab(this.in$1));
                        break block1;
                    }
                    if (this.$outer.hasBeenPulled(this.in$1)) break block1;
                    this.$outer.pull(this.in$1);
                }
            }

            public void onDownstreamFinish(Throwable cause) {
                if (this.$outer.finishing() || this.$outer.maxRestartsReached() || this.$outer.akka$stream$scaladsl$RestartWithBackoffLogic$$onlyOnFailures) {
                    this.$outer.cancel(this.in$1, cause);
                } else {
                    this.$outer.scheduleRestartTimer();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.in$1 = in$1;
                this.sourceOut$1 = sourceOut$1;
                OutHandler.$init$(this);
            }
        });
        this.setHandler(in, new InHandler(this, sourceOut, in){
            private final /* synthetic */ RestartWithBackoffLogic $outer;
            private final GraphStageLogic.SubSourceOutlet sourceOut$1;
            private final Inlet in$1;

            public void onPush() {
                block0: {
                    if (!this.sourceOut$1.isAvailable()) break block0;
                    this.sourceOut$1.push(this.$outer.grab(this.in$1));
                }
            }

            public void onUpstreamFinish() {
                this.$outer.finishing_$eq(true);
                this.sourceOut$1.complete();
            }

            public void onUpstreamFailure(Throwable ex) {
                this.$outer.finishing_$eq(true);
                this.sourceOut$1.fail(ex);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sourceOut$1 = sourceOut$1;
                this.in$1 = in$1;
                InHandler.$init$(this);
            }
        });
        return var2_2;
    }

    public final boolean maxRestartsReached() {
        if (this.resetDeadline().isOverdue()) {
            this.log().debug("Last restart attempt was more than {} ago, resetting restart count", (Object)this.minBackoff);
            this.restartCount_$eq(0);
        }
        return this.restartCount() == this.maxRestarts;
    }

    public final void scheduleRestartTimer() {
        FiniteDuration restartDelay = BackoffSupervisor$.MODULE$.calculateDelay(this.restartCount(), this.minBackoff, this.maxBackoff, this.randomFactor);
        this.log().debug("Restarting graph in {}", (Object)restartDelay);
        this.scheduleOnce((Object)"RestartTimer", restartDelay);
        this.restartCount_$eq(this.restartCount() + 1);
        this.backoff();
    }

    @Override
    public void onTimer(Object timerKey) {
        this.startGraph();
        this.resetDeadline_$eq(this.minBackoff.fromNow());
    }

    @Override
    public void preStart() {
        this.startGraph();
    }

    public RestartWithBackoffLogic(String name, S shape, Attributes inheritedAttributes, FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, boolean onlyOnFailures, int maxRestarts) {
        this.name = name;
        this.inheritedAttributes = inheritedAttributes;
        this.minBackoff = minBackoff;
        this.maxBackoff = maxBackoff;
        this.randomFactor = randomFactor;
        this.akka$stream$scaladsl$RestartWithBackoffLogic$$onlyOnFailures = onlyOnFailures;
        this.maxRestarts = maxRestarts;
        super((Shape)shape);
        this.restartCount = 0;
        this.resetDeadline = minBackoff.fromNow();
        this.finishing = false;
    }
}

