/*
 * Decompiled with CFR 0.152.
 */
package blended.security.ssl.internal;

import blended.security.ssl.CertificateHolder;
import blended.security.ssl.CertificateHolder$;
import blended.security.ssl.MemoryKeystore;
import blended.security.ssl.internal.JavaKeystore;
import blended.security.ssl.internal.SslContextProvider$;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.File;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.security.auth.x500.X500Principal;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u001d3A\u0001C\u0005\u0001%!A\u0011\u0004\u0001B\u0001B\u0003%!\u0004C\u0003\u001f\u0001\u0011\u0005q\u0004C\u0004$\u0001\t\u0007I\u0011\u0002\u0013\t\r5\u0002\u0001\u0015!\u0003&\u0011\u0015q\u0003\u0001\"\u00010\u0011\u0015A\u0004\u0001\"\u0003:\u0011\u0015\u0011\u0005\u0001\"\u0003D\u0005M!&/^:u'R|'/\u001a*fMJ,7\u000f[3s\u0015\tQ1\"\u0001\u0005j]R,'O\\1m\u0015\taQ\"A\u0002tg2T!AD\b\u0002\u0011M,7-\u001e:jifT\u0011\u0001E\u0001\bE2,g\u000eZ3e\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g\u0003\ti7\u000f\u0005\u0002\u001c95\t1\"\u0003\u0002\u001e\u0017\tqQ*Z7pef\\U-_:u_J,\u0017A\u0002\u001fj]&$h\b\u0006\u0002!EA\u0011\u0011\u0005A\u0007\u0002\u0013!)\u0011D\u0001a\u00015\u0005\u0019An\\4\u0016\u0003\u0015\u0002\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\u000f1|wmZ5oO*\u0011!fD\u0001\u0005kRLG.\u0003\u0002-O\t1Aj\\4hKJ\fA\u0001\\8hA\u0005\t\"/\u001a4sKNDGK];tiN$xN]3\u0015\u0003A\u00022!M\u001a6\u001b\u0005\u0011$B\u0001\u0016\u0016\u0013\t!$GA\u0002Uef\u00042\u0001\u0006\u001c\u001b\u0013\t9TC\u0001\u0004PaRLwN\\\u0001\u000bkB$\u0017\r^3S_>$Hc\u0001\u001e<{A\u0019\u0011g\r\u000e\t\u000bq2\u0001\u0019\u0001\u000e\u0002\u000fQ\u0014Xo\u001d;fI\")aH\u0002a\u0001\u007f\u0005!1-\u001a:u!\tY\u0002)\u0003\u0002B\u0017\t\t2)\u001a:uS\u001aL7-\u0019;f\u0011>dG-\u001a:\u0002\u0017U\u0004H-\u0019;f%>|Go\u001d\u000b\u0004u\u0011+\u0005\"\u0002\u001f\b\u0001\u0004Q\u0002\"\u0002$\b\u0001\u0004Q\u0012\u0001C6fsN$xN]3")
public class TrustStoreRefresher {
    private final MemoryKeystore ms;
    private final Logger log;

    private Logger log() {
        return this.log;
    }

    public Try<Option<MemoryKeystore>> refreshTruststore() {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Tuple2 tuple2 = new Tuple2((Object)Option$.MODULE$.apply((Object)System.getProperty(SslContextProvider$.MODULE$.propTrustStore())), (Object)Option$.MODULE$.apply((Object)System.getProperty(SslContextProvider$.MODULE$.propTrustStorePwd())));
            if (tuple2 == null) return None$.MODULE$;
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (!(option instanceof Some)) return None$.MODULE$;
            Some some = (Some)option;
            String store = (String)some.value();
            if (!(option2 instanceof Some)) return None$.MODULE$;
            Some some2 = (Some)option2;
            String pwd = (String)some2.value();
            File f = new File(store);
            this.log().info((Function0 & Serializable)() -> new StringBuilder(40).append("Reading trust store certificates from [").append(f.getAbsolutePath()).append("]").toString());
            JavaKeystore jks = new JavaKeystore(new File(store), pwd.toCharArray(), (Option<char[]>)None$.MODULE$);
            MemoryKeystore updated = (MemoryKeystore)this.updateRoots((MemoryKeystore)jks.loadKeyStore().get(), $this.ms).get();
            return new Some(jks.saveKeyStore(updated).get());
        });
    }

    private Try<MemoryKeystore> updateRoot(MemoryKeystore trusted, CertificateHolder cert) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            MemoryKeystore memoryKeystore;
            X509Certificate root = (X509Certificate)cert.chain().last();
            X500Principal rootCn = root.getSubjectX500Principal();
            this.log().info((Function0 & Serializable)() -> new StringBuilder(35).append("Checking trusted certificate for [").append(rootCn).append("]").toString());
            Option<CertificateHolder> option = trusted.findByPrincipal(rootCn);
            if (None$.MODULE$.equals(option)) {
                this.log().info((Function0 & Serializable)() -> new StringBuilder(44).append("Updating trust store with certificate for [").append(rootCn).append("]").toString());
                String alias = trusted.certificates().isDefinedAt((Object)rootCn.toString()) ? UUID.randomUUID().toString() : rootCn.toString();
                memoryKeystore = (MemoryKeystore)trusted.update(alias, CertificateHolder$.MODULE$.create(root)).get();
            } else if (option instanceof Some) {
                this.log().info((Function0 & Serializable)() -> new StringBuilder(49).append("Certificate for [").append(rootCn).append("] already exists in trust store.").toString());
                memoryKeystore = trusted;
            } else {
                throw new MatchError(option);
            }
            return memoryKeystore;
        });
    }

    private Try<MemoryKeystore> updateRoots(MemoryKeystore trusted, MemoryKeystore keystore) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> (MemoryKeystore)keystore.certificates().foldLeft((Object)trusted, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            MemoryKeystore s;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    s = (MemoryKeystore)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            CertificateHolder c = (CertificateHolder)tuple2._2();
            MemoryKeystore memoryKeystore = (MemoryKeystore)this.updateRoot(s, c).get();
            return memoryKeystore;
        }));
    }

    public TrustStoreRefresher(MemoryKeystore ms) {
        this.ms = ms;
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(TrustStoreRefresher.class));
    }
}

