/*
 * Decompiled with CFR 0.152.
 */
package blended.security.ssl.internal;

import blended.security.ssl.CertificateHolder;
import blended.security.ssl.MemoryKeystore;
import blended.security.ssl.X509CertificateInfo;
import blended.security.ssl.X509CertificateInfo$;
import blended.security.ssl.internal.CertificateCheckResult;
import blended.security.ssl.internal.CertificateChecker;
import blended.security.ssl.internal.ResultLevel$;
import java.security.cert.X509Certificate;
import scala.Enumeration;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00113AAB\u0004\u0001!!A1\u0004\u0001B\u0001B\u0003%A\u0004C\u0003 \u0001\u0011\u0005\u0001\u0005C\u0004$\u0001\t\u0007I\u0011\u0002\u0013\t\r!\u0002\u0001\u0015!\u0003&\u0011\u0015I\u0003\u0001\"\u0011+\u0005a\u0011V-\\1j]&twMV1mS\u0012LG/_\"iK\u000e\\WM\u001d\u0006\u0003\u0011%\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u0015-\t1a]:m\u0015\taQ\"\u0001\u0005tK\u000e,(/\u001b;z\u0015\u0005q\u0011a\u00022mK:$W\rZ\u0002\u0001'\r\u0001\u0011c\u0006\t\u0003%Ui\u0011a\u0005\u0006\u0002)\u0005)1oY1mC&\u0011ac\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005aIR\"A\u0004\n\u0005i9!AE\"feRLg-[2bi\u0016\u001c\u0005.Z2lKJ\fA\"\\5o-\u0006d\u0017\u000e\u001a#bsN\u0004\"AE\u000f\n\u0005y\u0019\"aA%oi\u00061A(\u001b8jiz\"\"!\t\u0012\u0011\u0005a\u0001\u0001\"B\u000e\u0003\u0001\u0004a\u0012\u0001D7jY2L7\u000fU3s\t\u0006LX#A\u0013\u0011\u0005I1\u0013BA\u0014\u0014\u0005\u0011auN\\4\u0002\u001b5LG\u000e\\5t!\u0016\u0014H)Y=!\u0003A\u0019\u0007.Z2l\u0007\u0016\u0014H/\u001b4jG\u0006$X\rF\u0002,cy\u00022A\u0005\u0017/\u0013\ti3C\u0001\u0004PaRLwN\u001c\t\u00031=J!\u0001M\u0004\u0003-\r+'\u000f^5gS\u000e\fG/Z\"iK\u000e\\'+Z:vYRDQAM\u0003A\u0002M\nQ!\u00197jCN\u0004\"\u0001N\u001e\u000f\u0005UJ\u0004C\u0001\u001c\u0014\u001b\u00059$B\u0001\u001d\u0010\u0003\u0019a$o\\8u}%\u0011!hE\u0001\u0007!J,G-\u001a4\n\u0005qj$AB*ue&twM\u0003\u0002;'!)q(\u0002a\u0001\u0001\u0006!1-\u001a:u!\t\t%)D\u0001\n\u0013\t\u0019\u0015BA\tDKJ$\u0018NZ5dCR,\u0007j\u001c7eKJ\u0004")
public class RemainingValidityChecker
implements CertificateChecker {
    private final int minValidDays;
    private final long millisPerDay;

    @Override
    public Seq<CertificateCheckResult> checkCertificates(MemoryKeystore certs) {
        return CertificateChecker.checkCertificates$(this, certs);
    }

    private long millisPerDay() {
        return this.millisPerDay;
    }

    @Override
    public Option<CertificateCheckResult> checkCertificate(String alias, CertificateHolder cert) {
        CertificateCheckResult certificateCheckResult;
        X509CertificateInfo certInfo = X509CertificateInfo$.MODULE$.apply((X509Certificate)cert.chain().head());
        long remaining = certInfo.notAfter().getTime() - System.currentTimeMillis();
        if (remaining <= (long)this.minValidDays * this.millisPerDay()) {
            String msg = new StringBuilder(46).append("Certificate for [").append(((X509Certificate)cert.chain().head()).getSubjectX500Principal()).append("] is about to expire in ").append((double)remaining / (double)this.millisPerDay()).append(" days").toString();
            certificateCheckResult = new CertificateCheckResult(alias, cert, (Seq<Tuple2<Enumeration.Value, String>>)((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)ResultLevel$.MODULE$.WARN(), (Object)msg)}))));
        } else {
            String msg = new StringBuilder(33).append("Certificate for [").append(((X509Certificate)cert.chain().head()).getSubjectX500Principal()).append("] is still valid").toString();
            certificateCheckResult = new CertificateCheckResult(alias, cert, (Seq<Tuple2<Enumeration.Value, String>>)((Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)ResultLevel$.MODULE$.INFO(), (Object)msg)}))));
        }
        return new Some((Object)certificateCheckResult);
    }

    public RemainingValidityChecker(int minValidDays) {
        this.minValidDays = minValidDays;
        CertificateChecker.$init$(this);
        this.millisPerDay = new package.DurationInt(package$.MODULE$.DurationInt(1)).day().toMillis();
    }
}

