/*
 * Decompiled with CFR 0.152.
 */
package blended.security.ssl.internal;

import blended.security.ssl.CertificateChange$Unchanged$;
import blended.security.ssl.CertificateHolder;
import blended.security.ssl.CertificateHolder$;
import blended.security.ssl.InconsistentKeystoreException;
import blended.security.ssl.MemoryKeystore;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005y4A\u0001E\t\u00015!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0004\"B\u001b\u0001\t\u00031\u0004\"\u0002\u001f\u0001\t\u0003i\u0004b\u0002 \u0001\u0005\u0004%Ia\u0010\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002!\t\u0011%\u0003!\u0019!C\u0001')CaA\u0016\u0001!\u0002\u0013Y\u0005\"B,\u0001\t\u0003A\u0006\"\u00022\u0001\t\u0003\u0019\u0007B\u00024\u0001\t\u0003\u0019r\r\u0003\u0004o\u0001\u0011\u00051c\u001c\u0005\u0007e\u0002!\taE:\t\rm\u0004A\u0011A\n}\u00051Q\u0015M^1LKf\u001cHo\u001c:f\u0015\t\u00112#\u0001\u0005j]R,'O\\1m\u0015\t!R#A\u0002tg2T!AF\f\u0002\u0011M,7-\u001e:jifT\u0011\u0001G\u0001\bE2,g\u000eZ3e\u0007\u0001\u0019\"\u0001A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g\u0003\u0015\u0019Ho\u001c:f!\t\u0019\u0003&D\u0001%\u0015\t)c%\u0001\u0002j_*\tq%\u0001\u0003kCZ\f\u0017BA\u0015%\u0005\u00111\u0015\u000e\\3\u0002\u0013M$xN]3qCN\u001c\bc\u0001\u000f-]%\u0011Q&\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00039=J!\u0001M\u000f\u0003\t\rC\u0017M]\u0001\bW\u0016L\b/Y:t!\ra2gK\u0005\u0003iu\u0011aa\u00149uS>t\u0017A\u0002\u001fj]&$h\b\u0006\u00038siZ\u0004C\u0001\u001d\u0001\u001b\u0005\t\u0002\"B\u0011\u0005\u0001\u0004\u0011\u0003\"\u0002\u0016\u0005\u0001\u0004Y\u0003\"B\u0019\u0005\u0001\u0004\u0011\u0014\u0001C6fsN$xN]3\u0016\u0003\t\n1\u0001\\8h+\u0005\u0001\u0005CA!G\u001b\u0005\u0011%BA\"E\u0003\u001dawnZ4j]\u001eT!!R\f\u0002\tU$\u0018\u000e\\\u0005\u0003\u000f\n\u0013a\u0001T8hO\u0016\u0014\u0018\u0001\u00027pO\u0002\n\u0011b\u001d;pe\u0016$\u0018\u0010]3\u0016\u0003-\u0003\"\u0001T*\u000f\u00055\u000b\u0006C\u0001(\u001e\u001b\u0005y%B\u0001)\u001a\u0003\u0019a$o\\8u}%\u0011!+H\u0001\u0007!J,G-\u001a4\n\u0005Q+&AB*ue&twM\u0003\u0002S;\u0005Q1\u000f^8sKRL\b/\u001a\u0011\u0002\u00191|\u0017\rZ&fsN#xN]3\u0015\u0003e\u00032A\u0017/_\u001b\u0005Y&BA#\u001e\u0013\ti6LA\u0002Uef\u0004\"a\u00181\u000e\u0003MI!!Y\n\u0003\u001d5+Wn\u001c:z\u0017\u0016L8\u000f^8sK\u0006a1/\u0019<f\u0017\u0016L8\u000b^8sKR\u0011\u0011\f\u001a\u0005\u0006K.\u0001\rAX\u0001\u0003[N\fA\u0003\\8bI.+\u0017p\u0015;pe\u00164%o\\7GS2,G#\u00015\u0011\u0007ic\u0016\u000e\u0005\u0002kY6\t1N\u0003\u0002\u0017M%\u0011Qn\u001b\u0002\t\u0017\u0016L8\u000b^8sK\u0006\u00112/\u0019<f\u0017\u0016L8\u000b^8sKR{g)\u001b7f)\tA\u0007\u000fC\u0003r\u001b\u0001\u0007\u0011.\u0001\u0002lg\u0006\u0011R\r\u001f;sC\u000e$8)\u001a:uS\u001aL7-\u0019;f)\r!\b0\u001f\t\u00045r+\bCA0w\u0013\t98CA\tDKJ$\u0018NZ5dCR,\u0007j\u001c7eKJDQ!\u001d\bA\u0002%DQA\u001f\bA\u0002-\u000bQ!\u00197jCN\fa\"\\3n_JL8*Z=ti>\u0014X\r\u0006\u0002Z{\")\u0011o\u0004a\u0001S\u0002")
public class JavaKeystore {
    private final File store;
    private final char[] storepass;
    private final Option<char[]> keypass;
    private final Logger log;
    private final String storetype;

    public File keystore() {
        return this.store;
    }

    private Logger log() {
        return this.log;
    }

    public String storetype() {
        return this.storetype;
    }

    public Try<MemoryKeystore> loadKeyStore() {
        return this.memoryKeystore((KeyStore)this.loadKeyStoreFromFile().get());
    }

    public Try<MemoryKeystore> saveKeyStore(MemoryKeystore ms) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            KeyStore ks = (KeyStore)this.loadKeyStoreFromFile().get();
            ((IterableOnceOps)ms.certificates().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JavaKeystore.$anonfun$saveKeyStore$2(x$1)))).foreach((Function1 & Serializable)x0$1 -> {
                JavaKeystore.$anonfun$saveKeyStore$3(this, ks, x0$1);
                return BoxedUnit.UNIT;
            });
            this.saveKeyStoreToFile(ks).get();
            return new MemoryKeystore((Map<String, CertificateHolder>)ms.certificates().view().mapValues((Function1 & Serializable)x$2 -> {
                CertificateChange$Unchanged$ x$1 = CertificateChange$Unchanged$.MODULE$;
                PublicKey x$22 = x$2.copy$default$1();
                Option<PrivateKey> x$3 = x$2.copy$default$2();
                List<X509Certificate> x$4 = x$2.copy$default$3();
                return x$2.copy(x$22, x$3, x$4, x$1);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        });
    }

    public Try<KeyStore> loadKeyStoreFromFile() {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            void var1_1;
            this.log().info((Function0 & Serializable)() -> new StringBuilder(50).append("Initializing key store of type [").append(this.storetype()).append("] from file [").append(this.keystore().getAbsolutePath()).append("] ...").toString());
            KeyStore ks = KeyStore.getInstance(this.storetype());
            if (this.keystore().exists()) {
                try (FileInputStream fis = new FileInputStream(this.keystore());){
                    ks.load(fis, $this.storepass);
                }
            } else {
                this.log().info((Function0 & Serializable)() -> new StringBuilder(30).append("Loading empty key store [").append(this.keystore().getAbsolutePath()).append("] ...").toString());
                ks.load(null, $this.storepass);
            }
            return var1_1;
        });
    }

    public Try<KeyStore> saveKeyStoreToFile(KeyStore ks) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            try (FileOutputStream fos = new FileOutputStream(this.keystore());){
                int certCount = CollectionConverters$.MODULE$.EnumerationHasAsScala(ks.aliases()).asScala().size();
                this.log().info((Function0 & Serializable)() -> new StringBuilder(29).append("Storing [").append(certCount).append("] certificates to [").append(this.keystore()).append("]").toString());
                ks.store(fos, $this.storepass);
                this.log().info((Function0 & Serializable)() -> new StringBuilder(54).append("Successfully written key store to [").append(this.keystore()).append("] with storePass [").append(new String($this.storepass)).append("]").toString());
            }
            return ks;
        });
    }

    public Try<CertificateHolder> extractCertificate(KeyStore ks, String alias) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            List list;
            Option option = Option$.MODULE$.apply((Object)ks.getCertificateChain(alias));
            if (None$.MODULE$.equals(option)) {
                Option option2 = Option$.MODULE$.apply((Object)ks.getCertificate(alias));
                if (None$.MODULE$.equals(option2)) {
                    throw new Exception(new StringBuilder(35).append("Certificate for alias [").append(alias).append("] not found.").toString());
                }
                if (!(option2 instanceof Some)) {
                    throw new MatchError((Object)option2);
                }
                Some some = (Some)option2;
                Certificate c = (Certificate)some.value();
                List list2 = (List)new .colon.colon((Object)((X509Certificate)c), (List)Nil$.MODULE$);
                list = list2;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Certificate[] c = (Certificate[])some.value();
                list = Predef$.MODULE$.wrapRefArray((Object[])c).toList().map((Function1 & Serializable)x$3 -> (X509Certificate)x$3);
            } else {
                throw new MatchError((Object)option);
            }
            List chain = list;
            PublicKey pubKey = ((Certificate)chain.head()).getPublicKey();
            Option privKey = $this.keypass.map((Function1 & Serializable)pwd -> (PrivateKey)ks.getKey(alias, (char[])pwd));
            return (CertificateHolder)CertificateHolder$.MODULE$.create(pubKey, (Option<PrivateKey>)privKey, (List<Certificate>)chain).get();
        });
    }

    public Try<MemoryKeystore> memoryKeystore(KeyStore ks) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Map certs = CollectionConverters$.MODULE$.EnumerationHasAsScala(ks.aliases()).asScala().map((Function1 & Serializable)alias -> new Tuple2(alias, this.extractCertificate(ks, (String)alias).get())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            MemoryKeystore result = new MemoryKeystore((Map<String, CertificateHolder>)certs);
            if (!result.consistent()) {
                throw new InconsistentKeystoreException(new StringBuilder(28).append("KeyStore [").append(this.keystore().getAbsolutePath()).append("] is inconsistent.").toString());
            }
            return result;
        });
    }

    public static final /* synthetic */ boolean $anonfun$saveKeyStore$2(Tuple2 x$1) {
        return ((CertificateHolder)x$1._2()).change().changed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$saveKeyStore$3(JavaKeystore $this, KeyStore ks$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String alias = (String)tuple2._1();
        CertificateHolder cert = (CertificateHolder)tuple2._2();
        Option<char[]> option = $this.keypass;
        if (None$.MODULE$.equals(option)) {
            ks$1.setCertificateEntry(alias, (Certificate)cert.chain().last());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!(option instanceof Some)) throw new MatchError(option);
            Some some = (Some)option;
            char[] pwd = (char[])some.value();
            Option<PrivateKey> option2 = cert.privateKey();
            if (None$.MODULE$.equals(option2)) {
                throw new Exception(new StringBuilder(45).append("Certificate for [").append(cert.subjectPrincipal()).append("] is missing the private key").toString());
            }
            if (!(option2 instanceof Some)) {
                throw new MatchError(option2);
            }
            Some some2 = (Some)option2;
            PrivateKey k = (PrivateKey)some2.value();
            ks$1.setKeyEntry(alias, k, pwd, (Certificate[])cert.chain().toArray(ClassTag$.MODULE$.apply(Certificate.class)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public JavaKeystore(File store, char[] storepass, Option<char[]> keypass) {
        String string;
        this.store = store;
        this.storepass = storepass;
        this.keypass = keypass;
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(JavaKeystore.class));
        Option<char[]> option = keypass;
        if (None$.MODULE$.equals(option)) {
            string = KeyStore.getDefaultType();
        } else if (option instanceof Some) {
            string = "PKCS12";
        } else {
            throw new MatchError(option);
        }
        this.storetype = string;
    }
}

