/*
 * Decompiled with CFR 0.152.
 */
package blended.security.ssl.internal;

import blended.security.ssl.CertificateHolder;
import blended.security.ssl.CertificateManager;
import blended.security.ssl.CertificateProvider;
import blended.security.ssl.MemoryKeystore;
import blended.security.ssl.internal.CertificateManagerConfig;
import blended.security.ssl.internal.CertificateManagerImpl$;
import blended.security.ssl.internal.CertificateRefresher;
import blended.security.ssl.internal.JavaKeystore;
import blended.security.ssl.internal.KeystoreConfig;
import blended.security.ssl.internal.RefresherConfig;
import blended.security.ssl.internal.SslContextInfo;
import blended.security.ssl.internal.SslContextProvider;
import blended.security.ssl.internal.TrustStoreRefresher;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import domino.capsule.Capsule;
import domino.capsule.CapsuleContext;
import domino.capsule.CapsuleConvenience;
import domino.capsule.CapsuleScope;
import domino.service_providing.ProvidableService;
import domino.service_providing.ServiceProviding;
import java.io.File;
import java.io.Serializable;
import java.security.KeyStore;
import java.util.Date;
import javax.net.ssl.SSLContext;
import org.osgi.framework.BundleContext;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005eb\u0001B\t\u0013\u0001mA\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0005\u000f\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005s!AA\t\u0001BC\u0002\u0013\u0005S\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003G\u0011!Q\u0005A!A!\u0002\u0013Y\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u000b\u0005\u0004A\u0011\u00012\t\r!\u0004\u0001\u0015!\u0003j\u0011\u001d\t\bA1A\u0005\nIDa!\u001f\u0001!\u0002\u0013\u0019\bB\u0002>\u0001\t\u0003\u00112\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u0013\u0001A\u0011IA\u0001\u0011!\tY\u0001\u0001Q\u0005\n\u00055\u0001bBA\u0011\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003o\u0001A\u0011IA\u0007\u0005Y\u0019UM\u001d;jM&\u001c\u0017\r^3NC:\fw-\u001a:J[Bd'BA\n\u0015\u0003!Ig\u000e^3s]\u0006d'BA\u000b\u0017\u0003\r\u00198\u000f\u001c\u0006\u0003/a\t\u0001b]3dkJLG/\u001f\u0006\u00023\u00059!\r\\3oI\u0016$7\u0001A\n\u0007\u0001q\u0011cEL\u0019\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\r\u0005s\u0017PU3g!\t\u0019C%D\u0001\u0015\u0013\t)CC\u0001\nDKJ$\u0018NZ5dCR,W*\u00198bO\u0016\u0014\bCA\u0014-\u001b\u0005A#BA\u0015+\u0003\u001d\u0019\u0017\r]:vY\u0016T\u0011aK\u0001\u0007I>l\u0017N\\8\n\u00055B#aB\"baN,H.\u001a\t\u0003O=J!\u0001\r\u0015\u0003%\r\u000b\u0007o];mK\u000e{gN^3oS\u0016t7-\u001a\t\u0003eUj\u0011a\r\u0006\u0003i)\n\u0011c]3sm&\u001cWm\u00189s_ZLG-\u001b8h\u0013\t14G\u0001\tTKJ4\u0018nY3Qe>4\u0018\u000eZ5oO\u0006i!-\u001e8eY\u0016\u001cuN\u001c;fqR,\u0012!\u000f\t\u0003u\u0005k\u0011a\u000f\u0006\u0003yu\n\u0011B\u001a:b[\u0016<xN]6\u000b\u0005yz\u0014\u0001B8tO&T\u0011\u0001Q\u0001\u0004_J<\u0017B\u0001\"<\u00055\u0011UO\u001c3mK\u000e{g\u000e^3yi\u0006q!-\u001e8eY\u0016\u001cuN\u001c;fqR\u0004\u0013AD2baN,H.Z\"p]R,\u0007\u0010^\u000b\u0002\rB\u0011qeR\u0005\u0003\u0011\"\u0012abQ1qgVdWmQ8oi\u0016DH/A\bdCB\u001cX\u000f\\3D_:$X\r\u001f;!\u0003\r\u0019gm\u001a\t\u0003\u00196k\u0011AE\u0005\u0003\u001dJ\u0011\u0001dQ3si&4\u0017nY1uK6\u000bg.Y4fe\u000e{gNZ5h\u0003-\u0001(o\u001c<jI\u0016\u0014X*\u00199\u0011\tEC6L\u0018\b\u0003%Z\u0003\"a\u0015\u0010\u000e\u0003QS!!\u0016\u000e\u0002\rq\u0012xn\u001c;?\u0013\t9f$\u0001\u0004Qe\u0016$WMZ\u0005\u00033j\u00131!T1q\u0015\t9f\u0004\u0005\u0002R9&\u0011QL\u0017\u0002\u0007'R\u0014\u0018N\\4\u0011\u0005\rz\u0016B\u00011\u0015\u0005M\u0019UM\u001d;jM&\u001c\u0017\r^3Qe>4\u0018\u000eZ3s\u0003\u0019a\u0014N\\5u}Q)1\rZ3gOB\u0011A\n\u0001\u0005\u0006o\u001d\u0001\r!\u000f\u0005\u0006\t\u001e\u0001\rA\u0012\u0005\u0006\u0015\u001e\u0001\ra\u0013\u0005\u0006\u001f\u001e\u0001\r\u0001U\u0001\u0004Y><\u0007C\u00016p\u001b\u0005Y'B\u00017n\u0003\u001dawnZ4j]\u001eT!A\u001c\r\u0002\tU$\u0018\u000e\\\u0005\u0003a.\u0014a\u0001T8hO\u0016\u0014\u0018\u0001\u00046bm\u0006\\U-_:u_J,W#A:\u0011\u0007u!h/\u0003\u0002v=\t1q\n\u001d;j_:\u0004\"\u0001T<\n\u0005a\u0014\"\u0001\u0004&bm\u0006\\U-_:u_J,\u0017!\u00046bm\u0006\\U-_:u_J,\u0007%\u0001\u000esK\u001eL7\u000f^3s'Nd7i\u001c8uKb$\bK]8wS\u0012,'\u000fF\u0001}!\t9S0\u0003\u0002\u007fQ\ta1)\u00199tk2,7kY8qK\u0006)1\u000f^1siR\u0011\u00111\u0001\t\u0004;\u0005\u0015\u0011bAA\u0004=\t!QK\\5u\u0003\u0011\u0019Ho\u001c9\u0002\u00191|\u0017\rZ&fsN#xN]3\u0015\u0005\u0005=\u0001CBA\t\u0003+\tI\"\u0004\u0002\u0002\u0014)\u0011aNH\u0005\u0005\u0003/\t\u0019BA\u0002Uef\u0004B!\b;\u0002\u001cA\u00191%!\b\n\u0007\u0005}AC\u0001\bNK6|'/_&fsN$xN]3\u0002-9,\u0007\u0010^\"feRLg-[2bi\u0016$\u0016.\\3pkR$\"!!\n\u0011\r\u0005E\u0011QCA\u0014!\u0011iB/!\u000b\u0011\t\u0005-\u00121G\u0007\u0003\u0003[Q1A\\A\u0018\u0015\t\t\t$\u0001\u0003kCZ\f\u0017\u0002BA\u001b\u0003[\u0011A\u0001R1uK\u0006\t2\r[3dW\u000e+'\u000f^5gS\u000e\fG/Z:")
public class CertificateManagerImpl
implements CertificateManager,
Capsule,
CapsuleConvenience,
ServiceProviding {
    private final BundleContext bundleContext;
    private final CapsuleContext capsuleContext;
    private final CertificateManagerConfig cfg;
    private final Map<String, CertificateProvider> providerMap;
    private final Logger log;
    private final Option<JavaKeystore> javaKeystore;

    public <S> ProvidableService<S> serviceToProvidableService(S service) {
        return ServiceProviding.serviceToProvidableService$((ServiceProviding)this, service);
    }

    public void onStart(Function0<BoxedUnit> f) {
        CapsuleConvenience.onStart$((CapsuleConvenience)this, f);
    }

    public void onStop(Function0<BoxedUnit> f) {
        CapsuleConvenience.onStop$((CapsuleConvenience)this, f);
    }

    public BundleContext bundleContext() {
        return this.bundleContext;
    }

    public CapsuleContext capsuleContext() {
        return this.capsuleContext;
    }

    private Option<JavaKeystore> javaKeystore() {
        return this.javaKeystore;
    }

    public CapsuleScope registerSslContextProvider() {
        return this.capsuleContext().executeWithinNewCapsuleScope((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SslContextProvider sslCtxtProvider = new SslContextProvider();
            this.javaKeystore().map((Function1 & Serializable)x$1 -> (KeyStore)x$1.loadKeyStoreFromFile().get()).foreach((Function1 & Serializable)ks -> {
                CertificateManagerImpl.$anonfun$registerSslContextProvider$3(this, sslCtxtProvider, ks);
                return BoxedUnit.UNIT;
            });
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CertificateManagerImpl.class.getClassLoader());
            public final class Blended_security_ssl_internal_CertificateManagerImpl$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("javax.net.ssl.SSLContext").asType().toTypeConstructor();
                }

                public Blended_security_ssl_internal_CertificateManagerImpl$$typecreator2$1(CertificateManagerImpl $outer) {
                }
            }
            this.serviceToProvidableService(sslCtxtProvider.clientContext()).providesService((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"client")})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Blended_security_ssl_internal_CertificateManagerImpl$$typecreator2$1(null)), ClassTag$.MODULE$.apply(SSLContext.class));
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public void start() {
        if (this.cfg.skipInitialCheck()) {
            this.log.debug((Function0 & Serializable)() -> "Skipping certificate check and refresher initialization as requested by config value: skipInitialCheck");
            return;
        }
        boolean bl = false;
        Success success = null;
        Try<Option<MemoryKeystore>> try_ = this.checkCertificates();
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.log.warn((Function0 & Serializable)() -> "Could not initialise Server certificate(s), checking if required certificates are present");
            throw e;
        }
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            Option option = (Option)success.value();
            if (None$.MODULE$.equals(option)) {
                this.registerSslContextProvider();
                this.log.info((Function0 & Serializable)() -> "Successfully refreshed trusted certificate store");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (!bl) throw new MatchError(try_);
        Option option = (Option)success.value();
        if (!(option instanceof Some)) throw new MatchError(try_);
        JavaKeystore jks = (JavaKeystore)this.javaKeystore().get();
        Try regScope = Try$.MODULE$.apply((Function0 & Serializable)() -> this.registerSslContextProvider());
        Option<RefresherConfig> option2 = this.cfg.refresherConfig();
        if (None$.MODULE$.equals(option2)) {
            this.log.debug((Function0 & Serializable)() -> "No configuration for automatic certificate refresh found");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!(option2 instanceof Some)) throw new MatchError(option2);
            Some some = (Some)option2;
            RefresherConfig c = (RefresherConfig)some.value();
            Try try_2 = regScope;
            if (try_2 instanceof Success) {
                Success success2 = (Success)try_2;
                CapsuleScope scope = (CapsuleScope)success2.value();
                this.capsuleContext().addCapsule((Capsule)new CertificateRefresher(this.bundleContext(), this, c, scope));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (!(try_2 instanceof Failure)) throw new MatchError((Object)try_2);
                Failure failure = (Failure)try_2;
                Throwable t = failure.exception();
                this.log.warn((Function0 & Serializable)() -> new StringBuilder(36).append("Failed to load keystore from [").append(jks.keystore().getAbsolutePath()).append("] : [").append(t.getMessage()).append("]").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void stop() {
    }

    private Try<Option<MemoryKeystore>> loadKeyStore() {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> this.javaKeystore().map((Function1 & Serializable)x$2 -> (MemoryKeystore)x$2.loadKeyStore().get()));
    }

    public Try<Option<Date>> nextCertificateTimeout() {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> ((Option)this.loadKeyStore().get()).map((Function1 & Serializable)x$3 -> (Date)x$3.nextCertificateTimeout().get()));
    }

    @Override
    public Try<Option<MemoryKeystore>> checkCertificates() {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            if ($this.cfg.maintainTruststore()) {
                $this.providerMap.foreach((Function1 & Serializable)x0$1 -> {
                    CertificateManagerImpl.$anonfun$checkCertificates$2(this, x0$1);
                    return BoxedUnit.UNIT;
                });
            }
            $this.log.debug((Function0 & Serializable)() -> "Loading keystore...");
            Option ks = (Option)this.loadKeyStore().get();
            $this.log.debug((Function0 & Serializable)() -> new StringBuilder(18).append("Loaded keystore [").append(ks).append("]").toString());
            return ks.map((Function1 & Serializable)ms -> {
                $this.log.debug((Function0 & Serializable)() -> new StringBuilder(39).append("Refreshing certificates for keystore [").append(ms).append("]").toString());
                MemoryKeystore changedKs = (MemoryKeystore)ms.refreshCertificates($this.cfg.certConfigs(), $this.providerMap).get();
                $this.log.debug((Function0 & Serializable)() -> new StringBuilder(30).append("Changed certificate aliases [").append(changedKs.certificates().collect((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Tuple2<String, CertificateHolder>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        Object object = ((CertificateHolder)A1._2()).change().changed() ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(A1._1()), (Object)((CertificateHolder)A1._2()).change()) : function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Tuple2<String, CertificateHolder> x1) {
                        Tuple2<String, CertificateHolder> tuple2 = x1;
                        boolean bl = ((CertificateHolder)tuple2._2()).change().changed();
                        return bl;
                    }
                })).append("]").toString());
                $this.log.debug((Function0 & Serializable)() -> "Saving keystore...");
                JavaKeystore jks = (JavaKeystore)this.javaKeystore().get();
                Try<MemoryKeystore> try_ = jks.saveKeyStore(changedKs);
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable t = failure.exception();
                    $this.log.warn(t, $this.log.warn$default$2(), (Function0 & Serializable)() -> new StringBuilder(39).append("Failed to save keystore to file [").append(jks.keystore().getAbsolutePath()).append("] : [").append(t.getMessage()).append("]").toString());
                    throw t;
                }
                if (!(try_ instanceof Success)) {
                    throw new MatchError(try_);
                }
                MemoryKeystore memoryKeystore = changedKs;
                return memoryKeystore;
            });
        });
    }

    public static final /* synthetic */ void $anonfun$registerSslContextProvider$3(CertificateManagerImpl $this, SslContextProvider sslCtxtProvider$1, KeyStore ks) {
        $this.log.debug((Function0 & Serializable)() -> "Registering SslContextProvider type=server");
        SSLContext serverCtxt = sslCtxtProvider$1.serverContext(ks, ((KeystoreConfig)$this.cfg.keystoreCfg().get()).keyPass().toCharArray());
        SSLContext.setDefault(serverCtxt);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CertificateManagerImpl.class.getClassLoader());
        public final class Blended_security_ssl_internal_CertificateManagerImpl$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("javax.net.ssl.SSLContext").asType().toTypeConstructor();
            }

            public Blended_security_ssl_internal_CertificateManagerImpl$$typecreator1$1(CertificateManagerImpl $outer) {
            }
        }
        $this.serviceToProvidableService(serverCtxt).providesService((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"server")})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Blended_security_ssl_internal_CertificateManagerImpl$$typecreator1$1(null)), ClassTag$.MODULE$.apply(SSLContext.class));
        $this.log.info((Function0 & Serializable)() -> new StringBuilder(20).append("Server SSLContext : ").append(new SslContextInfo(serverCtxt, $this.cfg.validCypherSuites()).toString()).toString());
    }

    public static final /* synthetic */ void $anonfun$checkCertificates$3(CertificateManagerImpl $this, MemoryKeystore ms) {
        Try<Option<MemoryKeystore>> try_ = new TrustStoreRefresher(ms).refreshTruststore();
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            $this.log.warn((Function0 & Serializable)() -> new StringBuilder(33).append("Unable to update trust store : [").append(t.getMessage()).append("]").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$checkCertificates$2(CertificateManagerImpl $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        CertificateProvider provider = (CertificateProvider)tuple2._2();
        Try<Option<MemoryKeystore>> try_ = provider.rootCertificates();
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Option certs = (Option)success.value();
            certs.foreach((Function1 & Serializable)ms -> {
                CertificateManagerImpl.$anonfun$checkCertificates$3($this, ms);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!(try_ instanceof Failure)) throw new MatchError(try_);
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            $this.log.warn((Function0 & Serializable)() -> new StringBuilder(33).append("Unable to update trust store : [").append(t.getMessage()).append("]").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public CertificateManagerImpl(BundleContext bundleContext, CapsuleContext capsuleContext, CertificateManagerConfig cfg, Map<String, CertificateProvider> providerMap) {
        this.bundleContext = bundleContext;
        this.capsuleContext = capsuleContext;
        this.cfg = cfg;
        this.providerMap = providerMap;
        CapsuleConvenience.$init$((CapsuleConvenience)this);
        ServiceProviding.$init$((ServiceProviding)this);
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(CertificateManagerImpl.class));
        this.javaKeystore = cfg.keystoreCfg().map((Function1 & Serializable)ksCfg -> new JavaKeystore(new File(ksCfg.keyStore()), ksCfg.storePass().toCharArray(), (Option<char[]>)new Some((Object)ksCfg.keyPass().toCharArray())));
    }
}

