/*
 * Decompiled with CFR 0.152.
 */
package blended.security.ssl;

import blended.container.context.api.ContainerContext;
import blended.security.ssl.CommonNameProvider;
import blended.security.ssl.SelfSignedConfig;
import blended.security.ssl.internal.ConfigCommonNameProvider;
import blended.util.config.Implicits$;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class SelfSignedConfig$
implements Serializable {
    public static final SelfSignedConfig$ MODULE$ = new SelfSignedConfig$();
    private static final int defaultKeyStrength = 2048;
    private static final String sigAlgPath = "signatureAlgorithm";
    private static final String validDaysPath = "validDays";

    private int defaultKeyStrength() {
        return defaultKeyStrength;
    }

    public String sigAlgPath() {
        return sigAlgPath;
    }

    public String validDaysPath() {
        return validDaysPath;
    }

    public SelfSignedConfig fromConfig(Config cfg, ContainerContext ctCtxt) {
        int keyStrength = Implicits$.MODULE$.RichDefaultConfig(cfg).getInt("keyStrength", this.defaultKeyStrength());
        String signatureAlgorithm = Implicits$.MODULE$.RichDefaultConfig(cfg).getString("signatureAlgorithm", "SHA256withRSA");
        int validDays = Implicits$.MODULE$.RichDefaultConfig(cfg).getInt("validDays", 1);
        return new SelfSignedConfig(new ConfigCommonNameProvider(cfg, ctCtxt), keyStrength, signatureAlgorithm, validDays);
    }

    public SelfSignedConfig apply(CommonNameProvider commonNameProvider, int keyStrength, String sigAlg, int validDays) {
        return new SelfSignedConfig(commonNameProvider, keyStrength, sigAlg, validDays);
    }

    public Option<Tuple4<CommonNameProvider, Object, String, Object>> unapply(SelfSignedConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.commonNameProvider(), (Object)BoxesRunTime.boxToInteger((int)x$0.keyStrength()), (Object)x$0.sigAlg(), (Object)BoxesRunTime.boxToInteger((int)x$0.validDays())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SelfSignedConfig$.class);
    }

    private SelfSignedConfig$() {
    }
}

