/*
 * Decompiled with CFR 0.152.
 */
package blended.security.ssl;

import blended.security.ssl.CertificateHolder;
import blended.security.ssl.CertificateHolder$;
import blended.security.ssl.CertificateProvider;
import blended.security.ssl.CertificateRequestBuilder;
import blended.security.ssl.CertificateSigner;
import blended.security.ssl.CommonNameProvider;
import blended.security.ssl.MemoryKeystore;
import blended.security.ssl.NoPrivateKeyException;
import blended.security.ssl.SelfSignedConfig;
import blended.security.ssl.X509CertificateInfo$;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u000553AAB\u0004\u0001\u001d!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005C\u0003$\u0001\u0011\u0005A\u0005\u0003\u0004(\u0001\u0001\u0006I\u0001\u000b\u0005\u0006a\u0001!I!\r\u0005\u0006s\u0001!\tE\u000f\u0002\u001e'\u0016dgmU5h]\u0016$7)\u001a:uS\u001aL7-\u0019;f!J|g/\u001b3fe*\u0011\u0001\"C\u0001\u0004gNd'B\u0001\u0006\f\u0003!\u0019XmY;sSRL(\"\u0001\u0007\u0002\u000f\tdWM\u001c3fI\u000e\u00011#\u0002\u0001\u0010+ea\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u0017/5\tq!\u0003\u0002\u0019\u000f\t\u00192)\u001a:uS\u001aL7-\u0019;f!J|g/\u001b3feB\u0011aCG\u0005\u00037\u001d\u0011\u0011dQ3si&4\u0017nY1uKJ+\u0017/^3ti\n+\u0018\u000e\u001c3feB\u0011a#H\u0005\u0003=\u001d\u0011\u0011cQ3si&4\u0017nY1uKNKwM\\3s\u0003\r\u0019gm\u001a\t\u0003-\u0005J!AI\u0004\u0003!M+GNZ*jO:,GmQ8oM&<\u0017A\u0002\u001fj]&$h\b\u0006\u0002&MA\u0011a\u0003\u0001\u0005\u0006?\t\u0001\r\u0001I\u0001\u0004Y><\u0007CA\u0015/\u001b\u0005Q#BA\u0016-\u0003\u001dawnZ4j]\u001eT!!L\u0006\u0002\tU$\u0018\u000e\\\u0005\u0003_)\u0012a\u0001T8hO\u0016\u0014\u0018aD4f]\u0016\u0014\u0018\r^3LKf\u0004\u0016-\u001b:\u0015\u0003I\u0002\"aM\u001c\u000e\u0003QR!AC\u001b\u000b\u0003Y\nAA[1wC&\u0011\u0001\b\u000e\u0002\b\u0017\u0016L\b+Y5s\u0003I\u0011XM\u001a:fg\"\u001cUM\u001d;jM&\u001c\u0017\r^3\u0015\u0007m\u001a\u0005\nE\u0002=}\u0001k\u0011!\u0010\u0006\u0003[EI!aP\u001f\u0003\u0007Q\u0013\u0018\u0010\u0005\u0002\u0017\u0003&\u0011!i\u0002\u0002\u0012\u0007\u0016\u0014H/\u001b4jG\u0006$X\rS8mI\u0016\u0014\b\"\u0002#\u0006\u0001\u0004)\u0015\u0001C3ySN$\u0018N\\4\u0011\u0007A1\u0005)\u0003\u0002H#\t1q\n\u001d;j_:DQ!S\u0003A\u0002)\u000b!b\u00198Qe>4\u0018\u000eZ3s!\t12*\u0003\u0002M\u000f\t\u00112i\\7n_:t\u0015-\\3Qe>4\u0018\u000eZ3s\u0001")
public class SelfSignedCertificateProvider
implements CertificateProvider,
CertificateRequestBuilder,
CertificateSigner {
    private final SelfSignedConfig cfg;
    private final Logger log;
    private Logger blended$security$ssl$CertificateRequestBuilder$$log;
    private int blended$security$ssl$CertificateRequestBuilder$$defaultValidDays;

    @Override
    public Try<X509Certificate> sign(X509v3CertificateBuilder certReq, String sigAlg, PrivateKey signKey) {
        return CertificateSigner.sign$(this, certReq, sigAlg, signKey);
    }

    @Override
    public Try<X509v3CertificateBuilder> hostCertificateRequest(CommonNameProvider cnProvider, KeyPair keyPair, BigInteger serial, int validDays, Option<CertificateHolder> issuedBy) {
        return CertificateRequestBuilder.hostCertificateRequest$(this, cnProvider, keyPair, serial, validDays, issuedBy);
    }

    @Override
    public BigInteger hostCertificateRequest$default$3() {
        return CertificateRequestBuilder.hostCertificateRequest$default$3$(this);
    }

    @Override
    public int hostCertificateRequest$default$4() {
        return CertificateRequestBuilder.hostCertificateRequest$default$4$(this);
    }

    @Override
    public Option<CertificateHolder> hostCertificateRequest$default$5() {
        return CertificateRequestBuilder.hostCertificateRequest$default$5$(this);
    }

    @Override
    public Try<Option<MemoryKeystore>> rootCertificates() {
        return CertificateProvider.rootCertificates$(this);
    }

    @Override
    public Logger blended$security$ssl$CertificateRequestBuilder$$log() {
        return this.blended$security$ssl$CertificateRequestBuilder$$log;
    }

    @Override
    public int blended$security$ssl$CertificateRequestBuilder$$defaultValidDays() {
        return this.blended$security$ssl$CertificateRequestBuilder$$defaultValidDays;
    }

    @Override
    public final void blended$security$ssl$CertificateRequestBuilder$_setter_$blended$security$ssl$CertificateRequestBuilder$$log_$eq(Logger x$1) {
        this.blended$security$ssl$CertificateRequestBuilder$$log = x$1;
    }

    @Override
    public final void blended$security$ssl$CertificateRequestBuilder$_setter_$blended$security$ssl$CertificateRequestBuilder$$defaultValidDays_$eq(int x$1) {
        this.blended$security$ssl$CertificateRequestBuilder$$defaultValidDays = x$1;
    }

    private KeyPair generateKeyPair() {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(this.cfg.keyStrength(), new SecureRandom());
        return kpg.genKeyPair();
    }

    @Override
    public Try<CertificateHolder> refreshCertificate(Option<CertificateHolder> existing, CommonNameProvider cnProvider) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            BigInteger bigInteger;
            KeyPair keyPair;
            Option oldCert = existing.map((Function1 & Serializable)x$1 -> (X509Certificate)x$1.chain().head());
            Option option = existing;
            if (option instanceof Some) {
                Some some = (Some)option;
                CertificateHolder c = (CertificateHolder)some.value();
                Option<PrivateKey> option2 = c.privateKey();
                if (None$.MODULE$.equals(option2)) {
                    throw new NoPrivateKeyException("Existing certificate must have a private key to update");
                }
                if (!(option2 instanceof Some)) {
                    throw new MatchError(option2);
                }
                Some some2 = (Some)option2;
                PrivateKey pk = (PrivateKey)some2.value();
                KeyPair keyPair2 = new KeyPair(c.publicKey(), pk);
                keyPair = keyPair2;
            } else if (None$.MODULE$.equals(option)) {
                keyPair = this.generateKeyPair();
            } else {
                throw new MatchError((Object)option);
            }
            KeyPair requesterKeypair = keyPair;
            Option option3 = oldCert;
            if (option3 instanceof Some) {
                Some some = (Some)option3;
                X509Certificate c = (X509Certificate)some.value();
                bigInteger = c.getSerialNumber().add(BigInteger.ONE);
            } else if (None$.MODULE$.equals(option3)) {
                bigInteger = BigInteger.ONE;
            } else {
                throw new MatchError((Object)option3);
            }
            BigInteger serial = bigInteger;
            CommonNameProvider x$12 = cnProvider;
            BigInteger x$2 = serial;
            int x$3 = $this.cfg.validDays();
            KeyPair x$4 = requesterKeypair;
            Option<CertificateHolder> x$5 = this.hostCertificateRequest$default$5();
            X509v3CertificateBuilder certBuilder = (X509v3CertificateBuilder)this.hostCertificateRequest(x$12, x$4, x$2, x$3, x$5).get();
            X509Certificate cert = (X509Certificate)this.sign(certBuilder, $this.cfg.sigAlg(), requesterKeypair.getPrivate()).get();
            $this.log.debug((Function0 & Serializable)() -> new StringBuilder(24).append("Generated certificate [").append(X509CertificateInfo$.MODULE$.apply(cert)).append("]").toString());
            return (CertificateHolder)CertificateHolder$.MODULE$.create(requesterKeypair, (List<Certificate>)((List)new .colon.colon((Object)cert, (List)Nil$.MODULE$))).get();
        });
    }

    public SelfSignedCertificateProvider(SelfSignedConfig cfg) {
        this.cfg = cfg;
        CertificateProvider.$init$(this);
        CertificateRequestBuilder.$init$(this);
        CertificateSigner.$init$(this);
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(SelfSignedCertificateProvider.class));
        Statics.releaseFence();
    }
}

