/*
 * Decompiled with CFR 0.152.
 */
package blended.security.ssl;

import blended.security.ssl.CertificateChainException;
import blended.security.ssl.CertificateChange;
import blended.security.ssl.CertificateChange$Unchanged$;
import blended.security.ssl.CertificateHolder;
import blended.security.ssl.EmptyCertificateChainException;
import blended.security.ssl.MissingRootCertificateException;
import blended.security.ssl.X509CertificateInfo$;
import java.io.Serializable;
import java.security.KeyPair;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try;
import scala.util.Try$;

public final class CertificateHolder$
implements Serializable {
    public static final CertificateHolder$ MODULE$ = new CertificateHolder$();

    private CertificateChange $lessinit$greater$default$4() {
        return CertificateChange$Unchanged$.MODULE$;
    }

    public CertificateHolder create(X509Certificate cert) {
        return this.apply(cert.getPublicKey(), (Option<PrivateKey>)None$.MODULE$, (List<X509Certificate>)((List)new .colon.colon((Object)cert, (List)Nil$.MODULE$)), this.apply$default$4());
    }

    public Try<CertificateHolder> create(PublicKey publicKey, List<Certificate> chain) {
        return this.create(publicKey, (Option<PrivateKey>)None$.MODULE$, chain);
    }

    public Try<CertificateHolder> create(KeyPair keyPair, List<Certificate> chain) {
        return this.create(keyPair.getPublic(), (Option<PrivateKey>)new Some((Object)keyPair.getPrivate()), chain);
    }

    public Try<CertificateHolder> create(List<Certificate> chain) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            List x509Chain = chain.map((Function1 & Serializable)x$2 -> (X509Certificate)x$2);
            Option option = x509Chain.find((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)CertificateHolder$.$anonfun$create$3(c)));
            if (None$.MODULE$.equals(option)) {
                throw new MissingRootCertificateException();
            }
            if (!(option instanceof Some)) {
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            X509Certificate root = (X509Certificate)some.value();
            root.verify(root.getPublicKey());
            X509Certificate x509Certificate = root;
            List sortedChain = (List)MODULE$.sort((List<X509Certificate>)x509Chain.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)CertificateHolder$.$anonfun$create$4(root, c))), (List<X509Certificate>)Nil$.MODULE$.$colon$colon((Object)x509Certificate)).get();
            CertificateHolder certificateHolder = (CertificateHolder)MODULE$.create(((Certificate)sortedChain.head()).getPublicKey(), (Option<PrivateKey>)None$.MODULE$, (List<Certificate>)sortedChain).get();
            return certificateHolder;
        });
    }

    public Try<CertificateHolder> create(PublicKey publicKey, Option<PrivateKey> privateKey, List<Certificate> chain) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            List list;
            List list2 = chain.map((Function1 & Serializable)x$3 -> (X509Certificate)x$3);
            if (Nil$.MODULE$.equals(list2)) {
                throw new EmptyCertificateChainException();
            }
            Option option = list2.find((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)CertificateHolder$.$anonfun$create$7(c)));
            if (None$.MODULE$.equals(option)) {
                throw new MissingRootCertificateException();
            }
            if (!(option instanceof Some)) {
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            X509Certificate root = (X509Certificate)some.value();
            root.verify(root.getPublicKey());
            X509Certificate x509Certificate = root;
            List list3 = (List)MODULE$.sort((List<X509Certificate>)list2.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)CertificateHolder$.$anonfun$create$8(root, c))), (List<X509Certificate>)Nil$.MODULE$.$colon$colon((Object)x509Certificate)).get();
            List sortedChain = list = list3;
            return MODULE$.apply(publicKey, privateKey, (List<X509Certificate>)sortedChain, MODULE$.apply$default$4());
        });
    }

    private Function1<X509Certificate, Object> signedBy(Principal issuer) {
        return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)CertificateHolder$.$anonfun$signedBy$1(issuer, c));
    }

    private Try<List<X509Certificate>> sort(List<X509Certificate> remaining, List<X509Certificate> sorted) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            List list;
            List list2 = remaining;
            if (Nil$.MODULE$.equals(list2)) {
                list = sorted;
            } else {
                X509Certificate next;
                Option option = list2.find(MODULE$.signedBy(((X509Certificate)sorted.head()).getSubjectDN()));
                if (None$.MODULE$.equals(option)) {
                    throw new CertificateChainException(new StringBuilder(46).append("No signed certificate found for certificate [").append(X509CertificateInfo$.MODULE$.apply((X509Certificate)sorted.head())).append("]").toString());
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    next = (X509Certificate)some.value();
                    if (sorted.contains((Object)next)) {
                        throw new CertificateChainException("Certificate chain must not contain circular references");
                    }
                } else {
                    throw new MatchError((Object)option);
                }
                next.verify(((Certificate)sorted.head()).getPublicKey());
                X509Certificate x509Certificate = next;
                List list3 = (List)MODULE$.sort((List<X509Certificate>)remaining.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)CertificateHolder$.$anonfun$sort$2(next, c))), (List<X509Certificate>)sorted.$colon$colon((Object)x509Certificate)).get();
                list = list3;
            }
            return list;
        });
    }

    public CertificateHolder apply(PublicKey publicKey, Option<PrivateKey> privateKey, List<X509Certificate> chain, CertificateChange change) {
        return new CertificateHolder(publicKey, privateKey, chain, change);
    }

    public CertificateChange apply$default$4() {
        return CertificateChange$Unchanged$.MODULE$;
    }

    public Option<Tuple4<PublicKey, Option<PrivateKey>, List<X509Certificate>, CertificateChange>> unapply(CertificateHolder x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.publicKey(), x$0.privateKey(), x$0.chain(), (Object)x$0.change()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CertificateHolder$.class);
    }

    public static final /* synthetic */ boolean $anonfun$create$3(X509Certificate c) {
        return ((Object)c.getSubjectDN()).equals(c.getIssuerDN());
    }

    public static final /* synthetic */ boolean $anonfun$create$4(X509Certificate root$1, X509Certificate c) {
        return !c.equals(root$1);
    }

    public static final /* synthetic */ boolean $anonfun$create$7(X509Certificate c) {
        return ((Object)c.getSubjectDN()).equals(c.getIssuerDN());
    }

    public static final /* synthetic */ boolean $anonfun$create$8(X509Certificate root$2, X509Certificate c) {
        return !c.equals(root$2);
    }

    public static final /* synthetic */ boolean $anonfun$signedBy$1(Principal issuer$1, X509Certificate c) {
        return !((Object)c.getIssuerDN()).equals(c.getSubjectDN()) && ((Object)c.getIssuerDN()).equals(issuer$1);
    }

    public static final /* synthetic */ boolean $anonfun$sort$2(X509Certificate next$1, X509Certificate c) {
        return !c.equals(next$1);
    }

    private CertificateHolder$() {
    }
}

