/*
 * Decompiled with CFR 0.152.
 */
package blended.mgmt.repo.file;

import blended.mgmt.repo.WritableArtifactRepo;
import blended.mgmt.repo.file.FileArtifactRepo$;
import blended.util.io.StreamCopy$;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005Uc\u0001B\n\u0015\u0001uA\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0005\f\u0005\tq\u0001\u0011\t\u0011)A\u0005[!A\u0011\b\u0001B\u0001B\u0003%!\bC\u0003C\u0001\u0011\u00051\t\u0003\u0004I\u0001\u0001\u0006I!\u0013\u0005\u0006#\u0002!\tA\u0015\u0005\u0006Y\u0002!\t!\u001c\u0005\u0006e\u0002!\ta\u001d\u0005\u0006m\u0002!\te\u001e\u0005\u0006q\u0002!\t!\u001f\u0005\b\u0003\u0013\u0001A\u0011IA\u0006\u000f\u001d\t)\u0003\u0006E\u0001\u0003O1aa\u0005\u000b\t\u0002\u0005%\u0002B\u0002\"\u000e\t\u0003\tY\u0003C\u0004\u0002.5!\t!a\f\u0007\r\u0005\u0005S\u0002AA\"\u0011%\tY\u0005\u0005B\u0001B\u0003%Q\u0006\u0003\u0004C!\u0011\u0005\u0011Q\n\u0002\u0011\r&dW-\u0011:uS\u001a\f7\r\u001e*fa>T!!\u0006\f\u0002\t\u0019LG.\u001a\u0006\u0003/a\tAA]3q_*\u0011\u0011DG\u0001\u0005[\u001elGOC\u0001\u001c\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\u0001a\u0005\u0003\u0001=\u0011B\u0003CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g\r\u0005\u0002&M5\ta#\u0003\u0002(-\ta\u0011I\u001d;jM\u0006\u001cGOU3q_B\u0011Q%K\u0005\u0003UY\u0011Ac\u0016:ji\u0006\u0014G.Z!si&4\u0017m\u0019;SKB|\u0017A\u0002:fa>LE-F\u0001.!\tqSG\u0004\u00020gA\u0011\u0001\u0007I\u0007\u0002c)\u0011!\u0007H\u0001\u0007yI|w\u000e\u001e \n\u0005Q\u0002\u0013A\u0002)sK\u0012,g-\u0003\u00027o\t11\u000b\u001e:j]\u001eT!\u0001\u000e\u0011\u0002\u000fI,\u0007o\\%eA\u00059!-Y:f\t&\u0014\bCA\u001eA\u001b\u0005a$BA\u001f?\u0003\tIwNC\u0001@\u0003\u0011Q\u0017M^1\n\u0005\u0005c$\u0001\u0002$jY\u0016\fa\u0001P5oSRtDc\u0001#G\u000fB\u0011Q\tA\u0007\u0002)!)1\u0006\u0002a\u0001[!)\u0011\b\u0002a\u0001u\u0005\u0019An\\4\u0011\u0005){U\"A&\u000b\u00051k\u0015a\u00027pO\u001eLgn\u001a\u0006\u0003\u001dj\tA!\u001e;jY&\u0011\u0001k\u0013\u0002\u0007\u0019><w-\u001a:\u0002']LG\u000f[\"iK\u000e\\W\r\u001a$jY\u0016\u0004\u0016\r\u001e5\u0016\u0005McFC\u0001+k)\t)V\rE\u0002W1jk\u0011a\u0016\u0006\u0003\u001d\u0002J!!W,\u0003\u0007Q\u0013\u0018\u0010\u0005\u0002\\92\u0001A!B/\u0007\u0005\u0004q&!\u0001+\u0012\u0005}\u0013\u0007CA\u0010a\u0013\t\t\u0007EA\u0004O_RD\u0017N\\4\u0011\u0005}\u0019\u0017B\u00013!\u0005\r\te.\u001f\u0005\u0006M\u001a\u0001\raZ\u0001\u0002MB!q\u0004\u001b\u001e[\u0013\tI\u0007EA\u0005Gk:\u001cG/[8oc!)1N\u0002a\u0001[\u0005!\u0001/\u0019;i\u0003!1\u0017N\u001c3GS2,GC\u00018r!\ryrNO\u0005\u0003a\u0002\u0012aa\u00149uS>t\u0007\"B6\b\u0001\u0004i\u0013\u0001\u00064j]\u00124\u0015\u000e\\3TQ\u0006\f4\t[3dWN,X\u000e\u0006\u0002ukB\u0019qd\\\u0017\t\u000b-D\u0001\u0019A\u0017\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!L\u0001\nY&\u001cHOR5mKN$2A_A\u0004!\u0011Y\u0018\u0011A\u0017\u000f\u0005qthB\u0001\u0019~\u0013\u0005\t\u0013BA@!\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0001\u0002\u0006\tA\u0011\n^3sCR|'O\u0003\u0002\u0000A!)1N\u0003a\u0001[\u0005QQ\u000f\u001d7pC\u00124\u0015\u000e\\3\u0015\u0011\u00055\u0011QCA\f\u0003C\u0001BA\u0016-\u0002\u0010A\u0019q$!\u0005\n\u0007\u0005M\u0001E\u0001\u0003V]&$\b\"B6\f\u0001\u0004i\u0003bBA\r\u0017\u0001\u0007\u00111D\u0001\fM&dWmQ8oi\u0016tG\u000fE\u0002<\u0003;I1!a\b=\u0005-Ie\u000e];u'R\u0014X-Y7\t\r\u0005\r2\u00021\u0001u\u0003\u001d\u0019\b.Y\u0019Tk6\f\u0001CR5mK\u0006\u0013H/\u001b4bGR\u0014V\r]8\u0011\u0005\u0015k1CA\u0007\u001f)\t\t9#A\u0007csR,7\u000fV8TiJLgn\u001a\u000b\u0004[\u0005E\u0002bBA\u001a\u001f\u0001\u0007\u0011QG\u0001\u0007I&<Wm\u001d;\u0011\u000b}\t9$a\u000f\n\u0007\u0005e\u0002EA\u0003BeJ\f\u0017\u0010E\u0002 \u0003{I1!a\u0010!\u0005\u0011\u0011\u0015\u0010^3\u00035\u0005\u0013H/\u001b4bGR\u001cu\u000e\u001c7jg&|g.\u0012=dKB$\u0018n\u001c8\u0014\u0007A\t)\u0005E\u0002|\u0003\u000fJA!!\u0013\u0002\u0006\t\u0001\"+\u001e8uS6,W\t_2faRLwN\\\u0001\u0004[N<G\u0003BA(\u0003'\u00022!!\u0015\u0011\u001b\u0005i\u0001BBA&%\u0001\u0007Q\u0006")
public class FileArtifactRepo
implements WritableArtifactRepo {
    private final String repoId;
    private final File baseDir;
    private final Logger log;

    public static String bytesToString(byte[] byArray) {
        return FileArtifactRepo$.MODULE$.bytesToString(byArray);
    }

    @Override
    public String repoId() {
        return this.repoId;
    }

    public <T> Try<T> withCheckedFilePath(String path, Function1<File, T> f) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            URI base = $this.baseDir.toURI().normalize();
            URI toCheck = new File($this.baseDir, path).toURI().normalize();
            if (!toCheck.getPath().startsWith(base.getPath())) {
                throw scala.sys.package$.MODULE$.error("invalid path given");
            }
            String pathToCheck = toCheck.getPath().substring(base.getPath().length());
            if (pathToCheck.startsWith("..") || pathToCheck.startsWith("/..")) {
                throw scala.sys.package$.MODULE$.error("invalid path given");
            }
            return new File(toCheck);
        }).map(f);
    }

    @Override
    public Option<File> findFile(String path) {
        return (Option)this.withCheckedFilePath(path, (Function1 & Serializable)file -> file.exists() && file.isFile() ? Option$.MODULE$.apply(file) : None$.MODULE$).getOrElse((Function0 & Serializable)() -> None$.MODULE$);
    }

    @Override
    public Option<String> findFileSha1Checksum(String path) {
        return this.findFile(path).flatMap((Function1 & Serializable)file -> {
            Option option;
            try (DigestInputStream sha1Stream = new DigestInputStream(new BufferedInputStream(new FileInputStream((File)file)), MessageDigest.getInstance("SHA"));){
                try {
                    while (sha1Stream.read() != -1) {
                    }
                    option = Option$.MODULE$.apply((Object)FileArtifactRepo$.MODULE$.bytesToString(sha1Stream.getMessageDigest().digest()));
                }
                catch (Throwable throwable) {
                    Option option2;
                    Throwable throwable2 = throwable;
                    if (throwable2 == null || (option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        throw throwable;
                    }
                    None$ none$ = None$.MODULE$;
                    option = none$;
                }
            }
            return option;
        });
    }

    public String toString() {
        return new StringBuilder(18).append(this.getClass().getSimpleName()).append("(repoId=").append(this.repoId()).append(",baseDir=").append(this.baseDir).append(")").toString();
    }

    @Override
    public Iterator<String> listFiles(String path) {
        return (Iterator)this.withCheckedFilePath(path, (Function1 & Serializable)file -> {
            Iterator iterator;
            if (!file.exists()) {
                iterator = package$.MODULE$.Iterator().empty();
            } else {
                Iterator files = FileArtifactRepo.getFiles$1(file.toPath());
                URI baseFile = file.toURI();
                iterator = files.map((Function1 & Serializable)f -> baseFile.relativize(f.toUri().normalize()).getPath());
            }
            return iterator;
        }).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Iterator().empty());
    }

    @Override
    public Try<BoxedUnit> uploadFile(String path, InputStream fileContent, Option<String> sha1Sum) {
        return this.withCheckedFilePath(path, (Function1 & Serializable)file -> {
            FileArtifactRepo.$anonfun$uploadFile$1(this, sha1Sum, path, fileContent, file);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$listFiles$3(boolean isDir$1, Path f) {
        return !isDir$1;
    }

    private static final Iterator getFiles$1(Path dir) {
        Iterator files = CollectionConverters$.MODULE$.IteratorHasAsScala(Files.newDirectoryStream(dir).iterator()).asScala();
        return files.flatMap((Function1 & Serializable)f2 -> {
            boolean isDir = Files.isDirectory(f2, new LinkOption[0]);
            Iterator file = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{f2})).filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FileArtifactRepo.$anonfun$listFiles$3(isDir, f)));
            Iterator childs = isDir ? FileArtifactRepo.getFiles$1(f2) : package$.MODULE$.Iterator().empty();
            return file.$plus$plus((Function0 & Serializable)() -> childs);
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$uploadFile$1(FileArtifactRepo $this, Option sha1Sum$1, String path$2, InputStream fileContent$1, File file) {
        if (file.exists()) {
            if (file.isFile()) {
                Option option = sha1Sum$1;
                if (None$.MODULE$.equals(option)) {
                    throw new ArtifactCollisionException(new StringBuilder(51).append("There is already an artifact installed under path: ").append(path$2).toString());
                }
                Option<String> existingSum = $this.findFileSha1Checksum(path$2);
                Option option2 = option;
                Option<String> option3 = existingSum;
                if (option2 == null ? option3 != null : !option2.equals(option3)) {
                    $this.log.info((Function0 & Serializable)() -> new StringBuilder(70).append("Artifact with different checksum (existing: ").append(existingSum).append(", new: ").append(option).append(") already present: ").append(path$2).toString());
                    throw new ArtifactCollisionException(new StringBuilder(77).append("There is already an artifact with a different checksum installed under path: ").append(path$2).toString());
                }
                $this.log.info((Function0 & Serializable)() -> new StringBuilder(45).append("Artifact with same checksum already present: ").append(path$2).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            $this.log.error((Function0 & Serializable)() -> new StringBuilder(46).append("Artifact path [").append(path$2).append("] is a directory. Cannot upload").toString());
            throw new IllegalArgumentException(new StringBuilder(49).append("The given path [").append(path$2).append("] cannot be used as artifact path").toString());
        }
        Option$.MODULE$.apply((Object)file.getParentFile()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.mkdirs()));
        try (FileOutputStream fos = new FileOutputStream(file);){
            $this.log.debug((Function0 & Serializable)() -> new StringBuilder(20).append("About to save file: ").append(file).toString());
            StreamCopy$.MODULE$.copy(fileContent$1, (OutputStream)fos);
            return;
        }
    }

    public FileArtifactRepo(String repoId, File baseDir) {
        this.repoId = repoId;
        this.baseDir = baseDir;
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(FileArtifactRepo.class));
    }

    public static class ArtifactCollisionException
    extends RuntimeException {
        public ArtifactCollisionException(String msg) {
            super(msg);
        }
    }
}

