/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging;

import org.json.simple.JSONValue;

enum MessageFormat {
    TEXT("text"),
    JSON("json");

    private final String format;

    private MessageFormat(String format) {
        this.format = format;
    }

    Object parse(String message) {
        if (message == null || message.trim().length() == 0) {
            return message;
        }
        switch (this) {
            case JSON: {
                return this.parseJsonEventMessage(message);
            }
        }
        return message;
    }

    private Object parseJsonEventMessage(String message) {
        Object jsonObject = JSONValue.parse((String)message);
        if (jsonObject == null) {
            return message;
        }
        return jsonObject;
    }

    static MessageFormat fromFormat(String format) {
        if (format != null && format.trim().length() > 0) {
            format = format.toLowerCase();
            for (MessageFormat formatEnum : MessageFormat.values()) {
                if (!formatEnum.format.equals(format)) continue;
                return formatEnum;
            }
        }
        return TEXT;
    }
}

