/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.client;

import akka.Done;
import akka.Done$;
import akka.actor.ActorRefFactory;
import akka.annotation.InternalStableApi;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.client.PoolFlow;
import akka.http.impl.engine.client.PoolGateway;
import akka.http.impl.engine.client.PoolInterface$;
import akka.http.impl.engine.client.PoolInterface$ShutdownReason$IdleTimeout$;
import akka.http.impl.engine.client.PoolInterface$ShutdownReason$ShutdownRequested$;
import akka.http.impl.settings.HostConnectionPoolSetup;
import akka.http.impl.util.StreamUtils$;
import akka.http.impl.util.StreamUtils$CaptureTerminationOp$;
import akka.http.impl.util.package$;
import akka.http.impl.util.package$RichHttpRequest$;
import akka.http.javadsl.ConnectionContext;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.HttpResponse$;
import akka.http.scaladsl.model.OptHttpResponse$;
import akka.http.scaladsl.model.ResponseEntity;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.Host;
import akka.http.scaladsl.model.headers.Host$;
import akka.stream.Attributes;
import akka.stream.BufferOverflowException;
import akka.stream.FlowShape;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Materializer;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.stage.AsyncCallback;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.GraphStageWithMaterializedValue;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.stream.stage.TimerGraphStageLogic;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\r}g\u0001C0a!\u0003\r\nA\u001a6\t\u000bE\u0004a\u0011A:\t\u000f\u0005]\u0001A\"\u0001\u0002\u001a!911\u0012\u0001\u0007\u0002\ruw\u0001CA\u0015A\"\u0005a-a\u000b\u0007\u000f}\u0003\u0007\u0012\u00014\u0002.!9\u0011qF\u0003\u0005\u0002\u0005EbACA\u001a\u000bA\u0005\u0019\u0013\u00054\u00026\u001dA\u0011\u0011\\\u0003\t\u0002\u0019\fyD\u0002\u0005\u00024\u0015A\tAZA\u001e\u0011\u001d\ty#\u0003C\u0001\u0003{9q!a\u0011\n\u0011\u0003\u000b)EB\u0004\u0002J%A\t)a\u0013\t\u000f\u0005=B\u0002\"\u0001\u0002n!I\u0011q\u000e\u0007\u0002\u0002\u0013\u0005\u0013\u0011\u000f\u0005\n\u0003\u0007c\u0011\u0011!C\u0001\u0003\u000bC\u0011\"!$\r\u0003\u0003%\t!a$\t\u0013\u0005mE\"!A\u0005B\u0005u\u0005\"CAV\u0019\u0005\u0005I\u0011AAW\u0011%\t9\fDA\u0001\n\u0003\nI\fC\u0005\u0002<2\t\t\u0011\"\u0011\u0002>\"I\u0011q\u0018\u0007\u0002\u0002\u0013%\u0011\u0011Y\u0004\b\u0003\u0013L\u0001\u0012QAf\r\u001d\tI$\u0003EA\u0003\u001bDq!a\f\u0018\t\u0003\ty\rC\u0005\u0002p]\t\t\u0011\"\u0011\u0002r!I\u00111Q\f\u0002\u0002\u0013\u0005\u0011Q\u0011\u0005\n\u0003\u001b;\u0012\u0011!C\u0001\u0003#D\u0011\"a'\u0018\u0003\u0003%\t%!(\t\u0013\u0005-v#!A\u0005\u0002\u0005U\u0007\"CA\\/\u0005\u0005I\u0011IA]\u0011%\tYlFA\u0001\n\u0003\ni\fC\u0005\u0002@^\t\t\u0011\"\u0003\u0002B\"9\u00111\\\u0003\u0005\u0002\u0005u\u0007\"CAe\u000b\t\u0007I\u0011BA9\u0011!\u0011i!\u0002Q\u0001\n\u0005MdA\u0002B\b\u000b\u0001\u0011\t\u0002\u0003\u0006\u0002v\u0012\u0012\t\u0011)A\u0005\u0003oD!B!\u0014%\u0005\u0003\u0005\u000b\u0011\u0002B(\u0011\u001d\ty\u0003\nC\u0001\u00057B\u0011Ba\u0019%\u0005\u0004%IA!\u001a\t\u0011\t5D\u0005)A\u0005\u0005OB\u0011Ba\u001c%\u0005\u0004%IA!\u001d\t\u0011\teD\u0005)A\u0005\u0005gBqAa\u001f%\t\u0003\u0012i\bC\u0004\u0003\u0000\u0011\"\tE!!\t\u000f\t}D\u0005\"\u0011\u0003\u001a\u001a1!\u0011U\u0003\u0005\u0005GC!\"!>0\u0005\u0003\u0005\u000b\u0011BA|\u0011)\u0011Yh\fB\u0001B\u0003%!q\u0004\u0005\u000b\u0005Gz#\u0011!Q\u0001\n\t\u001d\u0004B\u0003B8_\t\u0005\t\u0015!\u0003\u0003t!Q!QJ\u0018\u0003\u0002\u0003\u0006IAa\u0014\t\u0015\t]vF!A!\u0002\u0017\u0011I\fC\u0004\u00020=\"\tAa0\t\u0011\tEw\u0006)A\u0005\u0005'D\u0011B!70\u0005\u0004%\tAa7\t\u0011\t%x\u0006)A\u0005\u0005;D\u0011Ba;0\u0005\u0004%\tA!<\t\u0011\tmx\u0006)A\u0005\u0005_D\u0011B!@0\u0005\u0004%\tAa@\t\u0011\r\rq\u0006)A\u0005\u0007\u0003Aqa!\u00020\t\u0003\u00199\u0001C\u0005\u0004\n=\u0002\r\u0011\"\u0001\u0004\f!I11C\u0018A\u0002\u0013\u00051Q\u0003\u0005\t\u00073y\u0003\u0015)\u0003\u0004\u000e!I11D\u0018A\u0002\u0013\u0005\u0011Q\u0011\u0005\n\u0007;y\u0003\u0019!C\u0001\u0007?A\u0001ba\t0A\u0003&\u0011q\u0011\u0005\b\u0007KyC\u0011IB\u0014\u0011\u001d\u0019Ic\fC)\u0007WAqa!\r0\t\u0003\u001a9\u0003C\u0004\u00044=\"\tea\n\t\u0013\rUrF1A\u0005\u0002\r]\u0002\u0002CB$_\u0001\u0006Ia!\u000f\t\u0013\r%sF1A\u0005\u0002\r-\u0003\u0002CB)_\u0001\u0006Ia!\u0014\t\u0013\rMsF1A\u0005\u0002\rU\u0003\u0002CB-_\u0001\u0006Iaa\u0016\t\u000f\rms\u0006\"\u0001\u0004(!91QL\u0018\u0005\u0002\r}\u0003bBB3_\u0011\u00051q\u0005\u0005\b\u0007OzC\u0011AB\u0014\u0011\u001d\u0019Ig\fC\u0001\u0007\u000fAqaa\u001b0\t\u0003\u001ai\u0007C\u0004\u0004z=\"\tea\n\t\rE|C\u0011IB>\u0011\u001d\t9b\fC!\u0007\u0003Cqaa#0\t\u0003\u001ai\tC\u0004\u0004\u0010>\"\ta!%\t\u000f\r\rv\u0006\"\u0001\u0004&\"911V\u0018\u0005\u0002\r5\u0006bBBb_\u0011\u00051Q\u0019\u0005\u000b\u0007\u001f,!\u0019!C\u0001M\u000eE\u0007\u0002CBm\u000b\u0001\u0006Iaa5\u0003\u001bA{w\u000e\\%oi\u0016\u0014h-Y2f\u0015\t\t'-\u0001\u0004dY&,g\u000e\u001e\u0006\u0003G\u0012\fa!\u001a8hS:,'BA3g\u0003\u0011IW\u000e\u001d7\u000b\u0005\u001dD\u0017\u0001\u00025uiBT\u0011![\u0001\u0005C.\\\u0017m\u0005\u0002\u0001WB\u0011An\\\u0007\u0002[*\ta.A\u0003tG\u0006d\u0017-\u0003\u0002q[\n1\u0011I\\=SK\u001a\fqA]3rk\u0016\u001cHo\u0001\u0001\u0015\tQ<\u0018\u0011\u0001\t\u0003YVL!A^7\u0003\tUs\u0017\u000e\u001e\u0005\u0006c\u0006\u0001\r\u0001\u001f\t\u0003szl\u0011A\u001f\u0006\u0003wr\fQ!\\8eK2T!! 4\u0002\u0011M\u001c\u0017\r\\1eg2L!a >\u0003\u0017!#H\u000f\u001d*fcV,7\u000f\u001e\u0005\b\u0003\u0007\t\u0001\u0019AA\u0003\u0003=\u0011Xm\u001d9p]N,\u0007K]8nSN,\u0007CBA\u0004\u0003\u001b\t\t\"\u0004\u0002\u0002\n)\u0019\u00111B7\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002\u0010\u0005%!a\u0002)s_6L7/\u001a\t\u0004s\u0006M\u0011bAA\u000bu\na\u0001\n\u001e;q%\u0016\u001c\bo\u001c8tK\u0006A1\u000f[;uI><h\u000e\u0006\u0002\u0002\u001cQ!\u0011QDBn!\u0019\t9!a\b\u0002$%!\u0011\u0011EA\u0005\u0005\u00191U\u000f^;sKB\u0019\u0011QE\u0004\u000f\u0007\u0005\u001dB!D\u0001a\u00035\u0001vn\u001c7J]R,'OZ1dKB\u0019\u0011qE\u0003\u0014\u0005\u0015Y\u0017A\u0002\u001fj]&$h\b\u0006\u0002\u0002,\tq1\u000b[;uI><hNU3bg>t7CA\u0004lS\r9q\u0003\u0004\u0002\f\u0013\u0012dW\rV5nK>,Ho\u0005\u0002\nWR\u0011\u0011q\b\t\u0004\u0003\u0003JQ\"A\u0003\u0002#MCW\u000f\u001e3po:\u0014V-];fgR,G\rE\u0002\u0002H1i\u0011!\u0003\u0002\u0012'\",H\u000fZ8x]J+\u0017/^3ti\u0016$7\u0003\u0003\u0007l\u0003\u001b\ny%!\u0016\u0011\u0007\u0005\u0005s\u0001E\u0002m\u0003#J1!a\u0015n\u0005\u001d\u0001&o\u001c3vGR\u0004B!a\u0016\u0002h9!\u0011\u0011LA2\u001d\u0011\tY&!\u0019\u000e\u0005\u0005u#bAA0e\u00061AH]8pizJ\u0011A\\\u0005\u0004\u0003Kj\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003S\nYG\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002f5$\"!!\u0012\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\b\u0005\u0003\u0002v\u0005}TBAA<\u0015\u0011\tI(a\u001f\u0002\t1\fgn\u001a\u0006\u0003\u0003{\nAA[1wC&!\u0011\u0011QA<\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0011\t\u0004Y\u0006%\u0015bAAF[\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011SAL!\ra\u00171S\u0005\u0004\u0003+k'aA!os\"I\u0011\u0011\u0014\t\u0002\u0002\u0003\u0007\u0011qQ\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005}\u0005CBAQ\u0003O\u000b\t*\u0004\u0002\u0002$*\u0019\u0011QU7\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002*\u0006\r&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a,\u00026B\u0019A.!-\n\u0007\u0005MVNA\u0004C_>dW-\u00198\t\u0013\u0005e%#!AA\u0002\u0005E\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\u001d\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005M\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAb!\u0011\t)(!2\n\t\u0005\u001d\u0017q\u000f\u0002\u0007\u001f\nTWm\u0019;\u0002\u0017%#G.\u001a+j[\u0016|W\u000f\u001e\t\u0004\u0003\u000f:2\u0003C\fl\u0003\u001b\ny%!\u0016\u0015\u0005\u0005-G\u0003BAI\u0003'D\u0011\"!'\u001c\u0003\u0003\u0005\r!a\"\u0015\t\u0005=\u0016q\u001b\u0005\n\u00033k\u0012\u0011!a\u0001\u0003#\u000bab\u00155vi\u0012|wO\u001c*fCN|g.A\u0003baBd\u0017\u0010\u0006\u0004\u0002`\u0006M\u0018Q \u000b\u0005\u0003C\f\u0019\u000fE\u0002\u0002(\u0001Aq!!:\"\u0001\b\t9/\u0001\u0002g[B!\u0011\u0011^Ax\u001b\t\tYOC\u0002\u0002n\"\faa\u001d;sK\u0006l\u0017\u0002BAy\u0003W\u0014A\"T1uKJL\u0017\r\\5{KJDq!!>\"\u0001\u0004\t90A\u0004hCR,w/Y=\u0011\t\u0005\u001d\u0012\u0011`\u0005\u0004\u0003w\u0004'a\u0003)p_2<\u0015\r^3xCfDq!a@\"\u0001\u0004\u0011\t!\u0001\u0004qCJ,g\u000e\u001e\t\u0005\u0005\u0007\u0011I!\u0004\u0002\u0003\u0006)\u0019!q\u00015\u0002\u000b\u0005\u001cGo\u001c:\n\t\t-!Q\u0001\u0002\u0010\u0003\u000e$xN\u001d*fM\u001a\u000b7\r^8ss\u0006a\u0011\n\u001a7f)&lWm\\;uA\t\u0011\u0002k\\8m\u0013:$XM\u001d4bG\u0016\u001cF/Y4f'\r!#1\u0003\t\t\u0005+\u0011YBa\b\u0002b6\u0011!q\u0003\u0006\u0005\u00053\tY/A\u0003ti\u0006<W-\u0003\u0003\u0003\u001e\t]!aH$sCBD7\u000b^1hK^KG\u000f['bi\u0016\u0014\u0018.\u00197ju\u0016$g+\u00197vKBA\u0011\u0011\u001eB\u0011\u0005K\u00119%\u0003\u0003\u0003$\u0005-(!\u0003$m_^\u001c\u0006.\u00199f!\u0011\u00119C!\u0011\u000f\t\t%\"Q\b\b\u0005\u0005W\u0011YD\u0004\u0003\u0003.\teb\u0002\u0002B\u0018\u0005oqAA!\r\u000369!\u00111\fB\u001a\u0013\u0005I\u0017BA4i\u0013\t)g-\u0003\u0002dI&\u0011\u0011MY\u0005\u0004\u0005\u007f\u0001\u0017\u0001\u0003)p_24En\\<\n\t\t\r#Q\t\u0002\u0010%\u0016\u001c\bo\u001c8tK\u000e{g\u000e^3yi*\u0019!q\b1\u0011\t\t\u001d\"\u0011J\u0005\u0005\u0005\u0017\u0012)E\u0001\bSKF,Xm\u001d;D_:$X\r\u001f;\u0002\u00071|w\r\u0005\u0003\u0003R\t]SB\u0001B*\u0015\r\u0011)\u0006[\u0001\u0006KZ,g\u000e^\u0005\u0005\u00053\u0012\u0019F\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\u0015\r\tu#q\fB1!\r\t\t\u0005\n\u0005\b\u0003k<\u0003\u0019AA|\u0011\u001d\u0011ie\na\u0001\u0005\u001f\n!B]3rk\u0016\u001cHoT;u+\t\u00119\u0007\u0005\u0004\u0002j\n%$qI\u0005\u0005\u0005W\nYO\u0001\u0004PkRdW\r^\u0001\fe\u0016\fX/Z:u\u001fV$\b%\u0001\u0006sKN\u0004xN\\:f\u0013:,\"Aa\u001d\u0011\r\u0005%(Q\u000fB\u0013\u0013\u0011\u00119(a;\u0003\u000b%sG.\u001a;\u0002\u0017I,7\u000f]8og\u0016Le\u000eI\u0001\u0006g\"\f\u0007/Z\u000b\u0003\u0005?\tqd\u0019:fCR,Gj\\4jG\u0006sG-T1uKJL\u0017\r\\5{K\u00124\u0016\r\\;f)\u0011\u0011\u0019Ia$\u0011\u000f1\u0014)I!#\u0002b&\u0019!qQ7\u0003\rQ+\b\u000f\\33!\u0011\u0011)Ba#\n\t\t5%q\u0003\u0002\u0010\u000fJ\f\u0007\u000f[*uC\u001e,Gj\\4jG\"9!\u0011S\u0017A\u0002\tM\u0015aE5oQ\u0016\u0014\u0018\u000e^3e\u0003R$(/\u001b2vi\u0016\u001c\b\u0003BAu\u0005+KAAa&\u0002l\nQ\u0011\t\u001e;sS\n,H/Z:\u0015\r\t\r%1\u0014BO\u0011\u001d\u0011\tJ\fa\u0001\u0005'CqAa(/\u0001\u0004\t9/A\u0007`[\u0006$XM]5bY&TXM\u001d\u0002\u0006\u0019><\u0017nY\n\n_\t\u0015\u0016\u0011\u001dBV\u0005c\u0003BA!\u0006\u0003(&!!\u0011\u0016B\f\u0005Q!\u0016.\\3s\u000fJ\f\u0007\u000f[*uC\u001e,Gj\\4jGB!!Q\u0003BW\u0013\u0011\u0011yKa\u0006\u0003\u0013%s\u0007*\u00198eY\u0016\u0014\b\u0003\u0002B\u000b\u0005gKAA!.\u0003\u0018\tQq*\u001e;IC:$G.\u001a:\u0002!\u0015DXmY;uS>t7i\u001c8uKb$\b\u0003BA\u0004\u0005wKAA!0\u0002\n\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u000b\r\u0005\u0003\u00149M!3\u0003L\n5'q\u001a\u000b\u0005\u0005\u0007\u0014)\rE\u0002\u0002B=BqAa.7\u0001\b\u0011I\fC\u0004\u0002vZ\u0002\r!a>\t\u000f\tmd\u00071\u0001\u0003 !9!1\r\u001cA\u0002\t\u001d\u0004b\u0002B8m\u0001\u0007!1\u000f\u0005\b\u0005\u001b2\u0004\u0019\u0001B(\u0003U\u0001vn\u001c7Pm\u0016\u0014h\r\\8x\u000bb\u001cW\r\u001d;j_:\u0004B!!;\u0003V&!!q[Av\u0005]\u0011UO\u001a4fe>3XM\u001d4m_^,\u0005pY3qi&|g.\u0001\u0003iGB\u001cXC\u0001Bo!\u0011\u0011yN!:\u000e\u0005\t\u0005(b\u0001BrI\u0006A1/\u001a;uS:<7/\u0003\u0003\u0003h\n\u0005(a\u0006%pgR\u001cuN\u001c8fGRLwN\u001c)p_2\u001cV\r^;q\u0003\u0015A7\r]:!\u0003-IG\r\\3US6,w.\u001e;\u0016\u0005\t=\b\u0003\u0002By\u0005ol!Aa=\u000b\t\tU\u0018\u0011B\u0001\tIV\u0014\u0018\r^5p]&!!\u0011 Bz\u0005!!UO]1uS>t\u0017\u0001D5eY\u0016$\u0016.\\3pkR\u0004\u0013aD:ikR$wn\u001e8Qe>l\u0017n]3\u0016\u0005\r\u0005\u0001CBA\u0004\u0003\u001b\ti%\u0001\ttQV$Hm\\<o!J|W.[:fA\u0005a1\u000f[;ui&tw\rR8x]V\u0011\u0011qV\u0001\u0013g\",H\u000f^5oO\u0012{wO\u001c*fCN|g.\u0006\u0002\u0004\u000eA)Ana\u0004\u0002N%\u00191\u0011C7\u0003\r=\u0003H/[8o\u0003Y\u0019\b.\u001e;uS:<Gi\\<o%\u0016\f7o\u001c8`I\u0015\fHc\u0001;\u0004\u0018!I\u0011\u0011\u0014!\u0002\u0002\u0003\u00071QB\u0001\u0014g\",H\u000f^5oO\u0012{wO\u001c*fCN|g\u000eI\u0001\u0013e\u0016l\u0017-\u001b8j]\u001e\u0014V-];fgR,G-\u0001\fsK6\f\u0017N\\5oOJ+\u0017/^3ti\u0016$w\fJ3r)\r!8\u0011\u0005\u0005\n\u00033\u001b\u0015\u0011!a\u0001\u0003\u000f\u000b1C]3nC&t\u0017N\\4SKF,Xm\u001d;fI\u0002\n\u0001\u0002\u001d:f'R\f'\u000f\u001e\u000b\u0002i\u00069qN\u001c+j[\u0016\u0014Hc\u0001;\u0004.!91q\u0006$A\u0002\u0005E\u0015\u0001\u0003;j[\u0016\u00148*Z=\u0002\r=t\u0007+^:i\u0003\u0019yg\u000eU;mY\u0006I\"/Z:q_:\u001cXmQ8na2,G/\u001a3DC2d'-Y2l+\t\u0019I\u0004\u0005\u0004\u0003\u0016\rm2qH\u0005\u0005\u0007{\u00119BA\u0007Bgft7mQ1mY\n\f7m\u001b\t\u0005\u0007\u0003\u001a\u0019%D\u0001i\u0013\r\u0019)\u0005\u001b\u0002\u0005\t>tW-\u0001\u000esKN\u0004xN\\:f\u0007>l\u0007\u000f\\3uK\u0012\u001c\u0015\r\u001c7cC\u000e\\\u0007%A\bsKF,Xm\u001d;DC2d'-Y2l+\t\u0019i\u0005\u0005\u0004\u0003\u0016\rm2q\n\t\u0007Y\n\u0015\u00050!\u0002\u0002!I,\u0017/^3ti\u000e\u000bG\u000e\u001c2bG.\u0004\u0013\u0001E:ikR$wn\u001e8DC2d'-Y2l+\t\u00199\u0006E\u0003\u0003\u0016\rmB/A\ttQV$Hm\\<o\u0007\u0006dGNY1dW\u0002\nA#\u00194uKJ\u0014V-];fgR4\u0015N\\5tQ\u0016$\u0017a\u0004:fcV,7\u000f^*ikR$wn\u001e8\u0015\u0007Q\u001c\t\u0007C\u0004\u0004dA\u0003\r!!\u0014\u0002\rI,\u0017m]8o\u0003y\u0019\b.\u001e;e_^t\u0017J\u001a*fcV,7\u000f^3e\u0003:$\u0007k\\:tS\ndW-\u0001\bsKN,G/\u00133mKRKW.\u001a:\u0002!MDw.\u001e7e'R|\u0007o\u00148JI2,\u0017!E8o+B\u001cHO]3b[\u001a\u000b\u0017\u000e\\;sKR\u0019Aoa\u001c\t\u000f\rED\u000b1\u0001\u0004t\u0005\u0011Q\r\u001f\t\u0005\u0003/\u001a)(\u0003\u0003\u0004x\u0005-$!\u0003+ie><\u0018M\u00197f\u0003!\u0001xn\u001d;Ti>\u0004H#\u0002;\u0004~\r}\u0004\"B9W\u0001\u0004A\bbBA\u0002-\u0002\u0007\u0011Q\u0001\u000b\u0003\u0007\u0007#Ba!\"\u0004\bB1\u0011qAA\u0010\u0003\u001bBqa!#X\u0001\b\u0011I,\u0001\u0002fG\u0006aq\u000f[3o'\",H\u000fZ8x]V\u00111QQ\u0001\u0007_:Le.\u001b;\u0015\u0007Q\u001c\u0019\nC\u0004\u0002vf\u0003\r!a>)\u0007e\u001b9\n\u0005\u0003\u0004\u001a\u000e}UBABN\u0015\r\u0019i\n[\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BBQ\u00077\u0013\u0011#\u00138uKJt\u0017\r\\*uC\ndW-\u00119j\u0003)yg\u000eR5ta\u0006$8\r\u001b\u000b\u0004q\u000e\u001d\u0006\"B9[\u0001\u0004A\bf\u0001.\u0004\u0018\u0006QqN\u001c*fgB|gn]3\u0015\r\u0005E5qVBY\u0011\u0015\t8\f1\u0001y\u0011\u001d\u0019\u0019l\u0017a\u0001\u0007k\u000b\u0001B]3ta>t7/\u001a\t\u0007\u0007o\u001bi,!\u0005\u000e\u0005\re&bAB^[\u0006!Q\u000f^5m\u0013\u0011\u0019yl!/\u0003\u0007Q\u0013\u0018\u0010K\u0002\\\u0007/\u000b!c\u001c8SKN\u0004xN\\:f\u0007>l\u0007\u000f\\3uKR\u0019Aoa2\t\u000f\r%G\f1\u0001\u0002\u0012\u0006\u0019\u0011M\\=)\u0007q\u001b9\nK\u00020\u0007/\u000b\u0001cR1uK^\f\u0017\u0010T8h'>,(oY3\u0016\u0005\rM\u0007C\u0002B)\u0007+\f90\u0003\u0003\u0004X\nM#!\u0003'pON{WO]2f\u0003E9\u0015\r^3xCfdunZ*pkJ\u001cW\r\t\u0005\b\u0007\u0013\u0013\u00019\u0001B]+\t\ti\u0002")
public interface PoolInterface {
    public static PoolInterface apply(PoolGateway poolGateway, ActorRefFactory actorRefFactory, Materializer materializer) {
        return PoolInterface$.MODULE$.apply(poolGateway, actorRefFactory, materializer);
    }

    public void request(HttpRequest var1, Promise<HttpResponse> var2);

    public Future<ShutdownReason> shutdown(ExecutionContext var1);

    public Future<ShutdownReason> whenShutdown();

    @InternalStableApi
    public static class Logic
    extends TimerGraphStageLogic
    implements PoolInterface,
    InHandler,
    OutHandler {
        private final PoolGateway gateway;
        private final Outlet<PoolFlow.RequestContext> requestOut;
        private final Inlet<PoolFlow.ResponseContext> responseIn;
        private final LoggingAdapter log;
        private final ExecutionContext executionContext;
        private final BufferOverflowException PoolOverflowException;
        private final HostConnectionPoolSetup hcps;
        private final Duration idleTimeout;
        private final Promise<ShutdownReason> shutdownPromise;
        private Option<ShutdownReason> shuttingDownReason;
        private int remainingRequested;
        private final AsyncCallback<Done> responseCompletedCallback;
        private final AsyncCallback<Tuple2<HttpRequest, Promise<HttpResponse>>> requestCallback;
        private final AsyncCallback<BoxedUnit> shutdownCallback;

        public void onDownstreamFinish() throws Exception {
            OutHandler.onDownstreamFinish$((OutHandler)this);
        }

        public void onUpstreamFinish() throws Exception {
            InHandler.onUpstreamFinish$((InHandler)this);
        }

        public HostConnectionPoolSetup hcps() {
            return this.hcps;
        }

        public Duration idleTimeout() {
            return this.idleTimeout;
        }

        public Promise<ShutdownReason> shutdownPromise() {
            return this.shutdownPromise;
        }

        public boolean shuttingDown() {
            return this.shuttingDownReason().isDefined();
        }

        public Option<ShutdownReason> shuttingDownReason() {
            return this.shuttingDownReason;
        }

        public void shuttingDownReason_$eq(Option<ShutdownReason> x$1) {
            this.shuttingDownReason = x$1;
        }

        public int remainingRequested() {
            return this.remainingRequested;
        }

        public void remainingRequested_$eq(int x$1) {
            this.remainingRequested = x$1;
        }

        public void preStart() {
            this.onInit(this.gateway);
            this.pull(this.responseIn);
            this.resetIdleTimer();
        }

        public void onTimer(Object timerKey) {
            this.log.debug(new StringBuilder(88).append("Pool shutting down because akka.http.host-connection-pool.idle-timeout triggered after ").append(this.idleTimeout()).append(".").toString());
            this.requestShutdown(PoolInterface$ShutdownReason$IdleTimeout$.MODULE$);
        }

        /*
         * Unable to fully structure code
         */
        public void onPush() {
            var5_1 = (PoolFlow.ResponseContext)this.grab(this.responseIn);
            if (var5_1 == null) {
                throw new MatchError((Object)var5_1);
            }
            rc = var5_1.rc();
            response0 = var5_1.response();
            var3_4 = new Tuple2((Object)rc, response0);
            var4_5 = var3_4;
            rc = (PoolFlow.RequestContext)var4_5._1();
            response0 = (Try)var4_5._2();
            ctx = this.onResponse(rc.request(), (Try<HttpResponse>)response0);
            var12_9 = false;
            var13_10 = null;
            var14_11 = response0;
            if (!(var14_11 instanceof Success)) ** GOTO lbl-1000
            var12_9 = true;
            var13_10 = (Success)var14_11;
            r = (HttpResponse)var13_10.value();
            if (r != null && !OptHttpResponse$.MODULE$.isEmpty$extension(var16_13 = HttpResponse$.MODULE$.unapply(r)) && !(entity = var16_13._3()).isStrict()) {
                var19_15 = StreamUtils$.MODULE$.transformEntityStream(entity, StreamUtils$CaptureTerminationOp$.MODULE$);
                if (var19_15 == null) {
                    throw new MatchError(var19_15);
                }
                newEntity = (ResponseEntity)var19_15._1();
                termination = (Future)var19_15._2();
                var2_18 = new Tuple2((Object)newEntity, (Object)termination);
                var18_19 = var2_18;
                newEntity = (ResponseEntity)var18_19._1();
                termination = (Future)var18_19._2();
                termination.onComplete((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$onPush$1$adapted(akka.http.impl.engine.client.PoolInterface$Logic scala.util.Try ), (Lscala/util/Try;)Ljava/lang/Object;)((Logic)this), this.executionContext);
                var1_22 = new Success((Object)r.withEntity(newEntity));
            } else if (var12_9) {
                response = (HttpResponse)var13_10.value();
                this.remainingRequested_$eq(this.remainingRequested() - 1);
                var1_22 = new Success((Object)response);
            } else if (var14_11 instanceof Failure) {
                this.remainingRequested_$eq(this.remainingRequested() - 1);
                var1_22 = response0;
            } else {
                throw new MatchError((Object)var14_11);
            }
            response1 = var1_22;
            rc.responsePromise().complete(response1);
            this.onResponseComplete(ctx);
            this.pull(this.responseIn);
            this.afterRequestFinished();
        }

        public void onPull() {
        }

        public AsyncCallback<Done> responseCompletedCallback() {
            return this.responseCompletedCallback;
        }

        public AsyncCallback<Tuple2<HttpRequest, Promise<HttpResponse>>> requestCallback() {
            return this.requestCallback;
        }

        public AsyncCallback<BoxedUnit> shutdownCallback() {
            return this.shutdownCallback;
        }

        public void afterRequestFinished() {
            this.shutdownIfRequestedAndPossible();
            this.resetIdleTimer();
        }

        public void requestShutdown(ShutdownReason reason) {
            this.shuttingDownReason_$eq((Option<ShutdownReason>)new Some((Object)reason));
            this.shutdownIfRequestedAndPossible();
        }

        public void shutdownIfRequestedAndPossible() {
            block2: {
                if (!this.shuttingDown()) break block2;
                if (this.remainingRequested() == 0) {
                    this.log.debug("Pool is now shutting down as requested.");
                    this.shutdownPromise().trySuccess(this.shuttingDownReason().get());
                    this.completeStage();
                } else {
                    this.log.debug(new StringBuilder(64).append("Pool is shutting down after waiting for [").append(this.remainingRequested()).append("] outstanding requests.").toString());
                }
            }
        }

        public void resetIdleTimer() {
            block0: {
                this.cancelTimer(PoolInterface$.MODULE$.akka$http$impl$engine$client$PoolInterface$$IdleTimeout());
                if (!this.shouldStopOnIdle()) break block0;
                this.scheduleOnce(PoolInterface$.MODULE$.akka$http$impl$engine$client$PoolInterface$$IdleTimeout(), (FiniteDuration)this.idleTimeout());
            }
        }

        public boolean shouldStopOnIdle() {
            return !this.shuttingDown() && this.remainingRequested() == 0 && this.idleTimeout().isFinite() && this.hcps().setup().settings().minConnections() == 0;
        }

        public void onUpstreamFailure(Throwable ex) {
            this.shutdownPromise().tryFailure(ex);
        }

        public void postStop() {
            this.shutdownPromise().tryFailure((Throwable)new IllegalStateException("Pool shutdown unexpectedly"));
        }

        @Override
        public void request(HttpRequest request, Promise<HttpResponse> responsePromise) {
            this.requestCallback().invokeWithFeedback((Object)new Tuple2((Object)request, responsePromise)).failed().foreach((Function1 & Serializable)x$6 -> {
                $this.log.debug("Request was sent to pool which was already closed, retrying through the gateway to create new pool instance");
                return responsePromise.tryCompleteWith($this.gateway.apply(request));
            }, this.executionContext);
        }

        @Override
        public Future<ShutdownReason> shutdown(ExecutionContext ec) {
            this.shutdownCallback().invoke((Object)BoxedUnit.UNIT);
            return this.whenShutdown();
        }

        @Override
        public Future<ShutdownReason> whenShutdown() {
            return this.shutdownPromise().future();
        }

        @InternalStableApi
        public void onInit(PoolGateway gateway) {
        }

        @InternalStableApi
        public HttpRequest onDispatch(HttpRequest request) {
            return request;
        }

        @InternalStableApi
        public Object onResponse(HttpRequest request, Try<HttpResponse> response) {
            return None$.MODULE$;
        }

        @InternalStableApi
        public void onResponseComplete(Object any) {
        }

        public static final /* synthetic */ void $anonfun$onPush$1(Logic $this, Try x$3) {
            $this.responseCompletedCallback().invoke((Object)Done$.MODULE$);
        }

        public static final /* synthetic */ void $anonfun$responseCompletedCallback$1(Logic $this, Done x$4) {
            $this.remainingRequested_$eq($this.remainingRequested() - 1);
            $this.afterRequestFinished();
        }

        public static final /* synthetic */ void $anonfun$requestCallback$1(Logic $this, Tuple2 x0$1) {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                HttpRequest request = (HttpRequest)tuple2._1();
                Promise responsePromise = (Promise)tuple2._2();
                if ($this.isAvailable($this.requestOut)) {
                    $this.log.debug(new StringBuilder(30).append("Dispatching request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(request))).append("] to pool").toString());
                    String scheme = Uri$.MODULE$.httpScheme(((ConnectionContext)((Object)$this.hcps().setup().connectionContext())).isSecure());
                    Host hostHeader = Host$.MODULE$.apply($this.hcps().host(), Uri$.MODULE$.normalizePort($this.hcps().port(), scheme));
                    HttpRequest effectiveRequest = $this.onDispatch((HttpRequest)request.withUri(request.uri().toHttpRequestTargetOriginForm()).withDefaultHeaders(hostHeader, (Seq<HttpHeader>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new HttpHeader[0])));
                    int retries = request.method().isIdempotent() ? $this.hcps().setup().settings().maxRetries() : 0;
                    $this.remainingRequested_$eq($this.remainingRequested() + 1);
                    $this.resetIdleTimer();
                    $this.push($this.requestOut, new PoolFlow.RequestContext(effectiveRequest, (Promise<HttpResponse>)responsePromise, retries));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    $this.log.debug(new StringBuilder(52).append("Could not dispatch request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(request))).append("] because buffer is full").toString());
                    responsePromise.tryFailure((Throwable)$this.PoolOverflowException);
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }

        public Logic(PoolGateway gateway, FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext> shape, Outlet<PoolFlow.RequestContext> requestOut, Inlet<PoolFlow.ResponseContext> responseIn, LoggingAdapter log, ExecutionContext executionContext) {
            this.gateway = gateway;
            this.requestOut = requestOut;
            this.responseIn = responseIn;
            this.log = log;
            this.executionContext = executionContext;
            super(shape);
            InHandler.$init$((InHandler)this);
            OutHandler.$init$((OutHandler)this);
            this.PoolOverflowException = new BufferOverflowException(new StringBuilder(141).append(new StringBuilder(101).append("Exceeded configured max-open-requests value of [").append(gateway.hcps().setup().settings().maxOpenRequests()).append("]. This means that the request queue of this pool (").append(gateway.hcps()).append(") ").toString()).append("has completely filled up because the pool currently does not process requests fast enough to handle the incoming request load. ").append("Please retry the request later. See http://doc.akka.io/docs/akka-http/current/scala/http/client-side/pool-overflow.html for ").append("more information.").toString());
            this.hcps = gateway.hcps();
            this.idleTimeout = this.hcps().setup().settings().idleTimeout();
            this.shutdownPromise = Promise$.MODULE$.apply();
            this.shuttingDownReason = None$.MODULE$;
            this.remainingRequested = 0;
            this.setHandlers(responseIn, requestOut, this);
            this.responseCompletedCallback = this.getAsyncCallback((Function1 & Serializable)x$4 -> {
                Logic.$anonfun$responseCompletedCallback$1(this, x$4);
                return BoxedUnit.UNIT;
            });
            this.requestCallback = this.getAsyncCallback((Function1 & Serializable)x0$1 -> {
                Logic.$anonfun$requestCallback$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            this.shutdownCallback = this.getAsyncCallback((Function1 & Serializable)x$5 -> {
                this.requestShutdown(PoolInterface$ShutdownReason$ShutdownRequested$.MODULE$);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ Object $anonfun$onPush$1$adapted(Logic $this, Try x$3) {
            Logic.$anonfun$onPush$1($this, x$3);
            return BoxedUnit.UNIT;
        }
    }

    public static class PoolInterfaceStage
    extends GraphStageWithMaterializedValue<FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext>, PoolInterface> {
        private final PoolGateway gateway;
        private final LoggingAdapter log;
        private final Outlet<PoolFlow.RequestContext> requestOut;
        private final Inlet<PoolFlow.ResponseContext> responseIn;

        private Outlet<PoolFlow.RequestContext> requestOut() {
            return this.requestOut;
        }

        private Inlet<PoolFlow.ResponseContext> responseIn() {
            return this.responseIn;
        }

        public FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext> shape() {
            return new FlowShape(this.responseIn(), this.requestOut());
        }

        public Tuple2<GraphStageLogic, PoolInterface> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
            throw new IllegalStateException("Should not be called");
        }

        public Tuple2<GraphStageLogic, PoolInterface> createLogicAndMaterializedValue(Attributes inheritedAttributes, Materializer _materializer) {
            Logic logic = new Logic(this.gateway, this.shape(), this.requestOut(), this.responseIn(), this.log, (ExecutionContext)_materializer.executionContext());
            return new Tuple2((Object)logic, (Object)logic);
        }

        public PoolInterfaceStage(PoolGateway gateway, LoggingAdapter log) {
            this.gateway = gateway;
            this.log = log;
            this.requestOut = Outlet$.MODULE$.apply("PoolInterface.requestOut");
            this.responseIn = Inlet$.MODULE$.apply("PoolInterface.responseIn");
        }
    }

    public static interface ShutdownReason {
    }
}

