/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.client;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.event.LogSource;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.client.PoolFlow$;
import akka.http.impl.engine.client.PoolGateway;
import akka.http.impl.engine.client.PoolInterface;
import akka.http.impl.engine.client.pool.NewHostConnectionPool$;
import akka.http.javadsl.ConnectionContext;
import akka.http.scaladsl.Http;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.settings.PoolImplementation;
import akka.stream.ActorMaterializer;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.OverflowStrategy$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import scala.MatchError;
import scala.concurrent.Future;

public final class PoolInterface$ {
    public static final PoolInterface$ MODULE$ = new PoolInterface$();
    private static final String akka$http$impl$engine$client$PoolInterface$$IdleTimeout = "idle-timeout";
    private static final LogSource<PoolGateway> GatewayLogSource = new LogSource<PoolGateway>(){

        public String genString(PoolGateway gateway) {
            String scheme = ((ConnectionContext)((Object)gateway.hcps().setup().connectionContext())).isSecure() ? "https" : "http";
            return new StringBuilder(12).append("Pool(").append(gateway.gatewayId().name()).append("->").append(scheme).append("://").append(gateway.hcps().host()).append(":").append(gateway.hcps().port()).append(")").toString();
        }

        public String genString(PoolGateway gateway, ActorSystem system) {
            return new StringBuilder(1).append(system.name()).append("/").append(this.genString(gateway)).toString();
        }

        public Class<?> getClazz(PoolGateway t) {
            return PoolGateway.class;
        }
        {
            LogSource.$init$((LogSource)this);
        }
    };

    public PoolInterface apply(PoolGateway gateway, ActorRefFactory parent, Materializer fm) {
        Flow flow;
        ActorSystem system = ((ActorMaterializer)fm).system();
        LoggingAdapter log = Logging$.MODULE$.apply(system, (Object)gateway, this.GatewayLogSource());
        log.debug("Creating pool.");
        Flow<HttpRequest, HttpResponse, Future<Http.OutgoingConnection>> connectionFlow = Http$.MODULE$.apply(system).outgoingConnectionUsingContext(gateway.hcps().host(), gateway.hcps().port(), gateway.hcps().setup().connectionContext(), gateway.hcps().setup().settings().connectionSettings(), gateway.hcps().setup().log());
        PoolImplementation poolImplementation = gateway.hcps().setup().settings().poolImplementation();
        if (PoolImplementation.Legacy$.MODULE$.equals(poolImplementation)) {
            log.warning("Legacy pool implementation is deprecated and will be removed in the future. Please start using `akka.http.host-connection-pool.pool-implementation = new`, instead.");
            flow = PoolFlow$.MODULE$.apply(connectionFlow, gateway.hcps().setup().settings(), log).named("PoolFlow");
        } else if (PoolImplementation.New$.MODULE$.equals(poolImplementation)) {
            flow = NewHostConnectionPool$.MODULE$.apply(connectionFlow, gateway.hcps().setup().settings(), log).named("PoolFlow");
        } else {
            throw new MatchError((Object)poolImplementation);
        }
        Flow poolFlow = flow;
        int targetBufferSize = gateway.hcps().setup().settings().maxOpenRequests() - gateway.hcps().setup().settings().maxConnections();
        Flow bufferIfNeeded = targetBufferSize > 0 ? (Flow)Flow$.MODULE$.apply().buffer(targetBufferSize, OverflowStrategy$.MODULE$.backpressure()) : Flow$.MODULE$.apply();
        return (PoolInterface)Flow$.MODULE$.fromGraph((Graph)new PoolInterface.PoolInterfaceStage(gateway, log)).via((Graph)bufferIfNeeded).join((Graph)poolFlow).run(fm);
    }

    public String akka$http$impl$engine$client$PoolInterface$$IdleTimeout() {
        return akka$http$impl$engine$client$PoolInterface$$IdleTimeout;
    }

    public LogSource<PoolGateway> GatewayLogSource() {
        return GatewayLogSource;
    }

    private PoolInterface$() {
    }
}

