/*
 * Decompiled with CFR 0.152.
 */
package blended.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionHelper.class);

    private ReflectionHelper() {
    }

    public static List<String> getPropertyNames(Object object) {
        List<Method> list = ReflectionHelper.getGetterMethods(object.getClass());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Method method : list) {
            LOGGER.info(method.getName());
            arrayList.add(ReflectionHelper.getPropertyName(method));
        }
        return arrayList;
    }

    public static <T> T getProperty(Object object, String ... stringArray) {
        String string;
        if (stringArray == null || object == null) {
            return null;
        }
        Object object2 = object;
        Object object3 = stringArray;
        int n = ((String[])object3).length;
        for (int i = 0; i < n && (object2 = ReflectionHelper.getPropertyInternal(object2, string = object3[i])) != null; ++i) {
        }
        try {
            object3 = object2;
            return (T)object3;
        }
        catch (ClassCastException classCastException) {
            ReflectionHelper.getLogger().warn("ReflectionHelper encountered wrong property type: " + object2.getClass().getName());
            return null;
        }
    }

    public static <T> T getProperty(Object object, String string) {
        if (string == null) {
            return null;
        }
        T t = ReflectionHelper.getProperty(object, string.split("\\."));
        return t;
    }

    public static void setProperty(Object object, Object object2, String ... stringArray) {
        try {
            if (object == null || stringArray == null || stringArray.length == 0) {
                throw new Exception("Destination object and property name must not be empty to set the property");
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Wrong context to set property", (Throwable)exception);
            return;
        }
        Object object3 = object;
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if ((object3 = ReflectionHelper.getPropertyInternal(object3, stringArray[i])) != null) continue;
            LOGGER.warn("Property [" + stringArray[i] + "] not found for object [" + object3 + "]");
            break;
        }
        if (object3 != null) {
            ReflectionHelper.setPropertyInternal(object3, stringArray[stringArray.length - 1], object2);
        }
    }

    private static void setPropertyInternal(Object object, String string, Object object2) {
        for (Method method : ReflectionHelper.getSetterMethods(object.getClass())) {
            if (!ReflectionHelper.getPropertyName(method).equals(string)) continue;
            try {
                LOGGER.debug("Setting property [{}] to [{}]", (Object)string, object2);
                method.invoke(object, object2);
            }
            catch (Exception exception) {
                Class<?> clazz = method.getParameterTypes()[0];
                Class clazz2 = Object.class;
                clazz2 = clazz.isPrimitive() && clazz.getName().equals("boolean") ? Boolean.class : (clazz.isPrimitive() && clazz.getName().equals("long") ? Long.class : (clazz.isPrimitive() && clazz.getName().equals("short") ? Short.class : (clazz.isPrimitive() && clazz.getName().equals("int") ? Integer.class : (clazz.isPrimitive() && clazz.getName().equals("float") ? Float.class : (clazz.isPrimitive() && clazz.getName().equals("double") ? Double.class : (clazz.isPrimitive() && clazz.getName().equals("byte") ? Byte.class : clazz))))));
                try {
                    Constructor constructor = clazz2.getConstructor(object2.getClass());
                    method.invoke(object, constructor.newInstance(object2));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    LOGGER.warn("No constructor found for [{}] from type [{}]", (Object)clazz2.getName(), object2.getClass());
                    return;
                }
                catch (Exception exception2) {
                    LOGGER.warn("Failed to set property ... trying to convert [{}] into [{}]", (Object)object2.getClass().getName(), (Object)method.getParameterTypes()[0].getName());
                }
            }
        }
    }

    public static List<Method> getGetterMethods(Class<?> clazz) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().startsWith("get") || method.getName().equals("getClass") || method.getParameterTypes().length != 0) continue;
            arrayList.add(method);
        }
        return arrayList;
    }

    public static List<Method> getSetterMethods(Class<?> clazz) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1) continue;
            arrayList.add(method);
        }
        return arrayList;
    }

    public static String getPropertyName(Class<?> clazz, Class<?> clazz2) {
        for (Method method : ReflectionHelper.getGetterMethods(clazz)) {
            if (!method.getReturnType().equals(clazz2)) continue;
            try {
                clazz.getMethod(method.getName().replaceFirst("g", "s"), clazz2);
                return ReflectionHelper.getPropertyName(method);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static String getPropertyName(Method method) {
        String string = null;
        if (method.getName().startsWith("get") || method.getName().startsWith("set")) {
            string = method.getName().substring(3);
            if (string.length() == 1) {
                string = string.toLowerCase();
            } else if (string.matches(".[a-z](.)*")) {
                string = string.substring(0, 1).toLowerCase() + string.substring(1);
            }
        }
        return string;
    }

    private static Object getPropertyInternal(Object object, String string) {
        for (Method method : ReflectionHelper.getGetterMethods(object.getClass())) {
            if (!ReflectionHelper.getPropertyName(method).equals(string)) continue;
            try {
                Object object2 = method.invoke(object, new Object[0]);
                return object2;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ReflectionHelper.class);
    }
}

