/*
 * Decompiled with CFR 0.152.
 */
package blended.streams.transaction;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.stream.FanInShape2;
import akka.stream.FanOutShape2;
import akka.stream.FlowShape;
import akka.stream.Graph;
import akka.stream.KillSwitch;
import akka.stream.UniformFanInShape;
import akka.stream.UniformFanOutShape;
import akka.stream.scaladsl.Broadcast$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.GraphDSL;
import akka.stream.scaladsl.GraphDSL$;
import akka.stream.scaladsl.Merge$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Zip$;
import blended.jms.utils.IdAwareConnectionFactory;
import blended.jms.utils.JmsDestination;
import blended.jms.utils.JmsTopic;
import blended.streams.FlowHeaderConfig;
import blended.streams.FlowProcessor$;
import blended.streams.jms.JmsConsumerSettings;
import blended.streams.jms.JmsDeliveryMode;
import blended.streams.jms.JmsDestinationResolver;
import blended.streams.jms.JmsKeyFormatStrategy;
import blended.streams.jms.JmsProducerSettings;
import blended.streams.jms.JmsProducerSettings$;
import blended.streams.jms.JmsStreamSupport;
import blended.streams.message.FlowEnvelope;
import blended.streams.message.FlowEnvelopeLogger;
import blended.streams.message.FlowEnvelopeLogger$;
import blended.streams.message.MsgProperty;
import blended.streams.processor.Collector;
import blended.streams.transaction.FlowTransaction;
import blended.streams.transaction.FlowTransaction$;
import blended.streams.transaction.FlowTransactionEvent;
import blended.streams.transaction.FlowTransactionEvent$;
import blended.streams.transaction.FlowTransactionManager;
import blended.streams.transaction.FlowTransactionState;
import blended.streams.transaction.FlowTransactionStateCompleted$;
import blended.streams.transaction.FlowTransactionStateFailed$;
import blended.streams.transaction.FlowTransactionStateStarted$;
import blended.streams.worklist.WorklistState;
import blended.util.logging.LogLevel$;
import java.io.Serializable;
import java.util.Date;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001\u0002\n\u0014\u0001iA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011!\u0019\u0005A!A!\u0002\u0017!\u0005\"\u0002'\u0001\t\u0003i\u0005bB+\u0001\u0005\u0004%IA\u0016\u0005\u0007M\u0002\u0001\u000b\u0011B,\t\u000f\u001d\u0004!\u0019!C\u0005Q\"1a\u000f\u0001Q\u0001\n%Dqa\u001e\u0001C\u0002\u0013%\u0001\u0010C\u0004\u0002\n\u0001\u0001\u000b\u0011B=\t\u0013\u0005-\u0001A1A\u0005\n\u00055\u0001\u0002CA\u000b\u0001\u0001\u0006I!a\u0004\t\u0013\u0005]\u0001A1A\u0005\n\u0005e\u0001\u0002CA\u0012\u0001\u0001\u0006I!a\u0007\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(\t)b\t\\8x)J\fgn]1di&|gn\u0015;sK\u0006l'B\u0001\u000b\u0016\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005Y9\u0012aB:ue\u0016\fWn\u001d\u0006\u00021\u00059!\r\\3oI\u0016$7\u0001A\n\u0004\u0001m\t\u0003C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"AB!osJ+g\r\u0005\u0002#K5\t1E\u0003\u0002%+\u0005\u0019!.\\:\n\u0005\u0019\u001a#\u0001\u0005&ngN#(/Z1n'V\u0004\bo\u001c:u\u0003)Ig\u000e^3s]\u0006d7I\u001a\t\u00049%Z\u0013B\u0001\u0016\u001e\u0005\u0019y\u0005\u000f^5p]B\u0011A\u0006M\u0007\u0002[)\u0011afL\u0001\u0006kRLGn\u001d\u0006\u0003I]I!!M\u0017\u00031%#\u0017i^1sK\u000e{gN\\3di&|gNR1di>\u0014\u00180A\u0005iK\u0006$WM]\"gOB\u0011A'N\u0007\u0002+%\u0011a'\u0006\u0002\u0011\r2|w\u000fS3bI\u0016\u00148i\u001c8gS\u001e\fA\u0001^'heB\u0011\u0011HO\u0007\u0002'%\u00111h\u0005\u0002\u0017\r2|w\u000f\u0016:b]N\f7\r^5p]6\u000bg.Y4fe\u0006a1\u000f\u001e:fC6dunZ4feB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001)F\u0001\b[\u0016\u001c8/Y4f\u0013\t\u0011uH\u0001\nGY><XI\u001c<fY>\u0004X\rT8hO\u0016\u0014\u0018AB:zgR,W\u000e\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006)\u0011m\u0019;pe*\t\u0011*\u0001\u0003bW.\f\u0017BA&G\u0005-\t5\r^8s'f\u001cH/Z7\u0002\rqJg.\u001b;?)\u0015q\u0015KU*U)\ty\u0005\u000b\u0005\u0002:\u0001!)1I\u0002a\u0002\t\")qE\u0002a\u0001Q!)!G\u0002a\u0001g!)qG\u0002a\u0001q!)AH\u0002a\u0001{\u0005YQ\u000f\u001d3bi\u0016,e/\u001a8u+\u00059\u0006\u0003\u0002\u000fY5vK!!W\u000f\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001 \\\u0013\tavH\u0001\u0007GY><XI\u001c<fY>\u0004X\rE\u0002_C\u000el\u0011a\u0018\u0006\u0003Av\tA!\u001e;jY&\u0011!m\u0018\u0002\u0004)JL\bCA\u001de\u0013\t)7C\u0001\u000bGY><HK]1og\u0006\u001cG/[8o\u000bZ,g\u000e^\u0001\rkB$\u0017\r^3Fm\u0016tG\u000fI\u0001\u000eY><WI^3oiR{'*\\:\u0016\u0003%\u0004B\u0001\b-,UB)1\u000e\u001d.[e6\tAN\u0003\u0002n]\u0006A1oY1mC\u0012\u001cHN\u0003\u0002p\u0011\u000611\u000f\u001e:fC6L!!\u001d7\u0003\t\u0019cwn\u001e\t\u0003gRl\u0011\u0001S\u0005\u0003k\"\u0013qAT8u+N,G-\u0001\bm_\u001e,e/\u001a8u)>TUn\u001d\u0011\u0002#I,7m\u001c:e)J\fgn]1di&|g.F\u0001z!\u0011Q80 :\u000e\u00039L!\u0001 8\u0003\u000b\u001d\u0013\u0018\r\u001d5\u0011\u000bitX,!\u0001\n\u0005}t'!\u0003$m_^\u001c\u0006.\u00199f!\u0011q\u0016-a\u0001\u0011\u0007e\n)!C\u0002\u0002\bM\u0011qB\u00127poR\u0013\u0018M\\:bGRLwN\\\u0001\u0013e\u0016\u001cwN\u001d3Ue\u0006t7/Y2uS>t\u0007%\u0001\bm_\u001e$&/\u00198tC\u000e$\u0018n\u001c8\u0016\u0005\u0005=\u0001#\u0002>|\u0003#\u0011\bC\u0002>\u007f\u0003\u0003\t\u0019\u0002E\u0002_Cj\u000bq\u0002\\8h)J\fgn]1di&|g\u000eI\u0001\rGJ,\u0017\r^3SKN,H\u000e^\u000b\u0003\u00037\u0001R\u0001\b-\u0002\u001ei\u0003b\u0001HA\u00105\u0006M\u0011bAA\u0011;\t1A+\u001e9mKJ\nQb\u0019:fCR,'+Z:vYR\u0004\u0013!\u00022vS2$G#\u00016")
public class FlowTransactionStream
implements JmsStreamSupport {
    private final Option<IdAwareConnectionFactory> internalCf;
    private final FlowHeaderConfig headerCfg;
    private final FlowTransactionManager tMgr;
    private final FlowEnvelopeLogger streamLogger;
    private final ActorSystem system;
    private final Function1<FlowEnvelope, Try<FlowTransactionEvent>> updateEvent;
    private final Function1<IdAwareConnectionFactory, Flow<FlowEnvelope, FlowEnvelope, NotUsed>> logEventToJms;
    private final Graph<FlowShape<Try<FlowTransactionEvent>, Try<FlowTransaction>>, NotUsed> recordTransaction;
    private final Graph<FlowShape<Try<FlowTransaction>, Try<FlowEnvelope>>, NotUsed> logTransaction;
    private final Function1<Tuple2<FlowEnvelope, Try<FlowEnvelope>>, FlowEnvelope> createResult;

    @Override
    public Try<KillSwitch> processMessages(Flow<FlowEnvelope, FlowEnvelope, ?> processFlow, Seq<FlowEnvelope> msgs, ActorSystem system) {
        return JmsStreamSupport.processMessages$(this, processFlow, msgs, system);
    }

    @Override
    public Try<KillSwitch> sendMessages(JmsProducerSettings producerSettings, FlowEnvelopeLogger log, Seq<FlowEnvelope> msgs, ActorSystem system) {
        return JmsStreamSupport.sendMessages$(this, producerSettings, log, msgs, system);
    }

    @Override
    public Collector<FlowEnvelope> receiveMessages(FlowHeaderConfig headerCfg, IdAwareConnectionFactory cf, JmsDestination dest, FlowEnvelopeLogger log, Integer listener, Option<FiniteDuration> minMessageDelay, Option<String> selector, Option<Function1<Seq<FlowEnvelope>, Object>> completeOn, Option<FiniteDuration> timeout, ActorSystem system) {
        return JmsStreamSupport.receiveMessages$(this, headerCfg, cf, dest, log, listener, minMessageDelay, selector, completeOn, timeout, system);
    }

    @Override
    public Integer receiveMessages$default$5() {
        return JmsStreamSupport.receiveMessages$default$5$(this);
    }

    @Override
    public Option<FiniteDuration> receiveMessages$default$6() {
        return JmsStreamSupport.receiveMessages$default$6$(this);
    }

    @Override
    public Option<String> receiveMessages$default$7() {
        return JmsStreamSupport.receiveMessages$default$7$(this);
    }

    @Override
    public Option<Function1<Seq<FlowEnvelope>, Object>> receiveMessages$default$8() {
        return JmsStreamSupport.receiveMessages$default$8$(this);
    }

    @Override
    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> jmsProducer(String name, JmsProducerSettings settings, boolean autoAck, ActorSystem system) {
        return JmsStreamSupport.jmsProducer$(this, name, settings, autoAck, system);
    }

    @Override
    public Source<FlowEnvelope, NotUsed> jmsConsumer(String name, JmsConsumerSettings settings, Option<FiniteDuration> minMessageDelay, ActorSystem system) {
        return JmsStreamSupport.jmsConsumer$(this, name, settings, minMessageDelay, system);
    }

    private Function1<FlowEnvelope, Try<FlowTransactionEvent>> updateEvent() {
        return this.updateEvent;
    }

    private Function1<IdAwareConnectionFactory, Flow<FlowEnvelope, FlowEnvelope, NotUsed>> logEventToJms() {
        return this.logEventToJms;
    }

    private Graph<FlowShape<Try<FlowTransactionEvent>, Try<FlowTransaction>>, NotUsed> recordTransaction() {
        return this.recordTransaction;
    }

    private Graph<FlowShape<Try<FlowTransaction>, Try<FlowEnvelope>>, NotUsed> logTransaction() {
        return this.logTransaction;
    }

    private Function1<Tuple2<FlowEnvelope, Try<FlowEnvelope>>, FlowEnvelope> createResult() {
        return this.createResult;
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> build() {
        Graph g = GraphDSL$.MODULE$.create((Function1 & Serializable)b -> {
            GraphDSL.Implicits$.PortOps portOps;
            FlowShape update = (FlowShape)b.add((Graph)Flow$.MODULE$.fromFunction(this.updateEvent()).named("updateEvent"));
            FlowShape record = (FlowShape)b.add((Graph)Flow$.MODULE$.fromGraph(this.recordTransaction()).named("recordTransaction"));
            FlowShape logTrans = (FlowShape)b.add((Graph)Flow$.MODULE$.fromGraph(this.logTransaction()).named("logTransaction"));
            UniformFanOutShape split = (UniformFanOutShape)b.add((Graph)Broadcast$.MODULE$.apply(2, Broadcast$.MODULE$.apply$default$2()));
            FanInShape2 join = (FanInShape2)b.add((Graph)Zip$.MODULE$.apply());
            GraphDSL.Implicits$.MODULE$.port2flow(split.out(0), b).$tilde$greater(join.in0(), b);
            Option<IdAwareConnectionFactory> option = $this.internalCf;
            if (None$.MODULE$.equals(option)) {
                portOps = GraphDSL.Implicits$.MODULE$.port2flow(split.out(1), b).$tilde$greater(update, b).$tilde$greater(record, b).$tilde$greater(logTrans, b);
            } else if (option instanceof Some) {
                Some some = (Some)option;
                IdAwareConnectionFactory cf = (IdAwareConnectionFactory)some.value();
                FlowShape logToJms = (FlowShape)b.add((Graph)((Flow)this.logEventToJms().apply((Object)cf)).named("logToJms"));
                portOps = GraphDSL.Implicits$.MODULE$.port2flow(split.out(1), b).$tilde$greater(logToJms, b).$tilde$greater(update, b).$tilde$greater(record, b).$tilde$greater(logTrans, b);
            } else {
                throw new MatchError(option);
            }
            GraphDSL.Implicits$.MODULE$.port2flow(logTrans.out(), b).$tilde$greater(join.in1(), b);
            FlowShape result = (FlowShape)b.add((Graph)Flow$.MODULE$.fromFunction(this.createResult()).named("result"));
            GraphDSL.Implicits$.MODULE$.port2flow(join.out(), b).$tilde$greater(result.in(), b);
            return new FlowShape(split.in(), result.out());
        });
        return Flow$.MODULE$.fromGraph(g);
    }

    public FlowTransactionStream(Option<IdAwareConnectionFactory> internalCf, FlowHeaderConfig headerCfg, FlowTransactionManager tMgr, FlowEnvelopeLogger streamLogger, ActorSystem system) {
        this.internalCf = internalCf;
        this.headerCfg = headerCfg;
        this.tMgr = tMgr;
        this.streamLogger = streamLogger;
        this.system = system;
        JmsStreamSupport.$init$(this);
        this.updateEvent = (Function1 & Serializable)env -> Try$.MODULE$.apply((Function0 & Serializable)() -> {
            void var2_2;
            FlowTransactionEvent event = (FlowTransactionEvent)((Try)((Function1)FlowTransactionEvent$.MODULE$.envelope2event().apply((Object)$this.headerCfg)).apply(env)).get();
            $this.streamLogger.logEnv((FlowEnvelope)env, LogLevel$.MODULE$.Trace(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Received transaction event [").append(event.transactionId()).append("][").append(event.state()).append("]").toString(), $this.streamLogger.logEnv$default$4());
            return var2_2;
        });
        this.logEventToJms = (Function1 & Serializable)cf -> {
            FlowEnvelopeLogger x$12 = $this.streamLogger;
            FlowHeaderConfig x$2 = $this.headerCfg;
            IdAwareConnectionFactory x$3 = cf;
            Some x$4 = new Some((Object)new JmsTopic(new StringBuilder(19).append($this.headerCfg.prefix()).append(".topic.transactions").toString()));
            boolean x$5 = true;
            Function1 & Serializable x$6 = (Function1 & Serializable)x$1 -> LogLevel$.MODULE$.Debug();
            JmsKeyFormatStrategy x$7 = JmsProducerSettings$.MODULE$.apply$default$4();
            FiniteDuration x$8 = JmsProducerSettings$.MODULE$.apply$default$6();
            int x$9 = JmsProducerSettings$.MODULE$.apply$default$8();
            Function1<JmsProducerSettings, JmsDestinationResolver> x$10 = JmsProducerSettings$.MODULE$.apply$default$9();
            int x$11 = JmsProducerSettings$.MODULE$.apply$default$10();
            JmsDeliveryMode x$122 = JmsProducerSettings$.MODULE$.apply$default$11();
            Option<FiniteDuration> x$13 = JmsProducerSettings$.MODULE$.apply$default$12();
            Function0<Option<String>> x$14 = JmsProducerSettings$.MODULE$.apply$default$13();
            JmsProducerSettings settings = new JmsProducerSettings(x$12, (Function1<FlowEnvelope, Enumeration.Value>)x$6, x$2, x$7, x$3, x$8, (Option<JmsDestination>)x$4, x$9, x$10, x$11, x$122, x$13, x$14, true);
            return this.jmsProducer("logToJms", settings, false, $this.system);
        };
        this.recordTransaction = GraphDSL$.MODULE$.create((Function1 & Serializable)b -> {
            FlowShape callTMgr = (FlowShape)b.add((Graph)Flow$.MODULE$.fromFunction((Function1 & Serializable)e -> $this.tMgr.updateTransaction((FlowTransactionEvent)e)));
            FanOutShape2 errorFilter = (FanOutShape2)b.add(FlowProcessor$.MODULE$.partition((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isSuccess())));
            FlowShape succ = (FlowShape)b.add((Graph)Flow$.MODULE$.fromFunction((Function1 & Serializable)x$3 -> (FlowTransactionEvent)x$3.get()));
            GraphDSL.Implicits$.MODULE$.port2flow(errorFilter.out0(), b).$tilde$greater(succ, b).$tilde$greater(callTMgr, b);
            FlowShape failed = (FlowShape)b.add((Graph)Flow$.MODULE$.fromFunction((Function1 & Serializable)evt -> new Failure((Throwable)evt.failed().get())));
            GraphDSL.Implicits$.MODULE$.port2flow(errorFilter.out1(), b).$tilde$greater(failed, b);
            UniformFanInShape fanIn = (UniformFanInShape)b.add((Graph)Merge$.MODULE$.apply(2, Merge$.MODULE$.apply$default$2()));
            GraphDSL.Implicits$.MODULE$.port2flow(callTMgr.out(), b).$tilde$greater(fanIn.in(0), b);
            GraphDSL.Implicits$.MODULE$.port2flow(failed.out(), b).$tilde$greater(fanIn.in(1), b);
            return new FlowShape(errorFilter.in(), fanIn.out());
        });
        Function1 & Serializable mdc = (Function1 & Serializable)trans -> FlowEnvelopeLogger$.MODULE$.mdcMap((String)FlowEnvelopeLogger$.MODULE$.mdcPrefix().apply((Object)$this.headerCfg), trans.creationProps());
        this.logTransaction = GraphDSL$.MODULE$.create((Function1 & Serializable)b -> {
            FlowShape f = (FlowShape)b.add((Graph)Flow$.MODULE$.fromFunction((Function1 & Serializable)x0$1 -> {
                Failure failure;
                Try try_ = x0$1;
                if (try_ instanceof Success) {
                    FlowTransactionState flowTransactionState;
                    boolean bl;
                    Success success = (Success)try_;
                    FlowTransaction t = (FlowTransaction)success.value();
                    FlowTransactionState flowTransactionState2 = t.state();
                    FlowTransactionStateStarted$ flowTransactionStateStarted$ = FlowTransactionStateStarted$.MODULE$;
                    if ((flowTransactionState2 == null ? flowTransactionStateStarted$ != null : !flowTransactionState2.equals(flowTransactionStateStarted$)) && t.first()) {
                        Map x$15 = Predef$.MODULE$.Map().empty();
                        FlowTransactionStateStarted$ x$16 = FlowTransactionStateStarted$.MODULE$;
                        String x$17 = t.copy$default$1();
                        Date x$18 = t.copy$default$2();
                        Date x$19 = t.copy$default$3();
                        boolean x$20 = t.copy$default$4();
                        Map<String, MsgProperty> x$21 = t.copy$default$5();
                        FlowTransaction s = t.copy(x$17, x$18, x$19, x$20, x$21, (Map<String, List<WorklistState>>)x$15, x$16);
                        $this.streamLogger.underlying().infoMdc((Map)mdc.apply((Object)s), (Function0 & Serializable)() -> s.toString());
                    }
                    if (bl = FlowTransactionStateStarted$.MODULE$.equals(flowTransactionState = t.state()) ? true : FlowTransactionStateCompleted$.MODULE$.equals(flowTransactionState)) {
                        $this.streamLogger.underlying().infoMdc((Map)mdc.apply((Object)t), (Function0 & Serializable)() -> t.toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (FlowTransactionStateFailed$.MODULE$.equals(flowTransactionState)) {
                        $this.streamLogger.underlying().warnMdc((Map)mdc.apply((Object)t), (Function0 & Serializable)() -> t.toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        $this.streamLogger.underlying().debugMdc((Map)mdc.apply((Object)t), (Function0 & Serializable)() -> t.toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    failure = new Success(((Function1)FlowTransaction$.MODULE$.transaction2envelope().apply((Object)$this.headerCfg)).apply((Object)t));
                } else if (try_ instanceof Failure) {
                    Failure failure2 = (Failure)try_;
                    Throwable t = failure2.exception();
                    failure = new Failure(t);
                } else {
                    throw new MatchError((Object)try_);
                }
                return failure;
            }));
            return new FlowShape(f.in(), f.out());
        });
        this.createResult = (Function1 & Serializable)x0$2 -> {
            FlowEnvelope flowEnvelope;
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            FlowEnvelope orig = (FlowEnvelope)tuple2._1();
            Try env = (Try)tuple2._2();
            Try try_ = env;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                FlowEnvelope e = (FlowEnvelope)success.value();
                $this.streamLogger.logEnv(e, LogLevel$.MODULE$.Trace(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Successfully processed transaction event [").append(e.id()).append("]").toString(), $this.streamLogger.logEnv$default$4());
                flowEnvelope = e.withAckHandler(orig.getAckHandler()).withRequiresAcknowledge(orig.requiresAcknowledge()).clearException();
                return flowEnvelope;
            } else {
                if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                Failure failure = (Failure)try_;
                Throwable t = failure.exception();
                $this.streamLogger.logEnv(orig, LogLevel$.MODULE$.Trace(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Failed to process transaction event [").append(orig.id()).append("]").toString(), $this.streamLogger.logEnv$default$4());
                flowEnvelope = orig.withException(t);
            }
            return flowEnvelope;
        };
    }
}

