/*
 * Decompiled with CFR 0.152.
 */
package blended.streams.jms;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.stream.Attributes;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.Shape;
import akka.stream.SourceShape;
import akka.stream.stage.AsyncCallback;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import blended.jms.utils.ConnectionStateChanged;
import blended.jms.utils.ConnectionStateListener$;
import blended.jms.utils.Disconnected$;
import blended.jms.utils.JmsConnectionState;
import blended.jms.utils.JmsDestination;
import blended.jms.utils.JmsSession;
import blended.jms.utils.MessageReceived;
import blended.streams.AckSourceLogic;
import blended.streams.AckSourceLogic$;
import blended.streams.DefaultAcknowledgeContext;
import blended.streams.FlowHeaderConfig;
import blended.streams.jms.AcknowledgeMode;
import blended.streams.jms.AcknowledgeMode$;
import blended.streams.jms.JmsConnector;
import blended.streams.jms.JmsConsumerSettings;
import blended.streams.jms.JmsConsumerStage$;
import blended.streams.jms.JmsEnvelopeHeader;
import blended.streams.jms.JmsFlowSupport$;
import blended.streams.message.AcknowledgeHandler;
import blended.streams.message.FlowEnvelope;
import blended.streams.message.FlowEnvelope$;
import blended.streams.message.FlowEnvelopeLogger;
import blended.streams.message.FlowMessage;
import blended.util.RichTry$;
import blended.util.logging.LogLevel$;
import java.io.Serializable;
import java.util.UUID;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\r\ra\u0001\u0002$H\u00059C\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tc\u0002\u0011\t\u0011)A\u0005e\"Aa\u000f\u0001B\u0001B\u0003%q\u000f\u0003\u0006\u0002\b\u0001\u0011\t\u0011)A\u0006\u0003\u0013Aq!!\u0006\u0001\t\u0003\t9\u0002C\u0005\u0002&\u0001\u0011\r\u0011\"\u0003\u0002(!A\u0011\u0011\u0007\u0001!\u0002\u0013\tI\u0003C\u0005\u00024\u0001\u0011\r\u0011\"\u0003\u00026!A\u0011Q\b\u0001!\u0002\u0013\t9\u0004C\u0005\u0002@\u0001\u0011\r\u0011\"\u0011\u0002B!9\u00111\t\u0001!\u0002\u0013IfABA#\u0001\u0011\t9\u0005C\u0006\u0002P1\u0011\t\u0011)A\u0005I\u0006E\u0003bCA*\u0019\t\u0005\t\u0015!\u0003^\u0003+B!\"!\u0017\r\u0005\u000b\u0007I\u0011AA.\u0011)\tY\u0007\u0004B\u0001B\u0003%\u0011Q\f\u0005\u000b\u0003[b!Q1A\u0005\u0002\u0005=\u0004BCA?\u0019\t\u0005\t\u0015!\u0003\u0002r!Q\u0011q\u0010\u0007\u0003\u0006\u0004%\t!!!\t\u0015\u0005EEB!A!\u0002\u0013\t\u0019\t\u0003\u0006\u0002\u00142\u0011)\u0019!C\u0001\u0003+C!\"!'\r\u0005\u0003\u0005\u000b\u0011BAL\u0011\u001d\t)\u0002\u0004C\u0001\u00037Cq!!,\r\t\u0003\ny\u000bC\u0004\u000222!\t%a,\u0007\r\u0005M\u0006\u0001BA[\u0011\u001d\t)B\u0007C\u0001\u0003\u0007D\u0011\"a2\u001b\u0005\u0004%\t&!3\t\u000f\u0005-'\u0004)A\u0005I\"I\u0011Q\u001a\u000eC\u0002\u0013\u0005\u0013q\u001a\u0005\t\u0003/T\u0002\u0015!\u0003\u0002R\"I\u0011\u0011\u001c\u000eC\u0002\u0013\u0005\u00131\u001c\u0005\t\u0003GT\u0002\u0015!\u0003\u0002^\"I\u0011Q\u001d\u000eA\u0002\u0013%\u0011q\u001d\u0005\n\u0003cT\u0002\u0019!C\u0005\u0003gD\u0001\"!?\u001bA\u0003&\u0011\u0011\u001e\u0005\n\u0003wT\"\u0019!C\u0005\u0003{D\u0001Ba\u0006\u001bA\u0003%\u0011q \u0005\n\u00053Q\"\u0019!C\u0005\u00057A\u0001Ba\t\u001bA\u0003%!Q\u0004\u0005\n\u0005KQ\"\u0019!C\u0005\u0003\u0013DqAa\n\u001bA\u0003%A\rC\u0005\u0003*i\u0011\r\u0011\"\u0003\u0002J\"9!1\u0006\u000e!\u0002\u0013!\u0007\u0002\u0003B\u00175\u0001\u0006IAa\f\t\u0011\t\u0015#\u0004)C\u0005\u0005\u000fB\u0001B!\u0015\u001bA\u0013%!1\u000b\u0005\n\u0005/R\"\u0019!C\u0005\u00053B\u0001B!\u0018\u001bA\u0003%!1\f\u0005\n\u0005?R\"\u0019!C\u0005\u0005CB\u0001B!\u001a\u001bA\u0003%!1\r\u0005\u000b\u0005OR\u0002R1A\u0005\n\t%\u0004b\u0002B95\u0011E#1\u000f\u0005\n\u0005oR\"\u0019!C)\u0005sB\u0001B!!\u001bA\u0003%!1\u0010\u0005\n\u0005\u0007S\u0002\u0019!C\u0005\u0005\u000bC\u0011Ba\"\u001b\u0001\u0004%IA!#\t\u000f\t5%\u0004)Q\u0005o\"9!q\u0012\u000e\u0005R\tE\u0005b\u0002BJ5\u0011%!Q\u0013\u0005\b\u0005OSB\u0011\u0002BU\u0011\u001d\u0011IL\u0007C)\u0005wCqA!2\u001b\t\u0003\ny\u000bC\u0004\u0003Hj!\t%a,\t\u000f\t%\u0007\u0001\"\u0011\u0003L\u001eI!Q\\$\u0002\u0002#\u0005!q\u001c\u0004\t\r\u001e\u000b\t\u0011#\u0001\u0003b\"9\u0011QC\"\u0005\u0002\t%\b\"\u0003Bv\u0007F\u0005I\u0011\u0001Bw\u0005AQUn]\"p]N,X.\u001a:Ti\u0006<WM\u0003\u0002I\u0013\u0006\u0019!.\\:\u000b\u0005)[\u0015aB:ue\u0016\fWn\u001d\u0006\u0002\u0019\u00069!\r\\3oI\u0016$7\u0001A\n\u0003\u0001=\u00032\u0001U,Z\u001b\u0005\t&B\u0001*T\u0003\u0015\u0019H/Y4f\u0015\t!V+\u0001\u0004tiJ,\u0017-\u001c\u0006\u0002-\u0006!\u0011m[6b\u0013\tA\u0016K\u0001\u0006He\u0006\u0004\bn\u0015;bO\u0016\u00042AW.^\u001b\u0005\u0019\u0016B\u0001/T\u0005-\u0019v.\u001e:dKNC\u0017\r]3\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001L\u0015aB7fgN\fw-Z\u0005\u0003E~\u0013AB\u00127po\u0016sg/\u001a7pa\u0016\fAA\\1nKB\u0011QM\u001c\b\u0003M2\u0004\"a\u001a6\u000e\u0003!T!!['\u0002\rq\u0012xn\u001c;?\u0015\u0005Y\u0017!B:dC2\f\u0017BA7k\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000e\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055T\u0017\u0001E2p]N,X.\u001a:TKR$\u0018N\\4t!\t\u0019H/D\u0001H\u0013\t)xIA\nK[N\u001cuN\\:v[\u0016\u00148+\u001a;uS:<7/A\bnS:lUm]:bO\u0016$U\r\\1z!\rA\u0018p_\u0007\u0002U&\u0011!P\u001b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007q\f\u0019!D\u0001~\u0015\tqx0\u0001\u0005ekJ\fG/[8o\u0015\r\t\tA[\u0001\u000bG>t7-\u001e:sK:$\u0018bAA\u0003{\nqa)\u001b8ji\u0016$UO]1uS>t\u0017aC1di>\u00148+_:uK6\u0004B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f)\u0016!B1di>\u0014\u0018\u0002BA\n\u0003\u001b\u00111\"Q2u_J\u001c\u0016p\u001d;f[\u00061A(\u001b8jiz\"\u0002\"!\u0007\u0002 \u0005\u0005\u00121\u0005\u000b\u0005\u00037\ti\u0002\u0005\u0002t\u0001!9\u0011qA\u0003A\u0004\u0005%\u0001\"B2\u0006\u0001\u0004!\u0007\"B9\u0006\u0001\u0004\u0011\bb\u0002<\u0006!\u0003\u0005\ra^\u0001\rQ\u0016\fG-\u001a:D_:4\u0017nZ\u000b\u0003\u0003S\u0001B!a\u000b\u0002.5\t\u0011*C\u0002\u00020%\u0013\u0001C\u00127po\"+\u0017\rZ3s\u0007>tg-[4\u0002\u001b!,\u0017\rZ3s\u0007>tg-[4!\u0003\ryW\u000f^\u000b\u0003\u0003o\u0001BAWA\u001d;&\u0019\u00111H*\u0003\r=+H\u000f\\3u\u0003\u0011yW\u000f\u001e\u0011\u0002\u000bMD\u0017\r]3\u0016\u0003e\u000baa\u001d5ba\u0016\u0004#!\u0004&ng\u0006\u001b7nQ8oi\u0016DHoE\u0002\r\u0003\u0013\u0002B!a\u000b\u0002L%\u0019\u0011QJ%\u00033\u0011+g-Y;mi\u0006\u001b7N\\8xY\u0016$w-Z\"p]R,\u0007\u0010^\u0001\u000bS:4G.[4ii&#\u0017\u0002BA(\u0003\u0017\n1!\u001a8w\u0013\u0011\t9&a\u0013\u0002\u0011\u0015tg/\u001a7pa\u0016\f!B[7t\u001b\u0016\u001c8/Y4f+\t\ti\u0006\u0005\u0003\u0002`\u0005\u001dTBAA1\u0015\rA\u00151\r\u0006\u0003\u0003K\nQA[1wCbLA!!\u001b\u0002b\t9Q*Z:tC\u001e,\u0017a\u00036ng6+7o]1hK\u0002\nQB[7t\u001b\u0016\u001c8/Y4f\u0003\u000e\\WCAA9!\u001dA\u00181OA/\u0003oJ1!!\u001ek\u0005%1UO\\2uS>t\u0017\u0007E\u0002y\u0003sJ1!a\u001fk\u0005\u0011)f.\u001b;\u0002\u001d)l7/T3tg\u0006<W-Q2lA\u000591/Z:tS>tWCAAB!\u0011\t))!$\u000e\u0005\u0005\u001d%\u0002BAE\u0003\u0017\u000bQ!\u001e;jYNT!\u0001S&\n\t\u0005=\u0015q\u0011\u0002\u000b\u00156\u001c8+Z:tS>t\u0017\u0001C:fgNLwN\u001c\u0011\u0002\u0019M,7o]5p]\u000ecwn]3\u0016\u0005\u0005]\u0005c\u0002=\u0002t\u0005\r\u0015qO\u0001\u000eg\u0016\u001c8/[8o\u00072|7/\u001a\u0011\u0015\u001d\u0005u\u0015\u0011UAR\u0003K\u000b9+!+\u0002,B\u0019\u0011q\u0014\u0007\u000e\u0003\u0001Aa!a\u0014\u0018\u0001\u0004!\u0007BBA*/\u0001\u0007Q\fC\u0004\u0002Z]\u0001\r!!\u0018\t\u000f\u00055t\u00031\u0001\u0002r!9\u0011qP\fA\u0002\u0005\r\u0005bBAJ/\u0001\u0007\u0011qS\u0001\u0005I\u0016t\u0017\u0010\u0006\u0002\u0002x\u0005Y\u0011mY6o_^dW\rZ4f\u00059QUn]*pkJ\u001cW\rT8hS\u000e\u001cRAGA\\\u0003{\u0003b!a\u000b\u0002:\u0006u\u0015bAA^\u0013\nq\u0011iY6T_V\u00148-\u001a'pO&\u001c\u0007cA:\u0002@&\u0019\u0011\u0011Y$\u0003#)k7/\u00128wK2|\u0007/\u001a%fC\u0012,'\u000f\u0006\u0002\u0002FB\u0019\u0011q\u0014\u000e\u0002\u0005%$W#\u00013\u0002\u0007%$\u0007%A\u0002m_\u001e,\"!!5\u0011\u0007y\u000b\u0019.C\u0002\u0002V~\u0013!C\u00127po\u0016sg/\u001a7pa\u0016dunZ4fe\u0006!An\\4!\u0003=\tW\u000f^8BG.twn\u001e7fI\u001e,WCAAo!\rA\u0018q\\\u0005\u0004\u0003CT'a\u0002\"p_2,\u0017M\\\u0001\u0011CV$x.Q2l]><H.\u001a3hK\u0002\nQb\u001d;bi\u0016d\u0015n\u001d;f]\u0016\u0014XCAAu!\u0011A\u00180a;\u0011\t\u0005-\u0011Q^\u0005\u0005\u0003_\fiA\u0001\u0005BGR|'OU3g\u0003E\u0019H/\u0019;f\u0019&\u001cH/\u001a8fe~#S-\u001d\u000b\u0005\u0003o\n)\u0010C\u0005\u0002x\u000e\n\t\u00111\u0001\u0002j\u0006\u0019\u0001\u0010J\u0019\u0002\u001dM$\u0018\r^3MSN$XM\\3sA\u0005Y\u0001.\u00198eY\u0016,%O]8s+\t\ty\u0010E\u0003Q\u0005\u0003\u0011)!C\u0002\u0003\u0004E\u0013Q\"Q:z]\u000e\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0003\u0002B\u0004\u0005#qAA!\u0003\u0003\u000e9\u0019qMa\u0003\n\u0003-L1Aa\u0004k\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0005\u0003\u0016\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0005\u001fQ\u0017\u0001\u00045b]\u0012dW-\u0012:s_J\u0004\u0013aB:sG\u0012+7\u000f^\u000b\u0003\u0005;\u0001B!!\"\u0003 %!!\u0011EAD\u00059QUn\u001d#fgRLg.\u0019;j_:\f\u0001b\u001d:d\t\u0016\u001cH\u000fI\u0001\u0007m\u0016tGm\u001c:\u0002\u000fY,g\u000eZ8sA\u0005A\u0001O]8wS\u0012,'/A\u0005qe>4\u0018\u000eZ3sA\u0005A1m\u001c8tk6,'\u000fE\u0004\u00032\tmBMa\u0010\u000e\u0005\tM\"\u0002\u0002B\u001b\u0005o\tq!\\;uC\ndWMC\u0002\u0003:)\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iDa\r\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002`\t\u0005\u0013\u0002\u0002B\"\u0003C\u0012q\"T3tg\u0006<WmQ8ogVlWM]\u0001\fC\u0012$7i\u001c8tk6,'\u000f\u0006\u0004\u0002x\t%#Q\n\u0005\u0007\u0005\u0017r\u0003\u0019\u00013\u0002\u0003MDqAa\u0014/\u0001\u0004\u0011y$A\u0001d\u00039\u0011X-\\8wK\u000e{gn];nKJ$B!a\u001e\u0003V!1!1J\u0018A\u0002\u0011\fAb\u00197pg\u0016\u001cVm]:j_:,\"Aa\u0017\u0011\u000bA\u0013\t!a!\u0002\u001b\rdwn]3TKN\u001c\u0018n\u001c8!\u0003)\t7m['fgN\fw-Z\u000b\u0003\u0005G\u0002R\u0001\u0015B\u0001\u0003;\n1\"Y2l\u001b\u0016\u001c8/Y4fA\u0005I1m\u001c8oK\u000e$xN]\u000b\u0003\u0005W\u00022a\u001dB7\u0013\r\u0011yg\u0012\u0002\r\u00156\u001c8i\u001c8oK\u000e$xN]\u0001\u0011MJ,W-\u00138gY&<\u0007\u000e^*m_R$\"A!\u001e\u0011\u0007aLH-A\u0007j]\u001ad\u0017n\u001a5u'2|Go]\u000b\u0003\u0005w\u0002RAa\u0002\u0003~\u0011LAAa \u0003\u0016\t!A*[:u\u00039IgN\u001a7jO\"$8\u000b\\8ug\u0002\n\u0001C\\3yiB{G\u000e\u001c*fY\u0006$\u0018N^3\u0016\u0003]\fAC\\3yiB{G\u000e\u001c*fY\u0006$\u0018N^3`I\u0015\fH\u0003BA<\u0005\u0017C\u0001\"a>:\u0003\u0003\u0005\ra^\u0001\u0012]\u0016DH\u000fU8mYJ+G.\u0019;jm\u0016\u0004\u0013\u0001\u00038fqR\u0004v\u000e\u001c7\u0015\u0003]\fqA]3dK&4X\r\u0006\u0003\u0003\u0018\n\u0015\u0006C\u0002BM\u0005?\u0013\u0019+\u0004\u0002\u0003\u001c*\u0019!Q\u00146\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005C\u0013YJA\u0002Uef\u0004B\u0001_=\u0002^!9\u0011q\u0010\u001fA\u0002\u0005\r\u0015AD2sK\u0006$X-\u00128wK2|\u0007/\u001a\u000b\u0007\u0005W\u0013iKa,\u0011\u000b\te%qT/\t\r\u0001l\u0004\u0019AA/\u0011\u001d\u0011\t,\u0010a\u0001\u0005g\u000b!\"Y2l\u0011\u0006tG\r\\3s!\rq&QW\u0005\u0004\u0005o{&AE!dW:|w\u000f\\3eO\u0016D\u0015M\u001c3mKJ\fQ\u0002Z8QKJ4wN]7Q_2dGC\u0002B_\u0005\u0003\u0014\u0019\r\u0005\u0004\u0003\u001a\n}%q\u0018\t\u0005qf\fi\n\u0003\u0004\u0002Hz\u0002\r\u0001\u001a\u0005\b\u0005cs\u0004\u0019\u0001BZ\u0003!\u0001(/Z*uCJ$\u0018\u0001\u00039pgR\u001cFo\u001c9\u0002\u0017\r\u0014X-\u0019;f\u0019><\u0017n\u0019\u000b\u0005\u0005\u001b\u0014\u0019\u000eE\u0002Q\u0005\u001fL1A!5R\u0005=9%/\u00199i'R\fw-\u001a'pO&\u001c\u0007b\u0002Bk\u0003\u0002\u0007!q[\u0001\u0014S:DWM]5uK\u0012\fE\u000f\u001e:jEV$Xm\u001d\t\u00045\ne\u0017b\u0001Bn'\nQ\u0011\t\u001e;sS\n,H/Z:\u0002!)k7oQ8ogVlWM]*uC\u001e,\u0007CA:D'\r\u0019%1\u001d\t\u0004q\n\u0015\u0018b\u0001BtU\n1\u0011I\\=SK\u001a$\"Aa8\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011yOK\u0002x\u0005c\\#Aa=\u0011\t\tU(q`\u0007\u0003\u0005oTAA!?\u0003|\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005{T\u0017AC1o]>$\u0018\r^5p]&!1\u0011\u0001B|\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public final class JmsConsumerStage
extends GraphStage<SourceShape<FlowEnvelope>> {
    public final String blended$streams$jms$JmsConsumerStage$$name;
    public final JmsConsumerSettings blended$streams$jms$JmsConsumerStage$$consumerSettings;
    public final Option<FiniteDuration> blended$streams$jms$JmsConsumerStage$$minMessageDelay;
    public final ActorSystem blended$streams$jms$JmsConsumerStage$$actorSystem;
    private final FlowHeaderConfig blended$streams$jms$JmsConsumerStage$$headerConfig;
    private final Outlet<FlowEnvelope> blended$streams$jms$JmsConsumerStage$$out;
    private final SourceShape<FlowEnvelope> shape;

    public static Option<FiniteDuration> $lessinit$greater$default$3() {
        return JmsConsumerStage$.MODULE$.$lessinit$greater$default$3();
    }

    public FlowHeaderConfig blended$streams$jms$JmsConsumerStage$$headerConfig() {
        return this.blended$streams$jms$JmsConsumerStage$$headerConfig;
    }

    public Outlet<FlowEnvelope> blended$streams$jms$JmsConsumerStage$$out() {
        return this.blended$streams$jms$JmsConsumerStage$$out;
    }

    public SourceShape<FlowEnvelope> shape() {
        return this.shape;
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new JmsSourceLogic();
    }

    public JmsConsumerStage(String name, JmsConsumerSettings consumerSettings, Option<FiniteDuration> minMessageDelay, ActorSystem actorSystem) {
        this.blended$streams$jms$JmsConsumerStage$$name = name;
        this.blended$streams$jms$JmsConsumerStage$$consumerSettings = consumerSettings;
        this.blended$streams$jms$JmsConsumerStage$$minMessageDelay = minMessageDelay;
        this.blended$streams$jms$JmsConsumerStage$$actorSystem = actorSystem;
        consumerSettings.log().underlying().debug((Function0 & Serializable)() -> new StringBuilder(20).append("Starting consumer [").append($this.blended$streams$jms$JmsConsumerStage$$name).append("]").toString());
        this.blended$streams$jms$JmsConsumerStage$$headerConfig = consumerSettings.headerCfg();
        this.blended$streams$jms$JmsConsumerStage$$out = Outlet$.MODULE$.apply(new StringBuilder(18).append("JmsAckSource(").append(name).append(".out)").toString());
        this.shape = new SourceShape(this.blended$streams$jms$JmsConsumerStage$$out());
    }

    public class JmsAckContext
    extends DefaultAcknowledgeContext {
        private final Message jmsMessage;
        private final Function1<Message, BoxedUnit> jmsMessageAck;
        private final JmsSession session;
        private final Function1<JmsSession, BoxedUnit> sessionClose;
        public final /* synthetic */ JmsConsumerStage $outer;

        public Message jmsMessage() {
            return this.jmsMessage;
        }

        public Function1<Message, BoxedUnit> jmsMessageAck() {
            return this.jmsMessageAck;
        }

        public JmsSession session() {
            return this.session;
        }

        public Function1<JmsSession, BoxedUnit> sessionClose() {
            return this.sessionClose;
        }

        @Override
        public void deny() {
            this.sessionClose().apply((Object)this.session());
            this.blended$streams$jms$JmsConsumerStage$JmsAckContext$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().logEnv(super.envelope(), LogLevel$.MODULE$.Debug(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("Message [").append(this.envelope().id()).append("] has been denied. Closing receiving session.").toString(), this.blended$streams$jms$JmsConsumerStage$JmsAckContext$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().logEnv$default$4());
        }

        @Override
        public void acknowledge() {
            this.jmsMessageAck().apply((Object)this.jmsMessage());
            this.blended$streams$jms$JmsConsumerStage$JmsAckContext$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().logEnv(super.envelope(), LogLevel$.MODULE$.Debug(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Acknowledged envelope [").append(this.envelope().id()).append("] for session [").append(this.session().sessionId()).append("]").toString(), this.blended$streams$jms$JmsConsumerStage$JmsAckContext$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().logEnv$default$4());
        }

        public /* synthetic */ JmsConsumerStage blended$streams$jms$JmsConsumerStage$JmsAckContext$$$outer() {
            return this.$outer;
        }

        public JmsAckContext(JmsConsumerStage $outer, String inflightId, FlowEnvelope env, Message jmsMessage, Function1<Message, BoxedUnit> jmsMessageAck, JmsSession session, Function1<JmsSession, BoxedUnit> sessionClose) {
            this.jmsMessage = jmsMessage;
            this.jmsMessageAck = jmsMessageAck;
            this.session = session;
            this.sessionClose = sessionClose;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(inflightId, env, System.currentTimeMillis());
        }
    }

    public class JmsSourceLogic
    extends AckSourceLogic<JmsAckContext>
    implements JmsEnvelopeHeader {
        private JmsConnector connector;
        private final String id;
        private final FlowEnvelopeLogger log;
        private final boolean autoAcknowledge;
        private Option<ActorRef> stateListener;
        private final AsyncCallback<Throwable> handleError;
        private final JmsDestination srcDest;
        private final String vendor;
        private final String provider;
        private final Map<String, MessageConsumer> consumer;
        private final AsyncCallback<JmsSession> closeSession;
        private final AsyncCallback<Message> ackMessage;
        private final List<String> inflightSlots;
        private Option<FiniteDuration> nextPollRelative;
        private Function1<String, String> jmsHeaderPrefix;
        private Function1<String, String> srcVendorHeader;
        private Function1<String, String> srcProviderHeader;
        private Function1<String, String> srcDestHeader;
        private Function1<String, String> destHeader;
        private Function1<String, String> corrIdHeader;
        private Function1<String, String> priorityHeader;
        private Function1<String, String> expireHeader;
        private Function1<String, String> deliveryModeHeader;
        private Function1<String, String> replyToHeader;
        private Function1<String, String> timestampHeader;
        private Function1<String, String> typeHeader;
        private Function1<String, String> msgIdHeader;
        private String replyToQueueName;
        private volatile boolean bitmap$0;

        @Override
        public Function1<String, String> jmsHeaderPrefix() {
            return this.jmsHeaderPrefix;
        }

        @Override
        public Function1<String, String> srcVendorHeader() {
            return this.srcVendorHeader;
        }

        @Override
        public Function1<String, String> srcProviderHeader() {
            return this.srcProviderHeader;
        }

        @Override
        public Function1<String, String> srcDestHeader() {
            return this.srcDestHeader;
        }

        @Override
        public Function1<String, String> destHeader() {
            return this.destHeader;
        }

        @Override
        public Function1<String, String> corrIdHeader() {
            return this.corrIdHeader;
        }

        @Override
        public Function1<String, String> priorityHeader() {
            return this.priorityHeader;
        }

        @Override
        public Function1<String, String> expireHeader() {
            return this.expireHeader;
        }

        @Override
        public Function1<String, String> deliveryModeHeader() {
            return this.deliveryModeHeader;
        }

        @Override
        public Function1<String, String> replyToHeader() {
            return this.replyToHeader;
        }

        @Override
        public Function1<String, String> timestampHeader() {
            return this.timestampHeader;
        }

        @Override
        public Function1<String, String> typeHeader() {
            return this.typeHeader;
        }

        @Override
        public Function1<String, String> msgIdHeader() {
            return this.msgIdHeader;
        }

        @Override
        public String replyToQueueName() {
            return this.replyToQueueName;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$jmsHeaderPrefix_$eq(Function1<String, String> x$1) {
            this.jmsHeaderPrefix = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcVendorHeader_$eq(Function1<String, String> x$1) {
            this.srcVendorHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcProviderHeader_$eq(Function1<String, String> x$1) {
            this.srcProviderHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcDestHeader_$eq(Function1<String, String> x$1) {
            this.srcDestHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$destHeader_$eq(Function1<String, String> x$1) {
            this.destHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$corrIdHeader_$eq(Function1<String, String> x$1) {
            this.corrIdHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$priorityHeader_$eq(Function1<String, String> x$1) {
            this.priorityHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$expireHeader_$eq(Function1<String, String> x$1) {
            this.expireHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$deliveryModeHeader_$eq(Function1<String, String> x$1) {
            this.deliveryModeHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$replyToHeader_$eq(Function1<String, String> x$1) {
            this.replyToHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$timestampHeader_$eq(Function1<String, String> x$1) {
            this.timestampHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$typeHeader_$eq(Function1<String, String> x$1) {
            this.typeHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$msgIdHeader_$eq(Function1<String, String> x$1) {
            this.msgIdHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$replyToQueueName_$eq(String x$1) {
            this.replyToQueueName = x$1;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public FlowEnvelopeLogger log() {
            return this.log;
        }

        @Override
        public boolean autoAcknowledge() {
            return this.autoAcknowledge;
        }

        private Option<ActorRef> stateListener() {
            return this.stateListener;
        }

        private void stateListener_$eq(Option<ActorRef> x$1) {
            this.stateListener = x$1;
        }

        private AsyncCallback<Throwable> handleError() {
            return this.handleError;
        }

        private JmsDestination srcDest() {
            return this.srcDest;
        }

        private String vendor() {
            return this.vendor;
        }

        private String provider() {
            return this.provider;
        }

        private void addConsumer(String s, MessageConsumer c) {
            this.consumer.put((Object)s, (Object)c);
            this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().underlying().debug((Function0 & Serializable)() -> new StringBuilder(30).append("Jms Consumer count of [").append($this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$name).append("] is [").append($this.consumer.size()).append("]").toString());
            this.nextPollRelative_$eq((Option<FiniteDuration>)None$.MODULE$);
            this.pollImmediately().invoke((Object)BoxedUnit.UNIT);
        }

        private void removeConsumer(String s) {
            this.consumer.remove((Object)s);
            this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().underlying().debug((Function0 & Serializable)() -> new StringBuilder(26).append("Consumer count of [").append($this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$name).append("] is [").append($this.consumer.size()).append("]").toString());
        }

        private AsyncCallback<JmsSession> closeSession() {
            return this.closeSession;
        }

        private AsyncCallback<Message> ackMessage() {
            return this.ackMessage;
        }

        private JmsConnector connector$lzycompute() {
            JmsSourceLogic jmsSourceLogic = this;
            synchronized (jmsSourceLogic) {
                if (!this.bitmap$0) {
                    this.connector = new JmsConnector(this.id(), this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings, (Function1<JmsSession, Try<BoxedUnit>>)(Function1 & Serializable)session -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                        $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().underlying().debug((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(42).append("Creating message consumer for session [").append(session.sessionId()).append("], ").toString()).append(new StringBuilder(30).append("destination [").append(this.srcDest()).append("] and selector [").append($this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.selector()).append("]").toString()).toString());
                        Try try_ = session.createConsumer(this.srcDest(), $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.selector());
                        if (try_ instanceof Success) {
                            Success success = (Success)try_;
                            MessageConsumer c = (MessageConsumer)success.value();
                            this.addConsumer(session.sessionId(), c);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable e = failure.exception();
                            $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().underlying().debug((Function0 & Serializable)() -> new StringBuilder(45).append("Failed to create consumer for session [").append(session.sessionId()).append("] : [").append(e.getMessage()).append("]").toString());
                            this.closeSession().invoke(session);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError((Object)try_);
                        }
                    }), (Function1<JmsSession, Try<BoxedUnit>>)(Function1 & Serializable)s -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.consumer.get((Object)s.sessionId()).foreach((Function1 & Serializable)c -> {
                        JmsSourceLogic.$anonfun$connector$7(this, s, c);
                        return BoxedUnit.UNIT;
                    })), (Function1<JmsSession, Try<BoxedUnit>>)(Function1 & Serializable)x$1 -> new Success((Object)BoxedUnit.UNIT), (Function1<Throwable, BoxedUnit>)(Function1 & Serializable)t -> {
                        JmsSourceLogic.$anonfun$connector$10(this, t);
                        return BoxedUnit.UNIT;
                    });
                    this.bitmap$0 = true;
                }
            }
            return this.connector;
        }

        private JmsConnector connector() {
            return !this.bitmap$0 ? this.connector$lzycompute() : this.connector;
        }

        @Override
        public Option<String> freeInflightSlot() {
            Some some;
            Option<String> option = this.determineNextSlot((List<String>)this.inflightSlots().filter((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)JmsSourceLogic.$anonfun$freeInflightSlot$1(this, id))));
            if (option instanceof Some) {
                Some some2 = (Some)option;
                String s = (String)some2.value();
                some = new Some((Object)s);
            } else if (None$.MODULE$.equals(option)) {
                some = this.determineNextSlot(this.inflightSlots());
            } else {
                throw new MatchError(option);
            }
            return some;
        }

        @Override
        public List<String> inflightSlots() {
            return this.inflightSlots;
        }

        private Option<FiniteDuration> nextPollRelative() {
            return this.nextPollRelative;
        }

        private void nextPollRelative_$eq(Option<FiniteDuration> x$1) {
            this.nextPollRelative = x$1;
        }

        @Override
        public Option<FiniteDuration> nextPoll() {
            Some some;
            Option<FiniteDuration> option = this.nextPollRelative();
            if (None$.MODULE$.equals(option)) {
                some = new Some((Object)this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.pollInterval());
            } else if (option instanceof Some) {
                Some some2 = (Some)option;
                FiniteDuration npr = (FiniteDuration)some2.value();
                this.nextPollRelative_$eq((Option<FiniteDuration>)None$.MODULE$);
                this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().underlying().debug((Function0 & Serializable)() -> new StringBuilder(37).append("Overriding next poll interval with [").append(npr).append("]").toString());
                some = new Some((Object)npr);
            } else {
                throw new MatchError(option);
            }
            return some;
        }

        private Try<Option<Message>> receive(JmsSession session) {
            return Try$.MODULE$.apply((Function0 & Serializable)() -> {
                None$ none$;
                Option msg = $this.consumer.get((Object)session.sessionId()).flatMap((Function1 & Serializable)c -> $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.receiveTimeout().toMillis() <= 0L ? Option$.MODULE$.apply((Object)c.receiveNoWait()) : Option$.MODULE$.apply((Object)c.receive($this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.receiveTimeout().toMillis())));
                Option option = msg;
                if (None$.MODULE$.equals(option)) {
                    none$ = None$.MODULE$;
                } else if (option instanceof Some) {
                    Option option2;
                    Some some = (Some)option;
                    Message m = (Message)some.value();
                    Option<FiniteDuration> option3 = $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$minMessageDelay;
                    if (option3 instanceof Some) {
                        Some some2;
                        Some some3 = (Some)option3;
                        FiniteDuration d = (FiniteDuration)some3.value();
                        long age = System.currentTimeMillis() - m.getJMSTimestamp();
                        if (age <= d.toMillis()) {
                            this.closeSession().invoke((Object)session);
                            this.nextPollRelative_$eq((Option<FiniteDuration>)new Some((Object)new package.DurationLong(package$.MODULE$.DurationLong(d.toMillis() - age)).millis()));
                            $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().underlying().debug((Function0 & Serializable)() -> new StringBuilder(75).append("Message has not reached the minimum message delay yet ...rescheduling in [").append(this.nextPollRelative()).append("]").toString());
                            some2 = None$.MODULE$;
                        } else {
                            this.nextPollRelative_$eq((Option<FiniteDuration>)None$.MODULE$);
                            some2 = new Some((Object)m);
                        }
                        option2 = some2;
                    } else if (None$.MODULE$.equals(option3)) {
                        option2 = msg;
                    } else {
                        throw new MatchError(option3);
                    }
                    none$ = option2;
                } else {
                    throw new MatchError((Object)option);
                }
                None$ result = none$;
                return result;
            });
        }

        private Try<FlowEnvelope> createEnvelope(Message message, AcknowledgeHandler ackHandler) {
            return Try$.MODULE$.apply((Function0 & Serializable)() -> {
                String string;
                FlowMessage flowMessage = (FlowMessage)RichTry$.MODULE$.toRichTry((Try)((Function1)((Function1)JmsFlowSupport$.MODULE$.jms2flowMessage().apply((Object)this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$headerConfig())).apply((Object)$this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings)).apply((Object)message)).unwrap();
                Option option = flowMessage.header(this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$headerConfig().headerTransId(), ManifestFactory$.MODULE$.classType(String.class));
                if (None$.MODULE$.equals(option)) {
                    String newId = UUID.randomUUID().toString();
                    $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().underlying().trace((Function0 & Serializable)() -> new StringBuilder(26).append("Created new envelope id [").append(newId).append("]").toString());
                    string = newId;
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    String s = (String)some.value();
                    $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().underlying().trace((Function0 & Serializable)() -> new StringBuilder(40).append("Reusing transaction id [").append(s).append("] as envelope id").toString());
                    string = s;
                } else {
                    throw new MatchError(option);
                }
                String envelopeId = string;
                FlowEnvelope qual$1 = FlowEnvelope$.MODULE$.apply(flowMessage, envelopeId);
                String x$1 = this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$headerConfig().headerTransId();
                String x$2 = envelopeId;
                boolean x$3 = qual$1.withHeader$default$3();
                return ((FlowEnvelope)RichTry$.MODULE$.toRichTry(qual$1.withHeader(x$1, x$2, x$3)).unwrap()).withRequiresAcknowledge(true).withAckHandler((Option<AcknowledgeHandler>)new Some((Object)ackHandler));
            });
        }

        @Override
        public Try<Option<JmsAckContext>> doPerformPoll(String id, AcknowledgeHandler ackHandler) {
            return Try$.MODULE$.apply((Function0 & Serializable)() -> {
                None$ none$;
                Option<JmsSession> option = this.connector().getSession(id);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    JmsSession s = (JmsSession)some.value();
                    none$ = ((Option)RichTry$.MODULE$.toRichTry(this.receive(s)).unwrap()).map((Function1 & Serializable)m -> {
                        FlowEnvelope e = (FlowEnvelope)RichTry$.MODULE$.toRichTry(this.createEnvelope((Message)m, ackHandler)).unwrap();
                        long now = System.currentTimeMillis();
                        long msgAge = now - BoxesRunTime.unboxToLong((Object)e.header((String)this.timestampHeader().apply((Object)this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$headerConfig().prefix()), ManifestFactory$.MODULE$.Long()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> now));
                        $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().logEnv(e, (Enumeration.Value)$this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.logLevel().apply((Object)e), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(28).append("Message received [").append(e.id()).append("][").append($this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.jmsDestination().map((Function1 & Serializable)x$2 -> x$2.asString())).append("] after ").toString()).append(new StringBuilder(13).append("[").append(msgAge).append("]ms in [").append(s.sessionId()).append("] : ").append(e.flowMessage()).toString()).toString(), $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().logEnv$default$4());
                        $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$actorSystem.eventStream().publish((Object)new MessageReceived(this.vendor(), this.provider(), e.id()));
                        return new JmsAckContext(this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer(), id, e, (Message)m, (Function1<Message, BoxedUnit>)(Function1 & Serializable)t -> {
                            JmsSourceLogic.$anonfun$doPerformPoll$6(this, t);
                            return BoxedUnit.UNIT;
                        }, s, (Function1<JmsSession, BoxedUnit>)(Function1 & Serializable)t -> {
                            JmsSourceLogic.$anonfun$doPerformPoll$7(this, t);
                            return BoxedUnit.UNIT;
                        });
                    });
                } else if (None$.MODULE$.equals(option)) {
                    none$ = None$.MODULE$;
                } else {
                    throw new MatchError(option);
                }
                return none$;
            });
        }

        @Override
        public void preStart() {
            super.preStart();
            this.stateListener_$eq((Option<ActorRef>)new Some((Object)ConnectionStateListener$.MODULE$.create(this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.connectionFactory().vendor(), this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.connectionFactory().provider(), (Function1 & Serializable)event -> {
                JmsSourceLogic.$anonfun$preStart$1(this, event);
                return BoxedUnit.UNIT;
            }, this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$actorSystem)));
        }

        @Override
        public void postStop() {
            this.log().underlying().debug((Function0 & Serializable)() -> new StringBuilder(29).append("Stopping JmsConsumerStage [").append(this.id()).append("].").toString());
            this.stateListener().foreach((Function1 & Serializable)actor -> {
                this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$actorSystem.stop(actor);
                return BoxedUnit.UNIT;
            });
            this.connector().closeAll();
            super.postStop();
        }

        public /* synthetic */ JmsConsumerStage blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer() {
            return JmsConsumerStage.this;
        }

        public static final /* synthetic */ void $anonfun$closeSession$1(JmsSourceLogic $this, JmsSession s) {
            $this.connector().closeSession(s.sessionId());
        }

        public static final /* synthetic */ void $anonfun$connector$7(JmsSourceLogic $this, JmsSession s$1, MessageConsumer c) {
            $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().underlying().debug((Function0 & Serializable)() -> new StringBuilder(31).append("Closing message consumer for [").append(s$1.sessionId()).append("]").toString());
            c.close();
            $this.removeConsumer(s$1.sessionId());
        }

        public static final /* synthetic */ void $anonfun$connector$10(JmsSourceLogic $this, Throwable t) {
            $this.handleError().invoke((Object)t);
        }

        public static final /* synthetic */ boolean $anonfun$freeInflightSlot$1(JmsSourceLogic $this, String id) {
            return $this.connector().isOpen(id);
        }

        public static final /* synthetic */ String $anonfun$inflightSlots$1(JmsSourceLogic $this, int i) {
            return new StringBuilder(1).append($this.id()).append("-").append(i).toString();
        }

        public static final /* synthetic */ void $anonfun$doPerformPoll$6(JmsSourceLogic $this, Message t) {
            $this.ackMessage().invoke((Object)t);
        }

        public static final /* synthetic */ void $anonfun$doPerformPoll$7(JmsSourceLogic $this, JmsSession t) {
            $this.closeSession().invoke((Object)t);
        }

        public static final /* synthetic */ void $anonfun$preStart$1(JmsSourceLogic $this, ConnectionStateChanged event) {
            JmsConnectionState jmsConnectionState = event.state().status();
            if (Disconnected$.MODULE$.equals(jmsConnectionState)) {
                String msg = new StringBuilder(39).append("Underlying JMS connection closed for [").append($this.id()).append("]").toString();
                $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().underlying().debug((Function0 & Serializable)() -> msg);
                Exception t = new Exception(msg);
                $this.handleError().invoke((Object)t);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }

        public JmsSourceLogic() {
            JmsDestination d;
            if (JmsConsumerStage.this == null) {
                throw null;
            }
            super((Shape)JmsConsumerStage.this.shape(), JmsConsumerStage.this.blended$streams$jms$JmsConsumerStage$$out(), AckSourceLogic$.MODULE$.$lessinit$greater$default$3());
            JmsEnvelopeHeader.$init$(this);
            this.id = JmsConsumerStage.this.blended$streams$jms$JmsConsumerStage$$name;
            this.log = JmsConsumerStage.this.blended$streams$jms$JmsConsumerStage$$consumerSettings.log();
            AcknowledgeMode acknowledgeMode = JmsConsumerStage.this.blended$streams$jms$JmsConsumerStage$$consumerSettings.acknowledgeMode();
            AcknowledgeMode acknowledgeMode2 = AcknowledgeMode$.MODULE$.AutoAcknowledge();
            this.autoAcknowledge = !(acknowledgeMode != null ? !acknowledgeMode.equals(acknowledgeMode2) : acknowledgeMode2 != null);
            this.stateListener = None$.MODULE$;
            this.handleError = this.getAsyncCallback((Function1 & Serializable)t -> {
                this.failStage(t);
                return BoxedUnit.UNIT;
            });
            Option<JmsDestination> option = JmsConsumerStage.this.blended$streams$jms$JmsConsumerStage$$consumerSettings.jmsDestination();
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalArgumentException(new StringBuilder(42).append("Destination must be set for consumer in [").append(this.id()).append("]").toString());
                }
                throw new MatchError(option);
            }
            Some some = (Some)option;
            JmsDestination jmsDestination = d = (JmsDestination)some.value();
            this.srcDest = jmsDestination;
            this.vendor = JmsConsumerStage.this.blended$streams$jms$JmsConsumerStage$$consumerSettings.connectionFactory().vendor();
            this.provider = JmsConsumerStage.this.blended$streams$jms$JmsConsumerStage$$consumerSettings.connectionFactory().provider();
            this.consumer = (Map)Map$.MODULE$.empty();
            this.closeSession = this.getAsyncCallback((Function1 & Serializable)s -> {
                JmsSourceLogic.$anonfun$closeSession$1(this, s);
                return BoxedUnit.UNIT;
            });
            this.ackMessage = this.getAsyncCallback((Function1 & Serializable)m -> {
                m.acknowledge();
                return BoxedUnit.UNIT;
            });
            this.inflightSlots = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), JmsConsumerStage.this.blended$streams$jms$JmsConsumerStage$$consumerSettings.sessionCount()).map((Function1 & Serializable)i -> JmsSourceLogic.$anonfun$inflightSlots$1(this, BoxesRunTime.unboxToInt((Object)i))).toList();
            this.nextPollRelative = None$.MODULE$;
            Statics.releaseFence();
        }
    }
}

