/*
 * Decompiled with CFR 0.152.
 */
package blended.streams.file;

import akka.stream.Attributes;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.Shape;
import akka.stream.SourceShape;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import blended.streams.AckSourceLogic;
import blended.streams.DefaultAcknowledgeContext;
import blended.streams.file.FileAckSource$;
import blended.streams.file.FilePollConfig;
import blended.streams.message.AcknowledgeHandler;
import blended.streams.message.FlowEnvelope;
import blended.streams.message.FlowEnvelope$;
import blended.streams.message.FlowEnvelopeLogger;
import blended.streams.message.FlowMessage;
import blended.streams.message.FlowMessage$;
import blended.util.FileHelper;
import blended.util.logging.LogLevel$;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005-x!B\u0014)\u0011\u0003yc!B\u0019)\u0011\u0003\u0011\u0004\"B\u001d\u0002\t\u0003Q\u0004bB\u001e\u0002\u0005\u0004%I\u0001\u0010\u0005\u0007'\u0006\u0001\u000b\u0011B\u001f\t\u000bQ\u000bA\u0011A+\u0007\tEB\u0003A\u001a\u0005\tE\u001a\u0011\t\u0011)A\u0005G\"A1P\u0002B\u0001B\u0003%A\u0010C\u0003:\r\u0011\u0005q\u0010C\u0005\u0002\b\u0019\u0011\r\u0011\"\u0003\u0002\n!9\u00111\u0002\u0004!\u0002\u0013)\u0005\"CA\u0007\r\t\u0007I\u0011BA\b\u0011!\t9B\u0002Q\u0001\n\u0005E\u0001\"CA\r\r\t\u0007I\u0011BA\u000e\u0011!\tIC\u0002Q\u0001\n\u0005u\u0001bBA\u0016\r\u0011\u0005\u0013Q\u0006\u0004\u0007\u0003_1A!!\r\t\u0017\u0005m\u0012C!A!\u0002\u0013)\u0015Q\b\u0005\f\u0003\u007f\t\"\u0011!Q\u0001\nU\f\t\u0005\u0003\u0006\u0002FE\u0011)\u0019!C\u0001\u0003\u000fB\u0011\"!\u0013\u0012\u0005\u0003\u0005\u000b\u0011B-\t\u0015\u0005-\u0013C!b\u0001\n\u0003\t9\u0005C\u0005\u0002NE\u0011\t\u0011)A\u00053\"1\u0011(\u0005C\u0001\u0003\u001fBq!!\u0018\u0012\t\u0003\ny\u0006C\u0004\u0002hE!\t%a\u0018\t\u001d\u0005%\u0014\u0003%A\u0002\u0002\u0003%I!!\u0003\u0002>\u00191\u00111\u000e\u0004\u0005\u0003[Ba!\u000f\u000f\u0005\u0002\u0005U\u0004\"CA=9\t\u0007I\u0011IA\u0005\u0011\u001d\tY\b\bQ\u0001\n\u0015Cq!! \u001d\t#\ny\bC\u0005\u0002\u0002r\u0011\r\u0011\"\u0015\u0002\u0004\"A\u0011q\u0013\u000f!\u0002\u0013\t)\tC\u0004\u0002\u001ar!\t&a'\t\u000f\u0005=F\u0004\"\u0015\u00022\"A\u0011Q\u001a\u000f!\n\u0013\ty\rC\u0004\u0002X\u001a!\t%!7\u0002\u001b\u0019KG.Z!dWN{WO]2f\u0015\tI#&\u0001\u0003gS2,'BA\u0016-\u0003\u001d\u0019HO]3b[NT\u0011!L\u0001\bE2,g\u000eZ3e\u0007\u0001\u0001\"\u0001M\u0001\u000e\u0003!\u0012QBR5mK\u0006\u001b7nU8ve\u000e,7CA\u00014!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aL\u0001\bg>,(oY3t+\u0005i\u0004\u0003\u0002 D\u000bBk\u0011a\u0010\u0006\u0003\u0001\u0006\u000bq!\\;uC\ndWM\u0003\u0002Ck\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0011{$aA'baB\u0011a)\u0014\b\u0003\u000f.\u0003\"\u0001S\u001b\u000e\u0003%S!A\u0013\u0018\u0002\rq\u0012xn\u001c;?\u0013\taU'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001d>\u0013aa\u0015;sS:<'B\u0001'6!\t\u0001\u0014+\u0003\u0002SQ\tyA)\u001b:fGR|'/_*pkJ\u001cW-\u0001\u0005t_V\u00148-Z:!\u0003!qW\r\u001f;GS2,GC\u0001,b!\r!t+W\u0005\u00031V\u0012aa\u00149uS>t\u0007C\u0001.`\u001b\u0005Y&B\u0001/^\u0003\tIwNC\u0001_\u0003\u0011Q\u0017M^1\n\u0005\u0001\\&\u0001\u0002$jY\u0016DQAY\u0003A\u0002\r\fq\u0001]8mY\u000e3w\r\u0005\u00021I&\u0011Q\r\u000b\u0002\u000f\r&dW\rU8mY\u000e{gNZ5h'\t1q\rE\u0002i_Fl\u0011!\u001b\u0006\u0003U.\fQa\u001d;bO\u0016T!\u0001\\7\u0002\rM$(/Z1n\u0015\u0005q\u0017\u0001B1lW\u0006L!\u0001]5\u0003\u0015\u001d\u0013\u0018\r\u001d5Ti\u0006<W\rE\u0002sgVl\u0011a[\u0005\u0003i.\u00141bU8ve\u000e,7\u000b[1qKB\u0011a/_\u0007\u0002o*\u0011\u0001PK\u0001\b[\u0016\u001c8/Y4f\u0013\tQxO\u0001\u0007GY><XI\u001c<fY>\u0004X-\u0001\u0004m_\u001e<WM\u001d\t\u0003mvL!A`<\u0003%\u0019cwn^#om\u0016dw\u000e]3M_\u001e<WM\u001d\u000b\u0007\u0003\u0003\t\u0019!!\u0002\u0011\u0005A2\u0001\"\u00022\n\u0001\u0004\u0019\u0007\"B>\n\u0001\u0004a\u0018A\u00029pY2LE-F\u0001F\u0003\u001d\u0001x\u000e\u001c7JI\u0002\n1a\\;u+\t\t\t\u0002\u0005\u0003s\u0003')\u0018bAA\u000bW\n1q*\u001e;mKR\fAa\\;uA\u0005\u00191\u000f\u001a4\u0016\u0005\u0005u\u0001\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\rR,\u0001\u0003uKb$\u0018\u0002BA\u0014\u0003C\u0011\u0001cU5na2,G)\u0019;f\r>\u0014X.\u0019;\u0002\tM$g\rI\u0001\u0006g\"\f\u0007/Z\u000b\u0002c\nqa)\u001b7f\u0003\u000e\\7i\u001c8uKb$8cA\t\u00024A!\u0011QGA\u001c\u001b\u0005Q\u0013bAA\u001dU\tIB)\u001a4bk2$\u0018iY6o_^dW\rZ4f\u0007>tG/\u001a=u\u0003)IgN\u001a7jO\"$\u0018\nZ\u0005\u0005\u0003w\t9$A\u0002f]ZLA!a\u0011\u00028\u0005AQM\u001c<fY>\u0004X-\u0001\u0007pe&<\u0017N\\1m\r&dW-F\u0001Z\u00035y'/[4j]\u0006dg)\u001b7fA\u0005ia-\u001b7f)>\u0004&o\\2fgN\faBZ5mKR{\u0007K]8dKN\u001c\b\u0005\u0006\u0006\u0002R\u0005U\u0013qKA-\u00037\u00022!a\u0015\u0012\u001b\u00051\u0001BBA\u001e1\u0001\u0007Q\t\u0003\u0004\u0002@a\u0001\r!\u001e\u0005\u0007\u0003\u000bB\u0002\u0019A-\t\r\u0005-\u0003\u00041\u0001Z\u0003-\t7m\u001b8po2,GmZ3\u0015\u0005\u0005\u0005\u0004c\u0001\u001b\u0002d%\u0019\u0011QM\u001b\u0003\tUs\u0017\u000e^\u0001\u0005I\u0016t\u00170\u0001\ttkB,'\u000fJ5oM2Lw\r\u001b;JI\nya)\u001b7f'>,(oY3M_\u001eL7mE\u0002\u001d\u0003_\u0002b!!\u000e\u0002r\u0005E\u0013bAA:U\tq\u0011iY6T_V\u00148-\u001a'pO&\u001cGCAA<!\r\t\u0019\u0006H\u0001\u0003S\u0012\f1!\u001b3!\u0003\rawnZ\u000b\u0002y\u0006i\u0011N\u001c4mS\u001eDGo\u00157piN,\"!!\"\u0011\u000b\u0005\u001d\u0015\u0011S#\u000f\t\u0005%\u0015Q\u0012\b\u0004\u0011\u0006-\u0015\"\u0001\u001c\n\u0007\u0005=U'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0015Q\u0013\u0002\u0005\u0019&\u001cHOC\u0002\u0002\u0010V\na\"\u001b8gY&<\u0007\u000e^*m_R\u001c\b%\u0001\u0005oKb$\bk\u001c7m)\t\ti\n\u0005\u00035/\u0006}\u0005\u0003BAQ\u0003Wk!!a)\u000b\t\u0005\u0015\u0016qU\u0001\tIV\u0014\u0018\r^5p]*\u0019\u0011\u0011V\u001b\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002.\u0006\r&A\u0004$j]&$X\rR;sCRLwN\\\u0001\u000eI>\u0004VM\u001d4pe6\u0004v\u000e\u001c7\u0015\r\u0005M\u0016\u0011YAb!\u0019\t),a/\u0002@6\u0011\u0011q\u0017\u0006\u0004\u0003s+\u0014\u0001B;uS2LA!!0\u00028\n\u0019AK]=\u0011\tQ:\u0016\u0011\u000b\u0005\u0007\u0003s\"\u0003\u0019A#\t\u000f\u0005\u0015G\u00051\u0001\u0002H\u0006Q\u0011mY6IC:$G.\u001a:\u0011\u0007Y\fI-C\u0002\u0002L^\u0014!#Q2l]><H.\u001a3hK\"\u000bg\u000e\u001a7fe\u00061An\\2lK\u0012$\"!!5\u0011\u0007Q\n\u0019.C\u0002\u0002VV\u0012qAQ8pY\u0016\fg.A\u0006de\u0016\fG/\u001a'pO&\u001cG\u0003BAn\u0003C\u00042\u0001[Ao\u0013\r\ty.\u001b\u0002\u0010\u000fJ\f\u0007\u000f[*uC\u001e,Gj\\4jG\"9\u00111\u001d\u0014A\u0002\u0005\u0015\u0018aE5oQ\u0016\u0014\u0018\u000e^3e\u0003R$(/\u001b2vi\u0016\u001c\bc\u0001:\u0002h&\u0019\u0011\u0011^6\u0003\u0015\u0005#HO]5ckR,7\u000f")
public class FileAckSource
extends GraphStage<SourceShape<FlowEnvelope>> {
    public final FilePollConfig blended$streams$file$FileAckSource$$pollCfg;
    public final FlowEnvelopeLogger blended$streams$file$FileAckSource$$logger;
    private final String blended$streams$file$FileAckSource$$pollId;
    private final Outlet<FlowEnvelope> blended$streams$file$FileAckSource$$out;
    private final SimpleDateFormat blended$streams$file$FileAckSource$$sdf;

    public static Option<File> nextFile(FilePollConfig filePollConfig) {
        return FileAckSource$.MODULE$.nextFile(filePollConfig);
    }

    public String blended$streams$file$FileAckSource$$pollId() {
        return this.blended$streams$file$FileAckSource$$pollId;
    }

    public Outlet<FlowEnvelope> blended$streams$file$FileAckSource$$out() {
        return this.blended$streams$file$FileAckSource$$out;
    }

    public SimpleDateFormat blended$streams$file$FileAckSource$$sdf() {
        return this.blended$streams$file$FileAckSource$$sdf;
    }

    public SourceShape<FlowEnvelope> shape() {
        return new SourceShape(this.blended$streams$file$FileAckSource$$out());
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new FileSourceLogic();
    }

    public FileAckSource(FilePollConfig pollCfg, FlowEnvelopeLogger logger) {
        this.blended$streams$file$FileAckSource$$pollCfg = pollCfg;
        this.blended$streams$file$FileAckSource$$logger = logger;
        this.blended$streams$file$FileAckSource$$pollId = new StringBuilder(19).append(pollCfg.headerCfg().prefix()).append(".FilePoller.").append(pollCfg.id()).append(".source").toString();
        this.blended$streams$file$FileAckSource$$out = Outlet$.MODULE$.apply(this.blended$streams$file$FileAckSource$$pollId());
        this.blended$streams$file$FileAckSource$$sdf = new SimpleDateFormat("yyyyMMdd-HHmmssSSS");
    }

    public class FileAckContext
    extends DefaultAcknowledgeContext {
        private final File originalFile;
        private final File fileToProcess;
        public final /* synthetic */ FileAckSource $outer;

        private /* synthetic */ String super$inflightId() {
            return super.inflightId();
        }

        public File originalFile() {
            return this.originalFile;
        }

        public File fileToProcess() {
            return this.fileToProcess;
        }

        @Override
        public void acknowledge() {
            this.blended$streams$file$FileAckSource$FileAckContext$$$outer().blended$streams$file$FileAckSource$$logger.logEnv(super.envelope(), LogLevel$.MODULE$.Debug(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Successfully processed envelope [").append(this.envelope().id()).append("]").toString(), this.blended$streams$file$FileAckSource$FileAckContext$$$outer().blended$streams$file$FileAckSource$$logger.logEnv$default$4());
            Option<String> option = this.blended$streams$file$FileAckSource$FileAckContext$$$outer().blended$streams$file$FileAckSource$$pollCfg.backup();
            if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.fileToProcess().delete()) {
                    this.blended$streams$file$FileAckSource$FileAckContext$$$outer().blended$streams$file$FileAckSource$$logger.logEnv(super.envelope(), LogLevel$.MODULE$.Debug(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append("Deleted file for [").append(this.envelope().id()).append("] : [").append(this.fileToProcess()).append("]").toString(), this.blended$streams$file$FileAckSource$FileAckContext$$$outer().blended$streams$file$FileAckSource$$logger.logEnv$default$4());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.blended$streams$file$FileAckSource$FileAckContext$$$outer().blended$streams$file$FileAckSource$$logger.logEnv(super.envelope(), LogLevel$.MODULE$.Warn(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("File for [").append(this.envelope().id()).append("] could not be deleted : [").append(this.fileToProcess()).append("]").toString(), this.blended$streams$file$FileAckSource$FileAckContext$$$outer().blended$streams$file$FileAckSource$$logger.logEnv$default$4());
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (option instanceof Some) {
                BoxedUnit boxedUnit;
                File fTo;
                Some some = (Some)option;
                String d = (String)some.value();
                File backupDir = new File(d);
                Object object = !backupDir.exists() ? BoxesRunTime.boxToBoolean((boolean)backupDir.mkdirs()) : BoxedUnit.UNIT;
                String backupFileName = this.blended$streams$file$FileAckSource$FileAckContext$$$outer().blended$streams$file$FileAckSource$$pollCfg.backupTimestamp() ? new StringBuilder(1).append(this.originalFile().getName()).append("-").append(this.blended$streams$file$FileAckSource$FileAckContext$$$outer().blended$streams$file$FileAckSource$$sdf().format(new Date())).toString() : this.originalFile().getName();
                File fFrom = this.fileToProcess();
                if (FileHelper.renameFile((File)fFrom, (File)(fTo = new File(backupDir, backupFileName)), (Boolean)Predef$.MODULE$.boolean2Boolean(true))) {
                    this.blended$streams$file$FileAckSource$FileAckContext$$$outer().blended$streams$file$FileAckSource$$logger.logEnv(super.envelope(), LogLevel$.MODULE$.Debug(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Moved file for [").append(this.envelope().id()).append("] from [").append(fFrom.getAbsolutePath()).append("] to [").append(fTo.getAbsolutePath()).append("]").toString(), this.blended$streams$file$FileAckSource$FileAckContext$$$outer().blended$streams$file$FileAckSource$$logger.logEnv$default$4());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.blended$streams$file$FileAckSource$FileAckContext$$$outer().blended$streams$file$FileAckSource$$logger.logEnv(super.envelope(), LogLevel$.MODULE$.Debug(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("File for [").append(this.envelope().id()).append("] failed to be renamed from [").append(fFrom.getAbsolutePath()).append("] to [").append(fTo.getAbsolutePath()).append("]").toString(), this.blended$streams$file$FileAckSource$FileAckContext$$$outer().blended$streams$file$FileAckSource$$logger.logEnv$default$4());
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            } else {
                throw new MatchError(option);
            }
        }

        @Override
        public void deny() {
            this.blended$streams$file$FileAckSource$FileAckContext$$$outer().blended$streams$file$FileAckSource$$logger.logEnv(super.envelope(), LogLevel$.MODULE$.Debug(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("Restoring file [").append(this.originalFile()).append("] in [").append(this.super$inflightId()).append("]").toString(), this.blended$streams$file$FileAckSource$FileAckContext$$$outer().blended$streams$file$FileAckSource$$logger.logEnv$default$4());
            FileHelper.renameFile((File)this.fileToProcess(), (File)this.originalFile(), (Boolean)Predef$.MODULE$.boolean2Boolean(true));
        }

        public /* synthetic */ FileAckSource blended$streams$file$FileAckSource$FileAckContext$$$outer() {
            return this.$outer;
        }

        public FileAckContext(FileAckSource $outer, String inflightId, FlowEnvelope env, File originalFile, File fileToProcess) {
            this.originalFile = originalFile;
            this.fileToProcess = fileToProcess;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(inflightId, env, System.currentTimeMillis());
        }
    }

    public class FileSourceLogic
    extends AckSourceLogic<FileAckContext> {
        private final String id;
        private final List<String> inflightSlots;

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public FlowEnvelopeLogger log() {
            return this.blended$streams$file$FileAckSource$FileSourceLogic$$$outer().blended$streams$file$FileAckSource$$logger;
        }

        @Override
        public List<String> inflightSlots() {
            return this.inflightSlots;
        }

        @Override
        public Option<FiniteDuration> nextPoll() {
            return new Some((Object)this.blended$streams$file$FileAckSource$FileSourceLogic$$$outer().blended$streams$file$FileAckSource$$pollCfg.interval());
        }

        @Override
        public Try<Option<FileAckContext>> doPerformPoll(String id, AcknowledgeHandler ackHandler) {
            Success success;
            if (this.locked()) {
                success = new Success((Object)None$.MODULE$);
            } else {
                Success success2;
                Option<File> option = FileAckSource$.MODULE$.nextFile(this.blended$streams$file$FileAckSource$FileSourceLogic$$$outer().blended$streams$file$FileAckSource$$pollCfg);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    File f = (File)some.value();
                    success2 = new Success(this.createEnvelope$1(f, ackHandler, id).get());
                } else if (None$.MODULE$.equals(option)) {
                    success2 = new Success((Object)None$.MODULE$);
                } else {
                    throw new MatchError(option);
                }
                success = success2;
            }
            return success;
        }

        private boolean locked() {
            boolean bl;
            Option<String> option = this.blended$streams$file$FileAckSource$FileSourceLogic$$$outer().blended$streams$file$FileAckSource$$pollCfg.lock();
            if (None$.MODULE$.equals(option)) {
                bl = false;
            } else if (option instanceof Some) {
                boolean bl2;
                File f;
                Some some = (Some)option;
                String l = (String)some.value();
                File file = f = l.startsWith("./") ? new File(this.blended$streams$file$FileAckSource$FileSourceLogic$$$outer().blended$streams$file$FileAckSource$$pollCfg.sourceDir(), l.substring(2)) : new File(l);
                if (f.exists()) {
                    this.log().underlying().debug((Function0 & Serializable)() -> new StringBuilder(39).append("Directory for [").append($this.blended$streams$file$FileAckSource$FileSourceLogic$$$outer().blended$streams$file$FileAckSource$$pollCfg.id()).append("] is locked with file [").append(f.getAbsolutePath()).append("]").toString());
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                bl = bl2;
            } else {
                throw new MatchError(option);
            }
            return bl;
        }

        public /* synthetic */ FileAckSource blended$streams$file$FileAckSource$FileSourceLogic$$$outer() {
            return FileAckSource.this;
        }

        public static final /* synthetic */ String $anonfun$inflightSlots$1(FileSourceLogic $this, int i) {
            return new StringBuilder(12).append("FilePoller-").append($this.blended$streams$file$FileAckSource$FileSourceLogic$$$outer().blended$streams$file$FileAckSource$$pollCfg.id()).append("-").append(i).toString();
        }

        private final Try createEnvelope$1(File f, AcknowledgeHandler ackHandler$1, String id$1) {
            return Try$.MODULE$.apply((Function0 & Serializable)() -> {
                None$ none$;
                if (f.exists()) {
                    String uuid = new StringBuilder(1).append(UUID.randomUUID().toString()).append("-").append(f.getName()).toString();
                    File fileToProcess = new File(new StringBuilder(0).append(f.getPath()).append($this.blended$streams$file$FileAckSource$FileSourceLogic$$$outer().blended$streams$file$FileAckSource$$pollCfg.tmpExt()).toString());
                    if (FileHelper.renameFile((File)f, (File)fileToProcess, (Boolean)Predef$.MODULE$.boolean2Boolean(false))) {
                        FlowMessage flowMessage;
                        byte[] bytes = FileHelper.readFile((String)fileToProcess.getAbsolutePath());
                        if ($this.blended$streams$file$FileAckSource$FileSourceLogic$$$outer().blended$streams$file$FileAckSource$$pollCfg.asText()) {
                            Charset charset;
                            Option<String> option = $this.blended$streams$file$FileAckSource$FileSourceLogic$$$outer().blended$streams$file$FileAckSource$$pollCfg.charSet();
                            if (None$.MODULE$.equals(option)) {
                                charset = Charset.defaultCharset();
                            } else if (option instanceof Some) {
                                Some some = (Some)option;
                                String s = (String)some.value();
                                charset = Charset.forName(s);
                            } else {
                                throw new MatchError(option);
                            }
                            Charset charSet = charset;
                            flowMessage = FlowMessage$.MODULE$.apply(new String(bytes, charSet), $this.blended$streams$file$FileAckSource$FileSourceLogic$$$outer().blended$streams$file$FileAckSource$$pollCfg.header());
                        } else {
                            flowMessage = FlowMessage$.MODULE$.apply(bytes, $this.blended$streams$file$FileAckSource$FileSourceLogic$$$outer().blended$streams$file$FileAckSource$$pollCfg.header());
                        }
                        FlowMessage msg = flowMessage;
                        FlowEnvelope qual$1 = FlowEnvelope$.MODULE$.apply(msg, uuid);
                        String x$1 = $this.blended$streams$file$FileAckSource$FileSourceLogic$$$outer().blended$streams$file$FileAckSource$$pollCfg.filenameProp();
                        String x$2 = f.getName();
                        boolean x$3 = qual$1.withHeader$default$3();
                        FlowEnvelope qual$2 = (FlowEnvelope)qual$1.withHeader(x$1, x$2, x$3).get();
                        String x$4 = $this.blended$streams$file$FileAckSource$FileSourceLogic$$$outer().blended$streams$file$FileAckSource$$pollCfg.filepathProp();
                        String x$5 = f.getAbsolutePath();
                        boolean x$6 = qual$2.withHeader$default$3();
                        FlowEnvelope env = ((FlowEnvelope)qual$2.withHeader(x$4, x$5, x$6).get()).withRequiresAcknowledge(true).withAckHandler((Option<AcknowledgeHandler>)new Some((Object)ackHandler$1));
                        FlowEnvelopeLogger qual$3 = this.log();
                        FlowEnvelope x$7 = env;
                        Enumeration.Value x$8 = LogLevel$.MODULE$.Info();
                        Function0 & Serializable x$9 = (Function0 & Serializable)() -> new StringBuilder(26).append("Created Envelope [").append(env).append("] in [").append(id$1).append("]]").toString();
                        boolean x$10 = qual$3.logEnv$default$4();
                        qual$3.logEnv(x$7, x$8, (Function0<String>)x$9, x$10);
                        none$ = new Some((Object)new FileAckContext(this.blended$streams$file$FileAckSource$FileSourceLogic$$$outer(), id$1, env, f, fileToProcess));
                    } else {
                        none$ = None$.MODULE$;
                    }
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            });
        }

        public FileSourceLogic() {
            if (FileAckSource.this == null) {
                throw null;
            }
            super((Shape)FileAckSource.this.shape(), FileAckSource.this.blended$streams$file$FileAckSource$$out(), FileAckSource.this.blended$streams$file$FileAckSource$$pollCfg.ackTimeout());
            this.id = FileAckSource.this.blended$streams$file$FileAckSource$$pollId();
            this.log().underlying().debug((Function0 & Serializable)() -> new StringBuilder(56).append("Initializing FileAckSource with config [").append($this.blended$streams$file$FileAckSource$FileSourceLogic$$$outer().blended$streams$file$FileAckSource$$pollCfg).append("], ackTimeout [").append(this.ackTimeout()).append("]").toString());
            this.inflightSlots = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), FileAckSource.this.blended$streams$file$FileAckSource$$pollCfg.batchSize()).map((Function1 & Serializable)i -> FileSourceLogic.$anonfun$inflightSlots$1(this, BoxesRunTime.unboxToInt((Object)i))).toList();
        }
    }
}

