/*
 * Decompiled with CFR 0.152.
 */
package blended.streams;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.stream.FanOutShape2;
import akka.stream.FlowShape;
import akka.stream.Graph;
import akka.stream.UniformFanOutShape;
import akka.stream.scaladsl.Broadcast$;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.GraphDSL;
import akka.stream.scaladsl.GraphDSL$;
import blended.jmx.statistics.ServiceInvocationReporter$;
import blended.streams.FlowHeaderConfig;
import blended.streams.message.FlowEnvelope;
import blended.streams.message.FlowEnvelopeLogger;
import blended.util.RichTry$;
import blended.util.logging.LogLevel$;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class FlowProcessor$ {
    public static final FlowProcessor$ MODULE$ = new FlowProcessor$();

    public <T> Graph<FlowShape<FlowEnvelope, Either<FlowEnvelope, T>>, NotUsed> transform(String name, FlowEnvelopeLogger log, Function1<FlowEnvelope, Try<T>> f, ClassTag<T> clazz) {
        return Flow$.MODULE$.fromFunction((Function1 & Serializable)env -> {
            Left left;
            Option<Throwable> option = env.exception();
            if (None$.MODULE$.equals(option)) {
                Right right;
                log.logEnv((FlowEnvelope)env, LogLevel$.MODULE$.Debug(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("Starting function [").append(env.id()).append("]:[").append(name).append("]").toString(), log.logEnv$default$4());
                long start = System.currentTimeMillis();
                Try try_ = (Try)f.apply(env);
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Object s = success.value();
                    log.logEnv((FlowEnvelope)env, LogLevel$.MODULE$.Debug(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Function [").append(env.id()).append("]:[").append(name).append("] completed in [").append(System.currentTimeMillis() - start).append("]ms").toString(), log.logEnv$default$4());
                    right = package$.MODULE$.Right().apply(s);
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable t = failure.exception();
                    log.logEnv(env.withException(t), LogLevel$.MODULE$.Warn(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Failed to create [").append(clazz.runtimeClass().getName()).append("] in [").append(env.id()).append("]:[").append(name).append("]").toString(), log.logEnv$default$4());
                    right = package$.MODULE$.Left().apply((Object)env.withException(t));
                } else {
                    throw new MatchError((Object)try_);
                }
                left = right;
            } else if (option instanceof Some) {
                log.logEnv((FlowEnvelope)env, LogLevel$.MODULE$.Debug(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Not executing function [").append(env.id()).append("]:[").append(name).append("] as envelope has exception [").append(env.exception().map((Function1 & Serializable)x$1 -> x$1.getMessage()).getOrElse((Function0 & Serializable)() -> "")).append("].").toString(), log.logEnv$default$4());
                left = package$.MODULE$.Left().apply(env);
            } else {
                throw new MatchError(option);
            }
            return left;
        }).named(name);
    }

    public Graph<FlowShape<FlowEnvelope, FlowEnvelope>, NotUsed> fromFunction(String name, FlowEnvelopeLogger log, Function1<FlowEnvelope, Try<FlowEnvelope>> f) {
        return Flow$.MODULE$.fromFunction((Function1 & Serializable)env -> {
            FlowEnvelope flowEnvelope;
            Option<Throwable> option = env.exception();
            if (None$.MODULE$.equals(option)) {
                FlowEnvelope result;
                FlowEnvelope flowEnvelope2;
                log.logEnv((FlowEnvelope)env, LogLevel$.MODULE$.Debug(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Starting Integration step [").append(env.id()).append("]:[").append(name).append("]").toString(), log.logEnv$default$4());
                long start = System.currentTimeMillis();
                Try try_ = (Try)f.apply(env);
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    FlowEnvelope s = (FlowEnvelope)success.value();
                    log.logEnv((FlowEnvelope)env, LogLevel$.MODULE$.Debug(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Integration step [").append(env.id()).append("]:[").append(name).append("] completed in [").append(System.currentTimeMillis() - start).append("]ms").toString(), log.logEnv$default$4());
                    flowEnvelope2 = s;
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable t = failure.exception();
                    log.logEnv(env.withException(t), LogLevel$.MODULE$.Debug(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Exception in FlowProcessor [").append(env.id()).append("]:[").append(name).append("] for message [").append(env.flowMessage()).append("] : [").append(t.getClass().getSimpleName()).append(" - ").append(t.getMessage()).append("]").toString(), false);
                    flowEnvelope2 = env.withException(t);
                } else {
                    throw new MatchError((Object)try_);
                }
                flowEnvelope = result = flowEnvelope2;
            } else if (option instanceof Some) {
                log.logEnv((FlowEnvelope)env, LogLevel$.MODULE$.Debug(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Skipping integration step [").append(env.id()).append("]:[").append(name).append("] due to exception caught in flow.").toString(), log.logEnv$default$4());
                flowEnvelope = env;
            } else {
                throw new MatchError(option);
            }
            return flowEnvelope;
        }).named(name);
    }

    public Graph<FlowShape<FlowEnvelope, FlowEnvelope>, NotUsed> log(Enumeration.Value level, FlowEnvelopeLogger logger, String text) {
        return Flow$.MODULE$.fromFunction((Function1 & Serializable)env -> {
            logger.logEnv((FlowEnvelope)env, level, (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(3).append(text).append(" : ").append(env).toString(), false);
            return env;
        });
    }

    public String log$default$3() {
        return "";
    }

    public <L, R> Graph<FanOutShape2<Either<L, R>, L, R>, NotUsed> splitEither() {
        return GraphDSL$.MODULE$.create((Function1 & Serializable)b -> {
            UniformFanOutShape branches = (UniformFanOutShape)b.add((Graph)Broadcast$.MODULE$.apply(2, Broadcast$.MODULE$.apply$default$2()));
            FlowShape isLeft = (FlowShape)b.add((Graph)Flow$.MODULE$.apply().collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Either<L, R>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof Left) {
                        Object l;
                        Left left = (Left)A1;
                        object = l = left.value();
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Either<L, R> x1) {
                    Either<L, R> either = x1;
                    boolean bl = either instanceof Left;
                    return bl;
                }
            }));
            FlowShape isRight = (FlowShape)b.add((Graph)Flow$.MODULE$.apply().collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Either<L, R>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof Right) {
                        Object r;
                        Right right = (Right)A1;
                        object = r = right.value();
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Either<L, R> x2) {
                    Either<L, R> either = x2;
                    boolean bl = either instanceof Right;
                    return bl;
                }
            }));
            GraphDSL.Implicits$.MODULE$.fanOut2flow(branches, b).$tilde$greater(isLeft, b);
            GraphDSL.Implicits$.MODULE$.fanOut2flow(branches, b).$tilde$greater(isRight, b);
            return new FanOutShape2(branches.in(), isLeft.out(), isRight.out());
        });
    }

    public <T> Graph<FanOutShape2<T, T, T>, NotUsed> partition(Function1<T, Object> p) {
        return GraphDSL$.MODULE$.create((Function1 & Serializable)b -> {
            UniformFanOutShape branches = (UniformFanOutShape)b.add((Graph)Broadcast$.MODULE$.apply(2, Broadcast$.MODULE$.apply$default$2()));
            FlowShape isTrue = (FlowShape)b.add((Graph)Flow$.MODULE$.apply().filter(p));
            FlowShape isFalse = (FlowShape)b.add((Graph)Flow$.MODULE$.apply().filterNot(p));
            GraphDSL.Implicits$.MODULE$.fanOut2flow(branches, b).$tilde$greater(isTrue, b);
            GraphDSL.Implicits$.MODULE$.fanOut2flow(branches, b).$tilde$greater(isFalse, b);
            return new FanOutShape2(branches.in(), isTrue.out(), isFalse.out());
        });
    }

    public Graph<FlowShape<FlowEnvelope, FlowEnvelope>, NotUsed> startStats(String name, FlowEnvelopeLogger log, String component, Map<String, String> subComp, FlowHeaderConfig headerCfg, ActorSystem system) {
        return this.fromFunction(name, log, (Function1<FlowEnvelope, Try<FlowEnvelope>>)(Function1 & Serializable)env -> Try$.MODULE$.apply((Function0 & Serializable)() -> {
            String id = ServiceInvocationReporter$.MODULE$.invoked(component, subComp, system);
            return (FlowEnvelope)RichTry$.MODULE$.toRichTry(env.withHeader(headerCfg.headerStatsId(), id, env.withHeader$default$3())).unwrap();
        }));
    }

    public Graph<FlowShape<FlowEnvelope, FlowEnvelope>, NotUsed> completeStats(String name, FlowEnvelopeLogger log, FlowHeaderConfig headerCfg, ActorSystem system) {
        return this.fromFunction(name, log, (Function1<FlowEnvelope, Try<FlowEnvelope>>)(Function1 & Serializable)env -> Try$.MODULE$.apply((Function0 & Serializable)() -> {
            env.header(headerCfg.headerStatsId(), ManifestFactory$.MODULE$.classType(String.class)).foreach((Function1 & Serializable)h -> {
                FlowProcessor$.$anonfun$completeStats$3(env, system, h);
                return BoxedUnit.UNIT;
            });
            return env;
        }));
    }

    public static final /* synthetic */ void $anonfun$completeStats$3(FlowEnvelope env$5, ActorSystem system$2, String h) {
        if (env$5.exception().isEmpty()) {
            ServiceInvocationReporter$.MODULE$.completed(h, system$2);
        } else {
            ServiceInvocationReporter$.MODULE$.failed(h, system$2);
        }
    }

    private FlowProcessor$() {
    }
}

