/*
 * Decompiled with CFR 0.152.
 */
package blended.jms.utils.internal;

import akka.actor.ActorRef;
import blended.jms.utils.ConnectionCommand;
import blended.jms.utils.ConnectionCommand$;
import blended.jms.utils.ConnectionState;
import blended.jms.utils.ConnectionState$;
import blended.jms.utils.Disconnected$;
import blended.jms.utils.internal.ConnectionMonitorMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\ra\u0001\u0002\r\u001a\u0001\tB\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ts\u0001\u0011\t\u0011)A\u0005]!A!\b\u0001B\u0001B\u0003%a\u0006C\u0003<\u0001\u0011\u0005A\b\u0003\u0004B\u0001\u0001\u0006IA\u0011\u0005\u0007\u0015\u0002\u0001\u000b\u0015B&\t\r=\u0003\u0001\u0015)\u0003Q\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015)\u0006\u0001\"\u0011U\u0011\u00151\u0006\u0001\"\u0011U\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u0015!\u0007\u0001\"\u0011U\u0011\u0015)\u0007\u0001\"\u0011U\u0011\u00151\u0007\u0001\"\u0011U\u0011\u00159\u0007\u0001\"\u0011i\u0011\u0015a\u0007\u0001\"\u0011i\u0011\u0015i\u0007\u0001\"\u0011o\u0011\u0015\t\b\u0001\"\u0011s\u0011\u00151\b\u0001\"\u0011x\u0011\u0015Q\b\u0001\"\u0011|\u0005E\u0019uN\u001c8fGRLwN\\'p]&$xN\u001d\u0006\u00035m\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u00039u\tQ!\u001e;jYNT!AH\u0010\u0002\u0007)l7OC\u0001!\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\u0001aE\u0002\u0001G%\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0007C\u0001\u0016,\u001b\u0005I\u0012B\u0001\u0017\u001a\u0005]\u0019uN\u001c8fGRLwN\\'p]&$xN]'Y\u0005\u0016\fg.\u0001\u0004wK:$wN\u001d\t\u0003_Yr!\u0001\r\u001b\u0011\u0005E*S\"\u0001\u001a\u000b\u0005M\n\u0013A\u0002\u001fs_>$h(\u0003\u00026K\u00051\u0001K]3eK\u001aL!a\u000e\u001d\u0003\rM#(/\u001b8h\u0015\t)T%\u0001\u0005qe>4\u0018\u000eZ3s\u0003!\u0019G.[3oi&#\u0017A\u0002\u001fj]&$h\b\u0006\u0003>}}\u0002\u0005C\u0001\u0016\u0001\u0011\u0015iC\u00011\u0001/\u0011\u0015ID\u00011\u0001/\u0011\u0015QD\u00011\u0001/\u0003\t!g\r\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006!A/\u001a=u\u0015\u00059\u0015\u0001\u00026bm\u0006L!!\u0013#\u0003!MKW\u000e\u001d7f\t\u0006$XMR8s[\u0006$\u0018!B:uCR,\u0007C\u0001'N\u001b\u0005Y\u0012B\u0001(\u001c\u0005=\u0019uN\u001c8fGRLwN\\*uCR,\u0017aA2nIB\u0011A*U\u0005\u0003%n\u0011\u0011cQ8o]\u0016\u001cG/[8o\u0007>lW.\u00198e\u0003%9W\r\u001e,f]\u0012|'\u000fF\u0001/\u0003-9W\r\u001e)s_ZLG-\u001a:\u0002\u0017\u001d,Go\u00117jK:$\u0018\nZ\u0001\u000bO\u0016$8i\\7nC:$G#\u0001)\u0002\u0019I,7/\u001a;D_6l\u0017M\u001c3\u0015\u0003m\u0003\"\u0001\n/\n\u0005u+#\u0001B+oSR\f\u0001b]3u'R\fG/\u001a\u000b\u00037\u0002DQ!Y\u0007A\u0002-\u000b\u0001B\\3x'R\fG/Z\u0001\tO\u0016$8\u000b^1uKR\t1*A\u0005hKR\u001cF/\u0019;vg\u0006qq-\u001a;MCN$8i\u001c8oK\u000e$\u0018!E4fi2\u000b7\u000f\u001e#jg\u000e|gN\\3di\u0006\u0019r-\u001a;NSN\u001cX\rZ&fKB\fE.\u001b<fgR\t\u0011\u000e\u0005\u0002%U&\u00111.\n\u0002\u0004\u0013:$\u0018\u0001D4fi6\u000b\u00070\u0012<f]R\u001c\u0018\u0001D:fi6\u000b\u00070\u0012<f]R\u001cHCA.p\u0011\u0015\u0001H\u00031\u0001j\u0003\u0005q\u0017!C4fi\u00163XM\u001c;t)\u0005\u0019\bc\u0001\u0013u]%\u0011Q/\n\u0002\u0006\u0003J\u0014\u0018-_\u0001\u000bI&\u001c8m\u001c8oK\u000e$HCA.y\u0011\u0015Ih\u00031\u0001/\u0003\u0019\u0011X-Y:p]\u000691m\u001c8oK\u000e$HCA.}\u0011\u0015ix\u00031\u0001\u007f\u0003\rqwn\u001e\t\u0003I}L1!!\u0001&\u0005\u001d\u0011un\u001c7fC:\u0004")
public class ConnectionMonitor
implements ConnectionMonitorMXBean {
    private final String vendor;
    private final String provider;
    private final String clientId;
    private final SimpleDateFormat df;
    private ConnectionState state;
    private ConnectionCommand cmd;

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public ConnectionCommand getCommand() {
        return this.cmd;
    }

    public void resetCommand() {
        this.cmd = new ConnectionCommand(this.vendor, this.provider, ConnectionCommand$.MODULE$.apply$default$3(), ConnectionCommand$.MODULE$.apply$default$4(), ConnectionCommand$.MODULE$.apply$default$5(), ConnectionCommand$.MODULE$.apply$default$6());
    }

    public void setState(ConnectionState newState) {
        this.state = newState;
    }

    public ConnectionState getState() {
        return this.state;
    }

    @Override
    public String getStatus() {
        return this.state.status().toString().toLowerCase();
    }

    @Override
    public String getLastConnect() {
        String string;
        Option<Date> option = this.state.lastConnect();
        if (None$.MODULE$.equals(option)) {
            string = "n/a";
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Date d = (Date)some.value();
            string = this.df.format(d);
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    @Override
    public String getLastDisconnect() {
        String string;
        Option<Date> option = this.state.lastDisconnect();
        if (None$.MODULE$.equals(option)) {
            string = "n/a";
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Date d = (Date)some.value();
            string = this.df.format(d);
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    @Override
    public int getMissedKeepAlives() {
        return this.state.missedKeepAlives();
    }

    @Override
    public int getMaxEvents() {
        return this.state.maxEvents();
    }

    @Override
    public void setMaxEvents(int n) {
        ConnectionCommand qual$1 = this.cmd;
        int x$1 = n;
        String x$2 = qual$1.copy$default$1();
        String x$3 = qual$1.copy$default$2();
        boolean x$4 = qual$1.copy$default$4();
        boolean x$5 = qual$1.copy$default$5();
        boolean x$6 = qual$1.copy$default$6();
        this.cmd = qual$1.copy(x$2, x$3, x$1, x$4, x$5, x$6);
    }

    @Override
    public String[] getEvents() {
        return (String[])this.state.events().toArray(ClassTag$.MODULE$.apply(String.class));
    }

    @Override
    public void disconnect(String reason) {
        ConnectionCommand qual$1 = this.cmd;
        boolean x$1 = true;
        String x$2 = qual$1.copy$default$1();
        String x$3 = qual$1.copy$default$2();
        int x$4 = qual$1.copy$default$3();
        boolean x$5 = qual$1.copy$default$5();
        boolean x$6 = qual$1.copy$default$6();
        this.cmd = qual$1.copy(x$2, x$3, x$4, true, x$5, x$6);
    }

    @Override
    public void connect(boolean now) {
        ConnectionCommand qual$1 = this.cmd;
        boolean x$1 = true;
        boolean x$2 = now;
        String x$3 = qual$1.copy$default$1();
        String x$4 = qual$1.copy$default$2();
        int x$5 = qual$1.copy$default$3();
        boolean x$6 = qual$1.copy$default$4();
        this.cmd = qual$1.copy(x$3, x$4, x$5, x$6, true, x$2);
    }

    public ConnectionMonitor(String vendor, String provider, String clientId) {
        this.vendor = vendor;
        this.provider = provider;
        this.clientId = clientId;
        this.df = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss:SSS");
        ConnectionState qual$1 = new ConnectionState(vendor, provider, ConnectionState$.MODULE$.apply$default$3(), ConnectionState$.MODULE$.apply$default$4(), ConnectionState$.MODULE$.apply$default$5(), ConnectionState$.MODULE$.apply$default$6(), ConnectionState$.MODULE$.apply$default$7(), ConnectionState$.MODULE$.apply$default$8(), ConnectionState$.MODULE$.apply$default$9(), ConnectionState$.MODULE$.apply$default$10(), ConnectionState$.MODULE$.apply$default$11());
        Disconnected$ x$1 = Disconnected$.MODULE$;
        String x$2 = qual$1.copy$default$1();
        String x$3 = qual$1.copy$default$2();
        Option<Date> x$4 = qual$1.copy$default$4();
        Option<Date> x$5 = qual$1.copy$default$5();
        int x$6 = qual$1.copy$default$6();
        int x$7 = qual$1.copy$default$7();
        List<String> x$8 = qual$1.copy$default$8();
        Option<Date> x$9 = qual$1.copy$default$9();
        Option<Date> x$10 = qual$1.copy$default$10();
        Option<ActorRef> x$11 = qual$1.copy$default$11();
        this.state = qual$1.copy(x$2, x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11);
        this.cmd = new ConnectionCommand(vendor, provider, ConnectionCommand$.MODULE$.apply$default$3(), ConnectionCommand$.MODULE$.apply$default$4(), ConnectionCommand$.MODULE$.apply$default$5(), ConnectionCommand$.MODULE$.apply$default$6());
    }
}

