/*
 * Decompiled with CFR 0.152.
 */
package blended.jms.utils;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import blended.jms.utils.BlendedJMSConnection;
import blended.jms.utils.CheckConnection;
import blended.jms.utils.ConnectionConfig;
import blended.jms.utils.IdAwareConnectionFactory;
import blended.jms.utils.ProviderAware;
import blended.jms.utils.internal.ConnectionHolder;
import blended.jms.utils.internal.ConnectionMonitor;
import blended.jms.utils.internal.ConnectionStateManager$;
import blended.jms.utils.internal.ConnectionStateMonitor$;
import blended.jms.utils.internal.JndiConnectionHolder;
import blended.jms.utils.internal.ReflectionConfigHolder;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005-d\u0001\u0002\f\u0018\u0001yA\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\ta\u0001\u0011\t\u0011)A\u0005[!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u0005C\u0001\t\u0005\t\u0015a\u0003D\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u001d\u0011\u0006A1A\u0005BMCaa\u0018\u0001!\u0002\u0013!\u0006b\u00021\u0001\u0005\u0004%\te\u0015\u0005\u0007C\u0002\u0001\u000b\u0011\u0002+\t\r\t\u0004\u0001\u0015!\u0003d\u0011\u0019Y\u0007\u0001)A\u0005)\"1A\u000e\u0001Q\u0001\nQCq!\u001c\u0001C\u0002\u0013\u00053\u000b\u0003\u0004o\u0001\u0001\u0006I\u0001\u0016\u0005\u0006_\u0002!\t\u0002\u001d\u0005\bs\u0002\u0011\r\u0011\"\u0003{\u0011\u0019Y\b\u0001)A\u0005c\"AA\u0010\u0001ECB\u0013%Q\u0010\u0003\u0005\u0002\u0004\u0001\u0001\u000b\u0011BA\u0003\u0011\u001d\ti\u0001\u0001C!\u0003\u001fAq!!\u0004\u0001\t\u0003\n\tG\u0001\u0010CY\u0016tG-\u001a3TS:<G.Z\"p]:,7\r^5p]\u001a\u000b7\r^8ss*\u0011\u0001$G\u0001\u0006kRLGn\u001d\u0006\u00035m\t1A[7t\u0015\u0005a\u0012a\u00022mK:$W\rZ\u0002\u0001'\r\u0001qd\n\t\u0003A\u0015j\u0011!\t\u0006\u0003E\r\nA\u0001\\1oO*\tA%\u0001\u0003kCZ\f\u0017B\u0001\u0014\"\u0005\u0019y%M[3diB\u0011\u0001&K\u0007\u0002/%\u0011!f\u0006\u0002\u0019\u0013\u0012\fu/\u0019:f\u0007>tg.Z2uS>tg)Y2u_JL\u0018AB2p]\u001aLw-F\u0001.!\tAc&\u0003\u00020/\t\u00012i\u001c8oK\u000e$\u0018n\u001c8D_:4\u0017nZ\u0001\bG>tg-[4!\u00035\u0011WO\u001c3mK\u000e{g\u000e^3yiB\u00191G\u000e\u001d\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012aa\u00149uS>t\u0007CA\u001dA\u001b\u0005Q$BA\u001e=\u0003%1'/Y7fo>\u00148N\u0003\u0002>}\u0005!qn]4j\u0015\u0005y\u0014aA8sO&\u0011\u0011I\u000f\u0002\u000e\u0005VtG\r\\3D_:$X\r\u001f;\u0002\rML8\u000f^3n!\t!\u0015*D\u0001F\u0015\t1u)A\u0003bGR|'OC\u0001I\u0003\u0011\t7n[1\n\u0005)+%aC!di>\u00148+_:uK6\fa\u0001P5oSRtDcA'Q#R\u0011aj\u0014\t\u0003Q\u0001AQAQ\u0003A\u0004\rCQaK\u0003A\u00025BQ!M\u0003A\u0002I\naA^3oI>\u0014X#\u0001+\u0011\u0005UcfB\u0001,[!\t9F'D\u0001Y\u0015\tIV$\u0001\u0004=e>|GOP\u0005\u00037R\na\u0001\u0015:fI\u00164\u0017BA/_\u0005\u0019\u0019FO]5oO*\u00111\fN\u0001\bm\u0016tGm\u001c:!\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018!\u00039s_ZLG-\u001a:!\u0003\rawn\u001a\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\fq\u0001\\8hO&twM\u0003\u0002i7\u0005!Q\u000f^5m\u0013\tQWM\u0001\u0004M_\u001e<WM]\u0001\f[>t\u0017\u000e^8s\u001d\u0006lW-\u0001\u0007ti\u0006$X-T4s\u001d\u0006lW-\u0001\u0005dY&,g\u000e^%e\u0003%\u0019G.[3oi&#\u0007%\u0001\u0007de\u0016\fG/\u001a%pY\u0012,'\u000f\u0006\u0002roB\u0011!/^\u0007\u0002g*\u0011AoF\u0001\tS:$XM\u001d8bY&\u0011ao\u001d\u0002\u0011\u0007>tg.Z2uS>t\u0007j\u001c7eKJDQ\u0001_\bA\u00025\n1a\u00194h\u0003\u0019Aw\u000e\u001c3feV\t\u0011/A\u0004i_2$WM\u001d\u0011\u0002\u0013\r4WI\\1cY\u0016$W#\u0001@\u0011\u0005Mz\u0018bAA\u0001i\t9!i\\8mK\u0006t\u0017\u0001C:uCR,Wj\u001a:\u0011\tM2\u0014q\u0001\t\u0004\t\u0006%\u0011bAA\u0006\u000b\nA\u0011i\u0019;peJ+g-\u0001\tde\u0016\fG/Z\"p]:,7\r^5p]R\u0011\u0011\u0011\u0003\t\u0005\u0003'\tY\"\u0004\u0002\u0002\u0016)\u0019!$a\u0006\u000b\u0005\u0005e\u0011!\u00026bm\u0006D\u0018\u0002BA\u000f\u0003+\u0011!bQ8o]\u0016\u001cG/[8oQ\u0015!\u0012\u0011EA\u0017!\u0015\u0019\u00141EA\u0014\u0013\r\t)\u0003\u000e\u0002\u0007i\"\u0014xn^:\u0011\t\u0005M\u0011\u0011F\u0005\u0005\u0003W\t)B\u0001\u0007K\u001bN+\u0005pY3qi&|g.\r\u0004\u001f)\u0006=\u0012qL\u0019\nG\u0005E\u0012qGA+\u0003s)2aUA\u001a\t\u001d\t)$\bb\u0001\u0003\u007f\u0011\u0011\u0001V\u0005\u0005\u0003s\tY$A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0003{!\u0014A\u0002;ie><8/\u0005\u0003\u0002B\u0005\u001d\u0003cA\u001a\u0002D%\u0019\u0011Q\t\u001b\u0003\u000f9{G\u000f[5oOB!\u0011\u0011JA(\u001d\r\u0019\u00141J\u0005\u0004\u0003\u001b\"\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003#\n\u0019FA\u0005UQJ|w/\u00192mK*\u0019\u0011Q\n\u001b2\u0013\r\n9&!\u0017\u0002\\\u0005ubbA\u001a\u0002Z%\u0019\u0011Q\b\u001b2\u000b\t\u001aD'!\u0018\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\n9\u0003\u0006\u0004\u0002\u0012\u0005\r\u0014q\r\u0005\u0007\u0003K*\u0002\u0019\u0001+\u0002\tU\u001cXM\u001d\u0005\u0007\u0003S*\u0002\u0019\u0001+\u0002\u0011A\f7o]<pe\u0012\u0004")
public class BlendedSingleConnectionFactory
implements IdAwareConnectionFactory {
    private boolean cfEnabled;
    private final ConnectionConfig config;
    private final ActorSystem system;
    private final String vendor;
    private final String provider;
    private final Logger log;
    private final String monitorName;
    private final String stateMgrName;
    private final String clientId;
    private final ConnectionHolder holder;
    private final Option<ActorRef> stateMgr;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ String blended$jms$utils$IdAwareConnectionFactory$$super$id() {
        return ProviderAware.id$(this);
    }

    @Override
    public String id() {
        return IdAwareConnectionFactory.id$(this);
    }

    public ConnectionConfig config() {
        return this.config;
    }

    @Override
    public String vendor() {
        return this.vendor;
    }

    @Override
    public String provider() {
        return this.provider;
    }

    @Override
    public String clientId() {
        return this.clientId;
    }

    public ConnectionHolder createHolder(ConnectionConfig cfg) {
        return this.config().useJndi() ? new JndiConnectionHolder(cfg, this.system) : new ReflectionConfigHolder(cfg, this.system);
    }

    private ConnectionHolder holder() {
        return this.holder;
    }

    private boolean cfEnabled$lzycompute() {
        BlendedSingleConnectionFactory blendedSingleConnectionFactory = this;
        synchronized (blendedSingleConnectionFactory) {
            if (!this.bitmap$0) {
                this.cfEnabled = this.config().enabled() && this.config().cfEnabled().forall((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)BlendedSingleConnectionFactory.$anonfun$cfEnabled$1(this, f)));
                this.bitmap$0 = true;
            }
        }
        return this.cfEnabled;
    }

    private boolean cfEnabled() {
        return !this.bitmap$0 ? this.cfEnabled$lzycompute() : this.cfEnabled;
    }

    public Connection createConnection() throws JMSException {
        BlendedJMSConnection blendedJMSConnection;
        if (this.cfEnabled()) {
            try {
                BlendedJMSConnection c;
                Option<BlendedJMSConnection> option = this.holder().getConnection();
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw new Exception(new StringBuilder(23).append("Error connecting to [").append(this.id()).append("].").toString());
                    }
                    throw new MatchError(option);
                }
                Some some = (Some)option;
                BlendedJMSConnection blendedJMSConnection2 = c = (BlendedJMSConnection)some.value();
                blendedJMSConnection = blendedJMSConnection2;
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    String msg = new StringBuilder(35).append("Error getting Connection Factory [").append(e.getMessage()).append("]").toString();
                    this.log.error((Function0 & Serializable)() -> msg);
                    JMSException jmsEx = new JMSException(msg);
                    Throwable throwable3 = e;
                    if (throwable3 instanceof Exception) {
                        Exception exception = (Exception)throwable3;
                        jmsEx.setLinkedException(exception);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    throw jmsEx;
                }
                throw throwable;
            }
        } else {
            throw new JMSException(new StringBuilder(39).append("Connection for provider [").append(this.id()).append("] is disabled.").toString());
        }
        return blendedJMSConnection;
    }

    public Connection createConnection(String user, String password) {
        this.log.warn((Function0 & Serializable)() -> new StringBuilder(70).append(new StringBuilder(91).append("BlendedSingleConnectionFactory.createConnection() for [").append(this.id()).append("]called with username and password, ").toString()).append("which is not supported.\nFalling back to default username and password.").toString());
        return this.createConnection();
    }

    public static final /* synthetic */ boolean $anonfun$cfEnabled$1(BlendedSingleConnectionFactory $this, Function1 f) {
        return BoxesRunTime.unboxToBoolean((Object)f.apply((Object)$this.config()));
    }

    private final void liftedTree1$1(MBeanServer jmxServer$1, ObjectName objName$1) {
        try {
            jmxServer$1.unregisterMBean(objName$1);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable t = (Throwable)option.get();
                this.log.warn((Function0 & Serializable)() -> new StringBuilder(32).append("Failed to deregister MBean [").append(objName$1.toString()).append("]:[").append(t.getMessage()).append("]").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private final Object liftedTree2$1(MBeanServer jmxServer$1, ConnectionMonitor jmxBean$1, ObjectName objName$1) {
        ObjectInstance objectInstance;
        try {
            objectInstance = jmxServer$1.registerMBean(jmxBean$1, objName$1);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable t = (Throwable)option.get();
            this.log.warn((Function0 & Serializable)() -> new StringBuilder(30).append("Could not register MBean [").append(objName$1.toString()).append("]:[").append(t.getMessage()).append("]").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            objectInstance = boxedUnit;
        }
        return objectInstance;
    }

    public static final /* synthetic */ void $anonfun$new$1(ActorRef a) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(a);
        CheckConnection x$1 = new CheckConnection(false);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public BlendedSingleConnectionFactory(ConnectionConfig config, Option<BundleContext> bundleContext, ActorSystem system) {
        None$ none$;
        this.config = config;
        this.system = system;
        ProviderAware.$init$(this);
        IdAwareConnectionFactory.$init$(this);
        this.vendor = config.vendor();
        this.provider = config.provider();
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(BlendedSingleConnectionFactory.class));
        this.monitorName = new StringBuilder(9).append("Monitor-").append(this.vendor()).append("-").append(this.provider()).toString();
        this.stateMgrName = new StringBuilder(5).append("JMS-").append(this.vendor()).append("-").append(this.provider()).toString();
        this.clientId = config.clientId();
        this.holder = this.createHolder(config);
        if (this.cfEnabled()) {
            None$ none$2;
            if (config.jmxEnabled()) {
                MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
                ConnectionMonitor jmxBean = new ConnectionMonitor(this.vendor(), this.provider(), this.clientId());
                ObjectName objName = new ObjectName(new StringBuilder(48).append("blended:type=ConnectionMonitor,vendor=").append(this.vendor()).append(",provider=").append(this.provider()).toString());
                if (jmxServer.isRegistered(objName)) {
                    this.liftedTree1$1(jmxServer, objName);
                }
                this.liftedTree2$1(jmxServer, jmxBean, objName);
                none$2 = new Some((Object)jmxBean);
            } else {
                none$2 = None$.MODULE$;
            }
            None$ mbean = none$2;
            system.actorOf(ConnectionStateMonitor$.MODULE$.props(this.vendor(), this.provider(), bundleContext, (Option<ConnectionMonitor>)mbean), this.monitorName);
            this.log.info((Function0 & Serializable)() -> new StringBuilder(36).append("Connection State Monitor [").append($this.stateMgrName).append("] created.").toString());
            none$ = new Some((Object)system.actorOf(ConnectionStateManager$.MODULE$.props(this.holder()), this.stateMgrName));
        } else {
            this.log.info((Function0 & Serializable)() -> new StringBuilder(58).append("Connection State Monitor [").append($this.stateMgrName).append("] is disabled by config setting.").toString());
            none$ = None$.MODULE$;
        }
        this.stateMgr = none$;
        this.stateMgr.foreach((Function1 & Serializable)a -> {
            BlendedSingleConnectionFactory.$anonfun$new$1(a);
            return BoxedUnit.UNIT;
        });
    }
}

