/*
 * Decompiled with CFR 0.152.
 */
package blended.launcher.jvmrunner;

import blended.util.io.StreamCopy$;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import scala.Function0;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005E4Q\u0001E\t\u0001#]A\u0001B\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!AA\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0011\u00151\u0004\u0001\"\u00018\u0011\u0019q\u0004\u0001)A\u0005\u007f!1Q\t\u0001Q\u0001\n\u0019Ca!\u0013\u0001!\u0002\u0013Q\u0005B\u0002*\u0001A\u0003%a\u0006\u0003\u0004T\u0001\u0001\u0006I\u0001\u0016\u0005\u0006/\u0002!\t\u0001\u0017\u0005\u00069\u0002!I!\u0018\u0005\u0006A\u0002!\t\u0001\u0017\u0005\u0006C\u0002!IA\u0019\u0005\u0006Q\u0002!I!\u001b\u0002\u000f%Vtg.\u001b8h!J|7-Z:t\u0015\t\u00112#A\u0005km6\u0014XO\u001c8fe*\u0011A#F\u0001\tY\u0006,hn\u00195fe*\ta#A\u0004cY\u0016tG-\u001a3\u0014\u0005\u0001A\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g-A\u0004qe>\u001cWm]:\u0004\u0001A\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0005Y\u0006twMC\u0001&\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0012#a\u0002)s_\u000e,7o]\u0001\u0011KJ\u0014xN]:J]R|w*\u001e;qkR\u0004\"!\u0007\u0016\n\u0005-R\"a\u0002\"p_2,\u0017M\\\u0001\fS:$XM]1di&4X-A\btQV$Hm\\<o)&lWm\\;u!\tyC'D\u00011\u0015\t\t$'\u0001\u0005ekJ\fG/[8o\u0015\t\u0019$$\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u000e\u0019\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"R\u0001\u000f\u001e<yu\u0002\"!\u000f\u0001\u000e\u0003EAQAH\u0003A\u0002\u0001BQ\u0001K\u0003A\u0002%BQ\u0001L\u0003A\u0002%BQ!L\u0003A\u00029\n!!\u001b8\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t#\u0013AA5p\u0013\t!\u0015IA\u0006J]B,Ho\u0015;sK\u0006l\u0017aA8viB\u0011\u0001iR\u0005\u0003\u0011\u0006\u0013AbT;uaV$8\u000b\u001e:fC6\f1\u0001\\8h!\tY\u0005+D\u0001M\u0015\tie*A\u0004m_\u001e<\u0017N\\4\u000b\u0005=+\u0012\u0001B;uS2L!!\u0015'\u0003\r1{wmZ3s\u00035\u0019H.Z3q\u0013:$XM\u001d<bY\u0006Iq.\u001e;UQJ,\u0017\r\u001a\t\u0003CUK!A\u0016\u0012\u0003\rQC'/Z1e\u0003\u001d9\u0018-\u001b;G_J$\u0012!\u0017\t\u00033iK!a\u0017\u000e\u0003\u0007%sG/\u0001\txC&$XK\u001c;jYN#x\u000e\u001d9fIR\u0011\u0011F\u0018\u0005\u0006?2\u0001\rAL\u0001\u0002i\u0006!1\u000f^8q\u0003=\t7/\u001f8d\u0007>\u0004\u0018\u0010\u00165sK\u0006$G#\u0002+dI\u0016<\u0007\"\u0002 \u000f\u0001\u0004y\u0004\"B#\u000f\u0001\u00041\u0005\"\u00024\u000f\u0001\u0004I\u0013aC5n[\u0016$\u0017.\u0019;fYfDQA\u0015\bA\u00029\nAaY8qsR)!.\u001c8paB\u0011\u0011d[\u0005\u0003Yj\u0011A!\u00168ji\")ah\u0004a\u0001\u007f!)Qi\u0004a\u0001\r\")am\u0004a\u0001S!)!k\u0004a\u0001]\u0001")
public class RunningProcess {
    private final Process process;
    private final boolean interactive;
    private final FiniteDuration shutdownTimeout;
    private final InputStream in;
    private final OutputStream out;
    private final Logger log;
    private final FiniteDuration sleepInterval;
    private final Thread outThread;

    public int waitFor() {
        int n;
        try {
            n = this.process.waitFor();
        }
        finally {
            this.process.getOutputStream().close();
            this.outThread.interrupt();
            this.process.getErrorStream().close();
            this.process.getInputStream().close();
        }
        return n;
    }

    private boolean waitUntilStopped(FiniteDuration t) {
        long now = System.currentTimeMillis();
        long end = now + t.toMillis();
        while (this.process.isAlive() && System.currentTimeMillis() <= end) {
            Thread.sleep(this.sleepInterval.toMillis());
        }
        return this.process.isAlive();
    }

    public int stop() {
        this.log.info((Function0 & Serializable)() -> "Stopping container JVM ...");
        if (this.interactive) {
            this.outThread.interrupt();
        } else {
            this.out.write("stop 0\n".getBytes());
        }
        if (this.waitUntilStopped(this.shutdownTimeout)) {
            this.log.info((Function0 & Serializable)() -> new StringBuilder(58).append("Killing container JVM after maximum shutdown timeout of [").append($this.shutdownTimeout).append("]").toString());
            this.process.destroy();
        }
        this.out.flush();
        this.out.close();
        return this.waitFor();
    }

    private Thread asyncCopyThread(InputStream in, OutputStream out, boolean immediately, FiniteDuration sleepInterval) {
        return new Thread(this, in, out, immediately, sleepInterval){
            private final /* synthetic */ RunningProcess $outer;
            private final InputStream in$1;
            private final OutputStream out$1;
            private final boolean immediately$1;
            private final FiniteDuration sleepInterval$1;

            public void run() {
                try {
                    this.$outer.blended$launcher$jvmrunner$RunningProcess$$copy(this.in$1, this.out$1, this.immediately$1, this.sleepInterval$1);
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.out$1.flush();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.in$1 = in$1;
                this.out$1 = out$1;
                this.immediately$1 = immediately$1;
                this.sleepInterval$1 = sleepInterval$1;
                super("StreamCopyThread");
                this.setDaemon(true);
            }
        };
    }

    public void blended$launcher$jvmrunner$RunningProcess$$copy(InputStream in, OutputStream out, boolean immediately, FiniteDuration sleepInterval) {
        if (immediately) {
            while (true) {
                if (in.available() > 0) {
                    int n = in.read();
                    switch (n) {
                        case -1: {
                            break;
                        }
                        default: {
                            out.write(n);
                            out.flush();
                            break;
                        }
                    }
                    continue;
                }
                Thread.sleep(sleepInterval.toMillis());
            }
        }
        StreamCopy$.MODULE$.copy(in, out);
    }

    public RunningProcess(Process process, boolean errorsIntoOutput, boolean interactive, FiniteDuration shutdownTimeout) {
        this.process = process;
        this.interactive = interactive;
        this.shutdownTimeout = shutdownTimeout;
        this.in = System.in;
        this.out = process.getOutputStream();
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(RunningProcess.class));
        this.sleepInterval = new package.DurationInt(package$.MODULE$.DurationInt(50)).millis();
        this.outThread = this.asyncCopyThread(this.in, this.out, true, this.sleepInterval);
        if (interactive) {
            this.log.info((Function0 & Serializable)() -> "Starting console read thread ...");
            this.outThread.start();
        } else {
            this.log.info((Function0 & Serializable)() -> "Container is started without console read thread ...");
        }
    }
}

