/*
 * Decompiled with CFR 0.152.
 */
package blended.mgmt.rest.internal;

import akka.event.EventStream;
import akka.http.scaladsl.marshalling.Marshaller;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.MediaType;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.headers.HttpChallenge;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.directives.AuthenticationDirective;
import akka.http.scaladsl.unmarshalling.Unmarshaller;
import blended.mgmt.repo.WritableArtifactRepo;
import blended.mgmt.rest.internal.CollectorService;
import blended.mgmt.rest.internal.RemoteContainerStatePersistor;
import blended.prickle.akka.http.PrickleSupport;
import blended.security.BlendedPermission;
import blended.security.BlendedPermissionManager;
import blended.security.akka.http.BlendedSecurityDirectives;
import blended.security.akka.http.JAASSecurityDirectives;
import blended.updater.config.ContainerInfo;
import blended.updater.config.ContainerRegistryResponseOK;
import blended.updater.config.RemoteContainerState;
import blended.updater.config.UpdateContainerInfo;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import javax.security.auth.Subject;
import microjson.JsValue;
import prickle.PConfig;
import prickle.Pickler;
import prickle.Unpickler;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005}b\u0001\u0002\t\u0012\u0001iA\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\tw\u0001\u0011)\u0019!C!y!A\u0011\t\u0001B\u0001B\u0003%Q\b\u0003\u0005C\u0001\t\u0015\r\u0011\"\u0011D\u0011!y\u0005A!A!\u0002\u0013!\u0005\"\u0002)\u0001\t\u0003\t\u0006\u0002\u0003,\u0001\u0011\u000b\u0007K\u0011B,\t\u000b\u0001\u0004A\u0011I1\t\r\t\u0004\u0001\u0015)\u0003d\u0011\u0019i\u0007\u0001)Q\u0005]\")q\u000f\u0001C\u0001q\")Q\u0010\u0001C\u0001}\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0001bBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003K\u0001A\u0011IA\u0014\u0005Q\u0019u\u000e\u001c7fGR|'oU3sm&\u001cW-S7qY*\u0011!cE\u0001\tS:$XM\u001d8bY*\u0011A#F\u0001\u0005e\u0016\u001cHO\u0003\u0002\u0017/\u0005!QnZ7u\u0015\u0005A\u0012a\u00022mK:$W\rZ\u0002\u0001'\u0015\u00011$I\u00130!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fMB\u0011!eI\u0007\u0002#%\u0011A%\u0005\u0002\u0011\u0007>dG.Z2u_J\u001cVM\u001d<jG\u0016\u0004\"AJ\u0017\u000e\u0003\u001dR!\u0001K\u0015\u0002\t!$H\u000f\u001d\u0006\u0003U-\nA!Y6lC*\u0011AfF\u0001\tg\u0016\u001cWO]5us&\u0011af\n\u0002\u0017\u0015\u0006\u000b5kU3dkJLG/\u001f#je\u0016\u001cG/\u001b<fgB\u0011\u0001'N\u0007\u0002c)\u0011\u0001F\r\u0006\u0003UMR!\u0001N\f\u0002\u000fA\u0014\u0018nY6mK&\u0011a'\r\u0002\u000f!JL7m\u001b7f'V\u0004\bo\u001c:u\u0003u\u0011X-\\8uK\u000e{g\u000e^1j]\u0016\u00148\u000b^1uKB+'o]5ti>\u0014\bC\u0001\u0012:\u0013\tQ\u0014CA\u000fSK6|G/Z\"p]R\f\u0017N\\3s'R\fG/\u001a)feNL7\u000f^8s\u0003\riwM]\u000b\u0002{A\u0011ahP\u0007\u0002W%\u0011\u0001i\u000b\u0002\u0019\u00052,g\u000eZ3e!\u0016\u0014X.[:tS>tW*\u00198bO\u0016\u0014\u0018\u0001B7he\u0002\nqA^3sg&|g.F\u0001E!\t)EJ\u0004\u0002G\u0015B\u0011q)H\u0007\u0002\u0011*\u0011\u0011*G\u0001\u0007yI|w\u000e\u001e \n\u0005-k\u0012A\u0002)sK\u0012,g-\u0003\u0002N\u001d\n11\u000b\u001e:j]\u001eT!aS\u000f\u0002\u0011Y,'o]5p]\u0002\na\u0001P5oSRtD\u0003\u0002*T)V\u0003\"A\t\u0001\t\u000b]2\u0001\u0019\u0001\u001d\t\u000bm2\u0001\u0019A\u001f\t\u000b\t3\u0001\u0019\u0001#\u0002\u00071|w-F\u0001Y!\tIf,D\u0001[\u0015\tYF,A\u0004m_\u001e<\u0017N\\4\u000b\u0005u;\u0012\u0001B;uS2L!a\u0018.\u0003\r1{wmZ3s\u0003!!xn\u0015;sS:<G#\u0001#\u0002\u0017\u00154XM\u001c;TiJ,\u0017-\u001c\t\u00049\u00114\u0017BA3\u001e\u0005\u0019y\u0005\u000f^5p]B\u0011qm[\u0007\u0002Q*\u0011\u0011N[\u0001\u0006KZ,g\u000e\u001e\u0006\u0002U%\u0011A\u000e\u001b\u0002\f\u000bZ,g\u000e^*ue\u0016\fW.A\u0007beRLg-Y2u%\u0016\u0004xn\u001d\t\u0005\u000b>$\u0015/\u0003\u0002q\u001d\n\u0019Q*\u00199\u0011\u0005I,X\"A:\u000b\u0005Q,\u0012\u0001\u0002:fa>L!A^:\u0003)]\u0013\u0018\u000e^1cY\u0016\f%\u000f^5gC\u000e$(+\u001a9p\u0003=\tG\rZ!si&4\u0017m\u0019;SKB|GCA=}!\ta\"0\u0003\u0002|;\t!QK\\5u\u0011\u0015!8\u00021\u0001r\u0003I\u0011X-\\8wK\u0006\u0013H/\u001b4bGR\u0014V\r]8\u0015\u0005e|\b\"\u0002;\r\u0001\u0004\t\u0018AD:fi\u00163XM\u001c;TiJ,\u0017-\u001c\u000b\u0004s\u0006\u0015\u0001\"\u00022\u000e\u0001\u0004\u0019\u0017\u0001\u00069s_\u000e,7o]\"p]R\f\u0017N\\3s\u0013:4w\u000e\u0006\u0003\u0002\f\u0005m\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0007G>tg-[4\u000b\u0007\u0005Uq#A\u0004va\u0012\fG/\u001a:\n\t\u0005e\u0011q\u0002\u0002\u001c\u0007>tG/Y5oKJ\u0014VmZ5tiJL(+Z:q_:\u001cXmT&\t\u000f\u0005ua\u00021\u0001\u0002 \u0005!\u0011N\u001c4p!\u0011\ti!!\t\n\t\u0005\r\u0012q\u0002\u0002\u000e\u0007>tG/Y5oKJLeNZ8\u0002\u001f\u001d,GoQ;se\u0016tGo\u0015;bi\u0016$\"!!\u000b\u0011\r\u0005-\u0012QGA\u001d\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012!C5n[V$\u0018M\u00197f\u0015\r\t\u0019$H\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u001c\u0003[\u00111aU3r!\u0011\ti!a\u000f\n\t\u0005u\u0012q\u0002\u0002\u0015%\u0016lw\u000e^3D_:$\u0018-\u001b8feN#\u0018\r^3")
public class CollectorServiceImpl
implements CollectorService,
JAASSecurityDirectives,
PrickleSupport {
    private Logger log;
    private final RemoteContainerStatePersistor remoteContainerStatePersistor;
    private final BlendedPermissionManager mgr;
    private final String version;
    private Option<EventStream> eventStream;
    private Map<String, WritableArtifactRepo> artifactRepos;
    private Logger blended$prickle$akka$http$PrickleSupport$$log;
    private MediaType.WithFixedCharset prickleMediaType;
    private Logger blended$security$akka$http$JAASSecurityDirectives$$log;
    private HttpChallenge blended$security$akka$http$JAASSecurityDirectives$$challenge;
    private AuthenticationDirective<Subject> authenticated;
    private Function1<RequestContext, Future<RouteResult>> httpRoute;
    private Logger blended$mgmt$rest$internal$CollectorService$$log;
    private volatile byte bitmap$0;

    public <T> Marshaller<T, RequestEntity> toEntityMarshaller(Pickler<T> p, PConfig<JsValue> config) {
        return PrickleSupport.toEntityMarshaller$((PrickleSupport)this, p, config);
    }

    public <T> Unmarshaller<HttpEntity, T> fromEntityUnmarshaller(Unpickler<T> u, PConfig<JsValue> config) {
        return PrickleSupport.fromEntityUnmarshaller$((PrickleSupport)this, u, config);
    }

    public Directive<BoxedUnit> requirePermission(BlendedPermission permission) {
        return JAASSecurityDirectives.requirePermission$((JAASSecurityDirectives)this, (BlendedPermission)permission);
    }

    public Directive<BoxedUnit> requireGroup(String group) {
        return JAASSecurityDirectives.requireGroup$((JAASSecurityDirectives)this, (String)group);
    }

    public Directive<BoxedUnit> requirePermission(String permission) {
        return BlendedSecurityDirectives.requirePermission$((BlendedSecurityDirectives)this, (String)permission);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> versionRoute() {
        return CollectorService.versionRoute$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> collectorRoute() {
        return CollectorService.collectorRoute$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> infoRoute() {
        return CollectorService.infoRoute$(this);
    }

    public Logger blended$prickle$akka$http$PrickleSupport$$log() {
        return this.blended$prickle$akka$http$PrickleSupport$$log;
    }

    public MediaType.WithFixedCharset prickleMediaType() {
        return this.prickleMediaType;
    }

    public final void blended$prickle$akka$http$PrickleSupport$_setter_$blended$prickle$akka$http$PrickleSupport$$log_$eq(Logger x$1) {
        this.blended$prickle$akka$http$PrickleSupport$$log = x$1;
    }

    public void blended$prickle$akka$http$PrickleSupport$_setter_$prickleMediaType_$eq(MediaType.WithFixedCharset x$1) {
        this.prickleMediaType = x$1;
    }

    private Logger blended$security$akka$http$JAASSecurityDirectives$$log$lzycompute() {
        CollectorServiceImpl collectorServiceImpl = this;
        synchronized (collectorServiceImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.blended$security$akka$http$JAASSecurityDirectives$$log = JAASSecurityDirectives.blended$security$akka$http$JAASSecurityDirectives$$log$((JAASSecurityDirectives)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.blended$security$akka$http$JAASSecurityDirectives$$log;
    }

    public Logger blended$security$akka$http$JAASSecurityDirectives$$log() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.blended$security$akka$http$JAASSecurityDirectives$$log$lzycompute() : this.blended$security$akka$http$JAASSecurityDirectives$$log;
    }

    public HttpChallenge blended$security$akka$http$JAASSecurityDirectives$$challenge() {
        return this.blended$security$akka$http$JAASSecurityDirectives$$challenge;
    }

    public AuthenticationDirective<Subject> authenticated() {
        return this.authenticated;
    }

    public final void blended$security$akka$http$JAASSecurityDirectives$_setter_$blended$security$akka$http$JAASSecurityDirectives$$challenge_$eq(HttpChallenge x$1) {
        this.blended$security$akka$http$JAASSecurityDirectives$$challenge = x$1;
    }

    public void blended$security$akka$http$JAASSecurityDirectives$_setter_$authenticated_$eq(AuthenticationDirective<Subject> x$1) {
        this.authenticated = x$1;
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> httpRoute() {
        return this.httpRoute;
    }

    private Logger blended$mgmt$rest$internal$CollectorService$$log$lzycompute() {
        CollectorServiceImpl collectorServiceImpl = this;
        synchronized (collectorServiceImpl) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.blended$mgmt$rest$internal$CollectorService$$log = CollectorService.blended$mgmt$rest$internal$CollectorService$$log$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.blended$mgmt$rest$internal$CollectorService$$log;
    }

    @Override
    public Logger blended$mgmt$rest$internal$CollectorService$$log() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.blended$mgmt$rest$internal$CollectorService$$log$lzycompute() : this.blended$mgmt$rest$internal$CollectorService$$log;
    }

    @Override
    public void blended$mgmt$rest$internal$CollectorService$_setter_$httpRoute_$eq(Function1<RequestContext, Future<RouteResult>> x$1) {
        this.httpRoute = x$1;
    }

    public BlendedPermissionManager mgr() {
        return this.mgr;
    }

    @Override
    public String version() {
        return this.version;
    }

    private Logger log$lzycompute() {
        CollectorServiceImpl collectorServiceImpl = this;
        synchronized (collectorServiceImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(CollectorServiceImpl.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.log;
    }

    private Logger log() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.log$lzycompute() : this.log;
    }

    public String toString() {
        return new StringBuilder(46).append(this.getClass().getSimpleName()).append("(remoteContainerStatePersistor=").append(this.remoteContainerStatePersistor).append(",mgr=").append(this.mgr()).append(",version=").append(this.version()).append(")").toString();
    }

    public void addArtifactRepo(WritableArtifactRepo repo) {
        this.artifactRepos = (Map)this.artifactRepos.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)repo.repoId()), (Object)repo));
    }

    public void removeArtifactRepo(WritableArtifactRepo repo) {
        this.artifactRepos = this.artifactRepos.view().filterKeys((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)CollectorServiceImpl.$anonfun$removeArtifactRepo$1(repo, name))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void setEventStream(Option<EventStream> eventStream) {
        this.eventStream = eventStream;
    }

    @Override
    public ContainerRegistryResponseOK processContainerInfo(ContainerInfo info) {
        this.log().debug((Function0 & Serializable)() -> new StringBuilder(27).append("Processing container info: ").append(info).toString());
        this.eventStream.foreach((Function1 & Serializable)x$1 -> {
            x$1.publish((Object)new UpdateContainerInfo(info));
            return BoxedUnit.UNIT;
        });
        RemoteContainerState state = new RemoteContainerState(info);
        this.remoteContainerStatePersistor.updateState(state);
        return new ContainerRegistryResponseOK(info.containerId());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<RemoteContainerState> getCurrentState() {
        void var1_1;
        List<RemoteContainerState> states = this.remoteContainerStatePersistor.findAll();
        this.log().debug((Function0 & Serializable)() -> new StringBuilder(21).append("About to send state: ").append(states).toString());
        return var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$removeArtifactRepo$1(WritableArtifactRepo repo$1, String name) {
        String string = name;
        String string2 = repo$1.repoId();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public CollectorServiceImpl(RemoteContainerStatePersistor remoteContainerStatePersistor, BlendedPermissionManager mgr, String version) {
        this.remoteContainerStatePersistor = remoteContainerStatePersistor;
        this.mgr = mgr;
        this.version = version;
        CollectorService.$init$(this);
        BlendedSecurityDirectives.$init$((BlendedSecurityDirectives)this);
        JAASSecurityDirectives.$init$((JAASSecurityDirectives)this);
        PrickleSupport.$init$((PrickleSupport)this);
        this.log().info((Function0 & Serializable)() -> new StringBuilder(8).append("This is ").append(this.toString()).toString());
        this.eventStream = None$.MODULE$;
        this.artifactRepos = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        Statics.releaseFence();
    }
}

