/*
 * Decompiled with CFR 0.152.
 */
package blended.security.ssl.internal;

import blended.container.context.api.ContainerContext;
import blended.security.ssl.internal.CertificateConfig;
import blended.security.ssl.internal.CertificateConfig$;
import blended.security.ssl.internal.CertificateManagerConfig;
import blended.security.ssl.internal.KeystoreConfig;
import blended.security.ssl.internal.KeystoreConfig$;
import blended.security.ssl.internal.PasswordHasher;
import blended.security.ssl.internal.RefresherConfig;
import blended.security.ssl.internal.RefresherConfig$;
import blended.util.config.Implicits$;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class CertificateManagerConfig$
implements Serializable {
    public static final CertificateManagerConfig$ MODULE$ = new CertificateManagerConfig$();

    public CertificateManagerConfig fromConfig(Config cfg, PasswordHasher hasher, ContainerContext ctCtxt) {
        boolean clientOnly = Implicits$.MODULE$.RichDefaultConfig(cfg).getBoolean("clientOnly", false);
        boolean maintainTruststore = Implicits$.MODULE$.RichDefaultConfig(cfg).getBoolean("maintainTruststore", true);
        None$ keystoreCfg = clientOnly ? None$.MODULE$ : new Some((Object)KeystoreConfig$.MODULE$.fromConfig(cfg, hasher, ctCtxt));
        List providers = Implicits$.MODULE$.RichDefaultConfig(cfg).getStringList("providerList", List$.MODULE$.empty());
        List certConfigs = ((IterableOnceOps)Implicits$.MODULE$.RichDefaultConfig(cfg).getConfigMap("certificates", Predef$.MODULE$.Map().empty()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Config v = (Config)tuple2._2();
            CertificateConfig certificateConfig = CertificateConfig$.MODULE$.fromConfig(k, v, ctCtxt);
            return certificateConfig;
        })).toList();
        Option refresherConfig = Implicits$.MODULE$.RichOptionConfig(cfg).getConfigOption("refresher").map((Function1 & Serializable)c -> (RefresherConfig)RefresherConfig$.MODULE$.fromConfig((Config)c).get());
        boolean skipInitialCheck = Implicits$.MODULE$.RichDefaultConfig(cfg).getBoolean("skipInitialCheck", false);
        List cyphers = Implicits$.MODULE$.RichDefaultConfig(cfg).getStringList("validCypherSuites", List$.MODULE$.empty());
        boolean x$1 = clientOnly;
        boolean x$2 = maintainTruststore;
        None$ x$3 = keystoreCfg;
        List x$4 = certConfigs;
        Option x$5 = refresherConfig;
        boolean x$6 = skipInitialCheck;
        List x$7 = providers;
        List x$8 = cyphers;
        return new CertificateManagerConfig(x$1, x$2, (Option<KeystoreConfig>)x$3, (List<String>)x$7, (List<CertificateConfig>)x$4, (Option<RefresherConfig>)x$5, x$6, (List<String>)x$8);
    }

    public CertificateManagerConfig apply(boolean clientOnly, boolean maintainTruststore, Option<KeystoreConfig> keystoreCfg, List<String> providerList, List<CertificateConfig> certConfigs, Option<RefresherConfig> refresherConfig, boolean skipInitialCheck, List<String> validCypherSuites) {
        return new CertificateManagerConfig(clientOnly, maintainTruststore, keystoreCfg, providerList, certConfigs, refresherConfig, skipInitialCheck, validCypherSuites);
    }

    public Option<Tuple8<Object, Object, Option<KeystoreConfig>, List<String>, List<CertificateConfig>, Option<RefresherConfig>, Object, List<String>>> unapply(CertificateManagerConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8((Object)BoxesRunTime.boxToBoolean((boolean)x$0.clientOnly()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.maintainTruststore()), x$0.keystoreCfg(), x$0.providerList(), x$0.certConfigs(), x$0.refresherConfig(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.skipInitialCheck()), x$0.validCypherSuites()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CertificateManagerConfig$.class);
    }

    private CertificateManagerConfig$() {
    }
}

