/*
 * Decompiled with CFR 0.152.
 */
package blended.container.context.impl.internal;

import blended.container.context.api.ContainerContext;
import blended.util.RichTry$;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.config.ConfigValueType;
import java.io.File;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class ConfigLocator$ {
    public static final ConfigLocator$ MODULE$ = new ConfigLocator$();
    private static final Logger log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(ConfigLocator$.class));
    private static final Config sysProps = ConfigFactory.systemProperties();
    private static final Config envProps = ConfigFactory.systemEnvironment();

    public Config readConfigFile(File f, Config fallback) {
        return f.exists() && f.isFile() && f.canRead() ? ConfigFactory.parseFile((File)f, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).withFallback((ConfigMergeable)fallback).withFallback((ConfigMergeable)sysProps).withFallback((ConfigMergeable)envProps).resolve() : ConfigFactory.empty();
    }

    public List<String> fullKeyset(String prefix, Config cfg) {
        List keySet = CollectionConverters$.MODULE$.SetHasAsScala(cfg.root().keySet()).asScala().toList();
        List toAdd = keySet.map((Function1 & Serializable)s -> {
            List list;
            if (cfg.getIsNull(s)) {
                list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(0).append(prefix).append((String)s).toString()}));
            } else {
                try {
                    list = (List)((IterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(0).append(prefix).append((String)s).toString()}))).$plus$plus(MODULE$.fullKeyset(new StringBuilder(1).append(prefix).append((String)s).append(".").toString(), cfg.getConfig(s)));
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        throw throwable;
                    }
                    List list2 = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(0).append(prefix).append((String)s).toString()}));
                    list = list2;
                }
            }
            return list;
        });
        return (List)toAdd.flatten(Predef$.MODULE$.$conforms());
    }

    public Try<Config> evaluatedConfig(Config rawCfg, ContainerContext ctContext) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            java.util.Map replaced = CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(rawCfg.entrySet()).asScala().map((Function1 & Serializable)e -> {
                Object object;
                ConfigValue configValue = (ConfigValue)e.getValue();
                ConfigValueType configValueType = configValue.valueType();
                ConfigValueType configValueType2 = ConfigValueType.STRING;
                if (!(configValueType != null ? !configValueType.equals(configValueType2) : configValueType2 != null)) {
                    String resolved = (String)RichTry$.MODULE$.toRichTry(ctContext.resolveString(configValue.unwrapped().toString(), ctContext.resolveString$default$2()).map((Function1 & Serializable)x$1 -> x$1.toString())).unwrap();
                    object = resolved;
                } else {
                    object = configValue.unwrapped();
                }
                Object v = object;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getKey()), (Object)ConfigValueFactory.fromAnyRef((Object)v));
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
            return ConfigFactory.parseMap((java.util.Map)replaced).resolve();
        });
    }

    public Config safeConfig(String cfgDir, String fileName, Config fallback, ContainerContext ctContext) {
        Config config;
        File file = new File(cfgDir, fileName);
        log.debug((Function0 & Serializable)() -> new StringBuilder(25).append("Retrieving config from [").append(file.getAbsolutePath()).append("]").toString());
        Try<Config> try_ = this.evaluatedConfig(this.readConfigFile(file, fallback), ctContext);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            log.warn((Function0 & Serializable)() -> new StringBuilder(41).append("Error reading [").append(file.getAbsolutePath()).append("] : [").append(e.getMessage()).append("], using empty config").toString());
            config = ConfigFactory.empty();
        } else if (try_ instanceof Success) {
            Config cfg;
            Success success = (Success)try_;
            config = cfg = (Config)success.value();
        } else {
            throw new MatchError(try_);
        }
        return config;
    }

    private ConfigLocator$() {
    }
}

