/*
 * Decompiled with CFR 0.152.
 */
package blended.container.context.impl.internal;

import blended.container.context.api.ContainerIdentifierService;
import blended.container.context.api.ContainerIdentifierService$;
import blended.container.context.api.PropertyResolverException;
import blended.container.context.api.SpelFunctions;
import blended.container.context.impl.internal.ContainerPropertyResolver;
import blended.container.context.impl.internal.ContainerPropertyResolver$ExtractedElement$;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

public final class ContainerPropertyResolver$ {
    public static ContainerPropertyResolver$ MODULE$;
    private final Logger log;
    private final String resolveStartChar;
    private final String resolveEndChar;
    private final String evalStartChar;
    private final String evalEndChar;
    private final Function1<String, Pattern> startDelim;
    private final Pattern resolveStartDelim;
    private final String resolveEndDelim;
    private final Pattern evalStartDelim;
    private final String evalEndDelim;
    private final SpelExpressionParser parser;
    private final Map<String, Expression> elCache;
    private final scala.collection.immutable.Map<String, Function2<String, String, String>> modifiers;

    static {
        new ContainerPropertyResolver$();
    }

    private Try<Expression> parseExpression(String exp) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Expression expression;
            Option option = ContainerPropertyResolver$.MODULE$.elCache.get((Object)exp);
            if (option instanceof Some) {
                Expression e;
                Some some = (Some)option;
                expression = e = (Expression)some.value();
            } else if (None$.MODULE$.equals(option)) {
                Expression r = ContainerPropertyResolver$.MODULE$.parser.parseExpression(exp);
                ContainerPropertyResolver$.MODULE$.elCache.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)exp), (Object)r));
                expression = r;
            } else {
                throw new MatchError((Object)option);
            }
            return expression;
        });
    }

    private int lastIndexOfPattern(int current, int next, String s, Pattern p) {
        Matcher m;
        while ((m = p.matcher(s)).find(Math.max(next, 0))) {
            next = m.start() + m.group(0).length();
            current = m.start();
        }
        return current;
    }

    private ContainerPropertyResolver.ExtractedElement extractVariableElement(String line, Pattern startDelim, String endDelim) {
        ContainerPropertyResolver.ExtractedElement extractedElement;
        int idx;
        int n = idx = this.lastIndexOfPattern(-1, -1, line, startDelim);
        switch (n) {
            case -1: {
                extractedElement = new ContainerPropertyResolver.ExtractedElement("", line, "", ContainerPropertyResolver$ExtractedElement$.MODULE$.apply$default$4());
                break;
            }
            default: {
                int n2 = line.indexOf(endDelim, n);
                switch (n2) {
                    case -1: {
                        throw new PropertyResolverException(new StringBuilder(64).append("Error decoding replacement pattern [").append(line).append("] : missing end delimiter [").append(endDelim).append("]").toString());
                    }
                }
                String subline = line.substring(n, n2 + endDelim.length());
                Matcher subMatcher = startDelim.matcher(subline);
                subMatcher.find();
                int patternStart = n + subMatcher.group(0).length();
                extractedElement = new ContainerPropertyResolver.ExtractedElement(line.substring(0, n), line.substring(patternStart, n2), line.substring(n2 + endDelim.length()), subMatcher.group(2));
                break;
            }
        }
        return extractedElement;
    }

    private scala.collection.immutable.Map<String, Function1<String, String>> resolver(ContainerIdentifierService idSvc) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ContainerIdentifierService$.MODULE$.containerId()), (Function1 & Serializable & scala.Serializable)x$1 -> idSvc.uuid())}));
    }

    private Option<Tuple2<Function2<String, String, String>, String>> extractModifier(String s) {
        Tuple2 tuple2;
        int pos = s.indexOf(":");
        Tuple2 tuple22 = tuple2 = pos != -1 ? new Tuple2((Object)s.substring(0, pos), (Object)s.substring(pos + 1)) : new Tuple2((Object)s, (Object)"");
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String modName = (String)tuple2._1();
        String params = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)modName, (Object)params);
        Tuple2 tuple24 = tuple23;
        String modName2 = (String)tuple24._1();
        String params2 = (String)tuple24._2();
        return this.modifiers.get((Object)modName2).map((Function1 & Serializable & scala.Serializable)m -> new Tuple2(m, (Object)params2));
    }

    private String processRule(ContainerIdentifierService idSvc, String rule, scala.collection.immutable.Map<String, Object> additionalProps) {
        String string;
        String string2;
        List modifier;
        block17: {
            Tuple2 tuple2;
            block16: {
                Tuple2 tuple22;
                this.log.trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Processing rule [").append(rule).append("]").toString());
                int n = rule.indexOf("(");
                switch (n) {
                    case -1: {
                        tuple22 = new Tuple2((Object)rule, (Object)List$.MODULE$.empty());
                        break;
                    }
                    default: {
                        tuple22 = new Tuple2((Object)rule.substring(0, n), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rule.substring(n + 1, rule.indexOf(")", n)).split(","))).toList());
                        break;
                    }
                }
                tuple2 = tuple22;
                if (tuple2 == null) break block16;
                String ruleName = (String)tuple2._1();
                modifier = (List)tuple2._2();
                if (ruleName == null) break block16;
                string2 = ruleName;
                if (modifier != null) break block17;
            }
            throw new MatchError((Object)tuple2);
        }
        List list = modifier;
        Tuple2 tuple2 = new Tuple2((Object)string2, (Object)list);
        Tuple2 tuple23 = tuple2;
        String ruleName = (String)tuple23._1();
        List modifier2 = (List)tuple23._2();
        this.log.trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("rule [").append(ruleName).append("], [").append(modifier2.mkString(",")).append("]").toString());
        List mods = (List)((List)modifier2.map((Function1 & Serializable & scala.Serializable)s -> MODULE$.extractModifier((String)s), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Option<Tuple2<Function2<String, String, String>, String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    Tuple2 m = (Tuple2)some.value();
                    object = m;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Option<Tuple2<Function2<String, String, String>, String>> x1) {
                Option<Tuple2<Function2<String, String, String>, String>> option = x1;
                boolean bl = option instanceof Some;
                return bl;
            }
        }, List$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map props = (scala.collection.immutable.Map)Option$.MODULE$.apply((Object)idSvc.properties()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        Option option = props.get((Object)ruleName);
        if (option instanceof Some) {
            String s2;
            Some some = (Some)option;
            string = s2 = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            String string3;
            Option option2 = Option$.MODULE$.apply(additionalProps.getOrElse((Object)rule, (Function0 & Serializable & scala.Serializable)() -> System.getenv().getOrDefault(ruleName, System.getProperty(ruleName))));
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Object s3 = some.value();
                string3 = s3.toString();
            } else if (None$.MODULE$.equals(option2)) {
                Option option3 = this.resolver(idSvc).get((Object)ruleName);
                if (!(option3 instanceof Some)) {
                    if (None$.MODULE$.equals(option3)) {
                        throw new PropertyResolverException(new StringBuilder(29).append("Unable to resolve property [").append(rule).append("]").toString());
                    }
                    throw new MatchError((Object)option3);
                }
                Some some = (Some)option3;
                Function1 r = (Function1)some.value();
                String string4 = (String)r.apply((Object)ruleName);
                string3 = string4;
            } else {
                throw new MatchError((Object)option2);
            }
            string = string3;
        } else {
            throw new MatchError((Object)option);
        }
        String result = string;
        result = (String)mods.foldLeft((Object)result, (Function2 & Serializable & scala.Serializable)(a, b) -> (String)((Function2)b._1()).apply(a, b._2()));
        return result;
    }

    public Object resolve(ContainerIdentifierService idSvc, String line, scala.collection.immutable.Map<String, Object> additionalProps) {
        Object object;
        block10: {
            int n;
            while (true) {
                if (this.lastIndexOfPattern(-1, -1, line, this.resolveStartDelim) != -1) {
                    String string;
                    ContainerPropertyResolver.ExtractedElement e = this.extractVariableElement(line, this.resolveStartDelim, this.resolveEndDelim);
                    String string2 = e.modifier();
                    if ("delayed".equals(string2)) {
                        string = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(this.resolve(idSvc, e.prefix(), this.resolve$default$3())), e.pattern())).append(this.resolve(idSvc, e.postfix(), this.resolve$default$3())).toString();
                    } else if ("encrypted".equals(string2)) {
                        String decrypted = (String)idSvc.getContainerContext().getContainerCryptoSupport().decrypt(e.pattern()).get();
                        string = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(this.resolve(idSvc, e.prefix(), this.resolve$default$3())), this.resolve(idSvc, decrypted, this.resolve$default$3()).toString())).append(this.resolve(idSvc, e.postfix(), this.resolve$default$3())).toString();
                    } else {
                        String inner = this.resolve(idSvc, e.pattern(), additionalProps).toString();
                        String string3 = new StringBuilder(0).append(e.prefix()).append(this.processRule(idSvc, inner, additionalProps)).append(e.postfix()).toString();
                        line = string3;
                        continue;
                    }
                    object = string;
                    break block10;
                }
                n = this.lastIndexOfPattern(-1, -1, line, this.evalStartDelim);
                switch (n) {
                    default: 
                }
                if (n < 0) {
                    object = line;
                    break block10;
                }
                if (n < 0) break;
                ContainerPropertyResolver.ExtractedElement e = this.extractVariableElement(line, this.evalStartDelim, this.evalEndDelim);
                if (e.prefix().isEmpty() && e.postfix().isEmpty()) {
                    object = this.evaluate(idSvc, e.pattern(), additionalProps);
                    break block10;
                }
                String string = new StringBuilder(0).append(e.prefix()).append(this.evaluate(idSvc, e.pattern(), additionalProps)).append(e.postfix()).toString();
                line = string;
            }
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return object;
    }

    public scala.collection.immutable.Map<String, Object> resolve$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public Object evaluate(ContainerIdentifierService idSvc, String line, scala.collection.immutable.Map<String, Object> additionalProps) {
        Object object;
        StandardEvaluationContext context = new StandardEvaluationContext();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])SpelFunctions.class.getDeclaredMethods())).foreach((Function1 & Serializable & scala.Serializable)m -> {
            context.registerFunction(m.getName(), m);
            return BoxedUnit.UNIT;
        });
        context.setRootObject((Object)idSvc);
        additionalProps.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ContainerPropertyResolver$.$anonfun$evaluate$2(context, x0$1);
            return BoxedUnit.UNIT;
        });
        context.setVariable("idSvc", (Object)idSvc);
        Expression exp = (Expression)this.parseExpression(line).get();
        Option option = Option$.MODULE$.apply(exp.getValue((EvaluationContext)context));
        if (None$.MODULE$.equals(option)) {
            this.log.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Could not resolve expression [").append(line).append("], using empty String").toString());
            object = "";
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Object r = some.value();
            this.log.trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Evaluated [").append(line).append("] to [").append(r).append("][").append(r.getClass().getName()).append("]").toString());
            object = r;
        } else {
            throw new MatchError((Object)option);
        }
        return object;
    }

    public scala.collection.immutable.Map<String, Object> evaluate$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ void $anonfun$evaluate$2(StandardEvaluationContext context$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        Object v = tuple2._2();
        context$1.setVariable(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private ContainerPropertyResolver$() {
        MODULE$ = this;
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(ContainerPropertyResolver$.class));
        this.resolveStartChar = "[";
        this.resolveEndChar = "]";
        this.evalStartChar = "{";
        this.evalEndChar = "}";
        this.startDelim = (Function1 & Serializable & scala.Serializable)s -> {
            StringBuffer buf = new StringBuffer();
            buf.append(new StringBuilder(5).append("(\\$\\").append((String)s).append(")").toString());
            buf.append(new StringBuilder(10).append("([^\\").append((String)s).append("]*)(\\").append((String)s).append(")").toString());
            return Pattern.compile(buf.toString());
        };
        this.resolveStartDelim = (Pattern)this.startDelim.apply((Object)this.resolveStartChar);
        this.resolveEndDelim = new StringBuilder(0).append(this.resolveEndChar).append(this.resolveEndChar).toString();
        this.evalStartDelim = (Pattern)this.startDelim.apply((Object)this.evalStartChar);
        this.evalEndDelim = new StringBuilder(0).append(this.evalEndChar).append(this.evalEndChar).toString();
        this.parser = new SpelExpressionParser();
        this.elCache = Map$.MODULE$.empty();
        this.modifiers = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"upper"), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            String string;
            block3: {
                Tuple2 tuple2;
                block2: {
                    String s;
                    tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 == null || (s = (String)tuple2._1()) == null) break block2;
                    string = s;
                    if (tuple2._2() != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String string2 = string.toUpperCase();
            return string2;
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lower"), (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            String string;
            block3: {
                Tuple2 tuple2;
                block2: {
                    String s;
                    tuple2 = new Tuple2(x0$2, x1$2);
                    if (tuple2 == null || (s = (String)tuple2._1()) == null) break block2;
                    string = s;
                    if (tuple2._2() != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String string2 = string.toLowerCase();
            return string2;
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"capitalize"), (Function2 & Serializable & scala.Serializable)(x0$3, x1$3) -> {
            String string;
            block3: {
                Tuple2 tuple2;
                block2: {
                    String s;
                    tuple2 = new Tuple2(x0$3, x1$3);
                    if (tuple2 == null || (s = (String)tuple2._1()) == null) break block2;
                    string = s;
                    if (tuple2._2() != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String string2 = new StringOps(Predef$.MODULE$.augmentString(string)).capitalize();
            return string2;
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Function2 & Serializable & scala.Serializable)(x0$4, x1$4) -> {
            String string;
            String param;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = new Tuple2(x0$4, x1$4);
                    if (tuple2 == null) break block2;
                    String s = (String)tuple2._1();
                    param = (String)tuple2._2();
                    if (s == null) break block2;
                    string = s;
                    if (param != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String string2 = param;
            int n = new StringOps(Predef$.MODULE$.augmentString(string2)).toInt();
            String string3 = n >= string.length() ? string : (String)new StringOps(Predef$.MODULE$.augmentString(string)).takeRight(n);
            return string3;
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Function2 & Serializable & scala.Serializable)(x0$5, x1$5) -> {
            String string;
            String param;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = new Tuple2(x0$5, x1$5);
                    if (tuple2 == null) break block2;
                    String s = (String)tuple2._1();
                    param = (String)tuple2._2();
                    if (s == null) break block2;
                    string = s;
                    if (param != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String string2 = param;
            int n = new StringOps(Predef$.MODULE$.augmentString(string2)).toInt();
            String string3 = n >= string.length() ? string : (String)new StringOps(Predef$.MODULE$.augmentString(string)).take(n);
            return string3;
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"replace"), (Function2 & Serializable & scala.Serializable)(x0$6, x1$6) -> {
            String string;
            String param;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = new Tuple2(x0$6, x1$6);
                    if (tuple2 == null) break block2;
                    String s = (String)tuple2._1();
                    param = (String)tuple2._2();
                    if (s == null) break block2;
                    string = s;
                    if (param != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String string2 = param;
            String[] replace = string2.split(":");
            String string3 = replace.length != 2 ? string : string.replaceAll(replace[0], replace[1]);
            return string3;
        })}));
    }
}

