/*
 * Decompiled with CFR 0.152.
 */
package blended.container.context.api;

import blended.container.context.api.ContainerIdentifierService;
import blended.container.context.api.ContainerIdentifierService$;
import blended.container.context.api.PropertyResolverException;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class ContainerPropertyResolver$ {
    public static ContainerPropertyResolver$ MODULE$;
    private final Logger log;
    private final String startDelim;
    private final String endDelim;

    static {
        new ContainerPropertyResolver$();
    }

    public Tuple3<String, String, String> extractRule(String line) {
        Tuple3 tuple3;
        int n = line.lastIndexOf(this.startDelim);
        switch (n) {
            case -1: {
                tuple3 = new Tuple3((Object)"", (Object)line, (Object)"");
                break;
            }
            default: {
                int n2 = line.indexOf(this.endDelim, n);
                switch (n2) {
                    case -1: {
                        throw new PropertyResolverException(new StringBuilder(64).append("Error decoding replacement pattern [").append(line).append("] : missing end delimiter [").append(this.endDelim).append("]").toString());
                    }
                }
                tuple3 = new Tuple3((Object)line.substring(0, n), (Object)line.substring(n + this.startDelim.length(), n2), (Object)line.substring(n2 + this.endDelim.length()));
                break;
            }
        }
        return tuple3;
    }

    public String processRule(ContainerIdentifierService idSvc, String rule) {
        String string;
        String string2;
        List modifier;
        Map resolvers;
        Map modifiers;
        block19: {
            Tuple2 tuple2;
            block18: {
                Tuple2 tuple22;
                if (this.log.isTraceEnabled()) {
                    this.log.trace(new StringBuilder(18).append("Processing rule [").append(rule).append("]").toString());
                }
                modifiers = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"upper"), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                    String string;
                    block3: {
                        Tuple2 tuple2;
                        block2: {
                            tuple2 = new Tuple2(x0$1, x1$1);
                            if (tuple2 == null) break block2;
                            String s = (String)tuple2._1();
                            String param = (String)tuple2._2();
                            if (s == null) break block2;
                            string = s;
                            if (param != null) break block3;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    String string2 = string.toUpperCase();
                    return string2;
                }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lower"), (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                    String string;
                    block3: {
                        Tuple2 tuple2;
                        block2: {
                            tuple2 = new Tuple2(x0$2, x1$2);
                            if (tuple2 == null) break block2;
                            String s = (String)tuple2._1();
                            String param = (String)tuple2._2();
                            if (s == null) break block2;
                            string = s;
                            if (param != null) break block3;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    String string2 = string.toLowerCase();
                    return string2;
                }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"capitalize"), (Function2 & Serializable & scala.Serializable)(x0$3, x1$3) -> {
                    String string;
                    block3: {
                        Tuple2 tuple2;
                        block2: {
                            tuple2 = new Tuple2(x0$3, x1$3);
                            if (tuple2 == null) break block2;
                            String s = (String)tuple2._1();
                            String param = (String)tuple2._2();
                            if (s == null) break block2;
                            string = s;
                            if (param != null) break block3;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    String string2 = new StringOps(Predef$.MODULE$.augmentString(string)).capitalize();
                    return string2;
                }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Function2 & Serializable & scala.Serializable)(x0$4, x1$4) -> {
                    String string;
                    String param;
                    block3: {
                        Tuple2 tuple2;
                        block2: {
                            tuple2 = new Tuple2(x0$4, x1$4);
                            if (tuple2 == null) break block2;
                            String s = (String)tuple2._1();
                            param = (String)tuple2._2();
                            if (s == null) break block2;
                            string = s;
                            if (param != null) break block3;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    String string2 = param;
                    int n = new StringOps(Predef$.MODULE$.augmentString(string2)).toInt();
                    String string3 = n >= string.length() ? string : (String)new StringOps(Predef$.MODULE$.augmentString(string)).takeRight(n);
                    return string3;
                }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Function2 & Serializable & scala.Serializable)(x0$5, x1$5) -> {
                    String string;
                    String param;
                    block3: {
                        Tuple2 tuple2;
                        block2: {
                            tuple2 = new Tuple2(x0$5, x1$5);
                            if (tuple2 == null) break block2;
                            String s = (String)tuple2._1();
                            param = (String)tuple2._2();
                            if (s == null) break block2;
                            string = s;
                            if (param != null) break block3;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    String string2 = param;
                    int n = new StringOps(Predef$.MODULE$.augmentString(string2)).toInt();
                    String string3 = n >= string.length() ? string : (String)new StringOps(Predef$.MODULE$.augmentString(string)).take(n);
                    return string3;
                }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"replace"), (Function2 & Serializable & scala.Serializable)(x0$6, x1$6) -> {
                    String string;
                    String param;
                    block3: {
                        Tuple2 tuple2;
                        block2: {
                            tuple2 = new Tuple2(x0$6, x1$6);
                            if (tuple2 == null) break block2;
                            String s = (String)tuple2._1();
                            param = (String)tuple2._2();
                            if (s == null) break block2;
                            string = s;
                            if (param != null) break block3;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    String string2 = param;
                    String[] replace = string2.split(":");
                    String string3 = replace.length != 2 ? string : string.replaceAll(replace[0], replace[1]);
                    return string3;
                })}));
                resolvers = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ContainerIdentifierService$.MODULE$.containerId()), (Function1 & Serializable & scala.Serializable)x$1 -> idSvc.uuid())}));
                int n = rule.indexOf("(");
                switch (n) {
                    case -1: {
                        tuple22 = new Tuple2((Object)rule, (Object)List$.MODULE$.empty());
                        break;
                    }
                    default: {
                        tuple22 = new Tuple2((Object)rule.substring(0, n), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rule.substring(n + 1, rule.indexOf(")", n)).split(","))).toList());
                        break;
                    }
                }
                tuple2 = tuple22;
                if (tuple2 == null) break block18;
                String ruleName = (String)tuple2._1();
                modifier = (List)tuple2._2();
                if (ruleName == null) break block18;
                string2 = ruleName;
                if (modifier != null) break block19;
            }
            throw new MatchError((Object)tuple2);
        }
        List list = modifier;
        Tuple2 tuple2 = new Tuple2((Object)string2, (Object)list);
        Tuple2 tuple23 = tuple2;
        String ruleName = (String)tuple23._1();
        List modifier2 = (List)tuple23._2();
        if (this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder(11).append("rule [").append(ruleName).append("], [").append(modifier2.mkString(",")).append("]").toString());
        }
        List mods = (List)((List)((TraversableLike)modifier2.map((Function1 & Serializable & scala.Serializable)m -> {
            int pos = m.indexOf(":");
            return pos != -1 ? new Tuple2((Object)m.substring(0, pos), (Object)m.substring(pos + 1)) : new Tuple2(m, (Object)"");
        }, List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)ContainerPropertyResolver$.$anonfun$processRule$9(modifiers, x0$7)))).map((Function1 & Serializable & scala.Serializable)x0$8 -> {
            Tuple2 tuple2 = x0$8;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String modName = (String)tuple2._1();
            String param = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2(modifiers.apply((Object)modName), (Object)param);
            return tuple22;
        }, List$.MODULE$.canBuildFrom());
        Map props = (Map)Option$.MODULE$.apply(idSvc.properties()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        Option option = props.get((Object)ruleName);
        if (option instanceof Some) {
            String s;
            Some some = (Some)option;
            string = s = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            String string3;
            Option option2 = Option$.MODULE$.apply((Object)System.getenv().getOrDefault(ruleName, System.getProperty(ruleName)));
            if (option2 instanceof Some) {
                String s;
                Some some = (Some)option2;
                string3 = s = (String)some.value();
            } else if (None$.MODULE$.equals(option2)) {
                Option option3 = resolvers.get((Object)ruleName);
                if (!(option3 instanceof Some)) {
                    if (None$.MODULE$.equals(option3)) {
                        throw new PropertyResolverException(new StringBuilder(29).append("Unable to resolve property [").append(rule).append("]").toString());
                    }
                    throw new MatchError((Object)option3);
                }
                Some some = (Some)option3;
                Function1 r = (Function1)some.value();
                String string4 = (String)r.apply((Object)ruleName);
                string3 = string4;
            } else {
                throw new MatchError((Object)option2);
            }
            string = string3;
        } else {
            throw new MatchError((Object)option);
        }
        String result = string;
        result = (String)mods.foldLeft((Object)result, (Function2 & Serializable & scala.Serializable)(a, b) -> (String)((Function2)b._1()).apply(a, b._2()));
        return result;
    }

    public String resolve(ContainerIdentifierService idSvc, String line) {
        String result;
        block2: {
            result = line;
            while (result.indexOf(this.startDelim) != -1) {
                Tuple3<String, String, String> tuple3 = this.extractRule(result);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                String prefix = (String)tuple3._1();
                String rule = (String)tuple3._2();
                String suffix = (String)tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)prefix, (Object)rule, (Object)suffix);
                Tuple3 tuple33 = tuple32;
                String prefix2 = (String)tuple33._1();
                String rule2 = (String)tuple33._2();
                String suffix2 = (String)tuple33._3();
                result = new StringBuilder(0).append(prefix2).append(this.processRule(idSvc, rule2)).append(suffix2).toString();
            }
            if (!this.log.isDebugEnabled()) break block2;
            this.log.debug(new StringBuilder(17).append("Resolved [").append(line).append("] to [").append(result).append("]").toString());
        }
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$processRule$9(Map modifiers$1, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String modName = (String)tuple2._1();
        boolean bl = modifiers$1.contains((Object)modName);
        return bl;
    }

    private ContainerPropertyResolver$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger((String)"blended.container.context.api.ContainerPropertyResolver");
        this.startDelim = "$[[";
        this.endDelim = "]]";
    }
}

