/*
 * Decompiled with CFR 0.152.
 */
package blended.camel.utils;

import blended.camel.utils.CamelServletProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import org.apache.camel.component.servlet.HttpRegistry;
import org.apache.camel.http.common.CamelServlet;
import org.apache.camel.http.common.HttpConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WOQHTTPRegistry
implements HttpRegistry {
    private static final transient Logger LOG = LoggerFactory.getLogger(WOQHTTPRegistry.class);
    private static HttpRegistry singleton;
    private final Set<HttpConsumer> consumers = new HashSet<HttpConsumer>();
    private final Set<CamelServlet> providers = new HashSet<CamelServlet>();

    public static synchronized HttpRegistry getSingletonHttpRegistry() {
        if (singleton == null) {
            singleton = new WOQHTTPRegistry();
        }
        return singleton;
    }

    public void register(HttpConsumer consumer) {
        LOG.debug("Registering consumer for path {} providers present: {}", (Object)consumer.getPath(), (Object)this.providers.size());
        this.consumers.add(consumer);
        for (CamelServlet provider : this.providers) {
            provider.connect(consumer);
        }
    }

    public void unregister(HttpConsumer consumer) {
        LOG.debug("Unregistering consumer for path {} ", (Object)consumer.getPath());
        this.consumers.remove(consumer);
        for (CamelServlet provider : this.providers) {
            provider.disconnect(consumer);
        }
    }

    public void register(CamelServletProvider provider, Map properties) {
        LOG.info("Registering provider through OSGi service listener {}", (Object)properties);
        try {
            CamelServlet camelServlet = provider.getCamelServlet();
            camelServlet.setServletName((String)properties.get("servlet-name"));
            this.register(camelServlet);
        }
        catch (ClassCastException cce) {
            LOG.info("Provider is not a Camel Servlet");
        }
    }

    public void unregister(CamelServletProvider provider, Map<String, Object> properties) {
        LOG.info("Deregistering provider through OSGi service listener {}", properties);
        try {
            CamelServlet camelServlet = provider.getCamelServlet();
            this.unregister((CamelServlet)provider);
        }
        catch (ClassCastException cce) {
            LOG.info("Provider is not a Camel Servlet");
        }
    }

    public void register(CamelServlet provider) {
        LOG.debug("Registering CamelServlet with name {} consumers present: {}", (Object)provider.getServletName(), (Object)this.consumers.size());
        this.providers.add(provider);
        for (HttpConsumer consumer : this.consumers) {
            provider.connect(consumer);
        }
    }

    public void unregister(CamelServlet provider) {
        this.providers.remove(provider);
    }

    public void setServlets(List<Servlet> servlets) {
        this.providers.clear();
        for (Servlet servlet : servlets) {
            if (!(servlet instanceof CamelServlet)) continue;
            this.providers.add((CamelServlet)servlet);
        }
    }

    public CamelServlet getCamelServlet(String servletName) {
        for (CamelServlet servlet : this.providers) {
            if (!servlet.getServletName().equals(servletName)) continue;
            return servlet;
        }
        return null;
    }
}

