/*
 * Decompiled with CFR 0.152.
 */
package blended.camel.utils;

import blended.camel.utils.EndpointURIFactory;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;

public class EndpointURIDispatcher {
    private final EndpointURIFactory uriFactory;

    public EndpointURIDispatcher(EndpointURIFactory uriFactory) {
        this.uriFactory = uriFactory;
    }

    public void dispatch(Exchange exchange) throws Exception {
        String[] endpointUris = this.uriFactory.createEndpointUris(exchange);
        if (endpointUris != null && endpointUris.length > 0) {
            ProducerTemplate template = exchange.getContext().createProducerTemplate();
            for (String uri : endpointUris) {
                template.send(uri, exchange);
            }
        }
    }
}

