/*
 * Decompiled with CFR 0.152.
 */
package blended.akka.http.restjms.internal;

import akka.NotUsed;
import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.ScalaActorRef;
import akka.actor.SupervisorStrategy;
import akka.actor.Terminated;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.marshalling.ToResponseMarshallable$;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.HttpResponse$;
import akka.http.scaladsl.model.ResponseEntity;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.PathMatcher;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.StandardRoute;
import akka.http.scaladsl.server.util.ApplyConverter$;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import akka.stream.Graph;
import akka.stream.KillSwitch;
import akka.stream.Materializer$;
import akka.stream.OverflowStrategy$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString$;
import blended.akka.OSGIActorConfig;
import blended.akka.http.restjms.internal.JmsOperationConfig;
import blended.akka.http.restjms.internal.RestJMSConfig;
import blended.akka.http.restjms.internal.RestJMSConfig$;
import blended.akka.http.restjms.internal.SimpleRestJmsService$ActorWatcher$;
import blended.jms.bridge.BridgeProviderConfig;
import blended.jms.bridge.BridgeProviderRegistry;
import blended.jms.utils.IdAwareConnectionFactory;
import blended.jms.utils.JmsDestination;
import blended.jms.utils.JmsQueue;
import blended.streams.BlendedStreamsConfig;
import blended.streams.FlowHeaderConfig;
import blended.streams.FlowHeaderConfig$;
import blended.streams.FlowProcessor$;
import blended.streams.StreamController;
import blended.streams.StreamController$;
import blended.streams.StreamFactories$;
import blended.streams.jms.AcknowledgeMode;
import blended.streams.jms.JmsConsumerSettings;
import blended.streams.jms.JmsConsumerSettings$;
import blended.streams.jms.JmsConsumerStage;
import blended.streams.jms.JmsConsumerStage$;
import blended.streams.jms.JmsDeliveryMode;
import blended.streams.jms.JmsEnvelopeHeader;
import blended.streams.jms.JmsKeyFormatStrategy;
import blended.streams.jms.JmsProducerSettings;
import blended.streams.jms.JmsProducerSettings$;
import blended.streams.jms.JmsProducerStage;
import blended.streams.jms.JmsStreamSupport;
import blended.streams.jms.MessageDestinationResolver;
import blended.streams.jms.PassThroughKeyFormatStrategy;
import blended.streams.message.BinaryFlowMessage;
import blended.streams.message.FlowEnvelope;
import blended.streams.message.FlowEnvelope$;
import blended.streams.message.FlowEnvelopeLogger;
import blended.streams.message.FlowEnvelopeLogger$;
import blended.streams.message.FlowMessage;
import blended.streams.message.FlowMessage$;
import blended.streams.message.TextFlowMessage;
import blended.streams.processor.Collector;
import blended.util.logging.LogLevel$;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\r\rg\u0001\u0002)R\u0001qC\u0001b\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\to\u0002\u0011\t\u0011)A\u0005q\"AA\u0010\u0001B\u0001B\u0003%Q\u0010\u0003\u0006\u0002\u0004\u0001\u0011\t\u0011)A\u0005\u0003\u000bA!\"a\u0005\u0001\u0005\u0003\u0005\u000b\u0011BA\u000b\u0011\u001d\t\t\u0003\u0001C\u0001\u0003GA\u0011\"a\r\u0001\u0005\u0004%I!!\u000e\t\u0011\u0005\u0015\u0003\u0001)A\u0005\u0003oA\u0011\"a\u0012\u0001\u0005\u0004%Y!!\u0013\t\u0011\u0005e\u0003\u0001)A\u0005\u0003\u0017B\u0011\"a\u0017\u0001\u0005\u0004%Y!!\u0018\t\u0011\u0005-\u0004\u0001)A\u0005\u0003?B\u0011\"!\u001c\u0001\u0005\u0004%I!a\u001c\t\u0011\u0005\u0005\u0005\u0001)A\u0005\u0003cB\u0011\"a!\u0001\u0005\u0004%I!!\"\t\u0011\u00055\u0005\u0001)A\u0005\u0003\u000fC\u0011\"a$\u0001\u0005\u0004%I!!\"\t\u0011\u0005E\u0005\u0001)A\u0005\u0003\u000fC\u0011\"a%\u0001\u0005\u0004%I!!&\t\u0011\u0005u\u0005\u0001)A\u0005\u0003/C\u0011\"a(\u0001\u0005\u0004%I!!)\t\u0011\u0005=\u0006\u0001)A\u0005\u0003GC\u0011\"!-\u0001\u0005\u0004%I!a-\t\u000f\u0005U\u0006\u0001)A\u0005Y\"I\u0011q\u0017\u0001C\u0002\u0013%\u0011\u0011\u0018\u0005\t\u0003\u0017\u0004\u0001\u0015!\u0003\u0002<\"I\u0011Q\u001a\u0001C\u0002\u0013%\u0011q\u001a\u0005\t\u0003/\u0004\u0001\u0015!\u0003\u0002R\"I\u0011\u0011\u001c\u0001C\u0002\u0013%\u00111\u001c\u0005\t\u0003G\u0004\u0001\u0015!\u0003\u0002^\"I\u0011Q\u001d\u0001C\u0002\u0013%\u0011q\u001d\u0005\t\u0003k\u0004\u0001\u0015!\u0003\u0002j\"I\u0011q\u001f\u0001C\u0002\u0013%\u0011\u0011 \u0005\t\u0005\u0003\u0001\u0001\u0015!\u0003\u0002|\"I!\u0011\u0002\u0001C\u0002\u0013%!1\u0002\u0005\t\u0005'\u0001\u0001\u0015!\u0003\u0003\u000e!I!Q\u0003\u0001C\u0002\u0013%!q\u0003\u0005\t\u0005\u000f\u0002\u0001\u0015!\u0003\u0003\u001a!I!\u0011\n\u0001C\u0002\u0013%!1\u0002\u0005\t\u0005\u0017\u0002\u0001\u0015!\u0003\u0003\u000e!I!Q\n\u0001C\u0002\u0013%!q\n\u0005\t\u0005/\u0002\u0001\u0015!\u0003\u0003R!9!\u0011\f\u0001\u0005\n\tm\u0003\"\u0003B9\u0001\t\u0007I\u0011\u0002B:\u0011!\u0011Y\t\u0001Q\u0001\n\tU\u0004\"\u0003BG\u0001\t\u0007I\u0011\u0002BH\u0011!\u00119\n\u0001Q\u0001\n\tE\u0005\"\u0003BM\u0001\t\u0007I\u0011\u0002BN\u0011!\u0011)\u000b\u0001Q\u0001\n\tu\u0005\"\u0003BT\u0001\u0001\u0007I\u0011\u0002BU\u0011%\u0011\t\f\u0001a\u0001\n\u0013\u0011\u0019\f\u0003\u0005\u0003@\u0002\u0001\u000b\u0015\u0002BV\u0011%\u0011\t\r\u0001a\u0001\n\u0013\u0011I\u000bC\u0005\u0003D\u0002\u0001\r\u0011\"\u0003\u0003F\"A!\u0011\u001a\u0001!B\u0013\u0011Y\u000bC\u0005\u0003L\u0002\u0001\r\u0011\"\u0003\u0003*\"I!Q\u001a\u0001A\u0002\u0013%!q\u001a\u0005\t\u0005'\u0004\u0001\u0015)\u0003\u0003,\"9!Q\u001b\u0001\u0005\u0002\t]\u0007b\u0002Bm\u0001\u0011\u0005!q\u001b\u0005\n\u00057\u0004!\u0019!C\u0001\u0005;D\u0001b!\u0001\u0001A\u0003%!q\u001c\u0005\b\u0007\u0007\u0001A\u0011BB\u0003\u0011\u001d\u0019)\u0003\u0001C\u0005\u0007OAqa!\u000f\u0001\t\u0013\u0019Y\u0004C\u0004\u0004T\u0001!Ia!\u0016\t\u000f\ru\u0003\u0001\"\u0003\u0004`!91Q\r\u0001\u0005\n\r\u001d\u0004bBB6\u0001\u0011%1Q\u000e\u0005\b\u0007\u000f\u0003A\u0011BBE\u000f\u001d\u0019i\t\u0001E\u0005\u0007\u001f3qaa%\u0001\u0011\u0013\u0019)\nC\u0004\u0002\"!#\taa&\t\u000f\re\u0005\n\"\u0001\u0004\u001c\u001a111\u0013\u0001\u0005\u0007OC!b!*L\u0005\u0003\u0005\u000b\u0011\u0002BP\u0011\u001d\t\tc\u0013C\u0001\u0007_Cqa!.L\t\u0003\u00129\u000eC\u0004\u00048.#\te!/\u0003)MKW\u000e\u001d7f%\u0016\u001cHOS7t'\u0016\u0014h/[2f\u0015\t\u00116+\u0001\u0005j]R,'O\\1m\u0015\t!V+A\u0004sKN$(.\\:\u000b\u0005Y;\u0016\u0001\u00025uiBT!\u0001W-\u0002\t\u0005\\7.\u0019\u0006\u00025\u00069!\r\\3oI\u0016$7\u0001A\n\u0004\u0001u\u001b\u0007C\u00010b\u001b\u0005y&\"\u00011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t|&AB!osJ+g\r\u0005\u0002eS6\tQM\u0003\u0002gO\u0006\u0019!.\\:\u000b\u0005!L\u0016aB:ue\u0016\fWn]\u0005\u0003U\u0016\u0014\u0011CS7t\u000b:4X\r\\8qK\"+\u0017\rZ3s\u0003\u0011q\u0017-\\3\u0011\u00055$hB\u00018s!\tyw,D\u0001q\u0015\t\t8,\u0001\u0004=e>|GOP\u0005\u0003g~\u000ba\u0001\u0015:fI\u00164\u0017BA;w\u0005\u0019\u0019FO]5oO*\u00111oX\u0001\b_N<\u0017n\u00114h!\tI(0D\u0001X\u0013\tYxKA\bP'\u001eK\u0015i\u0019;pe\u000e{gNZ5h\u00035\u0019HO]3b[N\u001cuN\u001c4jOB\u0011ap`\u0007\u0002O&\u0019\u0011\u0011A4\u0003)\tcWM\u001c3fIN#(/Z1ng\u000e{gNZ5h\u0003!\u0011XmZ5tiJL\b\u0003BA\u0004\u0003\u001fi!!!\u0003\u000b\t\u0005-\u0011QB\u0001\u0007EJLGmZ3\u000b\u0005\u0019L\u0016\u0002BA\t\u0003\u0013\u0011aC\u0011:jI\u001e,\u0007K]8wS\u0012,'OU3hSN$(/_\u0001\u0003G\u001a\u0004B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti!A\u0003vi&d7/\u0003\u0003\u0002 \u0005e!\u0001G%e\u0003^\f'/Z\"p]:,7\r^5p]\u001a\u000b7\r^8ss\u00061A(\u001b8jiz\"B\"!\n\u0002*\u0005-\u0012QFA\u0018\u0003c\u00012!a\n\u0001\u001b\u0005\t\u0006\"B6\u0007\u0001\u0004a\u0007\"B<\u0007\u0001\u0004A\b\"\u0002?\u0007\u0001\u0004i\bbBA\u0002\r\u0001\u0007\u0011Q\u0001\u0005\b\u0003'1\u0001\u0019AA\u000b\u0003=y\u0007/\u001a:bi&|g\u000eS3bI\u0016\u0014XCAA\u001c!\u0011\tI$a\u0011\u000e\u0005\u0005m\"\u0002BA\u001f\u0003\u007f\tA\u0001\\1oO*\u0011\u0011\u0011I\u0001\u0005U\u00064\u0018-C\u0002v\u0003w\t\u0001c\u001c9fe\u0006$\u0018n\u001c8IK\u0006$WM\u001d\u0011\u0002\rML8\u000f^3n+\t\tY\u0005\u0005\u0003\u0002N\u0005USBAA(\u0015\u0011\t\t&a\u0015\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003aKA!a\u0016\u0002P\tY\u0011i\u0019;peNK8\u000f^3n\u0003\u001d\u0019\u0018p\u001d;f[\u0002\nQ!Z\"uqR,\"!a\u0018\u0011\t\u0005\u0005\u0014qM\u0007\u0003\u0003GR1!!\u001a`\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003S\n\u0019G\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u00061Qm\u0011;yi\u0002\n1\u0001\\8h+\t\t\t\b\u0005\u0003\u0002t\u0005uTBAA;\u0015\u0011\t9(!\u001f\u0002\u000f1|wmZ5oO*\u0019\u00111P-\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u007f\n)H\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%\u0001\tj]R,'O\\1m!J|g/\u001b3feV\u0011\u0011q\u0011\t\u0005\u0003\u000f\tI)\u0003\u0003\u0002\f\u0006%!\u0001\u0006\"sS\u0012<W\r\u0015:pm&$WM]\"p]\u001aLw-A\tj]R,'O\\1m!J|g/\u001b3fe\u0002\n1\"\u001b8uKJt\u0017\r\\\"gO\u0006a\u0011N\u001c;fe:\fGn\u00114hA\u0005I\u0001.Z1eKJ\u001cemZ\u000b\u0003\u0003/\u00032A`AM\u0013\r\tYj\u001a\u0002\u0011\r2|w\u000fS3bI\u0016\u00148i\u001c8gS\u001e\f!\u0002[3bI\u0016\u00148IZ4!\u0003%)gN\u001e'pO\u001e,'/\u0006\u0002\u0002$B!\u0011QUAV\u001b\t\t9KC\u0002\u0002*\u001e\fq!\\3tg\u0006<W-\u0003\u0003\u0002.\u0006\u001d&A\u0005$m_^,eN^3m_B,Gj\\4hKJ\f!\"\u001a8w\u0019><w-\u001a:!\u0003-IGmU3qCJ\fGo\u001c:\u0016\u00031\fA\"\u001b3TKB\f'/\u0019;pe\u0002\n1\u0003Z3gCVdGoQ8oi\u0016tG\u000fV=qKN,\"!a/\u0011\r\u0005u\u0016qYA\u001c\u001b\t\tyL\u0003\u0003\u0002B\u0006\r\u0017!C5n[V$\u0018M\u00197f\u0015\r\t)mX\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAe\u0003\u007f\u0013A\u0001T5ti\u0006!B-\u001a4bk2$8i\u001c8uK:$H+\u001f9fg\u0002\n!B]3ti\u000e{gNZ5h+\t\t\t\u000e\u0005\u0003\u0002(\u0005M\u0017bAAk#\ni!+Z:u\u00156\u001b6i\u001c8gS\u001e\f1B]3ti\u000e{gNZ5hA\u0005\u0019\"/Z:q_:\u001cX\rR3ti&t\u0017\r^5p]V\u0011\u0011Q\u001c\t\u0005\u0003/\ty.\u0003\u0003\u0002b\u0006e!A\u0004&ng\u0012+7\u000f^5oCRLwN\\\u0001\u0015e\u0016\u001c\bo\u001c8tK\u0012+7\u000f^5oCRLwN\u001c\u0011\u0002\u0015=\u0004XM]1uS>t7/\u0006\u0002\u0002jB1Q.a;m\u0003_L1!!<w\u0005\ri\u0015\r\u001d\t\u0005\u0003O\t\t0C\u0002\u0002tF\u0013!CS7t\u001fB,'/\u0019;j_:\u001cuN\u001c4jO\u0006Yq\u000e]3sCRLwN\\:!\u0003)9\u0018N]3uCBTUn]\u000b\u0003\u0003w\u0014R!!@^\u0005\u00071a!a@#\u0001\u0005m(\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0014aC<je\u0016$\u0018\r\u001d&ng\u0002\u00022\u0001\u001aB\u0003\u0013\r\u00119!\u001a\u0002\u0011\u00156\u001c8\u000b\u001e:fC6\u001cV\u000f\u001d9peR\fqb^5sKR\f\u0007oU3ui&twm]\u000b\u0003\u0005\u001b\u00012\u0001\u001aB\b\u0013\r\u0011\t\"\u001a\u0002\u0014\u00156\u001c\bK]8ek\u000e,'oU3ui&twm]\u0001\u0011o&\u0014X\r^1q'\u0016$H/\u001b8hg\u0002\nq\u0002]3oI&twMU3rk\u0016\u001cHo]\u000b\u0003\u00053\u0001rAa\u0007\u0003\"1\u0014\u0019#\u0004\u0002\u0003\u001e)!!qDAb\u0003\u001diW\u000f^1cY\u0016LA!!<\u0003\u001eA9aL!\n\u0003*\tm\u0012b\u0001B\u0014?\n1A+\u001e9mKJ\u0002BAa\u000b\u000385\u0011!Q\u0006\u0006\u0005\u0005_\u0011\t$A\u0003n_\u0012,GN\u0003\u0003\u00034\tU\u0012\u0001C:dC2\fGm\u001d7\u000b\u0007Y\u000b\u0019&\u0003\u0003\u0003:\t5\"a\u0003%uiB\u0014V-];fgR\u0004b!!\u0019\u0003>\t\u0005\u0013\u0002\u0002B \u0003G\u0012q\u0001\u0015:p[&\u001cX\r\u0005\u0003\u0003,\t\r\u0013\u0002\u0002B#\u0005[\u0011A\u0002\u0013;uaJ+7\u000f]8og\u0016\f\u0001\u0003]3oI&twMU3rk\u0016\u001cHo\u001d\u0011\u0002!A\u0014x\u000eZ;dKJ\u001cV\r\u001e;j]\u001e\u001c\u0018!\u00059s_\u0012,8-\u001a:TKR$\u0018N\\4tA\u0005\u00012m\u001c8tk6,'oU3ui&twm]\u000b\u0003\u0005#\u00022\u0001\u001aB*\u0013\r\u0011)&\u001a\u0002\u0014\u00156\u001c8i\u001c8tk6,'oU3ui&twm]\u0001\u0012G>t7/^7feN+G\u000f^5oON\u0004\u0013aC:f]\u0012<\u0016N]3uCB$bA!\u0018\u0003d\t\u001d\u0004\u0003BAS\u0005?JAA!\u0019\u0002(\naa\t\\8x\u000b:4X\r\\8qK\"9!QM\u0016A\u0002\tu\u0013aA3om\"9!\u0011N\u0016A\u0002\t-\u0014!C5t%\u0016\fX/Z:u!\rq&QN\u0005\u0004\u0005_z&a\u0002\"p_2,\u0017M\\\u0001\ng\u0016tG\rV8K[N,\"A!\u001e\u0011\u0015\t]$q\u0010B/\u0005;\u0012\u0019)\u0004\u0002\u0003z)!!1\u0007B>\u0015\u0011\u0011i(a\u0015\u0002\rM$(/Z1n\u0013\u0011\u0011\tI!\u001f\u0003\t\u0019cwn\u001e\t\u0005\u0005\u000b\u00139)\u0004\u0002\u0002T%!!\u0011RA*\u0005\u001dqu\u000e^+tK\u0012\f!b]3oIR{'*\\:!\u0003-\u0011Xm\u001d9p]N,7K]2\u0016\u0005\tE\u0005\u0003\u0003B<\u0005'\u0013iFa!\n\t\tU%\u0011\u0010\u0002\u0007'>,(oY3\u0002\u0019I,7\u000f]8og\u0016\u001c&o\u0019\u0011\u0002\u0015I,\u0017/^3tiN\u00138-\u0006\u0002\u0003\u001eBA!q\u000fBJ\u0005;\u0012y\n\u0005\u0003\u0002N\t\u0005\u0016\u0002\u0002BR\u0003\u001f\u0012\u0001\"Q2u_J\u0014VMZ\u0001\fe\u0016\fX/Z:u'J\u001c\u0007%\u0001\u0007sKF,Xm\u001d;BGR|'/\u0006\u0002\u0003,B)aL!,\u0003 &\u0019!qV0\u0003\r=\u0003H/[8o\u0003A\u0011X-];fgR\f5\r^8s?\u0012*\u0017\u000f\u0006\u0003\u00036\nm\u0006c\u00010\u00038&\u0019!\u0011X0\u0003\tUs\u0017\u000e\u001e\u0005\n\u0005{\u001b\u0014\u0011!a\u0001\u0005W\u000b1\u0001\u001f\u00132\u00035\u0011X-];fgR\f5\r^8sA\u0005i!/Z9vKN$8\u000b\u001e:fC6\f\u0011C]3rk\u0016\u001cHo\u0015;sK\u0006lw\fJ3r)\u0011\u0011)La2\t\u0013\tuf'!AA\u0002\t-\u0016A\u0004:fcV,7\u000f^*ue\u0016\fW\u000eI\u0001\u000fe\u0016\u001c\bo\u001c8tKN#(/Z1n\u0003I\u0011Xm\u001d9p]N,7\u000b\u001e:fC6|F%Z9\u0015\t\tU&\u0011\u001b\u0005\n\u0005{K\u0014\u0011!a\u0001\u0005W\u000bqB]3ta>t7/Z*ue\u0016\fW\u000eI\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0005k\u000bAa\u001d;pa\u0006I\u0001\u000e\u001e;q%>,H/Z\u000b\u0003\u0005?\u0004BA!9\u0003|:!!1\u001dB{\u001d\u0011\u0011)O!=\u000f\t\t\u001d(q\u001e\b\u0005\u0005S\u0014iOD\u0002p\u0005WL\u0011\u0001W\u0005\u0004-\u0006M\u0013\u0002\u0002B\u001a\u0005kIAAa=\u00032\u000511/\u001a:wKJLAAa>\u0003z\u00069\u0001/Y2lC\u001e,'\u0002\u0002Bz\u0005cIAA!@\u0003\u0000\n)!k\\;uK*!!q\u001fB}\u0003)AG\u000f\u001e9S_V$X\rI\u0001\u000eM&dG/\u001a:IK\u0006$WM]:\u0015\t\r\u001d11\u0003\t\u0007\u0003{\u001bIa!\u0004\n\t\r-\u0011q\u0018\u0002\u0004'\u0016\f\b\u0003\u0002B\u0016\u0007\u001fIAa!\u0005\u0003.\tQ\u0001\n\u001e;q\u0011\u0016\fG-\u001a:\t\u000f\rUq\b1\u0001\u0004\u0018\u00059\u0001.Z1eKJ\u001c\bCBB\r\u0007C\u0019iA\u0004\u0003\u0004\u001c\r}abA8\u0004\u001e%\t\u0001-C\u0002\u0003x~KAaa\u0003\u0004$)\u0019!q_0\u0002\u001dA,'OZ8s[J+\u0017/^3tiRA1\u0011FB\u0018\u0007g\u00199\u0004\u0005\u0004\u0002b\r-\"\u0011I\u0005\u0005\u0007[\t\u0019G\u0001\u0004GkR,(/\u001a\u0005\u0007\u0007c\u0001\u0005\u0019\u00017\u0002\u000b=\u00048*Z=\t\u000f\rU\u0002\t1\u0001\u0003*\u00059!/Z9vKN$\bbBA)\u0001\u0002\u0007!qT\u0001\re\u0016\fX/Z:u%\u0016\u0004H.\u001f\u000b\r\u0007S\u0019id!\u0011\u0004F\r=3\u0011\u000b\u0005\u0007\u0007\u007f\t\u0005\u0019\u00017\u0002\u0013=\u0004XM]1uS>t\u0007bBB\"\u0003\u0002\u0007\u0011q^\u0001\u0006_B\u001cem\u001a\u0005\b\u0007\u000f\n\u0005\u0019AB%\u0003\u0015\u0019G+\u001f9f!\u0011\u0011Yca\u0013\n\t\r5#Q\u0006\u0002\f\u0007>tG/\u001a8u)f\u0004X\rC\u0004\u00046\u0005\u0003\rA!\u000b\t\u000f\u0005E\u0013\t1\u0001\u0003 \u0006i1\r[3dW\u000e{W\u000e\u001d7fi\u0016$bA!.\u0004X\rm\u0003BBB-\u0005\u0002\u0007A.\u0001\u0002jI\"911\t\"A\u0002\u0005=\u0018AC1eIJ+\u0017/^3tiR11\u0011FB1\u0007GBaa!\u0017D\u0001\u0004a\u0007bBB\u001b\u0007\u0002\u0007!\u0011F\u0001\u000ee\u0016lwN^3SKF,Xm\u001d;\u0015\t\tU6\u0011\u000e\u0005\u0007\u00073\"\u0005\u0019\u00017\u0002\u001dQLW.Z8viJ+\u0017/^3tiR11qNB;\u0007o\u00022AXB9\u0013\r\u0019\u0019h\u0018\u0002\u0004\u0003:L\bBBB-\u000b\u0002\u0007A\u000eC\u0004\u0004z\u0015\u0003\raa\u001f\u0002\u000fQLW.Z8viB!1QPBB\u001b\t\u0019yH\u0003\u0003\u0004\u0002\u0006\r\u0014\u0001\u00033ve\u0006$\u0018n\u001c8\n\t\r\u00155q\u0010\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u00039A\u0017M\u001c3mKJ+7\u000f]8og\u0016$BA!.\u0004\f\"9!Q\r$A\u0002\tu\u0013\u0001D!di>\u0014x+\u0019;dQ\u0016\u0014\bcABI\u00116\t\u0001A\u0001\u0007BGR|'oV1uG\",'o\u0005\u0002I;R\u00111qR\u0001\u0006aJ|\u0007o\u001d\u000b\u0005\u0007;\u001b\u0019\u000b\u0005\u0003\u0002N\r}\u0015\u0002BBQ\u0003\u001f\u0012Q\u0001\u0015:paNDqa!*K\u0001\u0004\u0011y*A\u0004xCR\u001c\u0007.\u001a3\u0014\t-k6\u0011\u0016\t\u0005\u0003\u001b\u001aY+\u0003\u0003\u0004.\u0006=#!B!di>\u0014H\u0003BBY\u0007g\u00032a!%L\u0011\u001d\u0019)+\u0014a\u0001\u0005?\u000b\u0001\u0002\u001d:f'R\f'\u000f^\u0001\be\u0016\u001cW-\u001b<f+\t\u0019Y\f\u0005\u0003\u0004>\u000e}V\"A&\n\t\r\u000571\u0016\u0002\b%\u0016\u001cW-\u001b<f\u0001")
public class SimpleRestJmsService
implements JmsEnvelopeHeader {
    private volatile SimpleRestJmsService$ActorWatcher$ ActorWatcher$module;
    private final String name;
    private final OSGIActorConfig osgiCfg;
    private final BlendedStreamsConfig streamsConfig;
    private final String operationHeader;
    private final ActorSystem system;
    private final ExecutionContext eCtxt;
    private final Logger blended$akka$http$restjms$internal$SimpleRestJmsService$$log;
    private final BridgeProviderConfig internalProvider;
    private final BridgeProviderConfig internalCfg;
    private final FlowHeaderConfig headerCfg;
    private final FlowEnvelopeLogger envLogger;
    private final String idSeparator;
    private final List<String> defaultContentTypes;
    private final RestJMSConfig restConfig;
    private final JmsDestination responseDestination;
    private final scala.collection.immutable.Map<String, JmsOperationConfig> operations;
    private final JmsStreamSupport wiretapJms;
    private final JmsProducerSettings wiretapSettings;
    private final Map<String, Tuple2<HttpRequest, Promise<HttpResponse>>> pendingRequests;
    private final JmsProducerSettings producerSettings;
    private final JmsConsumerSettings consumerSettings;
    private final Flow<FlowEnvelope, FlowEnvelope, NotUsed> sendToJms;
    private final Source<FlowEnvelope, NotUsed> responseSrc;
    private final Source<FlowEnvelope, ActorRef> requestSrc;
    private Option<ActorRef> requestActor;
    private Option<ActorRef> requestStream;
    private Option<ActorRef> responseStream;
    private final Function1<RequestContext, Future<RouteResult>> httpRoute;
    private Function1<String, String> jmsHeaderPrefix;
    private Function1<String, String> srcVendorHeader;
    private Function1<String, String> srcProviderHeader;
    private Function1<String, String> srcDestHeader;
    private Function1<String, String> destHeader;
    private Function1<String, String> corrIdHeader;
    private Function1<String, String> priorityHeader;
    private Function1<String, String> expireHeader;
    private Function1<String, String> deliveryModeHeader;
    private Function1<String, String> replyToHeader;
    private Function1<String, String> timestampHeader;
    private Function1<String, String> typeHeader;
    private Function1<String, String> msgIdHeader;
    private Function1<String, String> redeliveryHeader;
    private String replyToQueueName;

    private SimpleRestJmsService$ActorWatcher$ ActorWatcher() {
        if (this.ActorWatcher$module == null) {
            this.ActorWatcher$lzycompute$1();
        }
        return this.ActorWatcher$module;
    }

    public Function1<String, String> jmsHeaderPrefix() {
        return this.jmsHeaderPrefix;
    }

    public Function1<String, String> srcVendorHeader() {
        return this.srcVendorHeader;
    }

    public Function1<String, String> srcProviderHeader() {
        return this.srcProviderHeader;
    }

    public Function1<String, String> srcDestHeader() {
        return this.srcDestHeader;
    }

    public Function1<String, String> destHeader() {
        return this.destHeader;
    }

    public Function1<String, String> corrIdHeader() {
        return this.corrIdHeader;
    }

    public Function1<String, String> priorityHeader() {
        return this.priorityHeader;
    }

    public Function1<String, String> expireHeader() {
        return this.expireHeader;
    }

    public Function1<String, String> deliveryModeHeader() {
        return this.deliveryModeHeader;
    }

    public Function1<String, String> replyToHeader() {
        return this.replyToHeader;
    }

    public Function1<String, String> timestampHeader() {
        return this.timestampHeader;
    }

    public Function1<String, String> typeHeader() {
        return this.typeHeader;
    }

    public Function1<String, String> msgIdHeader() {
        return this.msgIdHeader;
    }

    public Function1<String, String> redeliveryHeader() {
        return this.redeliveryHeader;
    }

    public String replyToQueueName() {
        return this.replyToQueueName;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$jmsHeaderPrefix_$eq(Function1<String, String> x$1) {
        this.jmsHeaderPrefix = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcVendorHeader_$eq(Function1<String, String> x$1) {
        this.srcVendorHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcProviderHeader_$eq(Function1<String, String> x$1) {
        this.srcProviderHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcDestHeader_$eq(Function1<String, String> x$1) {
        this.srcDestHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$destHeader_$eq(Function1<String, String> x$1) {
        this.destHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$corrIdHeader_$eq(Function1<String, String> x$1) {
        this.corrIdHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$priorityHeader_$eq(Function1<String, String> x$1) {
        this.priorityHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$expireHeader_$eq(Function1<String, String> x$1) {
        this.expireHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$deliveryModeHeader_$eq(Function1<String, String> x$1) {
        this.deliveryModeHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$replyToHeader_$eq(Function1<String, String> x$1) {
        this.replyToHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$timestampHeader_$eq(Function1<String, String> x$1) {
        this.timestampHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$typeHeader_$eq(Function1<String, String> x$1) {
        this.typeHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$msgIdHeader_$eq(Function1<String, String> x$1) {
        this.msgIdHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$redeliveryHeader_$eq(Function1<String, String> x$1) {
        this.redeliveryHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$replyToQueueName_$eq(String x$1) {
        this.replyToQueueName = x$1;
    }

    private String operationHeader() {
        return this.operationHeader;
    }

    private ActorSystem system() {
        return this.system;
    }

    private ExecutionContext eCtxt() {
        return this.eCtxt;
    }

    public Logger blended$akka$http$restjms$internal$SimpleRestJmsService$$log() {
        return this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log;
    }

    private BridgeProviderConfig internalProvider() {
        return this.internalProvider;
    }

    private BridgeProviderConfig internalCfg() {
        return this.internalCfg;
    }

    private FlowHeaderConfig headerCfg() {
        return this.headerCfg;
    }

    private FlowEnvelopeLogger envLogger() {
        return this.envLogger;
    }

    private String idSeparator() {
        return this.idSeparator;
    }

    private List<String> defaultContentTypes() {
        return this.defaultContentTypes;
    }

    private RestJMSConfig restConfig() {
        return this.restConfig;
    }

    private JmsDestination responseDestination() {
        return this.responseDestination;
    }

    private scala.collection.immutable.Map<String, JmsOperationConfig> operations() {
        return this.operations;
    }

    private JmsStreamSupport wiretapJms() {
        return this.wiretapJms;
    }

    private JmsProducerSettings wiretapSettings() {
        return this.wiretapSettings;
    }

    private Map<String, Tuple2<HttpRequest, Promise<HttpResponse>>> pendingRequests() {
        return this.pendingRequests;
    }

    private JmsProducerSettings producerSettings() {
        return this.producerSettings;
    }

    private JmsConsumerSettings consumerSettings() {
        return this.consumerSettings;
    }

    private FlowEnvelope sendWiretap(FlowEnvelope env, boolean isRequest) {
        env.header(this.operationHeader(), ManifestFactory$.MODULE$.classType(String.class)).foreach((Function1 & Serializable)opName -> {
            SimpleRestJmsService.$anonfun$sendWiretap$1(this, isRequest, env, opName);
            return BoxedUnit.UNIT;
        });
        return env;
    }

    private Flow<FlowEnvelope, FlowEnvelope, NotUsed> sendToJms() {
        return this.sendToJms;
    }

    private Source<FlowEnvelope, NotUsed> responseSrc() {
        return this.responseSrc;
    }

    private Source<FlowEnvelope, ActorRef> requestSrc() {
        return this.requestSrc;
    }

    private Option<ActorRef> requestActor() {
        return this.requestActor;
    }

    private void requestActor_$eq(Option<ActorRef> x$1) {
        this.requestActor = x$1;
    }

    private Option<ActorRef> requestStream() {
        return this.requestStream;
    }

    private void requestStream_$eq(Option<ActorRef> x$1) {
        this.requestStream = x$1;
    }

    private Option<ActorRef> responseStream() {
        return this.responseStream;
    }

    private void responseStream_$eq(Option<ActorRef> x$1) {
        this.responseStream = x$1;
    }

    public void start() {
        this.requestStream_$eq((Option<ActorRef>)new Some((Object)this.system().actorOf(StreamController$.MODULE$.props(new StringBuilder(5).append(this.name).append("-send").toString(), this.requestSrc(), this.streamsConfig, (Function1 & Serializable)a -> {
            SimpleRestJmsService.$anonfun$start$1(this, a);
            return BoxedUnit.UNIT;
        }))));
        this.responseStream_$eq((Option<ActorRef>)new Some((Object)this.system().actorOf(StreamController$.MODULE$.props(new StringBuilder(9).append(this.name).append("-response").toString(), this.responseSrc(), this.streamsConfig, (Function1 & Serializable)x$3 -> {
            SimpleRestJmsService.$anonfun$start$3(x$3);
            return BoxedUnit.UNIT;
        }))));
    }

    public void stop() {
        this.requestStream().foreach((Function1 & Serializable)x$4 -> {
            SimpleRestJmsService.$anonfun$stop$1(x$4);
            return BoxedUnit.UNIT;
        });
        this.responseStream().foreach((Function1 & Serializable)x$5 -> {
            SimpleRestJmsService.$anonfun$stop$2(x$5);
            return BoxedUnit.UNIT;
        });
    }

    public Function1<RequestContext, Future<RouteResult>> httpRoute() {
        return this.httpRoute;
    }

    private Seq<HttpHeader> filterHeaders(Seq<HttpHeader> headers) {
        Seq notAllowedInResponses = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Host", "Accept-Encoding", "User-Agent", "Timeout-Access"}));
        return ((IterableOnceOps)headers.filterNot((Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)notAllowedInResponses.contains((Object)h.name())))).toList();
    }

    private Future<HttpResponse> performRequest(String opKey, HttpRequest request, ActorRef actor) {
        Future future;
        Option option = this.operations().get((Object)opKey);
        if (None$.MODULE$.equals(option)) {
            this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().warn((Function0 & Serializable)() -> new StringBuilder(36).append("Http operation [").append(opKey).append("] is not configured.").toString());
            future = Future$.MODULE$.apply((Function0 & Serializable)() -> {
                StatusCodes.ClientError x$1 = StatusCodes$.MODULE$.NotFound();
                HttpEntity.Strict x$2 = new HttpEntity.Strict(request.entity().contentType(), ByteString$.MODULE$.empty());
                Seq<HttpHeader> x$3 = this.filterHeaders((Seq<HttpHeader>)request.headers());
                HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
                return HttpResponse$.MODULE$.apply((StatusCode)x$1, x$3, (ResponseEntity)x$2, x$4);
            }, this.eCtxt());
        } else if (option instanceof Some) {
            Future future2;
            List list;
            Some some = (Some)option;
            JmsOperationConfig opCfg = (JmsOperationConfig)some.value();
            ContentType cType = request.entity().contentType();
            Option<List<String>> option2 = opCfg.contentTypes();
            if (None$.MODULE$.equals(option2)) {
                list = this.defaultContentTypes();
            } else if (option2 instanceof Some) {
                List l;
                Some some2 = (Some)option2;
                list = l = (List)some2.value();
            } else {
                throw new MatchError(option2);
            }
            List validContentTypes = list;
            List list2 = validContentTypes.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SimpleRestJmsService.$anonfun$performRequest$3(cType, x$6)));
            Nil$ nil$ = scala.package$.MODULE$.Nil();
            List list3 = list2;
            if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().warn((Function0 & Serializable)() -> new StringBuilder(30).append("Content-Type [").append(cType.value()).append("] not supported.").toString());
                future2 = Future$.MODULE$.apply((Function0 & Serializable)() -> {
                    StatusCodes.ServerError x$5 = StatusCodes$.MODULE$.InternalServerError();
                    HttpEntity.Strict x$6 = HttpEntity$.MODULE$.apply(cType, ByteString$.MODULE$.empty());
                    Seq<HttpHeader> x$7 = this.filterHeaders((Seq<HttpHeader>)request.headers());
                    HttpProtocol x$8 = HttpResponse$.MODULE$.apply$default$4();
                    return HttpResponse$.MODULE$.apply((StatusCode)x$5, x$7, (ResponseEntity)x$6, x$8);
                }, this.eCtxt());
            } else if (list2 instanceof .colon.colon) {
                future2 = this.requestReply(opKey, opCfg, cType, request, actor);
            } else {
                throw new MatchError((Object)list2);
            }
            future = future2;
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    private Future<HttpResponse> requestReply(String operation, JmsOperationConfig opCfg, ContentType cType, HttpRequest request, ActorRef actor) {
        Future data = (Future)request.entity().getDataBytes().asScala().runWith((Graph)Sink$.MODULE$.seq(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.system()));
        return data.map((Function1 & Serializable)result -> {
            byte[] content = (byte[])((IterableOnceOps)result.flatten(Predef$.MODULE$.$conforms())).toArray((ClassTag)ClassTag$.MODULE$.Byte());
            String envId = UUID.randomUUID().toString();
            Seq header = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.operationHeader()), (Object)operation), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.destHeader().apply((Object)this.headerCfg().prefix())), (Object)opCfg.destination()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.replyToHeader().apply((Object)this.headerCfg().prefix())), (Object)String.valueOf(this.responseDestination().name())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.corrIdHeader().apply((Object)this.headerCfg().prefix())), (Object)new StringBuilder(2).append($this.osgiCfg.ctContext().uuid()).append("##").append(envId).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Content-Type"), (Object)cType.mediaType().value())})).$plus$plus((IterableOnce)opCfg.header().map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
                return tuple22;
            }));
            FlowEnvelope env = FlowEnvelope$.MODULE$.apply(FlowMessage$.MODULE$.apply(content, (scala.collection.immutable.Map)FlowMessage$.MODULE$.props(header).get()), envId);
            this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().debug((Function0 & Serializable)() -> new StringBuilder(62).append("Received request [").append(env.id()).append("] of length [").append(content.length).append("], encoding [").append(opCfg.encoding()).append("], content type [").append(cType.mediaType()).append("]").toString());
            this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().debug((Function0 & Serializable)() -> new StringBuilder(22).append("Request envelope is [").append(env).append("]").toString());
            Future<HttpResponse> response = this.addRequest(env.id(), request);
            this.system().scheduler().scheduleOnce(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(opCfg.timeout())).millis(), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.timeoutRequest(env.id(), new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(opCfg.timeout())).millis()), this.eCtxt());
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(actor);
            FlowEnvelope x$1 = env;
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
            this.checkComplete(env.id(), opCfg);
            return response;
        }, this.eCtxt()).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void checkComplete(String id, JmsOperationConfig opCfg) {
        SimpleRestJmsService simpleRestJmsService = this;
        synchronized (simpleRestJmsService) {
            BoxedUnit boxedUnit;
            Some some;
            Tuple2 tuple2;
            Option option = this.pendingRequests().get((Object)id);
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                BoxedUnit boxedUnit2;
                HttpRequest req = (HttpRequest)tuple2._1();
                Promise p = (Promise)tuple2._2();
                if (!opCfg.jmsReply()) {
                    StatusCodes.Success x$1 = opCfg.isSoap() ? StatusCodes$.MODULE$.Accepted() : StatusCodes$.MODULE$.OK();
                    HttpEntity.Strict x$2 = HttpEntity$.MODULE$.apply(req.entity().contentType(), ByteString$.MODULE$.empty());
                    Seq<HttpHeader> x$3 = this.filterHeaders((Seq<HttpHeader>)req.headers());
                    HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
                    boxedUnit2 = p.complete((Try)new Success((Object)HttpResponse$.MODULE$.apply((StatusCode)x$1, x$3, (ResponseEntity)x$2, x$4)));
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else if (None$.MODULE$.equals(option)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    private synchronized Future<HttpResponse> addRequest(String id, HttpRequest request) {
        Promise p = Promise$.MODULE$.apply();
        this.pendingRequests().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)id), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)request), (Object)p)));
        p.future().onComplete((Function1 & Serializable)x$7 -> {
            SimpleRestJmsService.$anonfun$addRequest$1(this, id, x$7);
            return BoxedUnit.UNIT;
        }, this.eCtxt());
        return p.future();
    }

    private void removeRequest(String id) {
        SimpleRestJmsService simpleRestJmsService = this;
        synchronized (simpleRestJmsService) {
            Map cfr_ignored_0 = (Map)this.pendingRequests().$minus$eq((Object)id);
        }
    }

    private synchronized Object timeoutRequest(String id, FiniteDuration timeout) {
        BoxedUnit boxedUnit;
        Some some;
        Tuple2 tuple2;
        Option option = this.pendingRequests().get((Object)id);
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            HttpRequest req = (HttpRequest)tuple2._1();
            Promise p = (Promise)tuple2._2();
            this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().warn((Function0 & Serializable)() -> new StringBuilder(33).append("Request [").append(id).append("] has timed out after [").append(timeout).append("]").toString());
            StatusCodes.ServerError x$1 = StatusCodes$.MODULE$.InternalServerError();
            HttpEntity.Strict x$2 = HttpEntity$.MODULE$.apply(req.entity().contentType(), ByteString$.MODULE$.empty());
            Seq<HttpHeader> x$3 = this.filterHeaders((Seq<HttpHeader>)req.headers());
            HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
            boxedUnit = p.complete((Try)new Success((Object)HttpResponse$.MODULE$.apply((StatusCode)x$1, x$3, (ResponseEntity)x$2, x$4)));
        } else if (None$.MODULE$.equals(option)) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
        return boxedUnit;
    }

    private void handleResponse(FlowEnvelope env) {
        SimpleRestJmsService simpleRestJmsService = this;
        synchronized (simpleRestJmsService) {
            BoxedUnit boxedUnit;
            Some some;
            Tuple2 tuple2;
            Option option = this.pendingRequests().get((Object)env.id());
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Promise promise;
                HttpRequest req = (HttpRequest)tuple2._1();
                Promise p = (Promise)tuple2._2();
                this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().info((Function0 & Serializable)() -> new StringBuilder(37).append("Received response for HTTP request [").append(env).append("]").toString());
                this.sendWiretap(env, false);
                Option option2 = env.exception();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Throwable t = (Throwable)some2.value();
                    this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().warn(t, this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().warn$default$2(), (Function0 & Serializable)() -> t.getMessage());
                    promise = p.complete((Try)new Failure(t));
                } else if (None$.MODULE$.equals(option2)) {
                    StatusCodes.Success x$1 = StatusCodes$.MODULE$.OK();
                    ResponseEntity x$2 = SimpleRestJmsService.createEntity$1(req, env.flowMessage());
                    Seq<HttpHeader> x$3 = this.filterHeaders((Seq<HttpHeader>)req.headers());
                    HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
                    promise = p.complete((Try)new Success((Object)HttpResponse$.MODULE$.apply((StatusCode)x$1, x$3, x$2, x$4)));
                } else {
                    throw new MatchError((Object)option2);
                }
                boxedUnit = promise;
            } else if (None$.MODULE$.equals(option)) {
                this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().warn((Function0 & Serializable)() -> new StringBuilder(43).append("No pending request for received response [").append(env).append("]").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    private final void ActorWatcher$lzycompute$1() {
        SimpleRestJmsService simpleRestJmsService = this;
        synchronized (simpleRestJmsService) {
            if (this.ActorWatcher$module == null) {
                this.ActorWatcher$module = new SimpleRestJmsService$ActorWatcher$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$sendWiretap$1(SimpleRestJmsService $this, boolean isRequest$1, FlowEnvelope env$1, String opName) {
        JmsOperationConfig opCfg = (JmsOperationConfig)$this.restConfig().operations().apply((Object)opName);
        Option<String> resType2 = isRequest$1 ? opCfg.reqResourceType() : opCfg.respResourceType();
        resType2.foreach((Function1 & Serializable)resType -> {
            $this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().info((Function0 & Serializable)() -> new StringBuilder(43).append("Sending wiretap [").append(env$1.id()).append("] [").append((Object)(isRequest$1 ? "request" : "response")).append("] to dispatcher with [").append((String)resType).append("]").toString());
            FlowEnvelope qual$1 = (FlowEnvelope)env$1.withHeader($this.headerCfg().headerResourceType(), resType, env$1.withHeader$default$3()).get();
            String x$1 = $this.headerCfg().headerBridgeVendor();
            String x$2 = $this.internalCfg().vendor();
            boolean x$3 = qual$1.withHeader$default$3();
            FlowEnvelope qual$2 = (FlowEnvelope)qual$1.withHeader(x$1, (Object)x$2, x$3).get();
            String x$4 = $this.headerCfg().headerBridgeProvider();
            String x$5 = $this.internalCfg().provider();
            boolean x$6 = qual$2.withHeader$default$3();
            FlowEnvelope qual$3 = (FlowEnvelope)qual$2.withHeader(x$4, (Object)x$5, x$6).get();
            String x$7 = (String)$this.destHeader().apply((Object)$this.headerCfg().prefix());
            String x$8 = $this.internalCfg().inbound().asString();
            boolean x$9 = qual$3.withHeader$default$3();
            FlowEnvelope wiretapMsg = ((FlowEnvelope)qual$3.withHeader(x$7, (Object)x$8, x$9).get()).removeHeader((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)$this.replyToHeader().apply((Object)$this.headerCfg().prefix())}));
            FlowEnvelope toSend = (FlowEnvelope)opCfg.wiretapTtl().fold((Function0 & Serializable)() -> wiretapMsg.removeHeader((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)$this.expireHeader().apply((Object)$this.headerCfg().prefix())})), (Function1 & Serializable)ttl -> (FlowEnvelope)wiretapMsg.withHeader((String)$this.expireHeader().apply((Object)$this.headerCfg().prefix()), (Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() + ttl.toMillis())), wiretapMsg.withHeader$default$3()).get());
            $this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().debug((Function0 & Serializable)() -> new StringBuilder(18).append("Wiretap message : ").append(toSend).toString());
            return $this.wiretapJms().sendMessages($this.wiretapSettings(), $this.envLogger(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FlowEnvelope[]{toSend}), $this.system());
        });
    }

    public static final /* synthetic */ void $anonfun$start$1(SimpleRestJmsService $this, ActorRef a) {
        $this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().debug((Function0 & Serializable)() -> new StringBuilder(37).append("Stream actor [").append($this.name).append("] has been started : [").append(a).append("]").toString());
        $this.osgiCfg.system().actorOf($this.ActorWatcher().props(a));
        $this.requestActor_$eq((Option<ActorRef>)new Some((Object)a));
    }

    public static final /* synthetic */ void $anonfun$start$3(NotUsed x$3) {
    }

    public static final /* synthetic */ void $anonfun$stop$1(ActorRef x$4) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(x$4);
        StreamController.Stop$ x$1 = StreamController.Stop$.MODULE$;
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public static final /* synthetic */ void $anonfun$stop$2(ActorRef x$5) {
        ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(x$5);
        StreamController.Stop$ x$3 = StreamController.Stop$.MODULE$;
        ActorRef x$4 = qual$2.$bang$default$2((Object)x$3);
        qual$2.$bang((Object)x$3, x$4);
    }

    public static final /* synthetic */ void $anonfun$httpRoute$7(SimpleRestJmsService $this, Try r) {
        $this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().info((Function0 & Serializable)() -> new StringBuilder(19).append("Http response is [").append(r).append("]").toString());
    }

    public static final /* synthetic */ boolean $anonfun$performRequest$3(ContentType cType$1, String x$6) {
        String string = x$6;
        String string2 = cType$1.mediaType().value();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$addRequest$1(SimpleRestJmsService $this, String id$1, Try x$7) {
        $this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().debug((Function0 & Serializable)() -> new StringBuilder(27).append("Cleaning up Http request [").append(id$1).append("]").toString());
        $this.removeRequest(id$1);
    }

    private static final ResponseEntity createEntity$1(HttpRequest req, FlowMessage msg) {
        HttpEntity.Strict strict;
        FlowMessage flowMessage = msg;
        if (flowMessage instanceof TextFlowMessage) {
            TextFlowMessage textFlowMessage = (TextFlowMessage)flowMessage;
            strict = HttpEntity$.MODULE$.apply(req.entity().contentType(), textFlowMessage.getText().getBytes());
        } else if (flowMessage instanceof BinaryFlowMessage) {
            BinaryFlowMessage binaryFlowMessage = (BinaryFlowMessage)flowMessage;
            strict = HttpEntity$.MODULE$.apply(req.entity().contentType(), binaryFlowMessage.getBytes());
        } else {
            strict = HttpEntity$.MODULE$.apply(req.entity().contentType(), ByteString$.MODULE$.empty());
        }
        return strict;
    }

    public SimpleRestJmsService(String name, OSGIActorConfig osgiCfg, BlendedStreamsConfig streamsConfig, BridgeProviderRegistry registry, IdAwareConnectionFactory cf) {
        this.name = name;
        this.osgiCfg = osgiCfg;
        this.streamsConfig = streamsConfig;
        JmsEnvelopeHeader.$init$((JmsEnvelopeHeader)this);
        this.operationHeader = "RESTOperation";
        this.system = osgiCfg.system();
        this.eCtxt = this.system().dispatcher();
        this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log = Logger$.MODULE$.apply(new StringBuilder(1).append(this.getClass().getName()).append(".").append(name).toString());
        this.internalProvider = (BridgeProviderConfig)registry.internalProvider().get();
        this.internalCfg = (BridgeProviderConfig)registry.jmsProvider(this.internalProvider().vendor(), this.internalProvider().provider()).get();
        this.headerCfg = FlowHeaderConfig$.MODULE$.create(osgiCfg.ctContext());
        this.envLogger = FlowEnvelopeLogger$.MODULE$.create(this.headerCfg(), this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log());
        this.idSeparator = "##";
        this.defaultContentTypes = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"application/json", "text/xml"}));
        this.restConfig = RestJMSConfig$.MODULE$.fromConfig(osgiCfg.config());
        this.responseDestination = new JmsQueue(new StringBuilder(17).append("restJMS.").append(name).append(".response").toString());
        this.operations = this.restConfig().operations();
        this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().info((Function0 & Serializable)() -> new StringBuilder(32).append("Starting RestJMS Service with [").append(this.operations()).append("]").toString());
        this.wiretapJms = new JmsStreamSupport(null){

            public Try<KillSwitch> processMessages(Flow<FlowEnvelope, FlowEnvelope, ?> processFlow, FiniteDuration timeout, Seq<FlowEnvelope> msgs, ActorSystem system) {
                return JmsStreamSupport.processMessages$((JmsStreamSupport)this, processFlow, (FiniteDuration)timeout, msgs, (ActorSystem)system);
            }

            public Try<KillSwitch> sendMessages(JmsProducerSettings producerSettings, FlowEnvelopeLogger log, FiniteDuration timeout, Seq<FlowEnvelope> msgs, ActorSystem system) {
                return JmsStreamSupport.sendMessages$((JmsStreamSupport)this, (JmsProducerSettings)producerSettings, (FlowEnvelopeLogger)log, (FiniteDuration)timeout, msgs, (ActorSystem)system);
            }

            public Collector<FlowEnvelope> receiveMessages(FlowHeaderConfig headerCfg, IdAwareConnectionFactory cf, JmsDestination dest, FlowEnvelopeLogger log, Integer listener, Option<FiniteDuration> minMessageDelay, Option<String> selector, Option<Function1<Seq<FlowEnvelope>, Object>> completeOn, Option<FiniteDuration> timeout, FiniteDuration ackTimeout, ActorSystem system) {
                return JmsStreamSupport.receiveMessages$((JmsStreamSupport)this, (FlowHeaderConfig)headerCfg, (IdAwareConnectionFactory)cf, (JmsDestination)dest, (FlowEnvelopeLogger)log, (Integer)listener, minMessageDelay, selector, completeOn, timeout, (FiniteDuration)ackTimeout, (ActorSystem)system);
            }

            public Integer receiveMessages$default$5() {
                return JmsStreamSupport.receiveMessages$default$5$((JmsStreamSupport)this);
            }

            public Option<FiniteDuration> receiveMessages$default$6() {
                return JmsStreamSupport.receiveMessages$default$6$((JmsStreamSupport)this);
            }

            public Option<String> receiveMessages$default$7() {
                return JmsStreamSupport.receiveMessages$default$7$((JmsStreamSupport)this);
            }

            public Option<Function1<Seq<FlowEnvelope>, Object>> receiveMessages$default$8() {
                return JmsStreamSupport.receiveMessages$default$8$((JmsStreamSupport)this);
            }

            public Flow<FlowEnvelope, FlowEnvelope, NotUsed> jmsProducer(String name, JmsProducerSettings settings, boolean autoAck, ActorSystem system) {
                return JmsStreamSupport.jmsProducer$((JmsStreamSupport)this, (String)name, (JmsProducerSettings)settings, (boolean)autoAck, (ActorSystem)system);
            }

            public Source<FlowEnvelope, NotUsed> jmsConsumer(String name, JmsConsumerSettings settings, Option<FiniteDuration> minMessageDelay, ActorSystem system) {
                return JmsStreamSupport.jmsConsumer$((JmsStreamSupport)this, (String)name, (JmsConsumerSettings)settings, minMessageDelay, (ActorSystem)system);
            }
            {
                JmsStreamSupport.$init$((JmsStreamSupport)this);
            }
        };
        FlowEnvelopeLogger x$12 = this.envLogger();
        FlowHeaderConfig x$22 = this.headerCfg();
        IdAwareConnectionFactory x$3 = cf;
        Function1 & Serializable x$4 = (Function1 & Serializable)x$1 -> new MessageDestinationResolver(x$1);
        PassThroughKeyFormatStrategy x$5 = new PassThroughKeyFormatStrategy();
        Function1 x$6 = JmsProducerSettings$.MODULE$.apply$default$2();
        FiniteDuration x$7 = JmsProducerSettings$.MODULE$.apply$default$6();
        Option x$8 = JmsProducerSettings$.MODULE$.apply$default$7();
        int x$9 = JmsProducerSettings$.MODULE$.apply$default$8();
        int x$10 = JmsProducerSettings$.MODULE$.apply$default$10();
        JmsDeliveryMode x$11 = JmsProducerSettings$.MODULE$.apply$default$11();
        Option x$122 = JmsProducerSettings$.MODULE$.apply$default$12();
        Function0 x$13 = JmsProducerSettings$.MODULE$.apply$default$13();
        boolean x$14 = JmsProducerSettings$.MODULE$.apply$default$14();
        this.wiretapSettings = new JmsProducerSettings(x$12, x$6, x$22, (JmsKeyFormatStrategy)x$5, x$3, x$7, x$8, x$9, (Function1)x$4, x$10, x$11, x$122, x$13, x$14);
        this.pendingRequests = (Map)Map$.MODULE$.empty();
        FlowEnvelopeLogger x$15 = this.envLogger();
        FlowHeaderConfig x$16 = this.headerCfg();
        IdAwareConnectionFactory x$17 = cf;
        Function1 & Serializable x$18 = (Function1 & Serializable)s -> new MessageDestinationResolver(s);
        PassThroughKeyFormatStrategy x$19 = new PassThroughKeyFormatStrategy();
        Function1 x$20 = JmsProducerSettings$.MODULE$.apply$default$2();
        FiniteDuration x$21 = JmsProducerSettings$.MODULE$.apply$default$6();
        Option x$222 = JmsProducerSettings$.MODULE$.apply$default$7();
        int x$23 = JmsProducerSettings$.MODULE$.apply$default$8();
        int x$24 = JmsProducerSettings$.MODULE$.apply$default$10();
        JmsDeliveryMode x$25 = JmsProducerSettings$.MODULE$.apply$default$11();
        Option x$26 = JmsProducerSettings$.MODULE$.apply$default$12();
        Function0 x$27 = JmsProducerSettings$.MODULE$.apply$default$13();
        boolean x$28 = JmsProducerSettings$.MODULE$.apply$default$14();
        this.producerSettings = new JmsProducerSettings(x$15, x$20, x$16, (JmsKeyFormatStrategy)x$19, x$17, x$21, x$222, x$23, (Function1)x$18, x$24, x$25, x$26, x$27, x$28);
        FlowEnvelopeLogger x$29 = this.envLogger();
        FlowHeaderConfig x$30 = this.headerCfg();
        IdAwareConnectionFactory x$31 = cf;
        Some x$32 = new Some((Object)this.responseDestination());
        Function1 & Serializable x$33 = (Function1 & Serializable)x$2 -> LogLevel$.MODULE$.Debug();
        Some x$34 = new Some((Object)new StringBuilder(9).append(this.corrIdHeader().apply((Object)"")).append(" LIKE '").append(osgiCfg.ctContext().uuid()).append("%'").toString());
        PassThroughKeyFormatStrategy x$35 = new PassThroughKeyFormatStrategy();
        FiniteDuration x$36 = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second();
        FiniteDuration x$37 = JmsConsumerSettings$.MODULE$.apply$default$6();
        int x$38 = JmsConsumerSettings$.MODULE$.apply$default$8();
        FiniteDuration x$39 = JmsConsumerSettings$.MODULE$.apply$default$9();
        FiniteDuration x$40 = JmsConsumerSettings$.MODULE$.apply$default$10();
        AcknowledgeMode x$41 = JmsConsumerSettings$.MODULE$.apply$default$11();
        int x$42 = JmsConsumerSettings$.MODULE$.apply$default$12();
        Option x$43 = JmsConsumerSettings$.MODULE$.apply$default$15();
        this.consumerSettings = new JmsConsumerSettings(x$29, (Function1)x$33, x$30, (JmsKeyFormatStrategy)x$35, x$31, x$37, (Option)x$32, x$38, x$39, x$40, x$41, x$42, (Option)x$34, x$36, x$43);
        this.sendToJms = Flow$.MODULE$.fromGraph((Graph)new JmsProducerStage(new StringBuilder(5).append(name).append("-send").toString(), this.producerSettings(), this.system()));
        this.responseSrc = Source$.MODULE$.fromGraph((Graph)new JmsConsumerStage(new StringBuilder(9).append(name).append("-response").toString(), this.consumerSettings(), JmsConsumerStage$.MODULE$.$lessinit$greater$default$3(), this.system())).via(FlowProcessor$.MODULE$.fromFunction("handleResponse", this.envLogger(), (Function1 & Serializable)env -> Try$.MODULE$.apply((Function0 & Serializable)() -> {
            void var3_3;
            String corrId = (String)env.headerWithDefault((String)this.corrIdHeader().apply((Object)""), (Object)env.id(), ManifestFactory$.MODULE$.classType(String.class));
            FlowEnvelope responseEnv = ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])corrId.split(this.idSeparator()))) == 2 ? FlowEnvelope$.MODULE$.apply(env.flowMessage(), (String)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])corrId.split(this.idSeparator()))).last()) : env;
            this.handleResponse(responseEnv);
            return var3_3;
        })));
        this.requestSrc = StreamFactories$.MODULE$.actorSource(100, OverflowStrategy$.MODULE$.dropNew()).via(this.sendToJms()).via(FlowProcessor$.MODULE$.fromFunction(new StringBuilder(8).append(name).append("-wiretap").toString(), this.envLogger(), (Function1 & Serializable)env -> Try$.MODULE$.apply((Function0 & Serializable)() -> this.sendWiretap((FlowEnvelope)env, true))));
        this.requestActor = None$.MODULE$;
        this.requestStream = None$.MODULE$;
        this.responseStream = None$.MODULE$;
        this.httpRoute = (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.path((PathMatcher)Directives$.MODULE$.RemainingPath()), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)path -> (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.post()).apply((Function0 & Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.entity(Directives$.MODULE$.as(Unmarshaller$.MODULE$.identityUnmarshaller())), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)request -> {
            StandardRoute standardRoute;
            this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().info((Function0 & Serializable)() -> new StringBuilder(53).append("Http operation request received at [").append(path).append("] with headers [").append(request.headers()).append("]").toString());
            Option<ActorRef> option = this.requestActor();
            if (None$.MODULE$.equals(option)) {
                String msg = "JMS request reply stream is not ready";
                this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().warn((Function0 & Serializable)() -> msg);
                standardRoute = Directives$.MODULE$.complete((Function0 & Serializable)() -> {
                    StatusCodes.ServerError x$44 = StatusCodes$.MODULE$.InternalServerError();
                    HttpEntity.Strict x$45 = new HttpEntity.Strict(request.entity().contentType(), ByteString$.MODULE$.apply(msg));
                    Seq<HttpHeader> x$46 = this.filterHeaders((Seq<HttpHeader>)request.headers());
                    HttpProtocol x$47 = HttpResponse$.MODULE$.apply$default$4();
                    return ToResponseMarshallable$.MODULE$.apply((Object)HttpResponse$.MODULE$.apply((StatusCode)x$44, x$46, (ResponseEntity)x$45, x$47), Marshaller$.MODULE$.fromResponse());
                });
            } else if (option instanceof Some) {
                Some some = (Some)option;
                ActorRef a = (ActorRef)some.value();
                Future<HttpResponse> f = this.performRequest(path.toString(), (HttpRequest)request, a);
                f.onComplete((Function1 & Serializable)r -> {
                    SimpleRestJmsService.$anonfun$httpRoute$7(this, r);
                    return BoxedUnit.UNIT;
                }, this.eCtxt());
                standardRoute = Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)f, Marshaller$.MODULE$.futureMarshaller(Marshaller$.MODULE$.fromResponse())));
            } else {
                throw new MatchError(option);
            }
            return standardRoute;
        })));
        Statics.releaseFence();
    }

    private class ActorWatcher
    implements Actor {
        private final ActorRef watched;
        private ActorContext context;
        private ActorRef self;
        public final /* synthetic */ SimpleRestJmsService $outer;

        public final ActorRef sender() {
            return Actor.sender$((Actor)this);
        }

        @InternalApi
        public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
            Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
        }

        @InternalApi
        public void aroundPreStart() {
            Actor.aroundPreStart$((Actor)this);
        }

        @InternalApi
        public void aroundPostStop() {
            Actor.aroundPostStop$((Actor)this);
        }

        @InternalApi
        public void aroundPreRestart(Throwable reason, Option<Object> message) {
            Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
        }

        @InternalApi
        public void aroundPostRestart(Throwable reason) {
            Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
        }

        public SupervisorStrategy supervisorStrategy() {
            return Actor.supervisorStrategy$((Actor)this);
        }

        public void postStop() throws Exception {
            Actor.postStop$((Actor)this);
        }

        public void preRestart(Throwable reason, Option<Object> message) throws Exception {
            Actor.preRestart$((Actor)this, (Throwable)reason, message);
        }

        public void postRestart(Throwable reason) throws Exception {
            Actor.postRestart$((Actor)this, (Throwable)reason);
        }

        public void unhandled(Object message) {
            Actor.unhandled$((Actor)this, (Object)message);
        }

        public ActorContext context() {
            return this.context;
        }

        public final ActorRef self() {
            return this.self;
        }

        public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
            this.context = x$1;
        }

        public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
            this.self = x$1;
        }

        public void preStart() {
            this.context().watch(this.watched);
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ ActorWatcher $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof Terminated) {
                        Terminated terminated = (Terminated)A1;
                        ActorRef a = terminated.actor();
                        this.$outer.blended$akka$http$restjms$internal$SimpleRestJmsService$ActorWatcher$$$outer().blended$akka$http$restjms$internal$SimpleRestJmsService$$log().info((Function0 & Serializable)() -> new StringBuilder(23).append("Actor [").append(a).append("] has terminated").toString());
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof Terminated;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(akka.actor.ActorRef )}, serializedLambda);
                }
            };
        }

        public /* synthetic */ SimpleRestJmsService blended$akka$http$restjms$internal$SimpleRestJmsService$ActorWatcher$$$outer() {
            return this.$outer;
        }

        public ActorWatcher(SimpleRestJmsService $outer, ActorRef watched) {
            this.watched = watched;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Actor.$init$((Actor)this);
            Statics.releaseFence();
        }
    }
}

