/*
 * Decompiled with CFR 0.152.
 */
package blended.akka.http.restjms.internal;

import akka.NotUsed;
import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.ScalaActorRef;
import akka.actor.SupervisorStrategy;
import akka.actor.Terminated;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.marshalling.ToResponseMarshallable$;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.HttpResponse$;
import akka.http.scaladsl.model.ResponseEntity;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.PathMatcher;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.StandardRoute;
import akka.http.scaladsl.server.util.ApplyConverter$;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import akka.stream.Graph;
import akka.stream.Materializer$;
import akka.stream.OverflowStrategy$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString$;
import blended.akka.OSGIActorConfig;
import blended.akka.http.restjms.internal.JmsOperationConfig;
import blended.akka.http.restjms.internal.RestJMSConfig;
import blended.akka.http.restjms.internal.RestJMSConfig$;
import blended.akka.http.restjms.internal.SimpleRestJmsService$ActorWatcher$;
import blended.jms.utils.IdAwareConnectionFactory;
import blended.jms.utils.JmsDestination;
import blended.jms.utils.JmsQueue;
import blended.streams.BlendedStreamsConfig;
import blended.streams.FlowHeaderConfig;
import blended.streams.FlowHeaderConfig$;
import blended.streams.FlowProcessor$;
import blended.streams.StreamController;
import blended.streams.StreamController$;
import blended.streams.StreamFactories$;
import blended.streams.jms.AcknowledgeMode;
import blended.streams.jms.JmsConsumerSettings;
import blended.streams.jms.JmsConsumerSettings$;
import blended.streams.jms.JmsConsumerStage;
import blended.streams.jms.JmsConsumerStage$;
import blended.streams.jms.JmsDeliveryMode;
import blended.streams.jms.JmsEnvelopeHeader;
import blended.streams.jms.JmsKeyFormatStrategy;
import blended.streams.jms.JmsProducerSettings;
import blended.streams.jms.JmsProducerSettings$;
import blended.streams.jms.JmsProducerStage;
import blended.streams.jms.MessageDestinationResolver;
import blended.streams.jms.PassThroughKeyFormatStrategy;
import blended.streams.message.BinaryFlowMessage;
import blended.streams.message.FlowEnvelope;
import blended.streams.message.FlowEnvelope$;
import blended.streams.message.FlowEnvelopeLogger;
import blended.streams.message.FlowEnvelopeLogger$;
import blended.streams.message.FlowMessage;
import blended.streams.message.FlowMessage$;
import blended.streams.message.TextFlowMessage;
import blended.util.logging.LogLevel$;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\r}c\u0001\u0002#F\u0001AC\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tW\u0002\u0011\t\u0011)A\u0005Y\"A\u0001\u000f\u0001B\u0001B\u0003%\u0011\u000f\u0003\u0005v\u0001\t\u0005\t\u0015!\u0003w\u0011\u0015i\b\u0001\"\u0001\u007f\u0011%\tY\u0001\u0001b\u0001\n\u0017\ti\u0001\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\b\u0011%\ty\u0002\u0001b\u0001\n\u0017\t\t\u0003\u0003\u0005\u00020\u0001\u0001\u000b\u0011BA\u0012\u0011%\t\t\u0004\u0001b\u0001\n\u0013\t\u0019\u0004\u0003\u0005\u0002F\u0001\u0001\u000b\u0011BA\u001b\u0011%\t9\u0005\u0001b\u0001\n\u0013\tI\u0005\u0003\u0005\u0002R\u0001\u0001\u000b\u0011BA&\u0011%\t\u0019\u0006\u0001b\u0001\n\u0013\t)\u0006\u0003\u0005\u0002d\u0001\u0001\u000b\u0011BA,\u0011%\t)\u0007\u0001b\u0001\n\u0013\t9\u0007C\u0004\u0002j\u0001\u0001\u000b\u0011\u00021\t\u0013\u0005-\u0004A1A\u0005\n\u00055\u0004\u0002CAG\u0001\u0001\u0006I!a\u001c\t\u0013\u0005=\u0005A1A\u0005\n\u0005E\u0005\u0002CAM\u0001\u0001\u0006I!a%\t\u0013\u0005m\u0005A1A\u0005\n\u0005u\u0005\u0002CAS\u0001\u0001\u0006I!a(\t\u0013\u0005\u001d\u0006A1A\u0005\n\u0005%\u0006\u0002CA\\\u0001\u0001\u0006I!a+\t\u0013\u0005e\u0006A1A\u0005\n\u0005m\u0006\u0002CAv\u0001\u0001\u0006I!!0\t\u0013\u00055\bA1A\u0005\n\u0005=\b\u0002CA|\u0001\u0001\u0006I!!=\t\u0013\u0005e\bA1A\u0005\n\u0005m\b\u0002\u0003B\u0002\u0001\u0001\u0006I!!@\t\u0013\t\u0015\u0001A1A\u0005\n\t\u001d\u0001\u0002\u0003B\u0013\u0001\u0001\u0006IA!\u0003\t\u0013\t\u001d\u0002A1A\u0005\n\t%\u0002\u0002\u0003B\u0019\u0001\u0001\u0006IAa\u000b\t\u0013\tM\u0002A1A\u0005\n\tU\u0002\u0002\u0003B \u0001\u0001\u0006IAa\u000e\t\u0013\t\u0005\u0003\u00011A\u0005\n\t\r\u0003\"\u0003B&\u0001\u0001\u0007I\u0011\u0002B'\u0011!\u0011I\u0006\u0001Q!\n\t\u0015\u0003\"\u0003B.\u0001\u0001\u0007I\u0011\u0002B\"\u0011%\u0011i\u0006\u0001a\u0001\n\u0013\u0011y\u0006\u0003\u0005\u0003d\u0001\u0001\u000b\u0015\u0002B#\u0011%\u0011)\u0007\u0001a\u0001\n\u0013\u0011\u0019\u0005C\u0005\u0003h\u0001\u0001\r\u0011\"\u0003\u0003j!A!Q\u000e\u0001!B\u0013\u0011)\u0005C\u0004\u0003p\u0001!\tA!\u001d\t\u000f\tM\u0004\u0001\"\u0001\u0003r!I!Q\u000f\u0001C\u0002\u0013\u0005!q\u000f\u0005\t\u00057\u0003\u0001\u0015!\u0003\u0003z!9!Q\u0014\u0001\u0005\n\t}\u0005b\u0002B`\u0001\u0011%!\u0011\u0019\u0005\b\u0005'\u0004A\u0011\u0002Bk\u0011\u001d\u0011i\u000f\u0001C\u0005\u0005_DqAa>\u0001\t\u0013\u0011I\u0010C\u0004\u0003\u0000\u0002!Ia!\u0001\t\u000f\r\u0015\u0001\u0001\"\u0003\u0004\b!91\u0011\u0005\u0001\u0005\n\r\rraBB\u0015\u0001!%11\u0006\u0004\b\u0007_\u0001\u0001\u0012BB\u0019\u0011\u0019iH\b\"\u0001\u00044!91Q\u0007\u001f\u0005\u0002\r]bABB\u0018\u0001\u0011\u0019\u0019\u0005\u0003\u0006\u0004B}\u0012\t\u0011)A\u0005\u0005sAa!` \u0005\u0002\r-\u0003bBB)\u007f\u0011\u0005#\u0011\u000f\u0005\b\u0007'zD\u0011IB+\u0005Q\u0019\u0016.\u001c9mKJ+7\u000f\u001e&ngN+'O^5dK*\u0011aiR\u0001\tS:$XM\u001d8bY*\u0011\u0001*S\u0001\be\u0016\u001cHO[7t\u0015\tQ5*\u0001\u0003iiR\u0004(B\u0001'N\u0003\u0011\t7n[1\u000b\u00039\u000bqA\u00197f]\u0012,Gm\u0001\u0001\u0014\u0007\u0001\tv\u000b\u0005\u0002S+6\t1KC\u0001U\u0003\u0015\u00198-\u00197b\u0013\t16K\u0001\u0004B]f\u0014VM\u001a\t\u00031vk\u0011!\u0017\u0006\u00035n\u000b1A[7t\u0015\taV*A\u0004tiJ,\u0017-\\:\n\u0005yK&!\u0005&ng\u0016sg/\u001a7pa\u0016DU-\u00193fe\u0006!a.Y7f!\t\t\u0007N\u0004\u0002cMB\u00111mU\u0007\u0002I*\u0011QmT\u0001\u0007yI|w\u000e\u001e \n\u0005\u001d\u001c\u0016A\u0002)sK\u0012,g-\u0003\u0002jU\n11\u000b\u001e:j]\u001eT!aZ*\u0002\u000f=\u001cx-[\"gOB\u0011QN\\\u0007\u0002\u0017&\u0011qn\u0013\u0002\u0010\u001fN;\u0015*Q2u_J\u001cuN\u001c4jO\u0006i1\u000f\u001e:fC6\u001c8i\u001c8gS\u001e\u0004\"A]:\u000e\u0003mK!\u0001^.\u0003)\tcWM\u001c3fIN#(/Z1ng\u000e{gNZ5h\u0003\t\u0019g\r\u0005\u0002xw6\t\u0001P\u0003\u0002zu\u0006)Q\u000f^5mg*\u0011!,T\u0005\u0003yb\u0014\u0001$\u00133Bo\u0006\u0014XmQ8o]\u0016\u001cG/[8o\r\u0006\u001cGo\u001c:z\u0003\u0019a\u0014N\\5u}QIq0a\u0001\u0002\u0006\u0005\u001d\u0011\u0011\u0002\t\u0004\u0003\u0003\u0001Q\"A#\t\u000b}+\u0001\u0019\u00011\t\u000b-,\u0001\u0019\u00017\t\u000bA,\u0001\u0019A9\t\u000bU,\u0001\u0019\u0001<\u0002\rML8\u000f^3n+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005eQBAA\n\u0015\u0011\t)\"a\u0006\u0002\u000b\u0005\u001cGo\u001c:\u000b\u00031KA!a\u0007\u0002\u0014\tY\u0011i\u0019;peNK8\u000f^3n\u0003\u001d\u0019\u0018p\u001d;f[\u0002\nQ!Z\"uqR,\"!a\t\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000bT\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003[\t9C\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u00061Qm\u0011;yi\u0002\n1\u0001\\8h+\t\t)\u0004\u0005\u0003\u00028\u0005\u0005SBAA\u001d\u0015\u0011\tY$!\u0010\u0002\u000f1|wmZ5oO*\u0019\u0011qH'\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0007\nID\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%A\u0005iK\u0006$WM]\"gOV\u0011\u00111\n\t\u0004e\u00065\u0013bAA(7\n\u0001b\t\\8x\u0011\u0016\fG-\u001a:D_:4\u0017nZ\u0001\u000bQ\u0016\fG-\u001a:DM\u001e\u0004\u0013!C3om2{wmZ3s+\t\t9\u0006\u0005\u0003\u0002Z\u0005}SBAA.\u0015\r\tifW\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\t\t'a\u0017\u0003%\u0019cwn^#om\u0016dw\u000e]3M_\u001e<WM]\u0001\u000bK:4Hj\\4hKJ\u0004\u0013aC5e'\u0016\u0004\u0018M]1u_J,\u0012\u0001Y\u0001\rS\u0012\u001cV\r]1sCR|'\u000fI\u0001\u0014I\u00164\u0017-\u001e7u\u0007>tG/\u001a8u)f\u0004Xm]\u000b\u0003\u0003_\u0002b!!\u001d\u0002|\u0005}TBAA:\u0015\u0011\t)(a\u001e\u0002\u0013%lW.\u001e;bE2,'bAA='\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u00141\u000f\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0002\u0006-UBAAB\u0015\u0011\t))a\"\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0013\u000bAA[1wC&\u0019\u0011.a!\u0002)\u0011,g-Y;mi\u000e{g\u000e^3oiRK\b/Z:!\u0003)\u0011Xm\u001d;D_:4\u0017nZ\u000b\u0003\u0003'\u0003B!!\u0001\u0002\u0016&\u0019\u0011qS#\u0003\u001bI+7\u000f\u001e&N'\u000e{gNZ5h\u0003-\u0011Xm\u001d;D_:4\u0017n\u001a\u0011\u0002'I,7\u000f]8og\u0016$Um\u001d;j]\u0006$\u0018n\u001c8\u0016\u0005\u0005}\u0005cA<\u0002\"&\u0019\u00111\u0015=\u0003\u001d)k7\u000fR3ti&t\u0017\r^5p]\u0006!\"/Z:q_:\u001cX\rR3ti&t\u0017\r^5p]\u0002\n!b\u001c9fe\u0006$\u0018n\u001c8t+\t\tY\u000b\u0005\u0004b\u0003[\u0003\u0017\u0011W\u0005\u0004\u0003_S'aA'baB!\u0011\u0011AAZ\u0013\r\t),\u0012\u0002\u0013\u00156\u001cx\n]3sCRLwN\\\"p]\u001aLw-A\u0006pa\u0016\u0014\u0018\r^5p]N\u0004\u0013a\u00049f]\u0012Lgn\u001a*fcV,7\u000f^:\u0016\u0005\u0005u\u0006cBA`\u0003\u000b\u0004\u0017qY\u0007\u0003\u0003\u0003TA!a1\u0002x\u00059Q.\u001e;bE2,\u0017\u0002BAX\u0003\u0003\u0004rAUAe\u0003\u001b\fy.C\u0002\u0002LN\u0013a\u0001V;qY\u0016\u0014\u0004\u0003BAh\u00037l!!!5\u000b\t\u0005M\u0017Q[\u0001\u0006[>$W\r\u001c\u0006\u0005\u0003/\fI.\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\rQ\u0015qC\u0005\u0005\u0003;\f\tNA\u0006IiR\u0004(+Z9vKN$\bCBA\u0013\u0003C\f)/\u0003\u0003\u0002d\u0006\u001d\"a\u0002)s_6L7/\u001a\t\u0005\u0003\u001f\f9/\u0003\u0003\u0002j\u0006E'\u0001\u0004%uiB\u0014Vm\u001d9p]N,\u0017\u0001\u00059f]\u0012Lgn\u001a*fcV,7\u000f^:!\u0003A\u0001(o\u001c3vG\u0016\u00148+\u001a;uS:<7/\u0006\u0002\u0002rB\u0019\u0001,a=\n\u0007\u0005U\u0018LA\nK[N\u0004&o\u001c3vG\u0016\u00148+\u001a;uS:<7/A\tqe>$WoY3s'\u0016$H/\u001b8hg\u0002\n\u0001cY8ogVlWM]*fiRLgnZ:\u0016\u0005\u0005u\bc\u0001-\u0002\u0000&\u0019!\u0011A-\u0003')k7oQ8ogVlWM]*fiRLgnZ:\u0002#\r|gn];nKJ\u001cV\r\u001e;j]\u001e\u001c\b%A\u0005tK:$Gk\u001c&ngV\u0011!\u0011\u0002\t\u000b\u0005\u0017\u0011\u0019Ba\u0006\u0003\u0018\tuQB\u0001B\u0007\u0015\u0011\t9Na\u0004\u000b\t\tE\u0011qC\u0001\u0007gR\u0014X-Y7\n\t\tU!Q\u0002\u0002\u0005\r2|w\u000f\u0005\u0003\u0002Z\te\u0011\u0002\u0002B\u000e\u00037\u0012AB\u00127po\u0016sg/\u001a7pa\u0016\u0004BAa\b\u0003\"5\u0011\u0011qC\u0005\u0005\u0005G\t9BA\u0004O_R,6/\u001a3\u0002\u0015M,g\u000e\u001a+p\u00156\u001c\b%A\u0006sKN\u0004xN\\:f'J\u001cWC\u0001B\u0016!!\u0011YA!\f\u0003\u0018\tu\u0011\u0002\u0002B\u0018\u0005\u001b\u0011aaU8ve\u000e,\u0017\u0001\u0004:fgB|gn]3Te\u000e\u0004\u0013A\u0003:fcV,7\u000f^*sGV\u0011!q\u0007\t\t\u0005\u0017\u0011iCa\u0006\u0003:A!\u0011\u0011\u0003B\u001e\u0013\u0011\u0011i$a\u0005\u0003\u0011\u0005\u001bGo\u001c:SK\u001a\f1B]3rk\u0016\u001cHo\u0015:dA\u0005a!/Z9vKN$\u0018i\u0019;peV\u0011!Q\t\t\u0006%\n\u001d#\u0011H\u0005\u0004\u0005\u0013\u001a&AB(qi&|g.\u0001\tsKF,Xm\u001d;BGR|'o\u0018\u0013fcR!!q\nB+!\r\u0011&\u0011K\u0005\u0004\u0005'\u001a&\u0001B+oSRD\u0011Ba\u0016(\u0003\u0003\u0005\rA!\u0012\u0002\u0007a$\u0013'A\u0007sKF,Xm\u001d;BGR|'\u000fI\u0001\u000ee\u0016\fX/Z:u'R\u0014X-Y7\u0002#I,\u0017/^3tiN#(/Z1n?\u0012*\u0017\u000f\u0006\u0003\u0003P\t\u0005\u0004\"\u0003B,U\u0005\u0005\t\u0019\u0001B#\u00039\u0011X-];fgR\u001cFO]3b[\u0002\naB]3ta>t7/Z*ue\u0016\fW.\u0001\nsKN\u0004xN\\:f'R\u0014X-Y7`I\u0015\fH\u0003\u0002B(\u0005WB\u0011Ba\u0016.\u0003\u0003\u0005\rA!\u0012\u0002\u001fI,7\u000f]8og\u0016\u001cFO]3b[\u0002\nQa\u001d;beR$\"Aa\u0014\u0002\tM$x\u000e]\u0001\nQR$\bOU8vi\u0016,\"A!\u001f\u0011\t\tm$Q\u0013\b\u0005\u0005{\u0012yI\u0004\u0003\u0003\u0000\t-e\u0002\u0002BA\u0005\u0013sAAa!\u0003\b:\u00191M!\"\n\u00031K1ASA\f\u0013\u0011\t9.!7\n\t\t5\u0015Q[\u0001\u0007g\u0016\u0014h/\u001a:\n\t\tE%1S\u0001\ba\u0006\u001c7.Y4f\u0015\u0011\u0011i)!6\n\t\t]%\u0011\u0014\u0002\u0006%>,H/\u001a\u0006\u0005\u0005#\u0013\u0019*\u0001\u0006iiR\u0004(k\\;uK\u0002\nQBZ5mi\u0016\u0014\b*Z1eKJ\u001cH\u0003\u0002BQ\u0005[\u0003b!!\u001d\u0003$\n\u001d\u0016\u0002\u0002BS\u0003g\u00121aU3r!\u0011\tyM!+\n\t\t-\u0016\u0011\u001b\u0002\u000b\u0011R$\b\u000fS3bI\u0016\u0014\bb\u0002BXg\u0001\u0007!\u0011W\u0001\bQ\u0016\fG-\u001a:t!\u0019\u0011\u0019La/\u0003(:!!Q\u0017B]\u001d\r\u0019'qW\u0005\u0002)&\u0019!\u0011S*\n\t\t\u0015&Q\u0018\u0006\u0004\u0005#\u001b\u0016A\u00049fe\u001a|'/\u001c*fcV,7\u000f\u001e\u000b\t\u0005\u0007\u0014IM!4\u0003RB1\u0011Q\u0005Bc\u0003KLAAa2\u0002(\t1a)\u001e;ve\u0016DaAa35\u0001\u0004\u0001\u0017!B8q\u0017\u0016L\bb\u0002Bhi\u0001\u0007\u0011QZ\u0001\be\u0016\fX/Z:u\u0011\u001d\t)\u0002\u000ea\u0001\u0005s\tAB]3rk\u0016\u001cHOU3qYf$BBa1\u0003X\nm'q\u001cBu\u0005WDaA!76\u0001\u0004\u0001\u0017!C8qKJ\fG/[8o\u0011\u001d\u0011i.\u000ea\u0001\u0003c\u000bQa\u001c9DM\u001eDqA!96\u0001\u0004\u0011\u0019/A\u0003d)f\u0004X\r\u0005\u0003\u0002P\n\u0015\u0018\u0002\u0002Bt\u0003#\u00141bQ8oi\u0016tG\u000fV=qK\"9!qZ\u001bA\u0002\u00055\u0007bBA\u000bk\u0001\u0007!\u0011H\u0001\u000eG\",7m[\"p[BdW\r^3\u0015\r\t=#\u0011\u001fB{\u0011\u0019\u0011\u0019P\u000ea\u0001A\u0006\u0011\u0011\u000e\u001a\u0005\b\u0005;4\u0004\u0019AAY\u0003)\tG\r\u001a*fcV,7\u000f\u001e\u000b\u0007\u0005\u0007\u0014YP!@\t\r\tMx\u00071\u0001a\u0011\u001d\u0011ym\u000ea\u0001\u0003\u001b\fQB]3n_Z,'+Z9vKN$H\u0003\u0002B(\u0007\u0007AaAa=9\u0001\u0004\u0001\u0017A\u0004;j[\u0016|W\u000f\u001e*fcV,7\u000f\u001e\u000b\u0007\u0007\u0013\u0019ya!\u0005\u0011\u0007I\u001bY!C\u0002\u0004\u000eM\u00131!\u00118z\u0011\u0019\u0011\u00190\u000fa\u0001A\"911C\u001dA\u0002\rU\u0011a\u0002;j[\u0016|W\u000f\u001e\t\u0005\u0007/\u0019i\"\u0004\u0002\u0004\u001a)!11DA\u0014\u0003!!WO]1uS>t\u0017\u0002BB\u0010\u00073\u0011aBR5oSR,G)\u001e:bi&|g.\u0001\biC:$G.\u001a*fgB|gn]3\u0015\t\t=3Q\u0005\u0005\b\u0007OQ\u0004\u0019\u0001B\f\u0003\r)gN^\u0001\r\u0003\u000e$xN],bi\u000eDWM\u001d\t\u0004\u0007[aT\"\u0001\u0001\u0003\u0019\u0005\u001bGo\u001c:XCR\u001c\u0007.\u001a:\u0014\u0005q\nFCAB\u0016\u0003\u0015\u0001(o\u001c9t)\u0011\u0019Ida\u0010\u0011\t\u0005E11H\u0005\u0005\u0007{\t\u0019BA\u0003Qe>\u00048\u000fC\u0004\u0004By\u0002\rA!\u000f\u0002\u000f]\fGo\u00195fIN!q(UB#!\u0011\t\tba\u0012\n\t\r%\u00131\u0003\u0002\u0006\u0003\u000e$xN\u001d\u000b\u0005\u0007\u001b\u001ay\u0005E\u0002\u0004.}Bqa!\u0011B\u0001\u0004\u0011I$\u0001\u0005qe\u0016\u001cF/\u0019:u\u0003\u001d\u0011XmY3jm\u0016,\"aa\u0016\u0011\t\re31L\u0007\u0002\u007f%!1QLB$\u0005\u001d\u0011VmY3jm\u0016\u0004")
public class SimpleRestJmsService
implements JmsEnvelopeHeader {
    private volatile SimpleRestJmsService$ActorWatcher$ ActorWatcher$module;
    private final String name;
    private final OSGIActorConfig osgiCfg;
    private final BlendedStreamsConfig streamsConfig;
    private final ActorSystem system;
    private final ExecutionContext eCtxt;
    private final Logger blended$akka$http$restjms$internal$SimpleRestJmsService$$log;
    private final FlowHeaderConfig headerCfg;
    private final FlowEnvelopeLogger envLogger;
    private final String idSeparator;
    private final List<String> defaultContentTypes;
    private final RestJMSConfig restConfig;
    private final JmsDestination responseDestination;
    private final scala.collection.immutable.Map<String, JmsOperationConfig> operations;
    private final Map<String, Tuple2<HttpRequest, Promise<HttpResponse>>> pendingRequests;
    private final JmsProducerSettings producerSettings;
    private final JmsConsumerSettings consumerSettings;
    private final Flow<FlowEnvelope, FlowEnvelope, NotUsed> sendToJms;
    private final Source<FlowEnvelope, NotUsed> responseSrc;
    private final Source<FlowEnvelope, ActorRef> requestSrc;
    private Option<ActorRef> requestActor;
    private Option<ActorRef> requestStream;
    private Option<ActorRef> responseStream;
    private final Function1<RequestContext, Future<RouteResult>> httpRoute;
    private Function1<String, String> jmsHeaderPrefix;
    private Function1<String, String> srcVendorHeader;
    private Function1<String, String> srcProviderHeader;
    private Function1<String, String> srcDestHeader;
    private Function1<String, String> destHeader;
    private Function1<String, String> corrIdHeader;
    private Function1<String, String> priorityHeader;
    private Function1<String, String> expireHeader;
    private Function1<String, String> deliveryModeHeader;
    private Function1<String, String> replyToHeader;
    private Function1<String, String> timestampHeader;
    private Function1<String, String> typeHeader;
    private Function1<String, String> msgIdHeader;
    private String replyToQueueName;

    private SimpleRestJmsService$ActorWatcher$ ActorWatcher() {
        if (this.ActorWatcher$module == null) {
            this.ActorWatcher$lzycompute$1();
        }
        return this.ActorWatcher$module;
    }

    public Function1<String, String> jmsHeaderPrefix() {
        return this.jmsHeaderPrefix;
    }

    public Function1<String, String> srcVendorHeader() {
        return this.srcVendorHeader;
    }

    public Function1<String, String> srcProviderHeader() {
        return this.srcProviderHeader;
    }

    public Function1<String, String> srcDestHeader() {
        return this.srcDestHeader;
    }

    public Function1<String, String> destHeader() {
        return this.destHeader;
    }

    public Function1<String, String> corrIdHeader() {
        return this.corrIdHeader;
    }

    public Function1<String, String> priorityHeader() {
        return this.priorityHeader;
    }

    public Function1<String, String> expireHeader() {
        return this.expireHeader;
    }

    public Function1<String, String> deliveryModeHeader() {
        return this.deliveryModeHeader;
    }

    public Function1<String, String> replyToHeader() {
        return this.replyToHeader;
    }

    public Function1<String, String> timestampHeader() {
        return this.timestampHeader;
    }

    public Function1<String, String> typeHeader() {
        return this.typeHeader;
    }

    public Function1<String, String> msgIdHeader() {
        return this.msgIdHeader;
    }

    public String replyToQueueName() {
        return this.replyToQueueName;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$jmsHeaderPrefix_$eq(Function1<String, String> x$1) {
        this.jmsHeaderPrefix = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcVendorHeader_$eq(Function1<String, String> x$1) {
        this.srcVendorHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcProviderHeader_$eq(Function1<String, String> x$1) {
        this.srcProviderHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcDestHeader_$eq(Function1<String, String> x$1) {
        this.srcDestHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$destHeader_$eq(Function1<String, String> x$1) {
        this.destHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$corrIdHeader_$eq(Function1<String, String> x$1) {
        this.corrIdHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$priorityHeader_$eq(Function1<String, String> x$1) {
        this.priorityHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$expireHeader_$eq(Function1<String, String> x$1) {
        this.expireHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$deliveryModeHeader_$eq(Function1<String, String> x$1) {
        this.deliveryModeHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$replyToHeader_$eq(Function1<String, String> x$1) {
        this.replyToHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$timestampHeader_$eq(Function1<String, String> x$1) {
        this.timestampHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$typeHeader_$eq(Function1<String, String> x$1) {
        this.typeHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$msgIdHeader_$eq(Function1<String, String> x$1) {
        this.msgIdHeader = x$1;
    }

    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$replyToQueueName_$eq(String x$1) {
        this.replyToQueueName = x$1;
    }

    private ActorSystem system() {
        return this.system;
    }

    private ExecutionContext eCtxt() {
        return this.eCtxt;
    }

    public Logger blended$akka$http$restjms$internal$SimpleRestJmsService$$log() {
        return this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log;
    }

    private FlowHeaderConfig headerCfg() {
        return this.headerCfg;
    }

    private FlowEnvelopeLogger envLogger() {
        return this.envLogger;
    }

    private String idSeparator() {
        return this.idSeparator;
    }

    private List<String> defaultContentTypes() {
        return this.defaultContentTypes;
    }

    private RestJMSConfig restConfig() {
        return this.restConfig;
    }

    private JmsDestination responseDestination() {
        return this.responseDestination;
    }

    private scala.collection.immutable.Map<String, JmsOperationConfig> operations() {
        return this.operations;
    }

    private Map<String, Tuple2<HttpRequest, Promise<HttpResponse>>> pendingRequests() {
        return this.pendingRequests;
    }

    private JmsProducerSettings producerSettings() {
        return this.producerSettings;
    }

    private JmsConsumerSettings consumerSettings() {
        return this.consumerSettings;
    }

    private Flow<FlowEnvelope, FlowEnvelope, NotUsed> sendToJms() {
        return this.sendToJms;
    }

    private Source<FlowEnvelope, NotUsed> responseSrc() {
        return this.responseSrc;
    }

    private Source<FlowEnvelope, ActorRef> requestSrc() {
        return this.requestSrc;
    }

    private Option<ActorRef> requestActor() {
        return this.requestActor;
    }

    private void requestActor_$eq(Option<ActorRef> x$1) {
        this.requestActor = x$1;
    }

    private Option<ActorRef> requestStream() {
        return this.requestStream;
    }

    private void requestStream_$eq(Option<ActorRef> x$1) {
        this.requestStream = x$1;
    }

    private Option<ActorRef> responseStream() {
        return this.responseStream;
    }

    private void responseStream_$eq(Option<ActorRef> x$1) {
        this.responseStream = x$1;
    }

    public void start() {
        this.requestStream_$eq((Option<ActorRef>)new Some((Object)this.system().actorOf(StreamController$.MODULE$.props(new StringBuilder(5).append(this.name).append("-send").toString(), this.requestSrc(), this.streamsConfig, (Function1 & Serializable)a -> {
            SimpleRestJmsService.$anonfun$start$1(this, a);
            return BoxedUnit.UNIT;
        }))));
        this.responseStream_$eq((Option<ActorRef>)new Some((Object)this.system().actorOf(StreamController$.MODULE$.props(new StringBuilder(9).append(this.name).append("-response").toString(), this.responseSrc(), this.streamsConfig, (Function1 & Serializable)x$2 -> {
            SimpleRestJmsService.$anonfun$start$3(x$2);
            return BoxedUnit.UNIT;
        }))));
    }

    public void stop() {
        this.requestStream().foreach((Function1 & Serializable)x$3 -> {
            SimpleRestJmsService.$anonfun$stop$1(x$3);
            return BoxedUnit.UNIT;
        });
        this.responseStream().foreach((Function1 & Serializable)x$4 -> {
            SimpleRestJmsService.$anonfun$stop$2(x$4);
            return BoxedUnit.UNIT;
        });
    }

    public Function1<RequestContext, Future<RouteResult>> httpRoute() {
        return this.httpRoute;
    }

    private Seq<HttpHeader> filterHeaders(Seq<HttpHeader> headers) {
        Seq notAllowedInResponses = (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Host", "Accept-Encoding", "User-Agent", "Timeout-Access"}));
        return ((IterableOnceOps)headers.filterNot((Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)notAllowedInResponses.contains((Object)h.name())))).toList();
    }

    private Future<HttpResponse> performRequest(String opKey, HttpRequest request, ActorRef actor) {
        Future future;
        Option option = this.operations().get((Object)opKey);
        if (None$.MODULE$.equals(option)) {
            this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().warn((Function0 & Serializable)() -> new StringBuilder(36).append("Http operation [").append(opKey).append("] is not configured.").toString());
            future = Future$.MODULE$.apply((Function0 & Serializable)() -> {
                StatusCodes.ClientError x$1 = StatusCodes$.MODULE$.NotFound();
                HttpEntity.Strict x$2 = new HttpEntity.Strict(request.entity().contentType(), ByteString$.MODULE$.empty());
                Seq<HttpHeader> x$3 = this.filterHeaders((Seq<HttpHeader>)request.headers());
                HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
                return HttpResponse$.MODULE$.apply((StatusCode)x$1, x$3, (ResponseEntity)x$2, x$4);
            }, this.eCtxt());
        } else if (option instanceof Some) {
            Future future2;
            List list;
            Some some = (Some)option;
            JmsOperationConfig opCfg = (JmsOperationConfig)some.value();
            ContentType cType = request.entity().contentType();
            Option<List<String>> option2 = opCfg.contentTypes();
            if (None$.MODULE$.equals(option2)) {
                list = this.defaultContentTypes();
            } else if (option2 instanceof Some) {
                List l;
                Some some2 = (Some)option2;
                list = l = (List)some2.value();
            } else {
                throw new MatchError(option2);
            }
            List validContentTypes = list;
            List list2 = validContentTypes.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SimpleRestJmsService.$anonfun$performRequest$3(cType, x$5)));
            if (Nil$.MODULE$.equals(list2)) {
                this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().warn((Function0 & Serializable)() -> new StringBuilder(30).append("Content-Type [").append(cType.value()).append("] not supported.").toString());
                future2 = Future$.MODULE$.apply((Function0 & Serializable)() -> {
                    StatusCodes.ServerError x$5 = StatusCodes$.MODULE$.InternalServerError();
                    HttpEntity.Strict x$6 = HttpEntity$.MODULE$.apply(cType, ByteString$.MODULE$.empty());
                    Seq<HttpHeader> x$7 = this.filterHeaders((Seq<HttpHeader>)request.headers());
                    HttpProtocol x$8 = HttpResponse$.MODULE$.apply$default$4();
                    return HttpResponse$.MODULE$.apply((StatusCode)x$5, x$7, (ResponseEntity)x$6, x$8);
                }, this.eCtxt());
            } else if (list2 instanceof .colon.colon) {
                future2 = this.requestReply(opKey, opCfg, cType, request, actor);
            } else {
                throw new MatchError((Object)list2);
            }
            future = future2;
        } else {
            throw new MatchError((Object)option);
        }
        return future;
    }

    private Future<HttpResponse> requestReply(String operation, JmsOperationConfig opCfg, ContentType cType, HttpRequest request, ActorRef actor) {
        Future data = (Future)request.entity().getDataBytes().asScala().runWith((Graph)Sink$.MODULE$.seq(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.system()));
        return data.map((Function1 & Serializable)result -> {
            byte[] content = (byte[])((IterableOnceOps)result.flatten(Predef$.MODULE$.$conforms())).toArray((ClassTag)ClassTag$.MODULE$.Byte());
            String envId = UUID.randomUUID().toString();
            Seq header = (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.destHeader().apply((Object)this.headerCfg().prefix())), (Object)opCfg.destination()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.replyToHeader().apply((Object)this.headerCfg().prefix())), (Object)String.valueOf(this.responseDestination().name())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.corrIdHeader().apply((Object)this.headerCfg().prefix())), (Object)new StringBuilder(2).append($this.osgiCfg.ctContext().uuid()).append("##").append(envId).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Content-Type"), (Object)cType.mediaType().value())})).$plus$plus((IterableOnce)opCfg.header().map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
                return tuple22;
            }));
            FlowEnvelope env = FlowEnvelope$.MODULE$.apply(FlowMessage$.MODULE$.apply(content, (scala.collection.immutable.Map)FlowMessage$.MODULE$.props(header).get()), envId);
            this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().debug((Function0 & Serializable)() -> new StringBuilder(62).append("Received request [").append(env.id()).append("] of length [").append(content.length).append("], encoding [").append(opCfg.encoding()).append("], content type [").append(cType.mediaType()).append("]").toString());
            this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().debug((Function0 & Serializable)() -> new StringBuilder(22).append("Request envelope is [").append(env).append("]").toString());
            Future<HttpResponse> response = this.addRequest(env.id(), request);
            this.system().scheduler().scheduleOnce(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(opCfg.timeout())).millis(), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.timeoutRequest(env.id(), new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(opCfg.timeout())).millis()), this.eCtxt());
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(actor);
            FlowEnvelope x$1 = env;
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
            this.checkComplete(env.id(), opCfg);
            return response;
        }, this.eCtxt()).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void checkComplete(String id, JmsOperationConfig opCfg) {
        SimpleRestJmsService simpleRestJmsService = this;
        synchronized (simpleRestJmsService) {
            BoxedUnit boxedUnit;
            Some some;
            Tuple2 tuple2;
            Option option = this.pendingRequests().get((Object)id);
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                BoxedUnit boxedUnit2;
                HttpRequest req = (HttpRequest)tuple2._1();
                Promise p = (Promise)tuple2._2();
                if (!opCfg.jmsReply()) {
                    StatusCodes.Success x$1 = opCfg.isSoap() ? StatusCodes$.MODULE$.Accepted() : StatusCodes$.MODULE$.OK();
                    HttpEntity.Strict x$2 = HttpEntity$.MODULE$.apply(req.entity().contentType(), ByteString$.MODULE$.empty());
                    Seq<HttpHeader> x$3 = this.filterHeaders((Seq<HttpHeader>)req.headers());
                    HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
                    boxedUnit2 = p.complete((Try)new Success((Object)HttpResponse$.MODULE$.apply((StatusCode)x$1, x$3, (ResponseEntity)x$2, x$4)));
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else if (None$.MODULE$.equals(option)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    private synchronized Future<HttpResponse> addRequest(String id, HttpRequest request) {
        Promise p = Promise$.MODULE$.apply();
        this.pendingRequests().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)id), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)request), (Object)p)));
        p.future().onComplete((Function1 & Serializable)x$6 -> {
            SimpleRestJmsService.$anonfun$addRequest$1(this, id, x$6);
            return BoxedUnit.UNIT;
        }, this.eCtxt());
        return p.future();
    }

    private void removeRequest(String id) {
        SimpleRestJmsService simpleRestJmsService = this;
        synchronized (simpleRestJmsService) {
            Map cfr_ignored_0 = (Map)this.pendingRequests().$minus$eq((Object)id);
        }
    }

    private synchronized Object timeoutRequest(String id, FiniteDuration timeout) {
        BoxedUnit boxedUnit;
        Some some;
        Tuple2 tuple2;
        Option option = this.pendingRequests().get((Object)id);
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            HttpRequest req = (HttpRequest)tuple2._1();
            Promise p = (Promise)tuple2._2();
            this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().warn((Function0 & Serializable)() -> new StringBuilder(33).append("Request [").append(id).append("] has timed out after [").append(timeout).append("]").toString());
            StatusCodes.ServerError x$1 = StatusCodes$.MODULE$.InternalServerError();
            HttpEntity.Strict x$2 = HttpEntity$.MODULE$.apply(req.entity().contentType(), ByteString$.MODULE$.empty());
            Seq<HttpHeader> x$3 = this.filterHeaders((Seq<HttpHeader>)req.headers());
            HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
            boxedUnit = p.complete((Try)new Success((Object)HttpResponse$.MODULE$.apply((StatusCode)x$1, x$3, (ResponseEntity)x$2, x$4)));
        } else if (None$.MODULE$.equals(option)) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
        return boxedUnit;
    }

    private void handleResponse(FlowEnvelope env) {
        SimpleRestJmsService simpleRestJmsService = this;
        synchronized (simpleRestJmsService) {
            BoxedUnit boxedUnit;
            Some some;
            Tuple2 tuple2;
            Option option = this.pendingRequests().get((Object)env.id());
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Promise promise;
                HttpRequest req = (HttpRequest)tuple2._1();
                Promise p = (Promise)tuple2._2();
                this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().info((Function0 & Serializable)() -> new StringBuilder(37).append("Received response for HTTP request [").append(env).append("]").toString());
                Option option2 = env.exception();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Throwable t = (Throwable)some2.value();
                    this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().warn(t, this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().warn$default$2(), (Function0 & Serializable)() -> t.getMessage());
                    promise = p.complete((Try)new Failure(t));
                } else if (None$.MODULE$.equals(option2)) {
                    StatusCodes.Success x$1 = StatusCodes$.MODULE$.OK();
                    ResponseEntity x$2 = SimpleRestJmsService.createEntity$1(req, env.flowMessage());
                    Seq<HttpHeader> x$3 = this.filterHeaders((Seq<HttpHeader>)req.headers());
                    HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
                    promise = p.complete((Try)new Success((Object)HttpResponse$.MODULE$.apply((StatusCode)x$1, x$3, x$2, x$4)));
                } else {
                    throw new MatchError((Object)option2);
                }
                boxedUnit = promise;
            } else if (None$.MODULE$.equals(option)) {
                this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().warn((Function0 & Serializable)() -> new StringBuilder(43).append("No pending request for received response [").append(env).append("]").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    private final void ActorWatcher$lzycompute$1() {
        SimpleRestJmsService simpleRestJmsService = this;
        synchronized (simpleRestJmsService) {
            if (this.ActorWatcher$module == null) {
                this.ActorWatcher$module = new SimpleRestJmsService$ActorWatcher$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$start$1(SimpleRestJmsService $this, ActorRef a) {
        $this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().debug((Function0 & Serializable)() -> new StringBuilder(37).append("Stream actor [").append($this.name).append("] has been started : [").append(a).append("]").toString());
        $this.osgiCfg.system().actorOf($this.ActorWatcher().props(a));
        $this.requestActor_$eq((Option<ActorRef>)new Some((Object)a));
    }

    public static final /* synthetic */ void $anonfun$start$3(NotUsed x$2) {
    }

    public static final /* synthetic */ void $anonfun$stop$1(ActorRef x$3) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(x$3);
        StreamController.Stop$ x$1 = StreamController.Stop$.MODULE$;
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public static final /* synthetic */ void $anonfun$stop$2(ActorRef x$4) {
        ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(x$4);
        StreamController.Stop$ x$3 = StreamController.Stop$.MODULE$;
        ActorRef x$42 = qual$2.$bang$default$2((Object)x$3);
        qual$2.$bang((Object)x$3, x$42);
    }

    public static final /* synthetic */ void $anonfun$httpRoute$7(SimpleRestJmsService $this, Try r) {
        $this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().info((Function0 & Serializable)() -> new StringBuilder(19).append("Http response is [").append(r).append("]").toString());
    }

    public static final /* synthetic */ boolean $anonfun$performRequest$3(ContentType cType$1, String x$5) {
        String string = x$5;
        String string2 = cType$1.mediaType().value();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$addRequest$1(SimpleRestJmsService $this, String id$1, Try x$6) {
        $this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().debug((Function0 & Serializable)() -> new StringBuilder(27).append("Cleaning up Http request [").append(id$1).append("]").toString());
        $this.removeRequest(id$1);
    }

    private static final ResponseEntity createEntity$1(HttpRequest req, FlowMessage msg) {
        HttpEntity.Strict strict;
        FlowMessage flowMessage = msg;
        if (flowMessage instanceof TextFlowMessage) {
            TextFlowMessage textFlowMessage = (TextFlowMessage)flowMessage;
            strict = HttpEntity$.MODULE$.apply(req.entity().contentType(), textFlowMessage.getText().getBytes());
        } else if (flowMessage instanceof BinaryFlowMessage) {
            BinaryFlowMessage binaryFlowMessage = (BinaryFlowMessage)flowMessage;
            strict = HttpEntity$.MODULE$.apply(req.entity().contentType(), binaryFlowMessage.getBytes());
        } else {
            strict = HttpEntity$.MODULE$.apply(req.entity().contentType(), ByteString$.MODULE$.empty());
        }
        return strict;
    }

    public SimpleRestJmsService(String name, OSGIActorConfig osgiCfg, BlendedStreamsConfig streamsConfig, IdAwareConnectionFactory cf) {
        this.name = name;
        this.osgiCfg = osgiCfg;
        this.streamsConfig = streamsConfig;
        JmsEnvelopeHeader.$init$((JmsEnvelopeHeader)this);
        this.system = osgiCfg.system();
        this.eCtxt = this.system().dispatcher();
        this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log = Logger$.MODULE$.apply(new StringBuilder(1).append(this.getClass().getName()).append(".").append(name).toString());
        this.headerCfg = FlowHeaderConfig$.MODULE$.create(osgiCfg.ctContext());
        this.envLogger = FlowEnvelopeLogger$.MODULE$.create(this.headerCfg(), this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log());
        this.idSeparator = "##";
        this.defaultContentTypes = (List)new .colon.colon((Object)"application/json", (List)new .colon.colon((Object)"text/xml", (List)Nil$.MODULE$));
        this.restConfig = RestJMSConfig$.MODULE$.fromConfig(osgiCfg.config());
        this.responseDestination = new JmsQueue(new StringBuilder(17).append("restJMS.").append(name).append(".response").toString());
        this.operations = this.restConfig().operations();
        this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().info((Function0 & Serializable)() -> new StringBuilder(32).append("Starting RestJMS Service with [").append(this.operations()).append("]").toString());
        this.pendingRequests = (Map)Map$.MODULE$.empty();
        FlowEnvelopeLogger x$12 = this.envLogger();
        FlowHeaderConfig x$2 = this.headerCfg();
        IdAwareConnectionFactory x$3 = cf;
        Function1 & Serializable x$4 = (Function1 & Serializable)s -> new MessageDestinationResolver(s);
        PassThroughKeyFormatStrategy x$5 = new PassThroughKeyFormatStrategy();
        Function1 x$6 = JmsProducerSettings$.MODULE$.apply$default$2();
        FiniteDuration x$7 = JmsProducerSettings$.MODULE$.apply$default$6();
        Option x$8 = JmsProducerSettings$.MODULE$.apply$default$7();
        int x$9 = JmsProducerSettings$.MODULE$.apply$default$8();
        int x$10 = JmsProducerSettings$.MODULE$.apply$default$10();
        JmsDeliveryMode x$11 = JmsProducerSettings$.MODULE$.apply$default$11();
        Option x$122 = JmsProducerSettings$.MODULE$.apply$default$12();
        Function0 x$13 = JmsProducerSettings$.MODULE$.apply$default$13();
        boolean x$14 = JmsProducerSettings$.MODULE$.apply$default$14();
        this.producerSettings = new JmsProducerSettings(x$12, x$6, x$2, (JmsKeyFormatStrategy)x$5, x$3, x$7, x$8, x$9, (Function1)x$4, x$10, x$11, x$122, x$13, x$14);
        FlowEnvelopeLogger x$15 = this.envLogger();
        FlowHeaderConfig x$16 = this.headerCfg();
        IdAwareConnectionFactory x$17 = cf;
        Some x$18 = new Some((Object)this.responseDestination());
        Function1 & Serializable x$19 = (Function1 & Serializable)x$1 -> LogLevel$.MODULE$.Debug();
        Some x$20 = new Some((Object)new StringBuilder(9).append(this.corrIdHeader().apply((Object)"")).append(" LIKE '").append(osgiCfg.ctContext().uuid()).append("%'").toString());
        PassThroughKeyFormatStrategy x$21 = new PassThroughKeyFormatStrategy();
        FiniteDuration x$22 = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second();
        FiniteDuration x$23 = JmsConsumerSettings$.MODULE$.apply$default$6();
        int x$24 = JmsConsumerSettings$.MODULE$.apply$default$8();
        FiniteDuration x$25 = JmsConsumerSettings$.MODULE$.apply$default$9();
        FiniteDuration x$26 = JmsConsumerSettings$.MODULE$.apply$default$10();
        AcknowledgeMode x$27 = JmsConsumerSettings$.MODULE$.apply$default$11();
        int x$28 = JmsConsumerSettings$.MODULE$.apply$default$12();
        Option x$29 = JmsConsumerSettings$.MODULE$.apply$default$15();
        this.consumerSettings = new JmsConsumerSettings(x$15, (Function1)x$19, x$16, (JmsKeyFormatStrategy)x$21, x$17, x$23, (Option)x$18, x$24, x$25, x$26, x$27, x$28, (Option)x$20, x$22, x$29);
        this.sendToJms = Flow$.MODULE$.fromGraph((Graph)new JmsProducerStage(new StringBuilder(5).append(name).append("-send").toString(), this.producerSettings(), this.system()));
        this.responseSrc = Source$.MODULE$.fromGraph((Graph)new JmsConsumerStage(new StringBuilder(9).append(name).append("-response").toString(), this.consumerSettings(), JmsConsumerStage$.MODULE$.$lessinit$greater$default$3(), this.system())).via(FlowProcessor$.MODULE$.fromFunction("handleResponse", this.envLogger(), (Function1 & Serializable)env -> Try$.MODULE$.apply((Function0 & Serializable)() -> {
            void var3_3;
            String corrId = (String)env.headerWithDefault((String)this.corrIdHeader().apply((Object)""), (Object)env.id(), ManifestFactory$.MODULE$.classType(String.class));
            FlowEnvelope responseEnv = ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])corrId.split(this.idSeparator()))) == 2 ? FlowEnvelope$.MODULE$.apply(env.flowMessage(), (String)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])corrId.split(this.idSeparator()))).last()) : env;
            this.handleResponse(responseEnv);
            return var3_3;
        })));
        this.requestSrc = StreamFactories$.MODULE$.actorSource(100, OverflowStrategy$.MODULE$.dropNew()).via(this.sendToJms());
        this.requestActor = None$.MODULE$;
        this.requestStream = None$.MODULE$;
        this.responseStream = None$.MODULE$;
        this.httpRoute = (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.path((PathMatcher)Directives$.MODULE$.RemainingPath()), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)path -> (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.post()).apply((Function0 & Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.entity(Directives$.MODULE$.as(Unmarshaller$.MODULE$.identityUnmarshaller())), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)request -> {
            StandardRoute standardRoute;
            this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().info((Function0 & Serializable)() -> new StringBuilder(53).append("Http operation request received at [").append(path).append("] with headers [").append(request.headers()).append("]").toString());
            Option<ActorRef> option = this.requestActor();
            if (None$.MODULE$.equals(option)) {
                String msg = "JMS request reply stream is not ready";
                this.blended$akka$http$restjms$internal$SimpleRestJmsService$$log().warn((Function0 & Serializable)() -> msg);
                standardRoute = Directives$.MODULE$.complete((Function0 & Serializable)() -> {
                    StatusCodes.ServerError x$30 = StatusCodes$.MODULE$.InternalServerError();
                    HttpEntity.Strict x$31 = new HttpEntity.Strict(request.entity().contentType(), ByteString$.MODULE$.apply(msg));
                    Seq<HttpHeader> x$32 = this.filterHeaders((Seq<HttpHeader>)request.headers());
                    HttpProtocol x$33 = HttpResponse$.MODULE$.apply$default$4();
                    return ToResponseMarshallable$.MODULE$.apply((Object)HttpResponse$.MODULE$.apply((StatusCode)x$30, x$32, (ResponseEntity)x$31, x$33), Marshaller$.MODULE$.fromResponse());
                });
            } else if (option instanceof Some) {
                Some some = (Some)option;
                ActorRef a = (ActorRef)some.value();
                Future<HttpResponse> f = this.performRequest(path.toString(), (HttpRequest)request, a);
                f.onComplete((Function1 & Serializable)r -> {
                    SimpleRestJmsService.$anonfun$httpRoute$7(this, r);
                    return BoxedUnit.UNIT;
                }, this.eCtxt());
                standardRoute = Directives$.MODULE$.complete((Function0 & Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)f, Marshaller$.MODULE$.futureMarshaller(Marshaller$.MODULE$.fromResponse())));
            } else {
                throw new MatchError(option);
            }
            return standardRoute;
        })));
        Statics.releaseFence();
    }

    public class ActorWatcher
    implements Actor {
        private final ActorRef watched;
        private ActorContext context;
        private ActorRef self;
        public final /* synthetic */ SimpleRestJmsService $outer;

        public final ActorRef sender() {
            return Actor.sender$((Actor)this);
        }

        @InternalApi
        public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
            Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
        }

        @InternalApi
        public void aroundPreStart() {
            Actor.aroundPreStart$((Actor)this);
        }

        @InternalApi
        public void aroundPostStop() {
            Actor.aroundPostStop$((Actor)this);
        }

        @InternalApi
        public void aroundPreRestart(Throwable reason, Option<Object> message) {
            Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
        }

        @InternalApi
        public void aroundPostRestart(Throwable reason) {
            Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
        }

        public SupervisorStrategy supervisorStrategy() {
            return Actor.supervisorStrategy$((Actor)this);
        }

        public void postStop() throws Exception {
            Actor.postStop$((Actor)this);
        }

        public void preRestart(Throwable reason, Option<Object> message) throws Exception {
            Actor.preRestart$((Actor)this, (Throwable)reason, message);
        }

        public void postRestart(Throwable reason) throws Exception {
            Actor.postRestart$((Actor)this, (Throwable)reason);
        }

        public void unhandled(Object message) {
            Actor.unhandled$((Actor)this, (Object)message);
        }

        public ActorContext context() {
            return this.context;
        }

        public final ActorRef self() {
            return this.self;
        }

        public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
            this.context = x$1;
        }

        public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
            this.self = x$1;
        }

        public void preStart() {
            this.context().watch(this.watched);
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ ActorWatcher $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof Terminated) {
                        Terminated terminated = (Terminated)A1;
                        ActorRef a = terminated.actor();
                        this.$outer.blended$akka$http$restjms$internal$SimpleRestJmsService$ActorWatcher$$$outer().blended$akka$http$restjms$internal$SimpleRestJmsService$$log().info((Function0 & Serializable)() -> new StringBuilder(23).append("Actor [").append(a).append("] has terminated").toString());
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof Terminated;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(akka.actor.ActorRef )}, serializedLambda);
                }
            };
        }

        public /* synthetic */ SimpleRestJmsService blended$akka$http$restjms$internal$SimpleRestJmsService$ActorWatcher$$$outer() {
            return this.$outer;
        }

        public ActorWatcher(SimpleRestJmsService $outer, ActorRef watched) {
            this.watched = watched;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Actor.$init$((Actor)this);
            Statics.releaseFence();
        }
    }
}

