/*
 * Decompiled with CFR 0.152.
 */
package blended.akka.http.restjms.internal;

import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.marshalling.ToResponseMarshallable$;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.HttpResponse$;
import akka.http.scaladsl.model.ResponseEntity;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.PathMatcher;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.StandardRoute;
import akka.http.scaladsl.server.util.ApplyConverter$;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import akka.stream.ActorMaterializer;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.scaladsl.Sink$;
import akka.util.ByteString$;
import blended.akka.http.restjms.internal.JmsOperationConfig;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultMessage;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005uda\u0002\u0007\u000e!\u0003\r\t\u0001\u0007\u0005\u0006?\u0001!\t\u0001\t\u0005\bI\u0001\u0011\r\u0015\"\u0003&\u0011\u001dq\u0003A1Q\u0005\n=Bq\u0001\u0011\u0001CB\u0013%\u0011\tC\u0004L\u0001\t\u0007i1\u0001'\t\u000fI\u0003!\u0019!D\u0002'\"91\f\u0001b\u0001\u000e\u0003a\u0006b\u00028\u0001\u0005\u00045\ta\u001c\u0005\bu\u0002\u0011\r\u0011\"\u0001|\u0011!\t\t\u0003\u0001Q\u0005\n\u0005\r\u0002\u0002CA/\u0001\u0001&I!a\u0018\u0003\u0019)k5KU3rk\u0016\u001cHo\u001c:\u000b\u00059y\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005A\t\u0012a\u0002:fgRTWn\u001d\u0006\u0003%M\tA\u0001\u001b;ua*\u0011A#F\u0001\u0005C.\\\u0017MC\u0001\u0017\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\u0001a\u0005\u0002\u00013A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$C#A\u0011\u0011\u0005i\u0011\u0013BA\u0012\u001c\u0005\u0011)f.\u001b;\u0002\u00071|w-F\u0001'!\t9C&D\u0001)\u0015\tI#&A\u0004m_\u001e<\u0017N\\4\u000b\u0005-*\u0012\u0001B;uS2L!!\f\u0015\u0003\r1{wmZ3s\u0003M!WMZ1vYR\u001cuN\u001c;f]R$\u0016\u0010]3t+\u0005\u0001\u0004cA\u00197q5\t!G\u0003\u00024i\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003km\t!bY8mY\u0016\u001cG/[8o\u0013\t9$G\u0001\u0003MSN$\bCA\u001d?\u001b\u0005Q$BA\u001e=\u0003\u0011a\u0017M\\4\u000b\u0003u\nAA[1wC&\u0011qH\u000f\u0002\u0007'R\u0014\u0018N\\4\u0002\u0013=\u00048i\\;oi\u0016\u0014X#\u0001\"\u0011\u0005\rKU\"\u0001#\u000b\u0005\u00153\u0015AB1u_6L7M\u0003\u0002H\u0011\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005-b\u0014B\u0001&E\u0005)\tEo\\7jG2{gnZ\u0001\u0006K\u000e#\b\u0010^\u000b\u0002\u001bB\u0011a\nU\u0007\u0002\u001f*\u0011qiG\u0005\u0003#>\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u00195\fG/\u001a:jC2L'0\u001a:\u0016\u0003Q\u0003\"!V-\u000e\u0003YS!a\u0016-\u0002\rM$(/Z1n\u0015\u0005!\u0012B\u0001.W\u0005E\t5\r^8s\u001b\u0006$XM]5bY&TXM]\u0001\u000b_B,'/\u0019;j_:\u001cX#A/\u0011\ty+\u0007N\u001b\b\u0003?\u000e\u0004\"\u0001Y\u000e\u000e\u0003\u0005T!AY\f\u0002\rq\u0012xn\u001c;?\u0013\t!7$\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\u001e\u00141!T1q\u0015\t!7\u0004\u0005\u0002_S&\u0011qh\u001a\t\u0003W2l\u0011!D\u0005\u0003[6\u0011!CS7t\u001fB,'/\u0019;j_:\u001cuN\u001c4jO\u0006a1-Y7fY\u000e{g\u000e^3yiV\t\u0001\u000f\u0005\u0002rq6\t!O\u0003\u0002ti\u0006)1-Y7fY*\u0011QO^\u0001\u0007CB\f7\r[3\u000b\u0003]\f1a\u001c:h\u0013\tI(O\u0001\u0007DC6,GnQ8oi\u0016DH/A\u0005iiR\u0004(k\\;uKV\tA\u0010E\u0002~\u00037q1A`A\u000b\u001d\ry\u0018q\u0002\b\u0005\u0003\u0003\tIA\u0004\u0003\u0002\u0004\u0005\u001dab\u00011\u0002\u0006%\tA#\u0003\u0002\u00131&!\u00111BA\u0007\u0003!\u00198-\u00197bINd'B\u0001\nY\u0013\u0011\t\t\"a\u0005\u0002\rM,'O^3s\u0015\u0011\tY!!\u0004\n\t\u0005]\u0011\u0011D\u0001\ba\u0006\u001c7.Y4f\u0015\u0011\t\t\"a\u0005\n\t\u0005u\u0011q\u0004\u0002\u0006%>,H/\u001a\u0006\u0005\u0003/\tI\"\u0001\u0007fq\u0016\u001cW\u000f^3DC6,G\u000e\u0006\u0006\u0002&\u0005U\u0012\u0011HA\u001f\u0003\u001b\u0002b!a\n\u0002,\u0005=RBAA\u0015\u0015\tY3$\u0003\u0003\u0002.\u0005%\"a\u0001+ssB\u0019\u0011/!\r\n\u0007\u0005M\"O\u0001\u0005Fq\u000eD\u0017M\\4f\u0011\u0019\t9D\u0003a\u0001Q\u0006Iq\u000e]3sCRLwN\u001c\u0005\u0007\u0003wQ\u0001\u0019\u00016\u0002\u000b=\u00048IZ4\t\u000f\u0005}\"\u00021\u0001\u0002B\u0005)1\rV=qKB!\u00111IA%\u001b\t\t)E\u0003\u0003\u0002H\u0005M\u0011!B7pI\u0016d\u0017\u0002BA&\u0003\u000b\u00121bQ8oi\u0016tG\u000fV=qK\"9\u0011q\n\u0006A\u0002\u0005E\u0013aB2p]R,g\u000e\u001e\t\u00065\u0005M\u0013qK\u0005\u0004\u0003+Z\"!B!se\u0006L\bc\u0001\u000e\u0002Z%\u0019\u00111L\u000e\u0003\t\tKH/Z\u0001\re\u0016\fX/Z:u%\u0016\u0004H.\u001f\u000b\u000b\u0003C\ni'a\u001c\u0002r\u0005M\u0004#\u0002(\u0002d\u0005\u001d\u0014bAA3\u001f\n1a)\u001e;ve\u0016\u0004B!a\u0011\u0002j%!\u00111NA#\u00051AE\u000f\u001e9SKN\u0004xN\\:f\u0011\u0019\t9d\u0003a\u0001Q\"1\u00111H\u0006A\u0002)Dq!a\u0010\f\u0001\u0004\t\t\u0005C\u0004\u0002v-\u0001\r!a\u001e\u0002\u000fI,\u0017/^3tiB!\u00111IA=\u0013\u0011\tY(!\u0012\u0003\u0017!#H\u000f\u001d*fcV,7\u000f\u001e")
public interface JMSRequestor {
    public void blended$akka$http$restjms$internal$JMSRequestor$_setter_$blended$akka$http$restjms$internal$JMSRequestor$$log_$eq(Logger var1);

    public void blended$akka$http$restjms$internal$JMSRequestor$_setter_$blended$akka$http$restjms$internal$JMSRequestor$$defaultContentTypes_$eq(List<String> var1);

    public void blended$akka$http$restjms$internal$JMSRequestor$_setter_$blended$akka$http$restjms$internal$JMSRequestor$$opCounter_$eq(AtomicLong var1);

    public void blended$akka$http$restjms$internal$JMSRequestor$_setter_$httpRoute_$eq(Function1<RequestContext, Future<RouteResult>> var1);

    public Logger blended$akka$http$restjms$internal$JMSRequestor$$log();

    public List<String> blended$akka$http$restjms$internal$JMSRequestor$$defaultContentTypes();

    public AtomicLong blended$akka$http$restjms$internal$JMSRequestor$$opCounter();

    public ExecutionContext eCtxt();

    public ActorMaterializer materializer();

    public Map<String, JmsOperationConfig> operations();

    public CamelContext camelContext();

    public Function1<RequestContext, Future<RouteResult>> httpRoute();

    private Try<Exchange> executeCamel(String operation, JmsOperationConfig opCfg, ContentType cType, byte[] content) {
        Success success;
        String string;
        boolean bl;
        ProducerTemplate producer = this.camelContext().createProducerTemplate();
        DefaultExchange exchange = new DefaultExchange(this.camelContext());
        exchange.setPattern(opCfg.jmsReply() ? ExchangePattern.InOut : ExchangePattern.InOnly);
        DefaultMessage msg = new DefaultMessage();
        msg.setBody((Object)content);
        opCfg.header().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            JMSRequestor.$anonfun$executeCamel$1(msg, x0$1);
            return BoxedUnit.UNIT;
        });
        String requestContentType = cType.mediaType().value();
        this.blended$akka$http$restjms$internal$JMSRequestor$$log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Request Content Type for JMS Request is [").append(requestContentType).append("]").toString());
        msg.setHeader("Content-Type", (Object)cType.mediaType().value());
        exchange.setIn((Message)msg);
        String baseUri = new StringBuilder(93).append("jms:").append(opCfg.destination()).append("?jmsKeyFormatStrategy=passthrough&disableTimeToLive=true&requestTimeout=").append(opCfg.timeout()).append("&replyTo=restJMS.").append(operation).toString();
        boolean bl2 = bl = opCfg.receivetimeout() > 0L;
        if (bl) {
            string = new StringBuilder(0).append(baseUri).append(new StringBuilder(16).append("&receiveTimeout=").append(opCfg.receivetimeout()).toString()).toString();
        } else if (!bl) {
            string = baseUri;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        String uri = string;
        this.blended$akka$http$restjms$internal$JMSRequestor$$log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Using request/reply uri [").append(uri).append("] with content type [").append(requestContentType).append("]").toString());
        try {
            try {
                Success success2;
                Exchange result = producer.send(uri, (Exchange)exchange);
                Option option = Option$.MODULE$.apply((Object)result.getException());
                if (None$.MODULE$.equals(option)) {
                    success2 = new Success((Object)result);
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    Exception e = (Exception)some.value();
                    success2 = new Failure((Throwable)e);
                } else {
                    throw new MatchError((Object)option);
                }
                success = success2;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                Failure failure = new Failure(e);
                success = failure;
            }
        }
        finally {
            producer.stop();
        }
        return success;
    }

    private Future<HttpResponse> requestReply(String operation, JmsOperationConfig opCfg, ContentType cType, HttpRequest request) {
        long opNum = this.blended$akka$http$restjms$internal$JMSRequestor$$opCounter().incrementAndGet();
        Future data = (Future)request.entity().getDataBytes().runWith((Graph)Sink$.MODULE$.seq(), (Materializer)this.materializer());
        return data.map((Function1 & Serializable & scala.Serializable)result -> {
            HttpResponse httpResponse;
            byte[] content = (byte[])((TraversableOnce)result.flatten((Function1)Predef$.MODULE$.$conforms())).toArray(ClassTag$.MODULE$.Byte());
            this.blended$akka$http$restjms$internal$JMSRequestor$$log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Received request [").append(opNum).append("] of length [").append(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(content)).size()).append("] encoding [").append(opCfg.encoding()).append("], [").append(new String(content, opCfg.encoding())).append("]").toString());
            Try<Exchange> try_ = this.executeCamel(operation, opCfg, cType, content);
            if (try_ instanceof Success) {
                HttpResponse httpResponse2;
                Success success = (Success)try_;
                Exchange exchange = (Exchange)success.value();
                if (opCfg.jmsReply()) {
                    byte[] body = (byte[])exchange.getOut().getBody(byte[].class);
                    this.blended$akka$http$restjms$internal$JMSRequestor$$log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Received response [").append(opNum).append("] of length [").append(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(body)).size()).append("] encoding [").append(opCfg.encoding()).append("], [").append(new String(body, opCfg.encoding())).append("]").toString());
                    StatusCodes.Success x$1 = StatusCodes$.MODULE$.OK();
                    HttpEntity.Strict x$2 = new HttpEntity.Strict(cType, ByteString$.MODULE$.apply(body));
                    scala.collection.immutable.Seq x$3 = JMSRequestor.filterHeaders$1((Seq)request.headers());
                    HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
                    httpResponse2 = HttpResponse$.MODULE$.apply((StatusCode)x$1, x$3, (ResponseEntity)x$2, x$4);
                } else {
                    StatusCodes.Success x$5 = opCfg.isSoap() ? StatusCodes$.MODULE$.Accepted() : StatusCodes$.MODULE$.OK();
                    HttpEntity.Strict x$6 = new HttpEntity.Strict(cType, ByteString$.MODULE$.apply(""));
                    scala.collection.immutable.Seq x$7 = JMSRequestor.filterHeaders$1((Seq)request.headers());
                    HttpProtocol x$8 = HttpResponse$.MODULE$.apply$default$4();
                    httpResponse2 = HttpResponse$.MODULE$.apply((StatusCode)x$5, x$7, (ResponseEntity)x$6, x$8);
                }
                httpResponse = httpResponse2;
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                this.blended$akka$http$restjms$internal$JMSRequestor$$log().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Error performing JMS request/reply [").append(e.getMessage()).append("]").toString());
                StatusCodes.ServerError x$9 = StatusCodes$.MODULE$.InternalServerError();
                HttpEntity.Strict x$10 = new HttpEntity.Strict(cType, ByteString$.MODULE$.apply(""));
                scala.collection.immutable.Seq x$11 = JMSRequestor.filterHeaders$1((Seq)request.headers());
                HttpProtocol x$12 = HttpResponse$.MODULE$.apply$default$4();
                httpResponse = HttpResponse$.MODULE$.apply((StatusCode)x$9, x$11, (ResponseEntity)x$10, x$12);
            } else {
                throw new MatchError(try_);
            }
            return httpResponse;
        }, this.eCtxt());
    }

    public static /* synthetic */ boolean $anonfun$httpRoute$7(ContentType cType$1, String x$1) {
        String string = x$1;
        String string2 = cType$1.mediaType().value();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static /* synthetic */ void $anonfun$httpRoute$11(JMSRequestor $this, Try r) {
        $this.blended$akka$http$restjms$internal$JMSRequestor$$log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("HttpResponse is [").append(r).append("]").toString());
    }

    public static /* synthetic */ void $anonfun$executeCamel$1(DefaultMessage msg$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        msg$1.setHeader(k, (Object)v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static scala.collection.immutable.Seq filterHeaders$1(Seq headers) {
        Seq notAllowedInResponses = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Host", "Accept-Encoding", "User-Agent", "Timeout-Access"}));
        return (scala.collection.immutable.Seq)((TraversableLike)headers.filterNot((Function1 & Serializable & scala.Serializable)h -> BoxesRunTime.boxToBoolean((boolean)notAllowedInResponses.contains((Object)h.name())))).to(Predef$.MODULE$.fallbackStringCanBuildFrom());
    }

    public static void $init$(JMSRequestor $this) {
        $this.blended$akka$http$restjms$internal$JMSRequestor$_setter_$blended$akka$http$restjms$internal$JMSRequestor$$log_$eq(Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(JMSRequestor.class)));
        $this.blended$akka$http$restjms$internal$JMSRequestor$_setter_$blended$akka$http$restjms$internal$JMSRequestor$$defaultContentTypes_$eq((List<String>)new .colon.colon((Object)"application/json", (List)new .colon.colon((Object)"text/xml", (List)Nil$.MODULE$)));
        $this.blended$akka$http$restjms$internal$JMSRequestor$_setter_$blended$akka$http$restjms$internal$JMSRequestor$$opCounter_$eq(new AtomicLong(0L));
        $this.blended$akka$http$restjms$internal$JMSRequestor$_setter_$httpRoute_$eq((Function1<RequestContext, Future<RouteResult>>)((Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.path((PathMatcher)Directives$.MODULE$.RemainingPath()), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)path -> (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.post()).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.entity(Directives$.MODULE$.as(Unmarshaller$.MODULE$.identityUnmarshaller())), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)request -> {
            StandardRoute standardRoute;
            $this.blended$akka$http$restjms$internal$JMSRequestor$$log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Http operation request received at [").append(path).append("] : ").append(request).toString());
            ContentType cType = request.entity().contentType();
            Option option = $this.operations().get((Object)path.toString());
            if (None$.MODULE$.equals(option)) {
                $this.blended$akka$http$restjms$internal$JMSRequestor$$log().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Http operation at [").append(path).append("] is not configured.").toString());
                standardRoute = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> {
                    StatusCodes.ClientError x$1 = StatusCodes$.MODULE$.NotFound();
                    HttpEntity.Strict x$2 = new HttpEntity.Strict(cType, ByteString$.MODULE$.apply(""));
                    scala.collection.immutable.Seq x$3 = request.headers();
                    HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
                    return ToResponseMarshallable$.MODULE$.apply((Object)HttpResponse$.MODULE$.apply((StatusCode)x$1, x$3, (ResponseEntity)x$2, x$4), Marshaller$.MODULE$.fromResponse());
                });
            } else if (option instanceof Some) {
                StandardRoute standardRoute2;
                List list;
                Some some = (Some)option;
                JmsOperationConfig opCfg = (JmsOperationConfig)some.value();
                Option<List<String>> option2 = opCfg.contentTypes();
                if (None$.MODULE$.equals(option2)) {
                    list = $this.blended$akka$http$restjms$internal$JMSRequestor$$defaultContentTypes();
                } else if (option2 instanceof Some) {
                    List l;
                    Some some2 = (Some)option2;
                    list = l = (List)some2.value();
                } else {
                    throw new MatchError(option2);
                }
                List validContentTypes = list;
                List list2 = (List)validContentTypes.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JMSRequestor.$anonfun$httpRoute$7(cType, x$1)));
                if (Nil$.MODULE$.equals(list2)) {
                    $this.blended$akka$http$restjms$internal$JMSRequestor$$log().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Content-Type [").append(cType.value()).append("] not supported.").toString());
                    standardRoute2 = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> {
                        StatusCodes.ServerError x$5 = StatusCodes$.MODULE$.InternalServerError();
                        HttpEntity.Strict x$6 = HttpEntity$.MODULE$.apply(cType, ByteString$.MODULE$.apply(""));
                        scala.collection.immutable.Seq x$7 = request.headers();
                        HttpProtocol x$8 = HttpResponse$.MODULE$.apply$default$4();
                        return ToResponseMarshallable$.MODULE$.apply((Object)HttpResponse$.MODULE$.apply((StatusCode)x$5, x$7, (ResponseEntity)x$6, x$8), Marshaller$.MODULE$.fromResponse());
                    });
                } else if (list2 instanceof .colon.colon) {
                    standardRoute2 = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> {
                        Future<HttpResponse> f = $this.requestReply(path.toString(), opCfg, cType, (HttpRequest)request);
                        f.onComplete((Function1 & Serializable & scala.Serializable)r -> {
                            JMSRequestor.$anonfun$httpRoute$11($this, r);
                            return BoxedUnit.UNIT;
                        }, $this.eCtxt());
                        return ToResponseMarshallable$.MODULE$.apply(f, Marshaller$.MODULE$.futureMarshaller(Marshaller$.MODULE$.fromResponse()));
                    });
                } else {
                    throw new MatchError((Object)list2);
                }
                standardRoute = standardRoute2;
            } else {
                throw new MatchError((Object)option);
            }
            return standardRoute;
        })))));
    }
}

