/*
 * Decompiled with CFR 0.152.
 */
package blended.akka.http.proxy.internal;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.ConnectionContext$;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.HttpExt;
import akka.http.scaladsl.HttpsConnectionContext;
import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.marshalling.ToResponseMarshallable$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpMessage;
import akka.http.scaladsl.model.HttpMessage$;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.HttpResponse$;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.ResponseEntity;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.Host$;
import akka.http.scaladsl.model.headers.Location;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.PathMatcher;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.util.ApplyConverter$;
import akka.http.scaladsl.settings.ConnectionPoolSettings;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializer$;
import akka.stream.Materializer;
import blended.akka.http.proxy.internal.ProxyTarget;
import blended.akka.http.proxy.internal.RedirectHeaderPolicy$;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import javax.net.ssl.SSLContext;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001daa\u0002\u0006\f!\u0003\r\tA\u0006\u0005\u0006;\u0001!\tA\b\u0005\bE\u0001\u0011\r\u0015\"\u0003$\u0011\u0015a\u0003A\"\u0005.\u0011\u0015\u0011\u0004A\"\u00054\u0011\u0015Y\u0004A\"\u0005=\u0011\u0015Q\u0005\u0001\"\u0001L\u000b\u0019\u0019\u0007\u0001)A\u0005I\"Aa\u000f\u0001ECB\u0013%1\nC\u0003x\u0001\u0011\u0005\u0001P\u0001\u0006Qe>D\u0018PU8vi\u0016T!\u0001D\u0007\u0002\u0011%tG/\u001a:oC2T!AD\b\u0002\u000bA\u0014x\u000e_=\u000b\u0005A\t\u0012\u0001\u00025uiBT!AE\n\u0002\t\u0005\\7.\u0019\u0006\u0002)\u00059!\r\\3oI\u0016$7\u0001A\n\u0003\u0001]\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0017A\u0002\u0013j]&$H\u0005F\u0001 !\tA\u0002%\u0003\u0002\"3\t!QK\\5u\u0003\rawnZ\u000b\u0002IA\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\bY><w-\u001b8h\u0015\tI3#\u0001\u0003vi&d\u0017BA\u0016'\u0005\u0019aunZ4fe\u0006Y\u0001O]8ys\u000e{gNZ5h+\u0005q\u0003CA\u00181\u001b\u0005Y\u0011BA\u0019\f\u0005-\u0001&o\u001c=z)\u0006\u0014x-\u001a;\u0002\u0017\u0005\u001cGo\u001c:TsN$X-\\\u000b\u0002iA\u0011Q'O\u0007\u0002m)\u0011q\u0007O\u0001\u0006C\u000e$xN\u001d\u0006\u0002%%\u0011!H\u000e\u0002\f\u0003\u000e$xN]*zgR,W.\u0001\u0006tg2\u001cuN\u001c;fqR,\u0012!\u0010\t\u00041y\u0002\u0015BA \u001a\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011\tS\u0007\u0002\u0005*\u00111\tR\u0001\u0004gNd'BA#G\u0003\rqW\r\u001e\u0006\u0002\u000f\u0006)!.\u0019<bq&\u0011\u0011J\u0011\u0002\u000b'Nc5i\u001c8uKb$\u0018A\u00039s_bL(k\\;uKV\tA\n\u0005\u0002NA:\u0011a*\u0018\b\u0003\u001fjs!\u0001U,\u000f\u0005E3fB\u0001*V\u001b\u0005\u0019&B\u0001+\u0016\u0003\u0019a$o\\8u}%\t!#\u0003\u0002\u0011q%\u0011\u0001,W\u0001\tg\u000e\fG.\u00193tY*\u0011\u0001\u0003O\u0005\u00037r\u000baa]3sm\u0016\u0014(B\u0001-Z\u0013\tqv,A\u0004qC\u000e\\\u0017mZ3\u000b\u0005mc\u0016BA1c\u0005\u0015\u0011v.\u001e;f\u0015\tqvL\u0001\u0006IiR\u00048\t\\5f]R\u0004B\u0001G3h[&\u0011a-\u0007\u0002\n\rVt7\r^5p]F\u0002\"\u0001[6\u000e\u0003%T!A\u001b/\u0002\u000b5|G-\u001a7\n\u00051L'a\u0003%uiB\u0014V-];fgR\u00042A\\9t\u001b\u0005y'B\u00019\u001a\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003e>\u0014aAR;ukJ,\u0007C\u00015u\u0013\t)\u0018N\u0001\u0007IiR\u0004(+Z:q_:\u001cX-A\u0006`aJ|\u00070\u001f*pkR,\u0017A\u00025b]\u0012dW\r\u0006\u0002Ms\")!0\u0003a\u0001w\u0006Y!/Z9vKN$\b+\u0019;i!\ra\u0018\u0011\u0001\b\u0003{z\u0004\"AU\r\n\u0005}L\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0004\u0005\u0015!AB*ue&twM\u0003\u0002\u00003\u0001")
public interface ProxyRoute {
    public void blended$akka$http$proxy$internal$ProxyRoute$_setter_$blended$akka$http$proxy$internal$ProxyRoute$$log_$eq(Logger var1);

    public Logger blended$akka$http$proxy$internal$ProxyRoute$$log();

    public ProxyTarget proxyConfig();

    public ActorSystem actorSystem();

    public Option<SSLContext> sslContext();

    public static /* synthetic */ Function1 proxyRoute$(ProxyRoute $this) {
        return $this.proxyRoute();
    }

    default public Function1<RequestContext, Future<RouteResult>> proxyRoute() {
        return this.blended$akka$http$proxy$internal$ProxyRoute$$_proxyRoute();
    }

    public static /* synthetic */ Function1 blended$akka$http$proxy$internal$ProxyRoute$$_proxyRoute$(ProxyRoute $this) {
        return $this.blended$akka$http$proxy$internal$ProxyRoute$$_proxyRoute();
    }

    default public Function1<RequestContext, Future<RouteResult>> blended$akka$http$proxy$internal$ProxyRoute$$_proxyRoute() {
        return Directives$.MODULE$._enhanceRouteWithConcatenation((Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.pathEndOrSingleSlash()).apply((Function0 & Serializable & scala.Serializable)() -> this.handle(""))).$tilde((Function1)Directive$.MODULE$.addDirectiveApply(Directives$.MODULE$.path((PathMatcher)Directives$.MODULE$.Remaining()), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)requestPath -> this.handle((String)requestPath)));
    }

    public static /* synthetic */ Function1 handle$(ProxyRoute $this, String requestPath) {
        return $this.handle(requestPath);
    }

    default public Function1<RequestContext, Future<RouteResult>> handle(String requestPath) {
        ActorSystem _actorSystem = this.actorSystem();
        ActorMaterializer materializer = ActorMaterializer$.MODULE$.apply(ActorMaterializer$.MODULE$.apply$default$1(), ActorMaterializer$.MODULE$.apply$default$2(), (ActorRefFactory)_actorSystem);
        StatusCodes.ServerError x$1 = StatusCodes$.MODULE$.GatewayTimeout();
        HttpEntity.Strict x$2 = HttpEntity$.MODULE$.apply(new StringBuilder(50).append("The proxy request did not responded after ").append(this.proxyConfig().timeout()).append(" seconds").toString());
        scala.collection.immutable.Seq x$3 = HttpResponse$.MODULE$.apply$default$2();
        HttpProtocol x$4 = HttpResponse$.MODULE$.apply$default$4();
        HttpResponse timeoutResponse = HttpResponse$.MODULE$.apply((StatusCode)x$1, x$3, (ResponseEntity)x$2, x$4);
        return (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.withRequestTimeout((Duration)new package.DurationInt(package$.MODULE$.DurationInt(this.proxyConfig().timeout())).seconds(), (Function1 & Serializable & scala.Serializable)request -> timeoutResponse)).apply((Function0 & Serializable & scala.Serializable)() -> (Function1 & Serializable & scala.Serializable)ctx -> {
            Function1 & Serializable & scala.Serializable intersect;
            Option<SSLContext> option = this.sslContext();
            if (option instanceof Some) {
                Some some = (Some)option;
                SSLContext sslCtx = (SSLContext)some.value();
                intersect = (Function1 & Serializable & scala.Serializable)x$1 -> {
                    HttpExt qual$1 = Http$.MODULE$.apply(_actorSystem);
                    HttpRequest x$5 = x$1;
                    HttpsConnectionContext x$6 = ConnectionContext$.MODULE$.https(sslCtx, ConnectionContext$.MODULE$.https$default$2(), ConnectionContext$.MODULE$.https$default$3(), ConnectionContext$.MODULE$.https$default$4(), ConnectionContext$.MODULE$.https$default$5(), ConnectionContext$.MODULE$.https$default$6(), ConnectionContext$.MODULE$.https$default$7());
                    ConnectionPoolSettings x$7 = qual$1.singleRequest$default$3();
                    LoggingAdapter x$8 = qual$1.singleRequest$default$4();
                    return qual$1.singleRequest(x$5, x$6, x$7, x$8);
                };
            } else if (None$.MODULE$.equals(option)) {
                intersect = (Function1 & Serializable & scala.Serializable)x$2 -> {
                    HttpExt qual$2 = Http$.MODULE$.apply(_actorSystem);
                    HttpRequest x$9 = x$2;
                    HttpsConnectionContext x$10 = qual$2.singleRequest$default$2();
                    ConnectionPoolSettings x$11 = qual$2.singleRequest$default$3();
                    LoggingAdapter x$12 = qual$2.singleRequest$default$4();
                    return qual$2.singleRequest(x$9, x$10, x$11, x$12);
                };
            } else {
                throw new MatchError(option);
            }
            Function1 & Serializable & scala.Serializable simpleClient = intersect;
            HttpRequest request = ctx.request();
            Uri qual$3 = Uri$.MODULE$.apply(requestPath.isEmpty() ? this.proxyConfig().uri() : new StringBuilder(1).append(this.proxyConfig().uri()).append("/").append(requestPath).toString());
            Option x$13 = request.uri().rawQueryString();
            String x$14 = qual$3.copy$default$1();
            Uri.Authority x$15 = qual$3.copy$default$2();
            Uri.Path x$16 = qual$3.copy$default$3();
            Option x$17 = qual$3.copy$default$5();
            Uri uri = qual$3.copy(x$14, x$15, x$16, x$13, x$17);
            scala.collection.immutable.Seq headers = (scala.collection.immutable.Seq)request.headers().filter((Function1 & Serializable & scala.Serializable)header -> BoxesRunTime.boxToBoolean((boolean)header.isNot(Host$.MODULE$.lowercaseName())));
            this.blended$akka$http$proxy$internal$ProxyRoute$$log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Received HttpRequest [").append(request).append("] at endpoint [").append(this.proxyConfig().path()).append("] and path [").append(requestPath).append("] with query [").append(request.uri().queryString(request.uri().queryString$default$1())).append("]").toString());
            this.blended$akka$http$proxy$internal$ProxyRoute$$log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("About to request [").append(uri).append("] with method [").append(request.method()).append("] with entity [").append(request.entity()).append("] and headers [").append(headers).append("]").toString());
            HttpMethod x$18 = request.method();
            Uri x$19 = uri;
            RequestEntity x$20 = request.entity();
            scala.collection.immutable.Seq x$21 = HttpRequest$.MODULE$.apply$default$3();
            HttpProtocol x$22 = HttpRequest$.MODULE$.apply$default$5();
            HttpRequest proxyReq = HttpRequest$.MODULE$.apply(x$18, x$19, x$21, x$20, x$22).withHeaders(headers);
            this.blended$akka$http$proxy$internal$ProxyRoute$$log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Final http request [").append(proxyReq).append("]").toString());
            return ctx.complete(ToResponseMarshallable$.MODULE$.apply((Object)this.handleResponse$1(proxyReq, this.proxyConfig().redirectCount(), this.proxyConfig(), simpleClient, materializer), Marshaller$.MODULE$.futureMarshaller(Marshaller$.MODULE$.fromResponse())));
        });
    }

    private Future handleResponse$1(HttpRequest request, int redirectCount, ProxyTarget config, Function1 simpleClient$1, ActorMaterializer materializer$1) {
        return ((Future)simpleClient$1.apply((Object)request)).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            StatusCode statusCode = response.status();
            if (statusCode instanceof StatusCodes.ServerError) {
                StatusCodes.ServerError serverError = (StatusCodes.ServerError)statusCode;
                ResponseEntity re = response.entity();
                this.blended$akka$http$proxy$internal$ProxyRoute$$log().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("503 Bad Gateway. The upstream (proxied) server returned with error [").append(serverError).append("] and response entity [").append(re).append("]").toString());
                return Future$.MODULE$.successful((Object)HttpResponse$.MODULE$.apply((StatusCode)StatusCodes$.MODULE$.BadGateway(), HttpResponse$.MODULE$.apply$default$2(), HttpResponse$.MODULE$.apply$default$3(), HttpResponse$.MODULE$.apply$default$4()));
            }
            if (statusCode instanceof StatusCodes.Redirection) {
                StatusCodes.Redirection redirection = (StatusCodes.Redirection)statusCode;
                if (redirectCount > 0 && ((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{301, 302, 307, 308}))).contains((Object)BoxesRunTime.boxToInteger((int)redirection.intValue()))) {
                    HttpRequest httpRequest;
                    Uri newUri = ((Location)response.header(ClassTag$.MODULE$.apply(Location.class)).get()).uri();
                    int newRedirectCount = redirectCount - 1;
                    Enumeration.Value value = config.redirectHeaderPolicy();
                    Enumeration.Value value2 = RedirectHeaderPolicy$.MODULE$.Client_Only();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        httpRequest = request;
                    } else {
                        Enumeration.Value value4 = RedirectHeaderPolicy$.MODULE$.Redirect_Merge();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            this.blended$akka$http$proxy$internal$ProxyRoute$$log().debug((Function0 & Serializable & scala.Serializable)() -> "Merging headers from redirect address into request header.");
                            httpRequest = (HttpRequest)response.headers().foldLeft((Object)request, (Function2 & Serializable & scala.Serializable)(r, h) -> !r.getHeader(h.name()).isPresent() ? (HttpRequest)r.withHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HttpHeader[]{h})) : r);
                        } else {
                            Enumeration.Value value6 = RedirectHeaderPolicy$.MODULE$.Redirect_Replace();
                            Enumeration.Value value7 = value;
                            if (value6 == null) {
                                if (value7 != null) {
                                    throw new MatchError((Object)value);
                                }
                            } else if (!value6.equals(value7)) throw new MatchError((Object)value);
                            this.blended$akka$http$proxy$internal$ProxyRoute$$log().debug((Function0 & Serializable & scala.Serializable)() -> "Replacing request headers with headers from redirect address");
                            scala.collection.immutable.Seq oldHeaders = request.headers();
                            oldHeaders.foreach((Function1 & Serializable & scala.Serializable)h -> (HttpRequest)request.removeHeader(h.name()));
                            httpRequest = request.withHeaders(response.headers());
                        }
                    }
                    HttpRequest newRequest = httpRequest;
                    this.blended$akka$http$proxy$internal$ProxyRoute$$log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append(redirection).append(". Retry request with new URI [").append(newUri).append("], headers [").append(newRequest.headers()).append("] and redirectCount [").append(newRedirectCount).append("]").toString());
                    HttpMessage.HttpMessageScalaDSLSugar$.MODULE$.discardEntityBytes$extension(HttpMessage$.MODULE$.HttpMessageScalaDSLSugar((HttpMessage)response), (Materializer)materializer$1);
                    return this.handleResponse$1(newRequest.withUri(newUri), newRedirectCount, config, simpleClient$1, materializer$1);
                }
            }
            this.blended$akka$http$proxy$internal$ProxyRoute$$log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append(statusCode).append(". Received upstream response with status [").append(response.status()).append("] and headers [").append(response.headers()).append("]").toString());
            return Future$.MODULE$.successful(response);
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public static void $init$(ProxyRoute $this) {
        $this.blended$akka$http$proxy$internal$ProxyRoute$_setter_$blended$akka$http$proxy$internal$ProxyRoute$$log_$eq(Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(ProxyRoute.class)));
    }
}

