/*
 * Decompiled with CFR 0.152.
 */
package blended.activemq.brokerstarter.internal;

import java.io.Serializable;
import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.Message;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00194AAB\u0004\u0001!!AA\u0004\u0001B\u0001B\u0003%Q\u0004C\u0003@\u0001\u0011\u0005\u0001\tC\u0003E\u0001\u0011\u0005S\tC\u0003W\u0001\u0011%q\u000bC\u0003`\u0001\u0011%\u0001M\u0001\rU)2+eNZ8sG&twM\u0011:pW\u0016\u0014\b\u000b\\;hS:T!\u0001C\u0005\u0002\u0011%tG/\u001a:oC2T!AC\u0006\u0002\u001b\t\u0014xn[3sgR\f'\u000f^3s\u0015\taQ\"\u0001\u0005bGRLg/Z7r\u0015\u0005q\u0011a\u00022mK:$W\rZ\u0002\u0001'\t\u0001\u0011\u0003\u0005\u0002\u001355\t1C\u0003\u0002\u0015+\u00051!M]8lKJT!\u0001\u0004\f\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\u0005\u00037M\u00111C\u0011:pW\u0016\u0014\b\u000b\\;hS:\u001cV\u000f\u001d9peR\fA\u0001\u001e;mgB\u0019a\u0004K\u0016\u000f\u0005})cB\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0010\u0003\u0019a$o\\8u}%\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'O\u00059\u0001/Y2lC\u001e,'\"\u0001\u0013\n\u0005%R#aA*fc*\u0011ae\n\t\u0005Y5zs'D\u0001(\u0013\tqsE\u0001\u0004UkBdWM\r\t\u0003aQr!!\r\u001a\u0011\u0005\u0001:\u0013BA\u001a(\u0003\u0019\u0001&/\u001a3fM&\u0011QG\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M:\u0003C\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003!!WO]1uS>t'B\u0001\u001f(\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003}e\u0012aBR5oSR,G)\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003\u000e\u0003\"A\u0011\u0001\u000e\u0003\u001dAQ\u0001\b\u0002A\u0002u\tAa]3oIR\u0019a)\u0013(\u0011\u00051:\u0015B\u0001%(\u0005\u0011)f.\u001b;\t\u000b)\u001b\u0001\u0019A&\u0002!A\u0014x\u000eZ;dKJ,\u0005p\u00195b]\u001e,\u0007C\u0001\nM\u0013\ti5C\u0001\fQe>$WoY3s\u0005J|7.\u001a:Fq\u000eD\u0017M\\4f\u0011\u0015y5\u00011\u0001Q\u0003\u001diWm]:bO\u0016\u0004\"!\u0015+\u000e\u0003IS!aU\u000b\u0002\u000f\r|W.\\1oI&\u0011QK\u0015\u0002\b\u001b\u0016\u001c8/Y4f\u0003-yg/\u001a:sS\u0012,G\u000b\u0016'\u0015\u0005as\u0006c\u0001\u0017Z7&\u0011!l\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00051b\u0016BA/(\u0005\u0011auN\\4\t\u000b=#\u0001\u0019\u0001)\u0002!%\u001cH)Z:uS:\fG/[8o\t2\u000bFCA1e!\ta#-\u0003\u0002dO\t9!i\\8mK\u0006t\u0007\"B3\u0006\u0001\u0004\u0001\u0016aA7tO\u0002")
public class TTLEnforcingBrokerPlugin
extends BrokerPluginSupport {
    private final Seq<Tuple2<String, FiniteDuration>> ttls;

    public void send(ProducerBrokerExchange producerExchange, Message message) {
        if (!this.isDestinationDLQ(message)) {
            this.overrideTTL(message).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)ttl -> {
                long timestamp = System.currentTimeMillis();
                message.setTimestamp(timestamp);
                message.setExpiration(timestamp + ttl);
            });
        }
        super.send(producerExchange, message);
    }

    private Option<Object> overrideTTL(Message message) {
        return this.ttls.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TTLEnforcingBrokerPlugin.$anonfun$overrideTTL$1(message, x0$1))).map((Function1 & Serializable)x$1 -> (FiniteDuration)x$1._2()).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.toMillis())).filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$3 -> x$3 >= 0L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDestinationDLQ(Message msg) {
        Tuple2 tuple2 = new Tuple2((Object)Option$.MODULE$.apply((Object)msg), (Object)Option$.MODULE$.apply((Object)((Destination)msg.getRegionDestination())));
        if (tuple2 == null) return false;
        Option option = (Option)tuple2._1();
        Option option2 = (Option)tuple2._2();
        if (!(option instanceof Some)) return false;
        Some some = (Some)option;
        Message message = (Message)some.value();
        if (!(option2 instanceof Some)) return false;
        Some some2 = (Some)option2;
        Destination regionDest = (Destination)some2.value();
        DeadLetterStrategy dls = regionDest.getDeadLetterStrategy();
        ActiveMQMessage tmp = new ActiveMQMessage();
        tmp.setDestination(message.getOriginalDestination());
        tmp.setRegionDestination((Message.MessageDestination)regionDest);
        ActiveMQDestination dlqDest = dls.getDeadLetterQueueFor((Message)tmp, null);
        return dlqDest.equals((Object)message.getDestination());
    }

    public static final /* synthetic */ boolean $anonfun$overrideTTL$1(Message message$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String p = (String)tuple2._1();
        boolean bl = message$2.getDestination().getQualifiedName().matches(p);
        return bl;
    }

    public TTLEnforcingBrokerPlugin(Seq<Tuple2<String, FiniteDuration>> ttls) {
        this.ttls = ttls;
    }
}

