/*
 * Decompiled with CFR 0.152.
 */
package de.wayofquality.blended.container.context.internal;

import de.wayofquality.blended.container.context.internal.ContainerShutdownMBean;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerShutdown
implements ContainerShutdownMBean {
    private BundleContext bundleContext = null;
    private static final long WAIT_MS = 5000L;
    private final Logger LOGGER = LoggerFactory.getLogger(ContainerShutdown.class);
    private MBeanServer mBeanServer = null;

    @Override
    public void shutdown() {
        Bundle[] bundles = this.bundleContext.getBundles();
        for (int i = bundles.length - 1; i >= 0; --i) {
            final Bundle b = bundles[i];
            if (bundles[i].getState() != 32) continue;
            this.LOGGER.debug("Stopping bundle [" + b.getBundleId() + ":" + b.getSymbolicName() + "]");
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    long started = System.currentTimeMillis();
                    try {
                        b.stop();
                        while (b.getState() != 4 && System.currentTimeMillis() - started < 5000L) {
                        }
                    }
                    catch (Exception e) {
                        ContainerShutdown.this.LOGGER.error("Failed to stop bundle [" + b.getBundleId() + ":" + b.getSymbolicName() + "]", (Throwable)e);
                    }
                }
            });
            t.start();
            try {
                t.join();
                continue;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        this.LOGGER.debug("Terminating container JVM...");
        new Timer(true).schedule(new TimerTask(){

            @Override
            public void run() {
                System.exit(0);
            }
        }, 1000L);
    }

    public void init() throws Exception {
        ObjectName objectName = new ObjectName("de.wayofquality.blended:type=ShutdownBean");
        this.getmBeanServer().registerMBean(this, objectName);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public MBeanServer getmBeanServer() {
        return this.mBeanServer;
    }

    public void setmBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }
}

