/*
 * Decompiled with CFR 0.152.
 */
package de.wayofquality.blended.container.context.internal;

import de.wayofquality.blended.container.context.ContainerContext;
import de.wayofquality.blended.container.context.internal.ContainerShutdown;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerContextImpl
implements ContainerContext {
    private static final String PROP_WOQ_HOME = "woq.home";
    private static final String CONFIG_DIR = "etc";
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerContextImpl.class);
    private ContainerShutdown containerShutdown = null;

    public String getContainerHostname() {
        String result = "UNKNOWN";
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            result = localMachine.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return result;
    }

    public String getContainerDirectory() {
        File configDir;
        String dir = System.getProperty(PROP_WOQ_HOME);
        if (dir == null) {
            dir = System.getProperty("user.dir");
        }
        if (!(configDir = new File(dir)).exists()) {
            LOGGER.error("Directory [" + dir + "] does not exist.");
            configDir = null;
        }
        if (!(configDir == null || configDir.isDirectory() && configDir.canRead())) {
            LOGGER.error("Directory [" + dir + "] is not readable.");
            configDir = null;
        }
        return configDir.getAbsolutePath();
    }

    public String getContainerConfigDirectory() {
        return this.getContainerDirectory() + "/" + CONFIG_DIR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties readConfig(String configId) {
        Properties props = new Properties();
        File f = new File(this.getConfigFile(configId));
        if (!f.exists() || f.isDirectory() || !f.canRead()) {
            LOGGER.warn("Cannot open [" + f.getAbsolutePath() + "]");
            return props;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            props.load(is);
        }
        catch (Exception e) {
            LOGGER.warn("Error reading config file.", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {}
            }
        }
        LOGGER.info(String.format("Read [%d] properties from [%s]", props.size(), f.getAbsolutePath()));
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeConfig(String configId, Properties props) {
        String configFile = this.getConfigFile(configId);
        LOGGER.debug("Wrting config for [" + configId + "] to [" + configFile + "].");
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(configFile);
            props.store(os, "");
        }
        catch (Exception e) {
            LOGGER.warn("Error writing config file.", (Throwable)e);
        }
        finally {
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (Exception e) {}
        }
        LOGGER.info("Exported configuration [{}]", (Object)configFile);
    }

    public void shutdown() {
        this.getContainerShutdown().shutdown();
    }

    public ContainerShutdown getContainerShutdown() {
        return this.containerShutdown;
    }

    public void setContainerShutdown(ContainerShutdown containerShutdown) {
        this.containerShutdown = containerShutdown;
    }

    private String getConfigFile(String configId) {
        return this.getContainerConfigDirectory() + "/" + configId + ".cfg";
    }
}

