/*
 * Decompiled with CFR 0.152.
 */
package de.wayofquality.blended.itestsupport.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.model.Link;
import de.wayofquality.blended.itestsupport.ContainerLink;
import de.wayofquality.blended.itestsupport.ContainerUnderTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001}3A!\u0001\u0002\u0001\u001b\tyAi\\2lKJ\u001cuN\u001c;bS:,'O\u0003\u0002\u0004\t\u00051Am\\2lKJT!!\u0002\u0004\u0002\u0019%$Xm\u001d;tkB\u0004xN\u001d;\u000b\u0005\u001dA\u0011a\u00022mK:$W\r\u001a\u0006\u0003\u0013)\tAb^1z_\u001a\fX/\u00197jifT\u0011aC\u0001\u0003I\u0016\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aD\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IAF\u0001\u0004GV$\bCA\f\u0019\u001b\u0005!\u0011BA\r\u0005\u0005I\u0019uN\u001c;bS:,'/\u00168eKJ$Vm\u001d;\t\u0011m\u0001!\u0011!Q\u0001\fq\taa\u00197jK:$\bCA\u000f'\u001b\u0005q\"BA\u0010!\u0003\r\t\u0007/\u001b\u0006\u0003C\t\n!\u0002Z8dW\u0016\u0014(.\u0019<b\u0015\t\u0019C%\u0001\u0004hSRDWO\u0019\u0006\u0002K\u0005\u00191m\\7\n\u0005\u001dr\"\u0001\u0004#pG.,'o\u00117jK:$\b\"B\u0015\u0001\t\u0003Q\u0013A\u0002\u001fj]&$h\b\u0006\u0002,_Q\u0011AF\f\t\u0003[\u0001i\u0011A\u0001\u0005\u00067!\u0002\u001d\u0001\b\u0005\u0006+!\u0002\rA\u0006\u0005\u0007c\u0001\u0001\u000b\u0011\u0002\u001a\u0002\r1|wmZ3s!\t\u0019\u0004(D\u00015\u0015\t)d'A\u0003tY\u001a$$NC\u00018\u0003\ry'oZ\u0005\u0003sQ\u0012a\u0001T8hO\u0016\u0014\bBB\u001e\u0001A\u0013%A(\u0001\u0002jIV\tQ\b\u0005\u0002?\u0003:\u0011qbP\u0005\u0003\u0001B\ta\u0001\u0015:fI\u00164\u0017B\u0001\"D\u0005\u0019\u0019FO]5oO*\u0011\u0001\t\u0005\u0005\u0007\u000b\u0002\u0001K\u0011\u0002\u001f\u0002\u001b\r|g\u000e^1j]\u0016\u0014h*Y7f\u0011\u00159\u0005\u0001\"\u0001I\u00039\u0019H/\u0019:u\u0007>tG/Y5oKJ,\u0012\u0001\f\u0005\u0006\u0015\u0002!\taS\u0001\u000eG>tG/Y5oKJLeNZ8\u0016\u00031\u0003\"!\u0014)\u000e\u00039S!a\u0014\u0010\u0002\u000f\r|W.\\1oI&\u0011\u0011K\u0014\u0002\u0019\u0013:\u001c\b/Z2u\u0007>tG/Y5oKJ\u0014Vm\u001d9p]N,\u0007\"B*\u0001\t\u0003!\u0016a\u0004:f[>4XmQ8oi\u0006Lg.\u001a:\u0016\u0003U\u0003\"AV.\u000e\u0003]S!\u0001W-\u0002\t1\fgn\u001a\u0006\u00025\u0006!!.\u0019<b\u0013\tavK\u0001\u0003W_&$\u0007\"\u00020\u0001\t\u0003A\u0015!D:u_B\u001cuN\u001c;bS:,'\u000f")
public class DockerContainer {
    private final ContainerUnderTest cut;
    private final DockerClient client;
    private final Logger logger;

    private String id() {
        return this.cut.imgId();
    }

    private String containerName() {
        return this.cut.dockerName();
    }

    public DockerContainer startContainer() {
        List links = (List)this.cut.links().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Link apply(ContainerLink l) {
                return Link.parse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{l.container(), l.hostname()})));
            }
        }, List$.MODULE$.canBuildFrom());
        this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting container [", "] with container links [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cut.dockerName(), links})));
        CreateContainerResponse container = this.client.createContainerCmd(this.id()).withName(this.cut.dockerName()).withTty(true).exec();
        StartContainerCmd cmd = this.client.startContainerCmd(this.containerName()).withPublishAllPorts(Predef$.MODULE$.boolean2Boolean(true));
        Object object = links.isEmpty() ? BoxedUnit.UNIT : cmd.withLinks((Link[])links.toArray(ClassTag$.MODULE$.apply(Link.class)));
        cmd.exec();
        return this;
    }

    public InspectContainerResponse containerInfo() {
        return this.client.inspectContainerCmd(this.containerName()).exec();
    }

    public Void removeContainer() {
        this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing container [", "] from Docker."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.containerName()})));
        return this.client.removeContainerCmd(this.containerName()).withForce(true).withRemoveVolumes(true).exec();
    }

    public DockerContainer stopContainer() {
        this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping container [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.containerName()})));
        this.client.stopContainerCmd(this.containerName()).exec();
        return this;
    }

    public DockerContainer(ContainerUnderTest cut, DockerClient client) {
        this.cut = cut;
        this.client = client;
        this.logger = LoggerFactory.getLogger((String)DockerContainer.class.getName());
    }
}

