/*
 * Decompiled with CFR 0.152.
 */
package de.wayofquality.blended.activemq.brokerstarter;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.Service;
import org.apache.activemq.broker.BrokerService;
import org.apache.camel.Component;
import org.apache.camel.component.jms.JmsComponent;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.connection.CachingConnectionFactory;

public class BrokerStarter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrokerStarter.class);
    private final BrokerService brokerService;
    private BundleContext bundleContext = null;

    public BrokerStarter(Service brokerService) {
        this.brokerService = (BrokerService)brokerService;
    }

    public void init() {
        try {
            this.brokerService.waitUntilStarted();
            LOGGER.info("ActiveMQ broker [" + this.brokerService.getBrokerName() + "] started successfully.");
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("provider", "activemq");
            ((Dictionary)props).put("brokername", this.brokerService.getBrokerName());
            ConnectionFactory cf = this.createConnectionFactory(this.brokerService);
            this.bundleContext.registerService(ConnectionFactory.class, (Object)cf, props);
            ((Dictionary)props).put("CamelComponentId", "activemq");
            this.bundleContext.registerService(Component.class, (Object)JmsComponent.jmsComponent((ConnectionFactory)cf), props);
        }
        catch (Exception e) {
            LOGGER.error("Failed to start Active MQ broker", (Throwable)e);
        }
    }

    public void destroy() {
    }

    private ConnectionFactory createConnectionFactory(BrokerService broker) {
        String url = "vm://" + broker.getBrokerName() + "?create=false";
        LOGGER.info("Creating ActiveMQ ConnectionFactory for URL [" + url + "}");
        ActiveMQConnectionFactory amqFactory = new ActiveMQConnectionFactory(url);
        return new CachingConnectionFactory((ConnectionFactory)amqFactory);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

