/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.fat.BootSector;

class FatUtils {
    public static long getFatOffset(BootSector bs, int fatNr) {
        long sectSize = bs.getBytesPerSector();
        long sectsPerFat = bs.getSectorsPerFat();
        long resSects = bs.getNrReservedSectors();
        long offset = resSects * sectSize;
        long fatSize = sectsPerFat * sectSize;
        return offset += (long)fatNr * fatSize;
    }

    public static long getRootDirOffset(BootSector bs) {
        long sectSize = bs.getBytesPerSector();
        long sectsPerFat = bs.getSectorsPerFat();
        int fats = bs.getNrFats();
        long offset = FatUtils.getFatOffset(bs, 0);
        return offset += (long)fats * sectsPerFat * sectSize;
    }

    public static long getFilesOffset(BootSector bs) {
        long offset = FatUtils.getRootDirOffset(bs);
        return offset += (long)(bs.getRootDirEntryCount() * 32);
    }

    private FatUtils() {
    }
}

