/*
 * Decompiled with CFR 0.152.
 */
package de.w3is.jdial.protocol;

import de.w3is.jdial.protocol.ApplicationResource;
import de.w3is.jdial.protocol.ApplicationResourceImpl;
import de.w3is.jdial.protocol.DeviceDescriptorResource;
import de.w3is.jdial.protocol.DeviceDescriptorResourceImpl;
import de.w3is.jdial.protocol.MSearch;
import de.w3is.jdial.protocol.MSearchImpl;
import de.w3is.jdial.protocol.ProtocolFactory;
import java.net.URL;

public class ProtocolFactoryImpl
implements ProtocolFactory {
    private boolean legacyCompatibility;
    private int httpClientReadTimeoutMs = 1500;
    private int httpClientConnectionTimeoutMs = 1500;
    private int socketTimeoutMs = 1500;
    private int mSearchResponseDelay = 0;

    public ProtocolFactoryImpl(boolean legacyCompatibility) {
        this.legacyCompatibility = legacyCompatibility;
    }

    @Override
    public MSearch createMSearch() {
        return new MSearchImpl(this.mSearchResponseDelay, this.socketTimeoutMs);
    }

    @Override
    public DeviceDescriptorResource createDeviceDescriptorResource() {
        return new DeviceDescriptorResourceImpl();
    }

    @Override
    public ApplicationResource createApplicationResource(String clientFriendlyName, URL applicationResourceUrl) {
        ApplicationResourceImpl applicationResource = new ApplicationResourceImpl(clientFriendlyName, applicationResourceUrl);
        applicationResource.setSendQueryParameter(!this.legacyCompatibility);
        applicationResource.setConnectionTimeout(this.httpClientConnectionTimeoutMs);
        applicationResource.setReadTimeout(this.httpClientReadTimeoutMs);
        return applicationResource;
    }

    public boolean isLegacyCompatibility() {
        return this.legacyCompatibility;
    }

    public int getHttpClientReadTimeoutMs() {
        return this.httpClientReadTimeoutMs;
    }

    public int getHttpClientConnectionTimeoutMs() {
        return this.httpClientConnectionTimeoutMs;
    }

    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    public int getMSearchResponseDelay() {
        return this.mSearchResponseDelay;
    }

    public void setLegacyCompatibility(boolean legacyCompatibility) {
        this.legacyCompatibility = legacyCompatibility;
    }

    public void setHttpClientReadTimeoutMs(int httpClientReadTimeoutMs) {
        this.httpClientReadTimeoutMs = httpClientReadTimeoutMs;
    }

    public void setHttpClientConnectionTimeoutMs(int httpClientConnectionTimeoutMs) {
        this.httpClientConnectionTimeoutMs = httpClientConnectionTimeoutMs;
    }

    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    public void setMSearchResponseDelay(int mSearchResponseDelay) {
        this.mSearchResponseDelay = mSearchResponseDelay;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProtocolFactoryImpl)) {
            return false;
        }
        ProtocolFactoryImpl other = (ProtocolFactoryImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLegacyCompatibility() != other.isLegacyCompatibility()) {
            return false;
        }
        if (this.getHttpClientReadTimeoutMs() != other.getHttpClientReadTimeoutMs()) {
            return false;
        }
        if (this.getHttpClientConnectionTimeoutMs() != other.getHttpClientConnectionTimeoutMs()) {
            return false;
        }
        if (this.getSocketTimeoutMs() != other.getSocketTimeoutMs()) {
            return false;
        }
        return this.getMSearchResponseDelay() == other.getMSearchResponseDelay();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProtocolFactoryImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLegacyCompatibility() ? 79 : 97);
        result = result * 59 + this.getHttpClientReadTimeoutMs();
        result = result * 59 + this.getHttpClientConnectionTimeoutMs();
        result = result * 59 + this.getSocketTimeoutMs();
        result = result * 59 + this.getMSearchResponseDelay();
        return result;
    }

    public String toString() {
        return "ProtocolFactoryImpl(legacyCompatibility=" + this.isLegacyCompatibility() + ", httpClientReadTimeoutMs=" + this.getHttpClientReadTimeoutMs() + ", httpClientConnectionTimeoutMs=" + this.getHttpClientConnectionTimeoutMs() + ", socketTimeoutMs=" + this.getSocketTimeoutMs() + ", mSearchResponseDelay=" + this.getMSearchResponseDelay() + ")";
    }
}

