/*
 * Decompiled with CFR 0.152.
 */
package de.w3is.jdial.protocol;

import de.w3is.jdial.model.DialServer;
import de.w3is.jdial.protocol.MSearch;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

class MSearchImpl
implements MSearch {
    private static final Logger LOGGER = Logger.getLogger(MSearchImpl.class.getName());
    private static final String MULTICAST_IP = "239.255.255.250";
    private static final int MULTICAST_PORT = 1900;
    private static final String SEARCH_TARGET_HEADER_VALUE = "urn:dial-multiscreen-org:service:dial:1";
    private static final String SEARCH_TARGET_HEADER = "ST";
    private static final String LOCATION_HEADER = "LOCATION";
    private static final String USN_HEADER = "USN";
    private static final String WAKEUP_HEADER = "WAKEUP";
    private static final String SERVER_HEADER = "SERVER";
    private static final String WOL_MAC = "MAC";
    private static final String WOL_TIMEOUT = "TIMEOUT";
    private final String msearchRequest;
    private final int socketTimeoutMs;

    MSearchImpl(int responseDelay, int socketTimeoutMs) {
        this.msearchRequest = "M-SEARCH * HTTP/1.1\r\nHOST: 239.255.255.250:1900\r\nMAN: \"ssdp:discover\"\r\nMX: " + responseDelay + "\r\n" + SEARCH_TARGET_HEADER + ": " + SEARCH_TARGET_HEADER_VALUE + "\r\nUSER-AGENT: OS/version product/version\r\n";
        this.socketTimeoutMs = socketTimeoutMs;
    }

    @Override
    public List<DialServer> sendAndReceive() throws IOException {
        InetAddress inetAddress = InetAddress.getByName(MULTICAST_IP);
        byte[] requestBuffer = this.msearchRequest.getBytes(StandardCharsets.UTF_8);
        DatagramPacket requestPacket = new DatagramPacket(requestBuffer, requestBuffer.length, inetAddress, 1900);
        MulticastSocket socket = new MulticastSocket(1900);
        socket.setReuseAddress(true);
        socket.setSoTimeout(this.socketTimeoutMs);
        socket.joinGroup(inetAddress);
        LOGGER.log(Level.FINE, "Send M-SEARCH request");
        socket.send(requestPacket);
        HashMap discoveredDevicesByNames = new HashMap();
        try {
            while (true) {
                byte[] responseBuffer = new byte[1024];
                DatagramPacket responsePacket = new DatagramPacket(responseBuffer, responseBuffer.length);
                socket.receive(responsePacket);
                this.toDevice(responsePacket).ifPresent(device -> {
                    if (!discoveredDevicesByNames.containsKey(device.getUniqueServiceName())) {
                        LOGGER.log(Level.FINE, "Found device: " + device.toString());
                        discoveredDevicesByNames.put(device.getUniqueServiceName(), device);
                    }
                });
            }
        }
        catch (SocketTimeoutException e) {
            LOGGER.log(Level.FINER, "Socket timed out: ", e);
            return new ArrayList<DialServer>(discoveredDevicesByNames.values());
        }
    }

    private Optional<DialServer> toDevice(DatagramPacket packet) throws UnsupportedEncodingException {
        String data = new String(packet.getData(), StandardCharsets.UTF_8);
        if (!data.contains(SEARCH_TARGET_HEADER_VALUE)) {
            LOGGER.log(Level.FINER, "Ignore response for unrelated search target: " + data);
            return Optional.empty();
        }
        String[] dataRows = data.split("\n");
        DialServer dialServer = new DialServer();
        block12: for (String row : dataRows) {
            String headerName;
            String[] headerParts = row.split(": ");
            if (headerParts.length != 2) continue;
            switch (headerName = headerParts[0].toUpperCase()) {
                case "LOCATION": {
                    this.parseDeviceDescriptorUrl(dialServer, headerParts[1]);
                    continue block12;
                }
                case "USN": {
                    dialServer.setUniqueServiceName(headerParts[1]);
                    continue block12;
                }
                case "WAKEUP": {
                    this.parseWolHeader(dialServer, headerParts[1]);
                    continue block12;
                }
                case "SERVER": {
                    dialServer.setServerDescription(headerParts[1]);
                    continue block12;
                }
                default: {
                    LOGGER.log(Level.FINE, "Ignoring unknown header: " + headerName);
                }
            }
        }
        if (dialServer.getDeviceDescriptorUrl() != null && dialServer.getUniqueServiceName() != null && dialServer.getUniqueServiceName().length() > 0) {
            return Optional.of(dialServer);
        }
        LOGGER.log(Level.FINER, "Ignore package with incomplete data: " + data);
        return Optional.empty();
    }

    private void parseDeviceDescriptorUrl(DialServer dialServer, String headerPart) {
        try {
            dialServer.setDeviceDescriptorUrl(new URL(headerPart));
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.WARNING, "Server provided malformed device descriptor url: ", e);
        }
    }

    private void parseWolHeader(DialServer dialServer, String headerValue) {
        String[] wolParts;
        block8: for (String wolPart : wolParts = headerValue.split(";")) {
            String[] wolHeader = wolPart.split("=");
            if (wolHeader.length != 2) continue;
            switch (wolHeader[0].toUpperCase()) {
                case "MAC": {
                    dialServer.setWakeOnLanMAC(wolHeader[1]);
                    dialServer.setWakeOnLanSupport(true);
                    continue block8;
                }
                case "TIMEOUT": {
                    dialServer.setWakeOnLanTimeout(Integer.parseInt(wolHeader[1]));
                    continue block8;
                }
                default: {
                    LOGGER.log(Level.FINE, "Ignore unknown wol header: " + wolHeader[0]);
                }
            }
        }
    }
}

