/*
 * Decompiled with CFR 0.152.
 */
package de.w3is.jdial.protocol;

import de.w3is.jdial.protocol.DeviceDescriptorResource;
import de.w3is.jdial.protocol.XMLUtil;
import de.w3is.jdial.protocol.model.DeviceDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

class DeviceDescriptorResourceImpl
implements DeviceDescriptorResource {
    private static final Logger LOGGER = Logger.getLogger(DeviceDescriptorResourceImpl.class.getName());
    private static final String APPLICATION_URL_HEADER = "Application-URL";

    DeviceDescriptorResourceImpl() {
    }

    @Override
    public Optional<DeviceDescriptor> getDescriptor(URL deviceDescriptorLocation) throws IOException {
        if (deviceDescriptorLocation == null) {
            throw new IllegalArgumentException("Device descriptor can't be null");
        }
        if (!deviceDescriptorLocation.getProtocol().equals("http")) {
            LOGGER.log(Level.WARNING, "Only http is supported for device descriptor resolution");
            return Optional.empty();
        }
        HttpURLConnection connection = (HttpURLConnection)deviceDescriptorLocation.openConnection();
        if (connection.getResponseCode() != 200) {
            LOGGER.log(Level.WARNING, "Could not get device descriptor: " + connection.getResponseCode());
            return Optional.empty();
        }
        String applicationUrl = connection.getHeaderField(APPLICATION_URL_HEADER);
        if (applicationUrl == null) {
            LOGGER.log(Level.WARNING, "Server didn't return applicationUrl");
            return Optional.empty();
        }
        DeviceDescriptor deviceDescriptor = new DeviceDescriptor();
        deviceDescriptor.setApplicationResourceUrl(new URL(applicationUrl));
        this.readInfoFromBody(connection, deviceDescriptor);
        return Optional.of(deviceDescriptor);
    }

    private void readInfoFromBody(HttpURLConnection connection, DeviceDescriptor deviceDescriptor) throws IOException {
        try (InputStream inputStream = connection.getInputStream();){
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document bodyDocument = documentBuilder.parse(inputStream);
            bodyDocument.getDocumentElement().normalize();
            deviceDescriptor.setFriendlyName(XMLUtil.getTextFromSub(bodyDocument, "friendlyName"));
        }
        catch (ParserConfigurationException | SAXException e) {
            LOGGER.log(Level.WARNING, "Error while parsing device descriptor:", e);
        }
    }
}

