/*
 * Decompiled with CFR 0.152.
 */
package de.w3is.jdial.protocol;

import de.w3is.jdial.model.Application;
import de.w3is.jdial.model.DialContent;
import de.w3is.jdial.model.State;
import de.w3is.jdial.protocol.ApplicationResource;
import de.w3is.jdial.protocol.URLBuilder;
import de.w3is.jdial.protocol.XMLUtil;
import de.w3is.jdial.protocol.model.ApplicationResourceException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class ApplicationResourceImpl
implements ApplicationResource {
    private static final Logger LOGGER = Logger.getLogger(ApplicationResourceImpl.class.getName());
    private static final String APPLICATION_DIAL_VERSION_QUERY = "clientDialVersion=2.1";
    private static final String CLIENT_FRIENDLY_NAME_QUERY = "friendlyName";
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final DialContent NO_CONTENT = () -> null;
    private final String clientFriendlyName;
    private final URL rootUrl;
    private boolean sendQueryParameter;
    private Integer connectionTimeout;
    private Integer readTimeout;

    ApplicationResourceImpl(String clientFriendlyName, URL rootUrl) {
        this.clientFriendlyName = clientFriendlyName;
        this.rootUrl = rootUrl;
        this.sendQueryParameter = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Application> getApplication(String applicationName) throws IOException {
        URLBuilder applicationUrl = URLBuilder.of(this.rootUrl).path(applicationName);
        if (this.sendQueryParameter) {
            applicationUrl.query(APPLICATION_DIAL_VERSION_QUERY);
        }
        HttpURLConnection httpUrlConnection = (HttpURLConnection)applicationUrl.build().openConnection();
        this.addTimeoutParameter(httpUrlConnection);
        httpUrlConnection.setDoInput(true);
        if (httpUrlConnection.getResponseCode() != 200) {
            LOGGER.log(Level.FINE, "Application not found: ", httpUrlConnection.getResponseCode());
            return Optional.empty();
        }
        try (InputStream inputStream = httpUrlConnection.getInputStream();){
            Document serviceDocument = this.getServiceDocument(inputStream);
            Application application = new Application();
            application.setName(XMLUtil.getTextFromSub(serviceDocument, "name"));
            application.setInstanceUrl(this.getInstanceUrl(serviceDocument, application.getName()));
            application.setAllowStop(this.getIsAllowStopFromOption(serviceDocument));
            application.setAdditionalData(this.extractAdditionalData(serviceDocument));
            this.extractState(serviceDocument, application);
            Optional<Application> optional = Optional.of(application);
            return optional;
        }
        catch (ApplicationResourceException | ParserConfigurationException | SAXException e) {
            LOGGER.log(Level.WARNING, "Can't parse body xml", e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<URL> startApplication(String applicationName) throws IOException, ApplicationResourceException {
        return this.startApplication(applicationName, NO_CONTENT);
    }

    @Override
    public Optional<URL> startApplication(String applicationName, DialContent dialContent) throws IOException, ApplicationResourceException {
        URLBuilder applicationUrl = URLBuilder.of(this.rootUrl).path(applicationName);
        if (this.clientFriendlyName != null && this.sendQueryParameter) {
            applicationUrl.query(CLIENT_FRIENDLY_NAME_QUERY, this.clientFriendlyName);
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)applicationUrl.build().openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setDoOutput(true);
        this.addTimeoutParameter(httpURLConnection);
        if (dialContent.getData() == null) {
            httpURLConnection.setRequestProperty(CONTENT_LENGTH_HEADER, "0");
            httpURLConnection.getOutputStream().close();
        } else {
            httpURLConnection.setRequestProperty(CONTENT_LENGTH_HEADER, String.valueOf(dialContent.getData().length));
            httpURLConnection.setRequestProperty(CONTENT_TYPE_HEADER, dialContent.getContentType());
            try (OutputStream outputStream = httpURLConnection.getOutputStream();){
                outputStream.write(dialContent.getData());
            }
        }
        int code = httpURLConnection.getResponseCode();
        if (code == 200 || code == 201) {
            String instanceLocation = httpURLConnection.getHeaderField("LOCATION");
            if (instanceLocation != null) {
                return Optional.of(new URL(instanceLocation));
            }
            return Optional.empty();
        }
        throw new ApplicationResourceException("Could not start application. Status: " + code);
    }

    @Override
    public void stopApplication(URL instanceUrl) throws IOException, ApplicationResourceException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)instanceUrl.openConnection();
        this.addTimeoutParameter(httpURLConnection);
        httpURLConnection.setRequestMethod("DELETE");
        if (httpURLConnection.getResponseCode() != 200) {
            throw new ApplicationResourceException("Could not stop the application. Status: " + httpURLConnection.getResponseCode());
        }
    }

    @Override
    public void hideApplication(URL instanceURL) throws IOException, ApplicationResourceException {
        URL hidingUrl = URLBuilder.of(instanceURL).path("hide").build();
        HttpURLConnection httpURLConnection = (HttpURLConnection)hidingUrl.openConnection();
        this.addTimeoutParameter(httpURLConnection);
        httpURLConnection.setRequestMethod("POST");
        if (httpURLConnection.getResponseCode() != 200) {
            throw new ApplicationResourceException("Could not hide the application. Status: " + httpURLConnection.getResponseCode());
        }
    }

    private Document getServiceDocument(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        document.getDocumentElement().normalize();
        return document;
    }

    private Node extractAdditionalData(Document document) {
        NodeList nodes = document.getElementsByTagName("additionalData");
        if (nodes.getLength() >= 1) {
            return nodes.item(0);
        }
        return null;
    }

    private boolean getIsAllowStopFromOption(Document document) {
        NodeList nodes = document.getElementsByTagName("options");
        if (nodes.getLength() < 1) {
            return false;
        }
        NamedNodeMap optionAttributes = nodes.item(0).getAttributes();
        Node allowStop = optionAttributes.getNamedItem("allowStop");
        return allowStop != null && Boolean.parseBoolean(allowStop.getTextContent());
    }

    private URL getInstanceUrl(Document document, String applicationName) throws MalformedURLException, ApplicationResourceException {
        NodeList nodes = document.getElementsByTagName("link");
        if (nodes.getLength() < 1) {
            throw new ApplicationResourceException("Document has no link element");
        }
        NamedNodeMap linkAttributes = nodes.item(0).getAttributes();
        Node href = linkAttributes.getNamedItem("href");
        Node rel = linkAttributes.getNamedItem("rel");
        if (rel == null || href == null || !rel.getTextContent().equals("run")) {
            throw new ApplicationResourceException("Unknown link type on service");
        }
        return URLBuilder.of(this.rootUrl).path(applicationName).path(href.getTextContent()).build();
    }

    private void extractState(Document document, Application application) throws ApplicationResourceException, MalformedURLException {
        String stateText = XMLUtil.getTextFromSub(document, "state");
        State state = this.mapToState(stateText);
        application.setState(state);
        if (state == State.INSTALLABLE) {
            application.setInstallUrl(this.getInstallUrl(stateText));
        }
    }

    private URL getInstallUrl(String state) throws MalformedURLException {
        String[] stateParts = state.split("=");
        if (stateParts.length < 2) {
            return null;
        }
        return new URL(stateParts[1]);
    }

    private State mapToState(String value) throws ApplicationResourceException {
        if (value == null) {
            throw new ApplicationResourceException("App exists but has no state");
        }
        String lowercaseStatus = value.toLowerCase();
        if (lowercaseStatus.startsWith("installable")) {
            return State.INSTALLABLE;
        }
        switch (lowercaseStatus) {
            case "running": {
                return State.RUNNING;
            }
            case "stopped": {
                return State.STOPPED;
            }
            case "hidden": {
                return State.HIDDEN;
            }
        }
        throw new ApplicationResourceException("Unknown state: " + value);
    }

    private void addTimeoutParameter(HttpURLConnection httpUrlConnection) {
        if (this.connectionTimeout != null) {
            httpUrlConnection.setConnectTimeout(this.connectionTimeout);
        }
        if (this.readTimeout != null) {
            httpUrlConnection.setReadTimeout(this.readTimeout);
        }
    }

    public String getClientFriendlyName() {
        return this.clientFriendlyName;
    }

    public URL getRootUrl() {
        return this.rootUrl;
    }

    public boolean isSendQueryParameter() {
        return this.sendQueryParameter;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setSendQueryParameter(boolean sendQueryParameter) {
        this.sendQueryParameter = sendQueryParameter;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationResourceImpl)) {
            return false;
        }
        ApplicationResourceImpl other = (ApplicationResourceImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientFriendlyName = this.getClientFriendlyName();
        String other$clientFriendlyName = other.getClientFriendlyName();
        if (this$clientFriendlyName == null ? other$clientFriendlyName != null : !this$clientFriendlyName.equals(other$clientFriendlyName)) {
            return false;
        }
        URL this$rootUrl = this.getRootUrl();
        URL other$rootUrl = other.getRootUrl();
        if (this$rootUrl == null ? other$rootUrl != null : !((Object)this$rootUrl).equals(other$rootUrl)) {
            return false;
        }
        if (this.isSendQueryParameter() != other.isSendQueryParameter()) {
            return false;
        }
        Integer this$connectionTimeout = this.getConnectionTimeout();
        Integer other$connectionTimeout = other.getConnectionTimeout();
        if (this$connectionTimeout == null ? other$connectionTimeout != null : !((Object)this$connectionTimeout).equals(other$connectionTimeout)) {
            return false;
        }
        Integer this$readTimeout = this.getReadTimeout();
        Integer other$readTimeout = other.getReadTimeout();
        return !(this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApplicationResourceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientFriendlyName = this.getClientFriendlyName();
        result = result * 59 + ($clientFriendlyName == null ? 43 : $clientFriendlyName.hashCode());
        URL $rootUrl = this.getRootUrl();
        result = result * 59 + ($rootUrl == null ? 43 : ((Object)$rootUrl).hashCode());
        result = result * 59 + (this.isSendQueryParameter() ? 79 : 97);
        Integer $connectionTimeout = this.getConnectionTimeout();
        result = result * 59 + ($connectionTimeout == null ? 43 : ((Object)$connectionTimeout).hashCode());
        Integer $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        return result;
    }

    public String toString() {
        return "ApplicationResourceImpl(clientFriendlyName=" + this.getClientFriendlyName() + ", rootUrl=" + this.getRootUrl() + ", sendQueryParameter=" + this.isSendQueryParameter() + ", connectionTimeout=" + this.getConnectionTimeout() + ", readTimeout=" + this.getReadTimeout() + ")";
    }
}

