/*
 * Decompiled with CFR 0.152.
 */
package de.w3is.jdial;

import de.w3is.jdial.model.DialServer;
import de.w3is.jdial.protocol.ProtocolFactory;
import de.w3is.jdial.protocol.model.DeviceDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Discovery {
    private static final Logger LOGGER = Logger.getLogger(Discovery.class.getName());
    private final ProtocolFactory protocolFactory;

    public Discovery(ProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Discovery() {
        this(ProtocolFactory.createInstance());
    }

    public List<DialServer> discover() {
        List<DialServer> dialServers;
        try {
            dialServers = this.protocolFactory.createMSearch().sendAndReceive();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "IOException while discovering devices:", e);
            return Collections.emptyList();
        }
        ArrayList<DialServer> devicesToRemove = new ArrayList<DialServer>();
        for (DialServer device : dialServers) {
            try {
                Optional<DeviceDescriptor> optionalDescriptor = this.protocolFactory.createDeviceDescriptorResource().getDescriptor(device.getDeviceDescriptorUrl());
                if (optionalDescriptor.isPresent()) {
                    DeviceDescriptor descriptor = optionalDescriptor.get();
                    device.setFriendlyName(descriptor.getFriendlyName());
                    device.setApplicationResourceUrl(descriptor.getApplicationResourceUrl());
                    continue;
                }
                devicesToRemove.add(device);
            }
            catch (IOException e) {
                devicesToRemove.add(device);
                LOGGER.log(Level.WARNING, "IOException while reading device descriptor " + device.getDeviceDescriptorUrl(), e);
            }
        }
        dialServers.removeAll(devicesToRemove);
        return dialServers;
    }
}

