/*
 * Decompiled with CFR 0.152.
 */
package de.w3is.jdial;

import de.w3is.jdial.model.Application;
import de.w3is.jdial.model.DialClientException;
import de.w3is.jdial.model.DialContent;
import de.w3is.jdial.model.State;
import de.w3is.jdial.protocol.ApplicationResource;
import de.w3is.jdial.protocol.model.ApplicationResourceException;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DialClientConnection {
    private static final Logger LOGGER = Logger.getLogger(DialClientConnection.class.getName());
    private ApplicationResource applicationResource;

    DialClientConnection(ApplicationResource applicationResource) {
        this.applicationResource = applicationResource;
    }

    public boolean supportsApplication(String applicationName) {
        return this.getApplication(applicationName).isPresent();
    }

    public Optional<Application> getApplication(String applicationName) {
        try {
            return this.applicationResource.getApplication(applicationName);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "IOException while getting application", e);
            return Optional.empty();
        }
    }

    public Optional<URL> startApplication(Application application) throws DialClientException {
        return this.startApplication(application.getName());
    }

    public Optional<URL> startApplication(Application application, DialContent dialContent) throws DialClientException {
        return this.startApplication(application.getName(), dialContent);
    }

    public Optional<URL> startApplication(String applicationName) throws DialClientException {
        try {
            return this.applicationResource.startApplication(applicationName);
        }
        catch (ApplicationResourceException | IOException e) {
            LOGGER.log(Level.WARNING, "Exception while starting application", e);
            throw new DialClientException(e);
        }
    }

    public Optional<URL> startApplication(String applicationName, DialContent dialContent) throws DialClientException {
        try {
            return this.applicationResource.startApplication(applicationName, dialContent);
        }
        catch (ApplicationResourceException | IOException e) {
            LOGGER.log(Level.WARNING, "Exception while starting application", e);
            throw new DialClientException(e);
        }
    }

    public void stopApplication(URL instanceUrl) throws DialClientException {
        if (instanceUrl == null) {
            return;
        }
        try {
            this.applicationResource.stopApplication(instanceUrl);
        }
        catch (ApplicationResourceException | IOException e) {
            LOGGER.log(Level.WARNING, "Exception while stopping the application", e);
            throw new DialClientException(e);
        }
    }

    public void stopApplication(Application application) throws DialClientException {
        if (application.isAllowStop()) {
            throw new DialClientException("The application doesn't support stopping");
        }
        if (application.getState() == State.STOPPED) {
            return;
        }
        this.stopApplication(application.getInstanceUrl());
    }

    public void hideApplication(Application application) throws DialClientException {
        if (application.getState() == State.STOPPED || application.getState() == State.HIDDEN) {
            return;
        }
        this.hideApplication(application.getInstanceUrl());
    }

    private void hideApplication(URL instanceUrl) throws DialClientException {
        if (instanceUrl == null) {
            return;
        }
        try {
            this.applicationResource.hideApplication(instanceUrl);
        }
        catch (ApplicationResourceException | IOException e) {
            LOGGER.log(Level.WARNING, "Exception while hiding the application", e);
            throw new DialClientException(e);
        }
    }
}

