/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.twod.datamatrix;

import de.vwsoft.barcodelib4j.twod.datamatrix.ASCIIEncoder;
import de.vwsoft.barcodelib4j.twod.datamatrix.Base256Encoder;
import de.vwsoft.barcodelib4j.twod.datamatrix.C40Encoder;
import de.vwsoft.barcodelib4j.twod.datamatrix.Dimension;
import de.vwsoft.barcodelib4j.twod.datamatrix.EdifactEncoder;
import de.vwsoft.barcodelib4j.twod.datamatrix.Encoder;
import de.vwsoft.barcodelib4j.twod.datamatrix.EncoderContext;
import de.vwsoft.barcodelib4j.twod.datamatrix.SymbolShapeHint;
import de.vwsoft.barcodelib4j.twod.datamatrix.TextEncoder;
import de.vwsoft.barcodelib4j.twod.datamatrix.X12Encoder;
import java.util.Arrays;

public final class HighLevelEncoder {
    private static final char PAD = '\u0081';
    static final char LATCH_TO_C40 = '\u00e6';
    static final char LATCH_TO_BASE256 = '\u00e7';
    private static final char FNC1 = '\u00e8';
    static final char UPPER_SHIFT = '\u00eb';
    private static final char MACRO_05 = '\u00ec';
    private static final char MACRO_06 = '\u00ed';
    static final char LATCH_TO_ANSIX12 = '\u00ee';
    static final char LATCH_TO_TEXT = '\u00ef';
    static final char LATCH_TO_EDIFACT = '\u00f0';
    static final char C40_UNLATCH = '\u00fe';
    static final char X12_UNLATCH = '\u00fe';
    public static final String MACRO_05_HEADER = "[)>\u001e05\u001d";
    public static final String MACRO_06_HEADER = "[)>\u001e06\u001d";
    public static final String MACRO_TRAILER = "\u001e\u0004";
    static final int ASCII_ENCODATION = 0;
    static final int C40_ENCODATION = 1;
    static final int TEXT_ENCODATION = 2;
    static final int X12_ENCODATION = 3;
    static final int EDIFACT_ENCODATION = 4;
    static final int BASE256_ENCODATION = 5;

    private HighLevelEncoder() {
    }

    private static char randomize253State(int codewordPosition) {
        int pseudoRandom = 149 * codewordPosition % 253 + 1;
        int tempVariable = 129 + pseudoRandom;
        return (char)(tempVariable <= 254 ? tempVariable : tempVariable - 254);
    }

    public static String encodeHighLevel(String msg, SymbolShapeHint shape, Dimension minSize, Dimension maxSize, boolean isGS1, boolean forceC40) {
        StringBuilder codewords;
        C40Encoder c40Encoder = new C40Encoder();
        Encoder[] encoders = new Encoder[]{new ASCIIEncoder(), c40Encoder, new TextEncoder(), new X12Encoder(), new EdifactEncoder(), new Base256Encoder()};
        EncoderContext context = new EncoderContext(msg);
        context.setSymbolShape(shape);
        context.setSizeConstraints(minSize, maxSize);
        if (isGS1) {
            context.writeCodeword('\u00e8');
        } else if (msg.startsWith(MACRO_05_HEADER) && msg.endsWith(MACRO_TRAILER)) {
            context.writeCodeword('\u00ec');
            context.setSkipAtEnd(2);
            context.pos += MACRO_05_HEADER.length();
        } else if (msg.startsWith(MACRO_06_HEADER) && msg.endsWith(MACRO_TRAILER)) {
            context.writeCodeword('\u00ed');
            context.setSkipAtEnd(2);
            context.pos += MACRO_06_HEADER.length();
        }
        int encodingMode = 0;
        if (forceC40) {
            c40Encoder.encodeMaximal(context);
            encodingMode = context.getNewEncoding();
            context.resetEncoderSignal();
        }
        while (context.hasMoreCharacters()) {
            encoders[encodingMode].encode(context);
            if (context.getNewEncoding() < 0) continue;
            encodingMode = context.getNewEncoding();
            context.resetEncoderSignal();
        }
        int len = context.getCodewordCount();
        context.updateSymbolInfo();
        int capacity = context.getSymbolInfo().getDataCapacity();
        if (len < capacity && encodingMode != 0 && encodingMode != 5 && encodingMode != 4) {
            context.writeCodeword('\u00fe');
        }
        if ((codewords = context.getCodewords()).length() < capacity) {
            codewords.append('\u0081');
        }
        while (codewords.length() < capacity) {
            codewords.append(HighLevelEncoder.randomize253State(codewords.length() + 1));
        }
        return context.getCodewords().toString();
    }

    static int lookAheadTest(CharSequence msg, int startpos, int currentMode) {
        int newMode;
        block3: {
            block2: {
                newMode = HighLevelEncoder.lookAheadTestIntern(msg, startpos, currentMode);
                if (currentMode != 3 || newMode != 3) break block2;
                int endpos = Math.min(startpos + 3, msg.length());
                for (int i = startpos; i < endpos; ++i) {
                    if (HighLevelEncoder.isNativeX12(msg.charAt(i))) continue;
                    return 0;
                }
                break block3;
            }
            if (currentMode != 4 || newMode != 4) break block3;
            int endpos = Math.min(startpos + 4, msg.length());
            for (int i = startpos; i < endpos; ++i) {
                if (HighLevelEncoder.isNativeEDIFACT(msg.charAt(i))) continue;
                return 0;
            }
        }
        return newMode;
    }

    static int lookAheadTestIntern(CharSequence msg, int startpos, int currentMode) {
        float[] charCounts;
        if (startpos >= msg.length()) {
            return currentMode;
        }
        if (currentMode == 0) {
            charCounts = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.25f};
        } else {
            charCounts = new float[]{1.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.25f};
            charCounts[currentMode] = 0.0f;
        }
        int charsProcessed = 0;
        byte[] mins = new byte[6];
        int[] intCharCounts = new int[6];
        while (true) {
            if (startpos + charsProcessed == msg.length()) {
                Arrays.fill(mins, (byte)0);
                Arrays.fill(intCharCounts, 0);
                int min = HighLevelEncoder.findMinimums(charCounts, intCharCounts, Integer.MAX_VALUE, mins);
                int minCount = HighLevelEncoder.getMinimumCount(mins);
                if (intCharCounts[0] == min) {
                    return 0;
                }
                if (minCount == 1) {
                    if (mins[5] > 0) {
                        return 5;
                    }
                    if (mins[4] > 0) {
                        return 4;
                    }
                    if (mins[2] > 0) {
                        return 2;
                    }
                    if (mins[3] > 0) {
                        return 3;
                    }
                }
                return 1;
            }
            char c = msg.charAt(startpos + charsProcessed);
            ++charsProcessed;
            if (HighLevelEncoder.isDigit(c)) {
                charCounts[0] = charCounts[0] + 0.5f;
            } else if (HighLevelEncoder.isExtendedASCII(c)) {
                charCounts[0] = (float)Math.ceil(charCounts[0]);
                charCounts[0] = charCounts[0] + 2.0f;
            } else {
                charCounts[0] = (float)Math.ceil(charCounts[0]);
                charCounts[0] = charCounts[0] + 1.0f;
            }
            charCounts[1] = HighLevelEncoder.isNativeC40(c) ? charCounts[1] + 0.6666667f : (HighLevelEncoder.isExtendedASCII(c) ? charCounts[1] + 2.6666667f : charCounts[1] + 1.3333334f);
            charCounts[2] = HighLevelEncoder.isNativeText(c) ? charCounts[2] + 0.6666667f : (HighLevelEncoder.isExtendedASCII(c) ? charCounts[2] + 2.6666667f : charCounts[2] + 1.3333334f);
            charCounts[3] = HighLevelEncoder.isNativeX12(c) ? charCounts[3] + 0.6666667f : (HighLevelEncoder.isExtendedASCII(c) ? charCounts[3] + 4.3333335f : charCounts[3] + 3.3333333f);
            charCounts[4] = HighLevelEncoder.isNativeEDIFACT(c) ? charCounts[4] + 0.75f : (HighLevelEncoder.isExtendedASCII(c) ? charCounts[4] + 4.25f : charCounts[4] + 3.25f);
            charCounts[5] = HighLevelEncoder.isSpecialB256(c) ? charCounts[5] + 4.0f : charCounts[5] + 1.0f;
            if (charsProcessed < 4) continue;
            Arrays.fill(mins, (byte)0);
            Arrays.fill(intCharCounts, 0);
            HighLevelEncoder.findMinimums(charCounts, intCharCounts, Integer.MAX_VALUE, mins);
            if (intCharCounts[0] < HighLevelEncoder.min(intCharCounts[5], intCharCounts[1], intCharCounts[2], intCharCounts[3], intCharCounts[4])) {
                return 0;
            }
            if (intCharCounts[5] < intCharCounts[0] || intCharCounts[5] + 1 < HighLevelEncoder.min(intCharCounts[1], intCharCounts[2], intCharCounts[3], intCharCounts[4])) {
                return 5;
            }
            if (intCharCounts[4] + 1 < HighLevelEncoder.min(intCharCounts[5], intCharCounts[1], intCharCounts[2], intCharCounts[3], intCharCounts[0])) {
                return 4;
            }
            if (intCharCounts[2] + 1 < HighLevelEncoder.min(intCharCounts[5], intCharCounts[1], intCharCounts[4], intCharCounts[3], intCharCounts[0])) {
                return 2;
            }
            if (intCharCounts[3] + 1 < HighLevelEncoder.min(intCharCounts[5], intCharCounts[1], intCharCounts[4], intCharCounts[2], intCharCounts[0])) {
                return 3;
            }
            if (intCharCounts[1] + 1 >= HighLevelEncoder.min(intCharCounts[0], intCharCounts[5], intCharCounts[4], intCharCounts[2])) continue;
            if (intCharCounts[1] < intCharCounts[3]) {
                return 1;
            }
            if (intCharCounts[1] == intCharCounts[3]) break;
        }
        for (int p = startpos + charsProcessed + 1; p < msg.length(); ++p) {
            char tc = msg.charAt(p);
            if (HighLevelEncoder.isX12TermSep(tc)) {
                return 3;
            }
            if (!HighLevelEncoder.isNativeX12(tc)) break;
        }
        return 1;
    }

    private static int min(int f1, int f2, int f3, int f4, int f5) {
        return Math.min(HighLevelEncoder.min(f1, f2, f3, f4), f5);
    }

    private static int min(int f1, int f2, int f3, int f4) {
        return Math.min(f1, Math.min(f2, Math.min(f3, f4)));
    }

    private static int findMinimums(float[] charCounts, int[] intCharCounts, int min, byte[] mins) {
        for (int i = 0; i < 6; ++i) {
            intCharCounts[i] = (int)Math.ceil(charCounts[i]);
            int current = intCharCounts[i];
            if (min > current) {
                min = current;
                Arrays.fill(mins, (byte)0);
            }
            if (min != current) continue;
            int n = i;
            mins[n] = (byte)(mins[n] + 1);
        }
        return min;
    }

    private static int getMinimumCount(byte[] mins) {
        int minCount = 0;
        for (int i = 0; i < 6; ++i) {
            minCount += mins[i];
        }
        return minCount;
    }

    static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    static boolean isExtendedASCII(char ch) {
        return ch >= '\u0080' && ch <= '\u00ff';
    }

    static boolean isNativeC40(char ch) {
        return ch == ' ' || ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z';
    }

    static boolean isNativeText(char ch) {
        return ch == ' ' || ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z';
    }

    static boolean isNativeX12(char ch) {
        return HighLevelEncoder.isX12TermSep(ch) || ch == ' ' || ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z';
    }

    private static boolean isX12TermSep(char ch) {
        return ch == '\r' || ch == '*' || ch == '>';
    }

    static boolean isNativeEDIFACT(char ch) {
        return ch >= ' ' && ch <= '^';
    }

    private static boolean isSpecialB256(char ch) {
        return false;
    }

    public static int determineConsecutiveDigitCount(CharSequence msg, int startpos) {
        int idx;
        int len = msg.length();
        for (idx = startpos; idx < len && HighLevelEncoder.isDigit(msg.charAt(idx)); ++idx) {
        }
        return idx - startpos;
    }

    static void illegalCharacter(char c) {
        Object hex = Integer.toHexString(c);
        hex = "0000".substring(0, 4 - ((String)hex).length()) + (String)hex;
        throw new IllegalArgumentException("Illegal character: " + c + " (0x" + (String)hex + ")");
    }
}

