/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.twod.datamatrix;

import de.vwsoft.barcodelib4j.twod.datamatrix.DefaultPlacement;
import de.vwsoft.barcodelib4j.twod.datamatrix.Dimension;
import de.vwsoft.barcodelib4j.twod.datamatrix.ErrorCorrection;
import de.vwsoft.barcodelib4j.twod.datamatrix.HighLevelEncoder;
import de.vwsoft.barcodelib4j.twod.datamatrix.MinimalEncoder;
import de.vwsoft.barcodelib4j.twod.datamatrix.SymbolInfo;
import de.vwsoft.barcodelib4j.twod.datamatrix.SymbolShapeHint;
import de.vwsoft.barcodelib4j.twod.qrcode.ByteMatrix;
import de.vwsoft.barcodelib4j.twod.zxing.BarcodeFormat;
import de.vwsoft.barcodelib4j.twod.zxing.BitMatrix;
import de.vwsoft.barcodelib4j.twod.zxing.EncodeHintType;
import de.vwsoft.barcodelib4j.twod.zxing.Writer;
import java.nio.charset.Charset;
import java.util.Map;

public final class DataMatrixWriter
implements Writer {
    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height) {
        return this.encode(contents, format, width, height, null);
    }

    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) {
        String encoded;
        boolean hasCompactionHint;
        if (contents.isEmpty()) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (format != BarcodeFormat.DATA_MATRIX) {
            throw new IllegalArgumentException("Can only encode DATA_MATRIX, but got " + String.valueOf((Object)format));
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Requested dimensions can't be negative: " + width + "x" + height);
        }
        SymbolShapeHint shape = SymbolShapeHint.FORCE_NONE;
        Dimension minSize = null;
        Dimension maxSize = null;
        boolean hasGS1FormatHint = false;
        if (hints != null) {
            Object gs1;
            Dimension requestedMaxSize;
            Dimension requestedMinSize;
            SymbolShapeHint requestedShape = (SymbolShapeHint)((Object)hints.get((Object)EncodeHintType.DATA_MATRIX_SHAPE));
            if (requestedShape != null) {
                shape = requestedShape;
            }
            if ((requestedMinSize = (Dimension)hints.get((Object)EncodeHintType.MIN_SIZE)) != null) {
                minSize = requestedMinSize;
            }
            if ((requestedMaxSize = (Dimension)hints.get((Object)EncodeHintType.MAX_SIZE)) != null) {
                maxSize = requestedMaxSize;
            }
            hasGS1FormatHint = (gs1 = hints.get((Object)EncodeHintType.GS1_FORMAT)) != null ? Boolean.parseBoolean(gs1.toString()) : false;
        }
        boolean bl = hasCompactionHint = hints != null && hints.containsKey((Object)EncodeHintType.DATA_MATRIX_COMPACT) && Boolean.parseBoolean(hints.get((Object)EncodeHintType.DATA_MATRIX_COMPACT).toString());
        if (hasCompactionHint) {
            Charset charset = null;
            boolean hasEncodingHint = hints.containsKey((Object)EncodeHintType.CHARACTER_SET);
            if (hasEncodingHint) {
                charset = Charset.forName(hints.get((Object)EncodeHintType.CHARACTER_SET).toString());
            }
            encoded = MinimalEncoder.encodeHighLevel(contents, charset, hasGS1FormatHint ? 29 : -1, shape);
        } else {
            boolean hasForceC40Hint = hints != null && hints.containsKey((Object)EncodeHintType.FORCE_C40) && Boolean.parseBoolean(hints.get((Object)EncodeHintType.FORCE_C40).toString());
            encoded = HighLevelEncoder.encodeHighLevel(contents, shape, minSize, maxSize, hasGS1FormatHint, hasForceC40Hint);
        }
        SymbolInfo symbolInfo = SymbolInfo.lookup(encoded.length(), shape, minSize, maxSize, true);
        String codewords = ErrorCorrection.encodeECC200(encoded, symbolInfo);
        DefaultPlacement placement = new DefaultPlacement(codewords, symbolInfo.getSymbolDataWidth(), symbolInfo.getSymbolDataHeight());
        placement.place();
        return DataMatrixWriter.encodeLowLevel(placement, symbolInfo, width, height);
    }

    private static BitMatrix encodeLowLevel(DefaultPlacement placement, SymbolInfo symbolInfo, int width, int height) {
        int symbolWidth = symbolInfo.getSymbolDataWidth();
        int symbolHeight = symbolInfo.getSymbolDataHeight();
        ByteMatrix matrix = new ByteMatrix(symbolInfo.getSymbolWidth(), symbolInfo.getSymbolHeight());
        int matrixY = 0;
        for (int y = 0; y < symbolHeight; ++y) {
            int x;
            int matrixX;
            if (y % symbolInfo.matrixHeight == 0) {
                matrixX = 0;
                for (x = 0; x < symbolInfo.getSymbolWidth(); ++x) {
                    matrix.set(matrixX, matrixY, x % 2 == 0);
                    ++matrixX;
                }
                ++matrixY;
            }
            matrixX = 0;
            for (x = 0; x < symbolWidth; ++x) {
                if (x % symbolInfo.matrixWidth == 0) {
                    matrix.set(matrixX, matrixY, true);
                    ++matrixX;
                }
                matrix.set(matrixX, matrixY, placement.getBit(x, y));
                ++matrixX;
                if (x % symbolInfo.matrixWidth != symbolInfo.matrixWidth - 1) continue;
                matrix.set(matrixX, matrixY, y % 2 == 0);
                ++matrixX;
            }
            ++matrixY;
            if (y % symbolInfo.matrixHeight != symbolInfo.matrixHeight - 1) continue;
            matrixX = 0;
            for (x = 0; x < symbolInfo.getSymbolWidth(); ++x) {
                matrix.set(matrixX, matrixY, true);
                ++matrixX;
            }
            ++matrixY;
        }
        return DataMatrixWriter.convertByteMatrixToBitMatrix(matrix, width, height);
    }

    private static BitMatrix convertByteMatrixToBitMatrix(ByteMatrix matrix, int reqWidth, int reqHeight) {
        BitMatrix output;
        int matrixWidth = matrix.getWidth();
        int matrixHeight = matrix.getHeight();
        int outputWidth = Math.max(reqWidth, matrixWidth);
        int outputHeight = Math.max(reqHeight, matrixHeight);
        int multiple = Math.min(outputWidth / matrixWidth, outputHeight / matrixHeight);
        int leftPadding = (outputWidth - matrixWidth * multiple) / 2;
        int topPadding = (outputHeight - matrixHeight * multiple) / 2;
        if (reqHeight < matrixHeight || reqWidth < matrixWidth) {
            leftPadding = 0;
            topPadding = 0;
            output = new BitMatrix(matrixWidth, matrixHeight);
        } else {
            output = new BitMatrix(reqWidth, reqHeight);
        }
        output.clear();
        int inputY = 0;
        int outputY = topPadding;
        while (inputY < matrixHeight) {
            int inputX = 0;
            int outputX = leftPadding;
            while (inputX < matrixWidth) {
                if (matrix.get(inputX, inputY) == 1) {
                    output.setRegion(outputX, outputY, multiple, multiple);
                }
                ++inputX;
                outputX += multiple;
            }
            ++inputY;
            outputY += multiple;
        }
        return output;
    }
}

