/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.twod.aztec;

import de.vwsoft.barcodelib4j.twod.aztec.AztecCode;
import de.vwsoft.barcodelib4j.twod.aztec.Encoder;
import de.vwsoft.barcodelib4j.twod.zxing.BarcodeFormat;
import de.vwsoft.barcodelib4j.twod.zxing.BitMatrix;
import de.vwsoft.barcodelib4j.twod.zxing.EncodeHintType;
import de.vwsoft.barcodelib4j.twod.zxing.Writer;
import java.nio.charset.Charset;
import java.util.Map;

public final class AztecWriter
implements Writer {
    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height) {
        return this.encode(contents, format, width, height, null);
    }

    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) {
        Charset charset = null;
        int eccPercent = 33;
        int layers = 0;
        if (hints != null) {
            if (hints.containsKey((Object)EncodeHintType.CHARACTER_SET)) {
                charset = Charset.forName(hints.get((Object)EncodeHintType.CHARACTER_SET).toString());
            }
            if (hints.containsKey((Object)EncodeHintType.ERROR_CORRECTION)) {
                eccPercent = Integer.parseInt(hints.get((Object)EncodeHintType.ERROR_CORRECTION).toString());
            }
            if (hints.containsKey((Object)EncodeHintType.AZTEC_LAYERS)) {
                layers = Integer.parseInt(hints.get((Object)EncodeHintType.AZTEC_LAYERS).toString());
            }
        }
        return AztecWriter.encode(contents, format, width, height, charset, eccPercent, layers);
    }

    private static BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Charset charset, int eccPercent, int layers) {
        if (contents.isEmpty()) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (format != BarcodeFormat.AZTEC) {
            throw new IllegalArgumentException("Can only encode AZTEC, but got " + String.valueOf((Object)format));
        }
        AztecCode aztec = Encoder.encode(contents, eccPercent, layers, charset);
        return AztecWriter.renderResult(aztec, width, height);
    }

    private static BitMatrix renderResult(AztecCode code, int width, int height) {
        BitMatrix input = code.getMatrix();
        if (input == null) {
            throw new IllegalStateException();
        }
        int inputWidth = input.getWidth();
        int inputHeight = input.getHeight();
        int outputWidth = Math.max(width, inputWidth);
        int outputHeight = Math.max(height, inputHeight);
        int multiple = Math.min(outputWidth / inputWidth, outputHeight / inputHeight);
        int leftPadding = (outputWidth - inputWidth * multiple) / 2;
        int topPadding = (outputHeight - inputHeight * multiple) / 2;
        BitMatrix output = new BitMatrix(outputWidth, outputHeight);
        int inputY = 0;
        int outputY = topPadding;
        while (inputY < inputHeight) {
            int inputX = 0;
            int outputX = leftPadding;
            while (inputX < inputWidth) {
                if (input.get(inputX, inputY)) {
                    output.setRegion(outputX, outputY, multiple, multiple);
                }
                ++inputX;
                outputX += multiple;
            }
            ++inputY;
            outputY += multiple;
        }
        return output;
    }
}

