/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.twod;

public enum TwoDType {
    QRCODE("QR Code", 1, 4),
    DATAMATRIX("DataMatrix", 2, 1),
    PDF417("PDF 417", 3, 2),
    AZTEC("Aztec", 4, 0),
    GS1_QRCODE("GS1 QR Code", 5, 4),
    GS1_DATAMATRIX("GS1 DataMatrix", 6, 1);

    private final String myTypeName;
    private final int myID;
    private final int myDefaultQuietZone;

    private TwoDType(String typeName, int id, int defaultQuietZone) {
        this.myTypeName = typeName;
        this.myID = id;
        this.myDefaultQuietZone = defaultQuietZone;
    }

    public static TwoDType valueOf(int id) {
        for (TwoDType codeType : TwoDType.values()) {
            if (codeType.getID() != id) continue;
            return codeType;
        }
        throw new IllegalArgumentException("Invalid code type ID: " + id);
    }

    public int getID() {
        return this.myID;
    }

    public boolean isGS1() {
        return this == GS1_QRCODE || this == GS1_DATAMATRIX;
    }

    public int getDefaultQuietZone() {
        return this.myDefaultQuietZone;
    }

    public String getTypeName() {
        return this.myTypeName;
    }

    public String toString() {
        return this.myTypeName;
    }
}

