/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.twod;

import de.vwsoft.barcodelib4j.twod.zxing.BitMatrix;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Objects;

public class TwoDSymbol {
    private final Rectangle[] myChunks;
    private final Dimension mySize;

    public TwoDSymbol(BitMatrix bitMatrix, int quietZoneSize) {
        boolean bit;
        int i;
        boolean barOrSpace;
        int positionCounter;
        int j;
        Objects.requireNonNull(bitMatrix, "BitMatrix cannot be null");
        if (quietZoneSize < 0) {
            throw new IllegalArgumentException("Quiet zone size cannot be negative: " + quietZoneSize);
        }
        int matrixWidth = bitMatrix.getWidth();
        int matrixHeight = bitMatrix.getHeight();
        ArrayList<Rectangle> chunks = new ArrayList<Rectangle>(matrixWidth * matrixHeight / 3);
        for (j = 0; j < matrixHeight; ++j) {
            positionCounter = quietZoneSize;
            int widthCounter = 0;
            barOrSpace = bitMatrix.get(0, j);
            for (i = 0; i < matrixWidth; ++i) {
                bit = bitMatrix.get(i, j);
                if (bit != barOrSpace) {
                    if (!bit) {
                        chunks.add(new Rectangle(positionCounter, j + quietZoneSize, widthCounter, 1));
                    }
                    barOrSpace = bit;
                    positionCounter += widthCounter;
                    widthCounter = 1;
                    continue;
                }
                ++widthCounter;
            }
            if (!bitMatrix.get(matrixWidth - 1, j)) continue;
            chunks.add(new Rectangle(positionCounter, j + quietZoneSize, widthCounter, 1));
        }
        for (j = 0; j < matrixWidth; ++j) {
            positionCounter = quietZoneSize;
            int heightCounter = 0;
            barOrSpace = bitMatrix.get(j, 0);
            for (i = 0; i < matrixHeight; ++i) {
                bit = bitMatrix.get(j, i);
                if (bit != barOrSpace) {
                    if (!bit && heightCounter > 1) {
                        chunks.add(new Rectangle(j + quietZoneSize, positionCounter, 1, heightCounter));
                    }
                    barOrSpace = bit;
                    positionCounter += heightCounter;
                    heightCounter = 1;
                    continue;
                }
                ++heightCounter;
            }
            if (!bitMatrix.get(j, matrixHeight - 1)) continue;
            chunks.add(new Rectangle(j + quietZoneSize, positionCounter, 1, heightCounter));
        }
        this.myChunks = (Rectangle[])chunks.toArray(Rectangle[]::new);
        this.mySize = new Dimension(matrixWidth + (quietZoneSize <<= 1), matrixHeight + quietZoneSize);
    }

    public void draw(Graphics2D g2d, double x, double y, double w, double h, double dotSize, double moduleSize, double horBarWidthCorrection, double verBarWidthCorrection) {
        if (moduleSize == 0.0) {
            moduleSize = Math.min(w / (double)this.mySize.width, h / (double)this.mySize.height);
        }
        if (dotSize > 0.0) {
            moduleSize = (double)((int)(moduleSize / dotSize)) * dotSize;
        }
        double shiftedX = x + (w - moduleSize * (double)this.mySize.width) / 2.0 - horBarWidthCorrection;
        double shiftedY = y + (h - moduleSize * (double)this.mySize.height) / 2.0 - verBarWidthCorrection;
        double horBWC2 = horBarWidthCorrection * 2.0;
        double verBWC2 = verBarWidthCorrection * 2.0;
        Rectangle2D.Double chunk = new Rectangle2D.Double();
        for (Rectangle r : this.myChunks) {
            chunk.x = shiftedX + (double)r.x * moduleSize;
            chunk.y = shiftedY + (double)r.y * moduleSize;
            chunk.width = (double)r.width * moduleSize + horBWC2;
            chunk.height = (double)r.height * moduleSize + verBWC2;
            g2d.fill(chunk);
        }
    }

    public void draw(Graphics2D g2d, double x, double y, double w, double h, double dotSize) {
        this.draw(g2d, x, y, w, h, dotSize, 0.0, 0.0, 0.0);
    }

    public void draw(Graphics2D g2d, double x, double y, double w, double h) {
        this.draw(g2d, x, y, w, h, 0.0, 0.0, 0.0, 0.0);
    }
}

