/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.twod;

import de.vwsoft.barcodelib4j.twod.AztecSize;
import de.vwsoft.barcodelib4j.twod.DataMatrixShape;
import de.vwsoft.barcodelib4j.twod.DataMatrixSize;
import de.vwsoft.barcodelib4j.twod.PDF417ErrorCorrection;
import de.vwsoft.barcodelib4j.twod.PDF417Size;
import de.vwsoft.barcodelib4j.twod.QRCodeErrorCorrection;
import de.vwsoft.barcodelib4j.twod.QRCodeVersion;
import de.vwsoft.barcodelib4j.twod.TwoDSymbol;
import de.vwsoft.barcodelib4j.twod.TwoDType;
import de.vwsoft.barcodelib4j.twod.aztec.AztecWriter;
import de.vwsoft.barcodelib4j.twod.datamatrix.DataMatrixWriter;
import de.vwsoft.barcodelib4j.twod.datamatrix.Dimension;
import de.vwsoft.barcodelib4j.twod.datamatrix.SymbolShapeHint;
import de.vwsoft.barcodelib4j.twod.pdf417.Dimensions;
import de.vwsoft.barcodelib4j.twod.pdf417.PDF417Writer;
import de.vwsoft.barcodelib4j.twod.qrcode.QRCodeWriter;
import de.vwsoft.barcodelib4j.twod.zxing.BarcodeFormat;
import de.vwsoft.barcodelib4j.twod.zxing.BitMatrix;
import de.vwsoft.barcodelib4j.twod.zxing.EncodeHintType;
import de.vwsoft.barcodelib4j.twod.zxing.Writer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Objects;

public class TwoDCode
implements Cloneable {
    private TwoDType myType = TwoDType.QRCODE;
    private String myContent = "ABCD... 01234";
    private Charset myCharset = null;
    private int myQuietZoneSize = 1;
    private QRCodeVersion myQRVersion = QRCodeVersion.AUTO;
    private QRCodeErrorCorrection myQRErrCorr = QRCodeErrorCorrection.M;
    private DataMatrixSize myDMSize = DataMatrixSize.AUTO;
    private DataMatrixShape myDMShape = DataMatrixShape.AUTO;
    private PDF417Size myPDSize = new PDF417Size(0, 0);
    private PDF417ErrorCorrection myPDErrCorr = PDF417ErrorCorrection.EC2;
    private AztecSize myAZSize = AztecSize.AUTO;
    private int myAZErrCorr = 23;

    public TwoDCode() {
    }

    public TwoDCode(TwoDType codeType) {
        this.setType(codeType);
    }

    public void setType(TwoDType codeType) {
        this.myType = Objects.requireNonNull(codeType, "Code type cannot be null");
    }

    public void setContent(String content) {
        Objects.requireNonNull(content, "Content cannot be null");
        if (content.isEmpty()) {
            throw new IllegalArgumentException("Content cannot be empty");
        }
        this.myContent = content;
    }

    public void setCharset(Charset charset) {
        this.myCharset = charset;
    }

    public void setQuietZone(int sizeInModules) {
        if (sizeInModules < 0) {
            throw new IllegalArgumentException("Quiet zone size cannot be negative: " + sizeInModules);
        }
        this.myQuietZoneSize = sizeInModules;
    }

    public void setQRCodeVersion(QRCodeVersion version) {
        this.myQRVersion = Objects.requireNonNull(version, "QR Code version cannot be null");
    }

    public void setQRCodeErrCorr(QRCodeErrorCorrection errorCorrectionLevel) {
        this.myQRErrCorr = Objects.requireNonNull(errorCorrectionLevel, "QR Code error correction level cannot be null");
    }

    public void setDataMatrixSize(DataMatrixSize size) {
        this.myDMSize = Objects.requireNonNull(size, "DataMatrix size cannot be null");
    }

    public void setDataMatrixShape(DataMatrixShape shape) {
        this.myDMShape = Objects.requireNonNull(shape, "DataMatrix shape cannot be null");
    }

    public void setPDF417Size(PDF417Size size) {
        this.myPDSize = Objects.requireNonNull(size, "PDF417 size cannot be null");
    }

    public void setPDF417ErrCorr(PDF417ErrorCorrection errorCorrectionLevel) {
        this.myPDErrCorr = Objects.requireNonNull(errorCorrectionLevel, "PDF417 error correction level cannot be null");
    }

    public void setAztecSize(AztecSize size) {
        this.myAZSize = Objects.requireNonNull(size, "Aztec size cannot be null");
    }

    public void setAztecErrCorr(int errorCorrectionLevel) {
        if (errorCorrectionLevel < 5 || errorCorrectionLevel > 95) {
            throw new IllegalArgumentException("Invalid Aztec error correction level: " + errorCorrectionLevel);
        }
        this.myAZErrCorr = errorCorrectionLevel;
    }

    public boolean canEncode() {
        Charset cs = this.myCharset != null ? this.myCharset : StandardCharsets.ISO_8859_1;
        try {
            cs.newEncoder().encode(CharBuffer.wrap(this.myContent));
            return true;
        }
        catch (CharacterCodingException ex) {
            return false;
        }
    }

    public TwoDSymbol buildSymbol() throws Exception {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.MARGIN, 0);
        hints.put(EncodeHintType.GS1_FORMAT, this.myType.isGS1());
        if (this.myCharset != null) {
            hints.put(EncodeHintType.CHARACTER_SET, this.myCharset.name());
        }
        BarcodeFormat barcodeFormat = null;
        Writer writer = null;
        switch (this.myType) {
            case GS1_QRCODE: 
            case QRCODE: {
                barcodeFormat = BarcodeFormat.QR_CODE;
                writer = new QRCodeWriter();
                if (this.myQRVersion != QRCodeVersion.AUTO) {
                    hints.put(EncodeHintType.QR_VERSION, this.myQRVersion.getNumber());
                }
                hints.put(EncodeHintType.ERROR_CORRECTION, this.myQRErrCorr.name());
                break;
            }
            case GS1_DATAMATRIX: 
            case DATAMATRIX: {
                barcodeFormat = BarcodeFormat.DATA_MATRIX;
                writer = new DataMatrixWriter();
                if (this.myDMSize != DataMatrixSize.AUTO) {
                    Dimension dim = new Dimension(this.myDMSize.getWidth(), this.myDMSize.getHeight());
                    hints.put(EncodeHintType.MIN_SIZE, dim);
                    hints.put(EncodeHintType.MAX_SIZE, dim);
                    break;
                }
                hints.put(EncodeHintType.DATA_MATRIX_SHAPE, (Object)SymbolShapeHint.values()[this.myDMShape.getID()]);
                if (this.myCharset == null) break;
                hints.put(EncodeHintType.DATA_MATRIX_COMPACT, true);
                break;
            }
            case PDF417: {
                barcodeFormat = BarcodeFormat.PDF_417;
                writer = new PDF417Writer();
                int minCols = this.myPDSize.cols != 0 ? this.myPDSize.cols : 1;
                int maxCols = this.myPDSize.cols != 0 ? this.myPDSize.cols : 30;
                int minRows = this.myPDSize.rows != 0 ? this.myPDSize.rows : 3;
                int maxRows = this.myPDSize.rows != 0 ? this.myPDSize.rows : 90;
                hints.put(EncodeHintType.PDF417_DIMENSIONS, new Dimensions(minCols, maxCols, minRows, maxRows));
                hints.put(EncodeHintType.ERROR_CORRECTION, this.myPDErrCorr.getLevelNumber());
                break;
            }
            case AZTEC: {
                barcodeFormat = BarcodeFormat.AZTEC;
                writer = new AztecWriter();
                hints.put(EncodeHintType.AZTEC_LAYERS, this.myAZSize.getLayerCount());
                hints.put(EncodeHintType.ERROR_CORRECTION, this.myAZErrCorr);
            }
        }
        BitMatrix bitMatrix = writer.encode(this.myContent, barcodeFormat, 0, 0, hints);
        return new TwoDSymbol(bitMatrix, this.myQuietZoneSize);
    }

    public TwoDType getType() {
        return this.myType;
    }

    public String getContent() {
        return this.myContent;
    }

    public Charset getCharset() {
        return this.myCharset;
    }

    public int getQuietZone() {
        return this.myQuietZoneSize;
    }

    public QRCodeVersion getQRCodeVersion() {
        return this.myQRVersion;
    }

    public QRCodeErrorCorrection getQRCodeErrCorr() {
        return this.myQRErrCorr;
    }

    public DataMatrixSize getDataMatrixSize() {
        return this.myDMSize;
    }

    public DataMatrixShape getDataMatrixShape() {
        return this.myDMShape;
    }

    public PDF417Size getPDF417Size() {
        return this.myPDSize;
    }

    public PDF417ErrorCorrection getPDF417ErrCorr() {
        return this.myPDErrCorr;
    }

    public AztecSize getAztecSize() {
        return this.myAZSize;
    }

    public int getAztecErrCorr() {
        return this.myAZErrCorr;
    }

    public TwoDCode clone() {
        try {
            return (TwoDCode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError("Unexpected: Clone not supported", e);
        }
    }
}

