/*
 * Decompiled with CFR 0.152.
 */
package de.vwsoft.barcodelib4j.twod;

public enum QRCodeVersion {
    AUTO(0, 0),
    V01(1, 21),
    V02(2, 25),
    V03(3, 29),
    V04(4, 33),
    V05(5, 37),
    V06(6, 41),
    V07(7, 45),
    V08(8, 49),
    V09(9, 53),
    V10(10, 57),
    V11(11, 61),
    V12(12, 65),
    V13(13, 69),
    V14(14, 73),
    V15(15, 77),
    V16(16, 81),
    V17(17, 85),
    V18(18, 89),
    V19(19, 93),
    V20(20, 97),
    V21(21, 101),
    V22(22, 105),
    V23(23, 109),
    V24(24, 113),
    V25(25, 117),
    V26(26, 121),
    V27(27, 125),
    V28(28, 129),
    V29(29, 133),
    V30(30, 137),
    V31(31, 141),
    V32(32, 145),
    V33(33, 149),
    V34(34, 153),
    V35(35, 157),
    V36(36, 161),
    V37(37, 165),
    V38(38, 169),
    V39(39, 173),
    V40(40, 177);

    private final int myNumber;
    private final int mySize;
    private static final QRCodeVersion[] cachedValues;

    private QRCodeVersion(int number, int size) {
        this.myNumber = number;
        this.mySize = size;
    }

    public static QRCodeVersion valueOf(int number) {
        if (number < 0 || number > 40) {
            throw new IllegalArgumentException("Invalid QR Code version number: " + number);
        }
        return cachedValues[number];
    }

    public int getNumber() {
        return this.myNumber;
    }

    public int getSize() {
        return this.mySize;
    }

    static {
        cachedValues = QRCodeVersion.values();
    }
}

